//
//  AsReaderSDK4Manager.m
//  asreader_sdk4
//
//  Created by ios on 2024/12/31.
//

#import "AsReaderSDK4Manager.h"
#import <AsReaderDockSDK/AsReaderDockSDK.h>
@interface AsReaderSDK4Manager()<AsReaderDeviceDelegate,AsReaderRFIDDeviceDelegate,AsReaderNFCDeviceDelegate,AsReaderLfDeviceDelegate,AsReaderBLEProtocols,AsreaderBarcodeDeviceDelegate>
@end
@implementation AsReaderSDK4Manager{
    NSMutableArray * scanBLEDevice;
}
static AsReaderSDK4Manager * sharedAsReaderSDK4Manager;
+ (AsReaderSDK4Manager *)sharedInstance{
    if (!sharedAsReaderSDK4Manager) {
        sharedAsReaderSDK4Manager = [[AsReaderSDK4Manager alloc] init];
    }
    return sharedAsReaderSDK4Manager;
}
- (instancetype)init
{
    self = [super init];
    if (self) {
        [AsReaderBarcodeDevice sharedInstance].delegateDevice = self;
        [AsReaderRFIDDevice sharedInstance].delegateRFID = self;
        [AsReaderNFCDevice sharedInstance].delegateNFC = self;
        [AsReaderLfDevice sharedInstance].delegateLf = self;
        [AsReaderBleMgr sharedInstance].delegate = self;
        [AsReaderBarcodeDevice sharedInstance].delegateBarcode = self;
    }
    return self;
}
#pragma mark ----AsReaderDevice----START
- (NSString *)getSDKVersion{
    return [AsReaderDevice getSDKVersion];
}
- (NSString *)getFlutterSDKVersion{
    return @"1.2.0";
}
- (void)showPrintNSLog:(BOOL)isShow{
    [AsReaderDevice showPrintNSLog:isShow];
}
- (void)setConnectionType:(int)type{
    [[AsReaderBarcodeDevice sharedInstance] setConnectionType:(ConnectionType)type];
}
- (int)getConnectionType{
    return (int)[AsReaderBarcodeDevice sharedInstance] .connectionType;
}
- (BOOL)getReaderInfo:(int)infoType{
    return [[AsReaderBarcodeDevice sharedInstance] getReaderInfo:infoType];
}

- (int)getCurrentBattery{
    return [[AsReaderBarcodeDevice sharedInstance] getCurrentBattery];
}

- (BOOL)setBeep:(BOOL)isBeep
      vibration:(BOOL)isVibration
batteryGaugeLed:(BOOL)isbatteryGaugeLed
   barcodeAimer:(BOOL)isBarcodeAimer{
    return [[AsReaderBarcodeDevice sharedInstance] setBeep:isBeep vibration:isVibration batteryGaugeLed:isbatteryGaugeLed barcodeAimer:isBarcodeAimer];
}

- (BOOL)setBeep:(BOOL)isBeep vibration:(BOOL)isVibration batteryGaugeLed:(BOOL)isbatteryGaugeLed barcodeAimer:(BOOL)isBarcodeAimer barcodePowerOnBeep:(BOOL)isBarcodePowerOnBeep{
    return [[AsReaderBarcodeDevice sharedInstance] setBeep:isBeep vibration:isVibration batteryGaugeLed:isbatteryGaugeLed barcodeAimer:isBarcodeAimer barcodePowerOnBeep:isBarcodePowerOnBeep];
}

- (int)setReaderPower:(BOOL)isOn
    beep:(BOOL)isBeep
    vibration:(BOOL)isVib
    batteryGaugeLed:(BOOL)isbatteryGaugeLed
    barcodeAimer:(BOOL)isBarcodeAimer
    barcodePowerOnBeep:(BOOL)isBarcodePowerOnBeep
                 mode:(int)nDeviceType{
    return [[AsReaderRFIDDevice sharedInstance] setReaderPower:isOn
                                                          beep:isBeep
                                                     vibration:isVib
                                               batteryGaugeLed:isbatteryGaugeLed
                                                  barcodeAimer:isBarcodeAimer
                                            barcodePowerOnBeep:isBarcodePowerOnBeep
                                                          mode:nDeviceType];
}

- (void)setTagCount:(int)mtnu
        setScanTime:(int)mtime
           setCycle:(int)repeatCycle{
    [[AsReaderRFIDDevice sharedInstance] setTagCount:mtnu
                                         setScanTime:mtime
                                            setCycle:repeatCycle];
}

- (BOOL)setChargingControl:(BOOL)isOn{
    return [[AsReaderBarcodeDevice sharedInstance] setChargingControl:isOn];
}

- (void)setDelayDisconnectOnBackground:(NSTimeInterval)time{
    [[AsReaderBarcodeDevice sharedInstance] setDelayDisconnectOnBackground:time];
}

- (NSTimeInterval) getDelayDisconnectOnBackground{
    return [[AsReaderBarcodeDevice sharedInstance] getDelayDisconnectOnBackground];
}

- (BOOL)isOpened{
    return [[AsReaderRFIDDevice sharedInstance] isOpened];
}

- (BOOL)setStopTagNum:(int)maxTags
              maxTime:(int)maxTime
          repeatCycle:(int)repeatCycle{
    return [[AsReaderRFIDDevice sharedInstance] setStopTagNum:maxTags
                                                      maxTime:maxTime
                                                  repeatCycle:repeatCycle];
}

- (BOOL)getStopCondition{
    return [[AsReaderRFIDDevice sharedInstance] getStopCondition];
}

- (BOOL)setTriggerMode:(BOOL)isDefault{
    return [[AsReaderRFIDDevice sharedInstance] setTriggerMode:isDefault];
}

- (BOOL)reset{
    return [[AsReaderRFIDDevice sharedInstance] reset];
}

- (BOOL)getAutoLaunch{
    return [[AsReaderRFIDDevice sharedInstance] getAutoLaunch];
}

- (BOOL)setAutoLaunch:(BOOL)enable bundleId:(NSString*) bundleId{
    return [[AsReaderRFIDDevice sharedInstance] setAutoLaunch:enable bundleId:bundleId];
}

- (BOOL)setSleepBeep: (BOOL)isOn{
    return [[AsReaderRFIDDevice sharedInstance] setSleepBeep:isOn];
}

- (BOOL)setSleepTime: (int)time{
    return [[AsReaderRFIDDevice sharedInstance] setSleepTime:time];
}

- (BOOL)getSleepTime{
    return [[AsReaderRFIDDevice sharedInstance] getSleepTime];
}

-(BOOL)startBleScan{
    scanBLEDevice = [[NSMutableArray alloc] init];
    return [[AsReaderRFIDDevice sharedInstance] startBleScan];
}

- (void)stopBleScan{
    return [[AsReaderRFIDDevice sharedInstance] stopBleScan];
}

- (void)disConnectBLE{
    [[AsReaderRFIDDevice sharedInstance] disConnectBLE];
}

- (BOOL)connectBLE:(NSString *)deviceName{
    for (CBPeripheral * device in scanBLEDevice) {
        if ([device.name isEqualToString:deviceName]) {
            [[AsReaderRFIDDevice sharedInstance] connectBLE:device];
            return YES;
        }
    }
    return NO;
}

- (int)getSleepTimeForBLEDevice{
    return [[AsReaderRFIDDevice sharedInstance] getSleepTimeForBLEDevice];
}

- (int)setSleepTimeForBLEDevice:(int)min type:(int)type{
    return [[AsReaderRFIDDevice sharedInstance] setSleepTimeForBLEDevice:min type:(SaveType)type];
}
#pragma mark ----AsReaderDevice----END

#pragma mark ----AsReaderBarcodeDevice----START
- (BOOL)startBarcodeScan:(uint8_t)numberOfTags readUntilInSec:(uint8_t)readUntilInSec{
    return [[AsReaderBarcodeDevice sharedInstance] startScan:numberOfTags readUntilInSec:readUntilInSec];
}

- (BOOL)stopBarcodeScan{
    return [[AsReaderBarcodeDevice sharedInstance] stopScan];
}

- (BOOL)doFactoryReset{
    return [[AsReaderBarcodeDevice sharedInstance] doFactoryReset];
}

- (BOOL)sendBarcodeSettingData:(NSData*)sendData{
    return [[AsReaderBarcodeDevice sharedInstance] sendBarcodeSettingData:sendData];
}

- (BOOL)sendBarcodeHoneywellSettingWithData:(NSData*)sendData{
    return [[AsReaderBarcodeDevice sharedInstance] sendBarcodeHoneywellSettingWithData:sendData];
}

- (BOOL)setCustomPrefix:(NSString *)prefix{
    return [[AsReaderBarcodeDevice sharedInstance] setCustomPrefix:prefix];
}
- (BOOL)setDisableCustomPrefix{
    return [[AsReaderBarcodeDevice sharedInstance] setDisableCustomPrefix];
}
- (BOOL)setCustomSuffix:(NSString *)suffix{
    return [[AsReaderBarcodeDevice sharedInstance] setCustomSuffix:suffix];
}
- (BOOL)setDisableCustomSuffix{
    return [[AsReaderBarcodeDevice sharedInstance] setDisableCustomSuffix];
}

- (BOOL)setSymbologyPrefix{
    return [[AsReaderBarcodeDevice sharedInstance] setSymbologyPrefix];
}
- (BOOL)setDisableSymbologyPrefix{
    return [[AsReaderBarcodeDevice sharedInstance] setDisableSymbologyPrefix];
}
- (BOOL)setBarcodeEngineUserCommand:(NSString *)command{
    return [[AsReaderBarcodeDevice sharedInstance] setBarcodeEngineUserCommand:command];
}

- (BOOL)setCodeID: (int)type isBeepOn:(BOOL)isBeepOn{
    return [[AsReaderBarcodeDevice sharedInstance] setCodeID:(CODEId)type isBeepOn:isBeepOn];
}

- (BOOL)setOCRType: (int)type isBeepOn:(BOOL)isBeepOn{
    return [[AsReaderBarcodeDevice sharedInstance] setOCRType:(OCRType)type isBeepOn:isBeepOn];
}

- (BOOL)setAndroidHIDEnable: (BOOL)isOn{
    return [[AsReaderBarcodeDevice sharedInstance] setAndroidHIDEnable:isOn];
}

- (BOOL)setiOSHIDEnable: (BOOL)isOn{
    return [[AsReaderBarcodeDevice sharedInstance] setiOSHIDEnable:isOn];
}

- (BOOL)setPresentationMode: (BOOL)isOn isBeepOn:(BOOL)isBeepOn{
    return [[AsReaderBarcodeDevice sharedInstance] setPresentationMode:isOn isBeepOn:isBeepOn];
}

- (BOOL)getCodeID{
    return [[AsReaderBarcodeDevice sharedInstance] getCodeID];
}

- (BOOL)getOCR{
    return [[AsReaderBarcodeDevice sharedInstance] getOCR];
}

- (BOOL)getHID{
    return [[AsReaderBarcodeDevice sharedInstance] getHID];
}

- (BOOL)getSymbologies{
    return [[AsReaderBarcodeDevice sharedInstance] getSymbologies];
}

- (BOOL)setSsiParamWithData:(NSData *)symbolData beepOn:(BOOL)beepOn{
    return [[AsReaderBarcodeDevice sharedInstance] setSsiParamWithData:symbolData beepOn:beepOn];
}

- (BOOL)setSsiParamWithDictionary:(NSMutableArray *)symbologies beepOn:(BOOL)beepOn{
    NSMutableDictionary<NSNumber *, BarcodeZebraSsiParam *> *dictParams = [NSMutableDictionary dictionary];
    for (NSDictionary *dic in symbologies) {
        NSString *number = [dic valueForKey:@"number"];
        NSString *status = [dic valueForKey:@"status"];
        NSString *name = [dic valueForKey:@"name"];
        BarcodeZebraSsiParam *aSymbols = [[BarcodeZebraSsiParam alloc] initWithNumber:[number integerValue] status:[status integerValue] name:name];
        dictParams[@([number integerValue])] = aSymbols;
    }
    return [[AsReaderBarcodeDevice sharedInstance] setSsiParamWithDictionary:dictParams beepOn:beepOn];
}

- (BOOL)getPresentationMode{
    return [[AsReaderBarcodeDevice sharedInstance] getPresentationMode];
}

- (BOOL)getSecurity{
    return [[AsReaderBarcodeDevice sharedInstance] getSecurity];
}

- (BOOL)getSleepBuzzer{
    return [[AsReaderBarcodeDevice sharedInstance] getSleepBuzzer];
}

- (BOOL)setSleepBuzzer:(BOOL)sleepBuzzer{
    return [[AsReaderBarcodeDevice sharedInstance] setSleepBuzzer:sleepBuzzer];
}

- (BOOL)getBarcodeTimeOut{
    return [[AsReaderBarcodeDevice sharedInstance] getBarcodeTimeOut];
}

- (BOOL)setBarcodeTimeOut:(int)timeout{
    return [[AsReaderBarcodeDevice sharedInstance] setBarcodeTimeOut:timeout];
}
#pragma mark ----AsReaderBarcodeDevice----END

#pragma mark ----AsReaderRFIDDevice----START
- (BOOL)startScan:(int)numberOfTags
   readUntilInSec:(int)readUntilInSec
      repeatCycle:(int)repeatCycle{
    return [[AsReaderRFIDDevice sharedInstance] startScan:numberOfTags readUntilInSec:readUntilInSec repeatCycle:repeatCycle];
}

- (BOOL)stopRfidScan{
    return [[AsReaderRFIDDevice sharedInstance] stopScan];
}

- (BOOL)startReadTagsAndRssiWithTagNum:(int)maxTags
                               maxTime:(int)maxTime
                           repeatCycle:(int)repeatCycle{
    return [[AsReaderRFIDDevice sharedInstance] startReadTagsAndRssiWithTagNum:maxTags
                                                                       maxTime:maxTime
                                                                   repeatCycle:repeatCycle];
}

- (BOOL)startReadTagAndTidWithTagNum:(int)maxTags
                             maxTime:(int)maxTime
                         repeatCycle:(int)repeatCycle{
    return [[AsReaderRFIDDevice sharedInstance] startReadTagAndTidWithTagNum:maxTags
                                                                     maxTime:maxTime
                                                                 repeatCycle:repeatCycle];
}

- (BOOL)startReadTagsRFM:(int)codeType
                 maxTags:(int)maxTags
                 maxTime:(int)maxTime
             repeatCycle:(int)repeatCycle{
    return [[AsReaderRFIDDevice sharedInstance] startReadTagsRFM:codeType
                                                         maxTags:maxTags
                                                         maxTime:maxTime
                                                     repeatCycle:repeatCycle];
}

- (BOOL)getSelectParameter{
    return [[AsReaderRFIDDevice sharedInstance] getSelectParameter];
}

- (BOOL)setSelectParameter:(int)target
                    action:(int)action
                memoryBank:(int)memoryBank
                   pointer:(int)pointer
                    length:(int)length
                  truncate:(int)truncate
                      mask:(NSData *)mask{
    return [[AsReaderRFIDDevice sharedInstance] setSelectParameter:target
                                                            action:action
                                                        memoryBank:memoryBank
                                                           pointer:pointer
                                                            length:length
                                                          truncate:truncate
                                                              mask:mask];
}

- (BOOL)getChannel{
    return [[AsReaderRFIDDevice sharedInstance] getChannel];
}

- (BOOL)setReadTime:(int)ReadTime
           idleTime:(int)IdleTime{
    return [[AsReaderRFIDDevice sharedInstance] setReadTime:ReadTime
                                                   idleTime:IdleTime];
}

- (BOOL)setChannel:(int)channel
     channelOffset:(int)channelOffset{
    return [[AsReaderRFIDDevice sharedInstance] setChannel:channel
                                            channelOffset:channelOffset];
}

- (BOOL)getFhLbtParameter{
    return [[AsReaderRFIDDevice sharedInstance] getFhLbtParameter];
}

- (BOOL)setFhLbtParameter:(int)ReadTime
                 idleTime:(int)IdleTime
         carrierSenseTime:(int)carrierSenseTime
       targetRFPowerLevel:(int)targetRFPowerLevel
         frequencyHopping:(int)frequencyHopping
         listenBeforeTalk:(int)listenBeforeTalk
           continuousWave:(int)continuousWave{
    return [[AsReaderRFIDDevice sharedInstance] setFhLbtParameter:ReadTime
                                                         idleTime:IdleTime
                                                 carrierSenseTime:carrierSenseTime
                                               targetRFPowerLevel:targetRFPowerLevel
                                                 frequencyHopping:frequencyHopping
                                                 listenBeforeTalk:listenBeforeTalk
                                                   continuousWave:continuousWave];
}

- (BOOL)getOutputPowerLevel{
    return [[AsReaderRFIDDevice sharedInstance] getOutputPowerLevel];
}

- (BOOL)setOutputPowerLevel:(int)powerLevel{
    return [[AsReaderRFIDDevice sharedInstance] setOutputPowerLevel:powerLevel];
}

- (BOOL)writeTagMemoryWithAccessPassword:(int)accessPassword
                                     epc:(NSData *)epc
                              memoryBank:(int)memoryBank
                            startAddress:(int)startAddress
                             dataToWrite:(NSData *)dataToWrite{
    return [[AsReaderRFIDDevice sharedInstance] writeTagMemoryWithAccessPassword:accessPassword
                                                                             epc:epc
                                                                      memoryBank:memoryBank
                                                                    startAddress:startAddress
                                                                     dataToWrite:dataToWrite];
}

- (BOOL)killTagWithPassword:(int)password
                        epc:(NSData *)epc{
    return [[AsReaderRFIDDevice sharedInstance] killTagWithPassword:password
                                                                epc:epc];
}

- (BOOL)lockTagMemoryWithAccessPassword:(int)accessPassword
                                    epc:(NSData *)epc
                               lockData:(int)lockData{
    return [[AsReaderRFIDDevice sharedInstance] lockTagMemoryWithAccessPassword:accessPassword
                                                                            epc:epc
                                                                       lockData:lockData];
}

- (BOOL)getFrequencyHoppingTable{
    return [[AsReaderRFIDDevice sharedInstance] getFrequencyHoppingTable];
}

- (BOOL)setFrequencyHoppingTableSize:(int)tableSize
                            channels:(NSData*)channels{
    return [[AsReaderRFIDDevice sharedInstance] setFrequencyHoppingTableSize:tableSize
                                                                    channels:channels];
}

- (BOOL)getRssi{
    return [[AsReaderRFIDDevice sharedInstance] getRssi];
}

- (BOOL)getSession{
    return [[AsReaderRFIDDevice sharedInstance] getSession];
}

- (BOOL)setSession:(int)session{
    return [[AsReaderRFIDDevice sharedInstance] setSession:session];
}

- (BOOL)getAnticollision{
    return [[AsReaderRFIDDevice sharedInstance] getAnticollision];
}

- (BOOL)setAnticollision:(int)mode
                 Counter:(int)counter{
    return [[AsReaderRFIDDevice sharedInstance] setAnticollision:mode
                                                         Counter:counter];
}

- (BOOL)updateRegistry{
    return [[AsReaderRFIDDevice sharedInstance] updateRegistry];
}

- (BOOL)getRFIDModuleVersion{
    return [[AsReaderRFIDDevice sharedInstance] getRFIDModuleVersion];
}

- (BOOL)setHoppingOnOff:(BOOL)isOn{
    return [[AsReaderRFIDDevice sharedInstance] setHoppingOnOff:isOn];
}

- (BOOL)writeTagMemoryWithEPC:(NSData *)epc
             dataToWriteAscii:(NSString *)dataToWrite{
    return [[AsReaderRFIDDevice sharedInstance] writeTagMemoryWithEPC:epc
                                                     dataToWriteAscii:dataToWrite];
}

- (BOOL)setRSSIThreshold:(uint16_t)threshold{
    return [[AsReaderRFIDDevice sharedInstance] setRSSIThreshold:threshold];
}

- (BOOL)getRSSIThreshold{
    return [[AsReaderRFIDDevice sharedInstance] getRSSIThreshold];
}

- (BOOL)getQueryParameter{
    return [[AsReaderRFIDDevice sharedInstance] getQueryParameter];
}

- (BOOL)readTagWithAccessPassword:(int)accessPassword
                              epc:(NSData *)epc
                       memoryBank:(int)memoryBank
                     startAddress:(int)startAddress
                       dataLength:(int)dataLength{
    return [[AsReaderRFIDDevice sharedInstance] readTagWithAccessPassword:accessPassword
                                                                      epc:epc
                                                               memoryBank:memoryBank
                                                             startAddress:startAddress
                                                               dataLength:dataLength];
}

- (BOOL)setQueryParam:(int)divideRatio
                    m:(int)m
                trext:(int)trext
            selection:(int)selection
              session:(int)session
               target:(int)target
               qValue:(int)qValue{
    return [[AsReaderRFIDDevice sharedInstance] setQueryParam:divideRatio
                                                            m:m
                                                        trext:trext
                                                    selection:selection
                                                      session:session
                                                       target:target
                                                       qValue:qValue];
}

- (BOOL)setRfCw:(BOOL)on{
    return [[AsReaderRFIDDevice sharedInstance] setRfCw:on];
}

- (BOOL)getModulation{
    return [[AsReaderRFIDDevice sharedInstance] getModulation];
}

- (BOOL)setModulationBLF:(int)blf rxMod:(int)rxMod dr:(int)dr{
    return [[AsReaderRFIDDevice sharedInstance] setModulationBLF:blf rxMod:rxMod dr:dr];
}

- (BOOL)blockEraseTagMemoryWithAccessPassword:(int)accessPassword
                                          epc:(NSData *)epc
                                   memoryBank:(int)memoryBank
                                 startAddress:(int)startAddress
                                   dataLength:(int)dataLength{
    return [[AsReaderRFIDDevice sharedInstance] blockEraseTagMemoryWithAccessPassword:accessPassword
                                                                                  epc:epc
                                                                           memoryBank:memoryBank
                                                                         startAddress:startAddress
                                                                           dataLength:dataLength];
}

- (BOOL)genericTransportWithAccessPassword:(int)accessPassword
                                       epc:(NSData *)epc
                         transmissionState:(int)transmissionState
                                        rm:(int)rm
                                      size:(int)size
                            genericCommand:(NSData *)genericCommand{
    return [[AsReaderRFIDDevice sharedInstance] genericTransportWithAccessPassword:accessPassword
                                                                               epc:epc
                                                                 transmissionState:transmissionState
                                                                                rm:rm
                                                                              size:size
                                                                    genericCommand:genericCommand];
}

- (BOOL)getTemperature{
    return [[AsReaderRFIDDevice sharedInstance] getTemperature];
}

- (BOOL)getRegistryItem:(int)registryItem{
    return [[AsReaderRFIDDevice sharedInstance] getRegistryItem:registryItem];
}

- (BOOL)setOptimumFrequencyHoppingTable{
    return [[AsReaderRFIDDevice sharedInstance] setOptimumFrequencyHoppingTable];
}

- (BOOL)setFrequencyHoppingMode:(int)mode{
    return [[AsReaderRFIDDevice sharedInstance] setFrequencyHoppingMode:mode];
}

- (BOOL)getFrequencyHoppingMode{
    return [[AsReaderRFIDDevice sharedInstance] getFrequencyHoppingMode];
}

- (BOOL)setSmartHoppingOnOff:(BOOL)isOn{
    return [[AsReaderRFIDDevice sharedInstance] setSmartHoppingOnOff:isOn];
}

- (BOOL)getRegion{
    return [[AsReaderRFIDDevice sharedInstance] getRegion];
}

- (void)setReadRSSIMode:(BOOL)isReadRSSIMode{
    return [[AsReaderRFIDDevice sharedInstance] setReadRSSIMode:isReadRSSIMode];
}

- (BOOL)getRfidModuleInformation{
    return [[AsReaderRFIDDevice sharedInstance] getRfidModuleInformation];
}
- (BOOL)getHoppingOnOff{
    return [[AsReaderRFIDDevice sharedInstance] getHoppingOnOff];
}
- (BOOL)getAutoOffTime{
    if ([[AsReaderInfo sharedInstance].deviceName hasPrefix:@"ASR-M30S"]) {
        return [[AsReaderRFIDDevice sharedInstance] getAutoOffTime];
    } else if ([[AsReaderInfo sharedInstance].deviceName hasPrefix:@"ASR-025S"]) {
        return [[AsReaderBarcodeDevice sharedInstance] getAutoOffTime];
    } else {
        return false;
    }
}
- (BOOL)setAutoOffTime:(int)time{
    if ([[AsReaderInfo sharedInstance].deviceName hasPrefix:@"ASR-M30S"]) {
        return [[AsReaderRFIDDevice sharedInstance] setAutoOffTime:time];
    } else if ([[AsReaderInfo sharedInstance].deviceName hasPrefix:@"ASR-025S"]) {
        return [[AsReaderBarcodeDevice sharedInstance] setAutoOffTime:time];
    } else {
        return false;
    }
}
- (BOOL)getContinuousMode{
    return [[AsReaderRFIDDevice sharedInstance] getContinuousMode];
}
- (BOOL)setContinuousMode:(BOOL)isContinuousMode{
    return [[AsReaderRFIDDevice sharedInstance] setContinuousMode:isContinuousMode];
}
- (BOOL)getQValue{
    return [[AsReaderRFIDDevice sharedInstance] getQValue];
}
- (BOOL)setQValue:(int)value{
    return [[AsReaderRFIDDevice sharedInstance] setQValue:value];
}
- (BOOL)getSessionFlag{
    return [[AsReaderRFIDDevice sharedInstance] getSessionFlag];
}
- (BOOL)setSessionFlag:(int)sessionFlag{
    return [[AsReaderRFIDDevice sharedInstance] setSessionFlag:sessionFlag];
}
- (BOOL)getHidMode{
    return [[AsReaderRFIDDevice sharedInstance] getHidMode];
}
- (BOOL)setHidMode:(BOOL)hidMode{
    return [[AsReaderRFIDDevice sharedInstance] setHidMode:hidMode];
}
- (BOOL)getDutyRatio{
    return [[AsReaderRFIDDevice sharedInstance] getDutyRatio];
}
- (BOOL)setDutyRatio:(int)dutyRatio{
    return [[AsReaderRFIDDevice sharedInstance] setDutyRatio:dutyRatio];
}
- (BOOL)getDutyRatioBaseTime{
    return [[AsReaderRFIDDevice sharedInstance] getDutyRatioBaseTime];
}
- (BOOL)setDutyRatioBaseTime:(int)dutyRatioBaseTime{
    return [[AsReaderRFIDDevice sharedInstance] setDutyRatioBaseTime:dutyRatioBaseTime];
}
#pragma mark ----AsReaderRFIDDevice----END

#pragma mark ----AsReaderNFCDevice----START
- (BOOL)sendData:(NSData *)sendData{
    return [[AsReaderNFCDevice sharedInstance] sendData:sendData];
}

- (BOOL)setInventoryTime:(float)inventoryTime{
    return [[AsReaderNFCDevice sharedInstance] setInventoryTime:inventoryTime];
}

- (BOOL)startNFCScan{
    return [[AsReaderNFCDevice sharedInstance] startScan];
}

- (BOOL)stopNFCScan{
    return [[AsReaderNFCDevice sharedInstance] stopScan];
}

- (BOOL)readMultiBlockWithBlockIndex:(int)index
                               count:(int)count{
    return [[AsReaderNFCDevice sharedInstance] readMultiBlockWithBlockIndex:index
                                                                      count:count];
}

- (BOOL)writeSingleBlockWithBlockIndex:(int)index
                             writeData:(NSData *)writeData
                                   uid:(NSData *)uid{
    return [[AsReaderNFCDevice sharedInstance] writeSingleBlockWithBlockIndex:index
                                                                    writeData:writeData
                                                                          uid:uid];
}

- (BOOL)writeBytesWithBlockIndex:(int)index
                       writeData:(NSData *)writeData
                             uid:(NSData *)uid{
    return [[AsReaderNFCDevice sharedInstance] writeBytesWithBlockIndex:index
                                                              writeData:writeData
                                                                    uid:uid];
}
#pragma mark ----AsReaderNFCDevice----END

#pragma mark ----AsReaderLfDevice----START

- (BOOL)startLfScan:(int)numberOfTags
   readUntilInSec:(int)readUntilInSec
      repeatCycle:(int)repeatCycle{
    return [[AsReaderLfDevice sharedInstance] startScan:numberOfTags
                                         readUntilInSec:readUntilInSec
                                            repeatCycle:repeatCycle];
}

- (BOOL)stopLfScan{
    return [[AsReaderLfDevice sharedInstance] stopScan];
}
#pragma mark ----AsReaderLfDevice----END

#pragma mark ----AsReaderInfo----START

- (BOOL)isShowPrintNSLog{
    return [AsReaderInfo sharedInstance].isShowPrintNSLog;
}

- (NSString *)bundleIdentifier{
    return [AsReaderInfo sharedInstance].bundleIdentifier;
}

- (NSString *)deviceName{
    return [AsReaderInfo sharedInstance].deviceName;
}
- (NSString *)deviceFirmware{
    return [AsReaderInfo sharedInstance].deviceFirmware;
}
- (NSString *)deviceHardware{
    return [AsReaderInfo sharedInstance].deviceHardware;
}
- (NSString *)deviceID{
    return [AsReaderInfo sharedInstance].deviceID;
}
- (NSString *)deviceManufacturer{
    return [AsReaderInfo sharedInstance].deviceManufacturer;
}
- (NSString *)deviceModelNumber{
    return [AsReaderInfo sharedInstance].deviceModelNumber;
}
- (NSString *)deviceSerialNumber{
    return [AsReaderInfo sharedInstance].deviceSerialNumber;
}
- (NSString *)deviceProtocol{
    return [AsReaderInfo sharedInstance].deviceProtocol;
}
-(int)currentSelectDevice{
    return [AsReaderInfo sharedInstance].currentSelectDevice;
}
-(BOOL)isPowerOn{
    return [AsReaderInfo sharedInstance].isPowerOn;
}
-(int)supportMode{
    return (int)[AsReaderInfo sharedInstance].supportMode;
}
-(int)currentReaderMode{
    return (int)[AsReaderInfo sharedInstance].currentReaderMode;
}
-(int)receiveDataType{
    return (int)[AsReaderInfo sharedInstance].receiveDataType;
}
-(BOOL)dualSameTime{
    return [AsReaderInfo sharedInstance].dualSameTime;
}
-(BOOL)isBeep{
    return [AsReaderInfo sharedInstance].isBeep;
}
-(BOOL)isVibration{
    return [AsReaderInfo sharedInstance].isVibration;
}
-(BOOL)isLED{
    return [AsReaderInfo sharedInstance].isLED;
}
-(BOOL)isIllumination{
    return [AsReaderInfo sharedInstance].isIllumination;
}
-(int)count{
    return [AsReaderInfo sharedInstance].count;
}
-(int)scanTime{
    return [AsReaderInfo sharedInstance].scanTime;
}
-(int)cycle{
    return [AsReaderInfo sharedInstance].cycle;
}
-(BOOL)isTriggerModeDefault{
    return [AsReaderInfo sharedInstance].isTriggerModeDefault;
}
-(BOOL)isReadRSSIMode{
    return [AsReaderInfo sharedInstance].isReadRSSIMode;
}
-(BOOL)isEnginePowerAlwaysOn{
    return [AsReaderInfo sharedInstance].isEnginePowerAlwaysOn;
}
-(int)barcodeEngineType{
    return (int)[AsReaderInfo sharedInstance].barcodeEngineType;
}
-(int)carrierSenseTime{
    return (int)[AsReaderInfo sharedInstance].carrierSenseTime;
}
-(int)targetRFPowerLevel{
    return (int)[AsReaderInfo sharedInstance].targetRFPowerLevel;
}
-(BOOL)isSmartHopping{
    return [AsReaderInfo sharedInstance].isSmartHopping;
}
-(float)rfidPower{
    return [AsReaderInfo sharedInstance].rfidPower;
}
-(float)rfidPowerMax{
    return [AsReaderInfo sharedInstance].rfidPowerMax;
}
-(float)rfidPowerMin{
    return [AsReaderInfo sharedInstance].rfidPowerMin;
}
-(int)rfidOnTime{
    return [AsReaderInfo sharedInstance].rfidOnTime;
}
-(int)rfidOffTime{
    return [AsReaderInfo sharedInstance].rfidOffTime;
}
-(int)rfidChannel{
    return [AsReaderInfo sharedInstance].rfidChannel;
}
-(int)rfidListenBeforeTalk{
    return [AsReaderInfo sharedInstance].rfidListenBeforeTalk;
}
-(int)rfidFrequencyHopping{
    return [AsReaderInfo sharedInstance].rfidFrequencyHopping;
}
-(int)rfidContinuousWave{
    return [AsReaderInfo sharedInstance].rfidContinuousWave;
}
-(NSString*)rfidModuleVersion{
    return [AsReaderInfo sharedInstance].rfidModuleVersion;
}
- (BOOL)isSupportType:(int)supportType{
    return [[AsReaderInfo sharedInstance] isSupportType:(ReaderMode)supportType];
}
- (NSArray *)getSupportTypeArray{
    return [[AsReaderInfo sharedInstance] getSupportTypeArray];
}
#pragma mark ----AsReaderInfo----END

#pragma mark ----LFTagParser----START

- (NSDictionary *)parseDataByProtocolType:(NSData *)data protocolType:(int)protocolType{
    return [[LFTagParser sharedInstance] parseDataByProtocolType:data protocolType:(ProtocolTypeLF)protocolType];
}
#pragma mark ----LFTagParser----END
#pragma mark ----AsReaderDeviceProtocol----START
-(void)plugged:(BOOL)plug{
    NSLog(@"plugged = %d",plug);
    _isPlugged = plug;
    NSMutableDictionary * dic = [[NSMutableDictionary alloc] init];
    [dic setValue:[NSNumber numberWithBool:plug] forKey:@"result"];
    [dic setValue:PLUGGED_STATUS forKey:@"method"];
    [_currentChannel invokeMethod:PLUGGED_STATUS arguments:dic result:^(id  _Nullable result) {
        NSLog(@"Plugged result:%@",result);
    }];
}

- (void)readerConnected:(int)status{
    NSLog(@"isConnected = %d",status);
    _isConnected = status;
    NSMutableDictionary * dic = [[NSMutableDictionary alloc] init];
    [dic setValue:[NSNumber numberWithBool:status] forKey:@"result"];
    [dic setValue:CONNECTED_STATUS forKey:@"method"];
    [_currentChannel invokeMethod:CONNECTED_STATUS arguments:dic result:^(id  _Nullable result) {
        NSLog(@"Connected result:%@",result);
    }];
}

- (void)checkTriggerStatus:(NSString*)strStatus{
    NSMutableDictionary * dic = [[NSMutableDictionary alloc] init];
    [dic setValue:strStatus forKey:@"result"];
    [dic setValue:TRIGGER_STATUS forKey:@"method"];
    [_currentChannel invokeMethod:TRIGGER_STATUS arguments:dic result:^(id  _Nullable result) {
        NSLog(@"Trigger Status result:%@",strStatus);
    }];
}
- (void)responsePowerOnOff:(BOOL)isOn HWModeChange:(BOOL)isHWModeChange{
    NSMutableDictionary * dic = [[NSMutableDictionary alloc] init];
    [dic setValue:[NSNumber numberWithBool:isOn] forKey:@"isOn"];
    [dic setValue:[NSNumber numberWithBool:isHWModeChange] forKey:@"isHWModeChange"];
    [dic setValue:POWER_ON_OFF forKey:@"method"];
    [_currentChannel invokeMethod:POWER_ON_OFF arguments:dic result:^(id  _Nullable result) {
    }];
}
- (void)releasedTriggerButton{
    NSMutableDictionary * dic = [[NSMutableDictionary alloc] init];
    [dic setValue:RELEASED_TRIGGER_BUTTON forKey:@"method"];
    [_currentChannel invokeMethod:RELEASED_TRIGGER_BUTTON arguments:dic result:^(id  _Nullable result) {
    }];
}
- (void)pushedTriggerButton{
    NSMutableDictionary * dic = [[NSMutableDictionary alloc] init];
    [dic setValue:PUSHED_TRIGGER_BUTTON forKey:@"method"];
    [_currentChannel invokeMethod:PUSHED_TRIGGER_BUTTON arguments:dic result:^(id  _Nullable result) {
    }];
}
- (void)onAsReaderTriggerKeyEventStatus:(NSString*)status{
    NSMutableDictionary * dic = [[NSMutableDictionary alloc] init];
    [dic setValue:status forKey:@"status"];
    [dic setValue:ON_ASREADER_TRIGGER_KEY_EVENT_STATUS forKey:@"method"];
    [_currentChannel invokeMethod:ON_ASREADER_TRIGGER_KEY_EVENT_STATUS arguments:dic result:^(id  _Nullable result) {
    }];
}
- (void)receivedScanData:(NSData *)readData{
    NSMutableDictionary * dic = [[NSMutableDictionary alloc] init];
    [dic setValue:[FlutterStandardTypedData typedDataWithBytes:readData] forKey:@"result"];
    [dic setValue:RECEIVED_SCAN_DATA forKey:@"method"];
    [_currentChannel invokeMethod:RECEIVED_SCAN_DATA arguments:dic result:^(id  _Nullable result) {
    }];
}
- (void)receivedScanData:(NSData *)readData dataType:(int)dataType{
    NSMutableDictionary * dic = [[NSMutableDictionary alloc] init];
    [dic setValue:[FlutterStandardTypedData typedDataWithBytes:readData] forKey:@"readData"];
    [dic setValue:[NSNumber numberWithInt:dataType] forKey:@"dataType"];
    [dic setValue:RECEIVED_SCAN_DATA_AND_DATA_TYPE forKey:@"method"];
    [_currentChannel invokeMethod:RECEIVED_SCAN_DATA_AND_DATA_TYPE arguments:dic result:^(id  _Nullable result) {
    }];
}
- (void)unknownCommandReceived:(int)commandCode{
    NSMutableDictionary * dic = [[NSMutableDictionary alloc] init];
    [dic setValue:[NSNumber numberWithInt:commandCode] forKey:@"result"];
    [dic setValue:UNKNOWN_COMMAND_RECEIVED forKey:@"method"];
    [_currentChannel invokeMethod:UNKNOWN_COMMAND_RECEIVED arguments:dic result:^(id  _Nullable result) {
    }];
}
- (void)allDataReceived:(NSData *)data{
    NSMutableDictionary * dic = [[NSMutableDictionary alloc] init];
    [dic setValue:[FlutterStandardTypedData typedDataWithBytes:data] forKey:@"result"];
    [dic setValue:ALL_DATA_RECEIVED forKey:@"method"];
    [_currentChannel invokeMethod:ALL_DATA_RECEIVED arguments:dic result:^(id  _Nullable result) {
    }];
}
- (void)batteryReceived:(int)battery{
    NSMutableDictionary * dic = [[NSMutableDictionary alloc] init];
    [dic setValue:[NSNumber numberWithInt:battery] forKey:@"result"];
    [dic setValue:BATTERY_RECEIVED forKey:@"method"];
    [_currentChannel invokeMethod:BATTERY_RECEIVED arguments:dic result:^(id  _Nullable result) {
    }];
}
- (void)stopReadScan:(int)status{
    NSMutableDictionary * dic = [[NSMutableDictionary alloc] init];
    [dic setValue:[NSNumber numberWithInt:status] forKey:@"result"];
    [dic setValue:STOP_READ_SCAN forKey:@"method"];
    [_currentChannel invokeMethod:STOP_READ_SCAN arguments:dic result:^(id  _Nullable result) {
    }];
}
- (void)startedReadScan:(int)status{
    NSMutableDictionary * dic = [[NSMutableDictionary alloc] init];
    [dic setValue:[NSNumber numberWithInt:status] forKey:@"result"];
    [dic setValue:STARTED_READ_SCAN forKey:@"method"];
    [_currentChannel invokeMethod:STARTED_READ_SCAN arguments:dic result:^(id  _Nullable result) {
    }];
}
- (void)errorReceived:(NSData *)errorCode{
    NSMutableDictionary * dic = [[NSMutableDictionary alloc] init];
    [dic setValue:[FlutterStandardTypedData typedDataWithBytes:errorCode] forKey:@"result"];
    [dic setValue:ERROR_RECEIVED forKey:@"method"];
    [_currentChannel invokeMethod:ERROR_RECEIVED arguments:dic result:^(id  _Nullable result) {
    }];
}
- (void)receivedSleepTime:(int)time isAck:(BOOL)isAck{
    NSMutableDictionary * dic = [[NSMutableDictionary alloc] init];
    [dic setValue:[NSNumber numberWithInt:time] forKey:@"time"];
    [dic setValue:[NSNumber numberWithBool:isAck] forKey:@"isAck"];
    [dic setValue:RECEIVED_SLEEP_TIME_AND_ISACK forKey:@"method"];
    [_currentChannel invokeMethod:RECEIVED_SLEEP_TIME_AND_ISACK arguments:dic result:^(id  _Nullable result) {
    }];
}
- (void)receivedSleepTime:(int)time{
    NSMutableDictionary * dic = [[NSMutableDictionary alloc] init];
    [dic setValue:[NSNumber numberWithInt:time] forKey:@"result"];
    [dic setValue:RECEIVED_SLEEP_TIME forKey:@"method"];
    [_currentChannel invokeMethod:RECEIVED_SLEEP_TIME arguments:dic result:^(id  _Nullable result) {
    }];
}
- (void)receivedBeep:(NSData *)data{
    NSMutableDictionary * dic = [[NSMutableDictionary alloc] init];
    [dic setValue:[FlutterStandardTypedData typedDataWithBytes:data] forKey:@"result"];
    [dic setValue:RECEIVED_BEEP forKey:@"method"];
    [_currentChannel invokeMethod:RECEIVED_BEEP arguments:dic result:^(id  _Nullable result) {
    }];
}
- (void)readerInfoReceived:(NSData *)data{
    NSMutableDictionary * dic = [[NSMutableDictionary alloc] init];
    [dic setValue:[FlutterStandardTypedData typedDataWithBytes:data] forKey:@"result"];
    [dic setValue:READER_INFO_RECEIVED forKey:@"method"];
    [_currentChannel invokeMethod:READER_INFO_RECEIVED arguments:dic result:^(id  _Nullable result) {
    }];
}
- (void)didSetStopCondition:(int)status{
    NSMutableDictionary * dic = [[NSMutableDictionary alloc] init];
    [dic setValue:[NSNumber numberWithInt:status] forKey:@"result"];
    [dic setValue:DID_SET_STOP_CONDITION forKey:@"method"];
    [_currentChannel invokeMethod:DID_SET_STOP_CONDITION arguments:dic result:^(id  _Nullable result) {
    }];
}
- (void)stopConditionsReceived:(NSData *)data{
    NSMutableDictionary * dic = [[NSMutableDictionary alloc] init];
    [dic setValue:[FlutterStandardTypedData typedDataWithBytes:data] forKey:@"result"];
    [dic setValue:STOP_CONDITIONS_RECEIVED forKey:@"method"];
    [_currentChannel invokeMethod:STOP_CONDITIONS_RECEIVED arguments:dic result:^(id  _Nullable result) {
    }];
}
- (void)responseBootloaderS0:(NSData *)FWData{
    NSMutableDictionary * dic = [[NSMutableDictionary alloc] init];
    [dic setValue:[FlutterStandardTypedData typedDataWithBytes:FWData] forKey:@"result"];
    [dic setValue:RESPONSE_BOOT_LOADER_S0 forKey:@"method"];
    [_currentChannel invokeMethod:RESPONSE_BOOT_LOADER_S0 arguments:dic result:^(id  _Nullable result) {
    }];
}
#pragma mark ----AsReaderNFCProtocol----END

#pragma mark ----AsReaderBarcodeProtocol----START
- (void)receivedBarcodeData:(NSData *)data{
    NSMutableDictionary * dic = [[NSMutableDictionary alloc] init];
    [dic setValue:[FlutterStandardTypedData typedDataWithBytes:data] forKey:@"result"];
    [dic setValue:RECEIVED_BARCODE_DATA forKey:@"method"];
    [_currentChannel invokeMethod:RECEIVED_BARCODE_DATA arguments:dic result:^(id  _Nullable result) {
    }];
}
- (void)receiveFactoryReset:(int)status{
    NSMutableDictionary * dic = [[NSMutableDictionary alloc] init];
    [dic setValue:[NSNumber numberWithInt:status] forKey:@"result"];
    [dic setValue:RECEIVED_FACTORY_RESET forKey:@"method"];
    [_currentChannel invokeMethod:RECEIVED_FACTORY_RESET arguments:dic result:^(id  _Nullable result) {
    }];
}
- (void)ackUserCommandReceived:(NSData *)rawData{
    NSMutableDictionary * dic = [[NSMutableDictionary alloc] init];
    [dic setValue:[FlutterStandardTypedData typedDataWithBytes:rawData] forKey:@"result"];
    [dic setValue:ACK_USER_COMMAND_RECEIVED forKey:@"method"];
    [_currentChannel invokeMethod:ACK_USER_COMMAND_RECEIVED arguments:dic result:^(id  _Nullable result) {
    }];
}
- (void)receivedBypassPayload:(NSData *)rawData{
    NSMutableDictionary * dic = [[NSMutableDictionary alloc] init];
    [dic setValue:[FlutterStandardTypedData typedDataWithBytes:rawData] forKey:@"result"];
    [dic setValue:RECEIVED_BYPASS_PAYLOAD forKey:@"method"];
    [_currentChannel invokeMethod:RECEIVED_BYPASS_PAYLOAD arguments:dic result:^(id  _Nullable result) {
    }];
}
- (void)receivedCodeID:(int)codeID{
    NSMutableDictionary * dic = [[NSMutableDictionary alloc] init];
    [dic setValue:[NSNumber numberWithInt:codeID] forKey:@"result"];
    [dic setValue:RECEIVED_CODE_ID forKey:@"method"];
    [_currentChannel invokeMethod:RECEIVED_CODE_ID arguments:dic result:^(id  _Nullable result) {
    }];
}
- (void)receivedOCR: (BOOL)isNone ocrAon: (BOOL)isOCRAon ocrBOn: (BOOL)isOCRBon{
    NSMutableDictionary * dic = [[NSMutableDictionary alloc] init];
    [dic setValue:[NSNumber numberWithBool:isNone] forKey:@"isNone"];
    [dic setValue:[NSNumber numberWithBool:isOCRAon] forKey:@"isOCRAon"];
    [dic setValue:[NSNumber numberWithBool:isOCRBon] forKey:@"isOCRBon"];
    [dic setValue:RECEIVED_OCR forKey:@"method"];
    [_currentChannel invokeMethod:RECEIVED_OCR arguments:dic result:^(id  _Nullable result) {
    }];
}
- (void)receivedHID:(BOOL)hidOn receivediOSHID:(BOOL)iOShidOn{
    NSMutableDictionary * dic = [[NSMutableDictionary alloc] init];
    [dic setValue:[NSNumber numberWithBool:hidOn] forKey:@"hidOn"];
    [dic setValue:[NSNumber numberWithBool:iOShidOn] forKey:@"iOShidOn"];
    [dic setValue:RECEIVED_HID forKey:@"method"];
    [_currentChannel invokeMethod:RECEIVED_HID arguments:dic result:^(id  _Nullable result) {
    }];
}
- (void)receivedPresentationMode:(BOOL)isOn{
    NSMutableDictionary * dic = [[NSMutableDictionary alloc] init];
    [dic setValue:[NSNumber numberWithBool:isOn] forKey:@"isOn"];
    [dic setValue:RECEIVED_PRESENTATION_MODE forKey:@"method"];
    [_currentChannel invokeMethod:RECEIVED_PRESENTATION_MODE arguments:dic result:^(id  _Nullable result) {
    }];
}
- (void)receivedSleepBeep:(NSData *)data{
    NSMutableDictionary * dic = [[NSMutableDictionary alloc] init];
    [dic setValue:[FlutterStandardTypedData typedDataWithBytes:data] forKey:@"result"];
    [dic setValue:RECEIVED_SLEEP_BEEP forKey:@"method"];
    [_currentChannel invokeMethod:RECEIVED_SLEEP_BEEP arguments:dic result:^(id  _Nullable result) {
    }];
}
- (void)receivedBarcodeSetSsiSuccess:(NSData *)data{
    NSMutableDictionary * dic = [[NSMutableDictionary alloc] init];
    [dic setValue:[FlutterStandardTypedData typedDataWithBytes:data] forKey:@"result"];
    [dic setValue:RECEIVED_BARCODE_SET_SSI_SUCCESS forKey:@"method"];
    [_currentChannel invokeMethod:RECEIVED_BARCODE_SET_SSI_SUCCESS arguments:dic result:^(id  _Nullable result) {
    }];
}
- (void)receivedSymbologies:(NSDictionary*)symbols{
    NSMutableDictionary * dic = [[NSMutableDictionary alloc] init];
    NSMutableArray *dataArray = [[NSMutableArray alloc] init];
    for (NSString *key in symbols.allKeys) {
        BarcodeZebraSsiParam *param = [symbols objectForKey:key];
        NSMutableDictionary *paramDic = [[NSMutableDictionary alloc] init];
        [paramDic setValue:key forKey:@"key"];
        [paramDic setValue:[NSNumber numberWithInteger:param.number] forKey:@"number"];
        [paramDic setValue:[NSNumber numberWithInteger:param.status] forKey:@"status"];
        [paramDic setValue:param.name forKey:@"name"];
        [dataArray addObject:paramDic];
    }
    [dic setValue:dataArray forKey:@"dataArray"];
    [dic setValue:RECEIVED_SYMBOLOGIES forKey:@"method"];
    [_currentChannel invokeMethod:RECEIVED_SYMBOLOGIES arguments:dic result:^(id  _Nullable result) {
    }];
}
- (void)receivedGetAutoLaunch: (BOOL)isOn bundle:(NSString*)data{
    NSMutableDictionary * dic = [[NSMutableDictionary alloc] init];
    [dic setValue:[NSNumber numberWithBool:isOn] forKey:@"isOn"];
    [dic setValue:data forKey:@"data"];
    [dic setValue:RECEIVED_GET_AUTO_LAUNCH forKey:@"method"];
    [_currentChannel invokeMethod:RECEIVED_GET_AUTO_LAUNCH arguments:dic result:^(id  _Nullable result) {
    }];
}
- (void)receivedBarcodeSecurity:(NSDictionary*)security{
    NSMutableDictionary * dic = [[NSMutableDictionary alloc] init];
    NSMutableArray *dataArray = [[NSMutableArray alloc] init];
    for (NSString *key in security.allKeys) {
        BarcodeZebraSsiParam *param = [security objectForKey:key];
        NSMutableDictionary *paramDic = [[NSMutableDictionary alloc] init];
        [paramDic setValue:key forKey:@"key"];
        [paramDic setValue:[NSNumber numberWithInteger:param.number] forKey:@"number"];
        [paramDic setValue:[NSNumber numberWithInteger:param.status] forKey:@"status"];
        [paramDic setValue:param.name forKey:@"name"];
        [dataArray addObject:paramDic];
    }
    [dic setValue:dataArray forKey:@"dataArray"];
    [dic setValue:RECEIVED_BARCODE_SECURITY forKey:@"method"];
    [_currentChannel invokeMethod:RECEIVED_BARCODE_SECURITY arguments:dic result:^(id  _Nullable result) {
    }];
}
- (void)receivedScanBarcodeData:(NSData *)barcodeData barcodeType:(AsReader025SBarcodeType)barcodeType{
    NSMutableDictionary * dic = [[NSMutableDictionary alloc] init];
    [dic setValue:[FlutterStandardTypedData typedDataWithBytes:barcodeData] forKey:@"result"];
    NSString *type = [AsReader025SBarcode getBarcodeString:barcodeType];
    [dic setValue:type forKey:@"barcodeType"];
    [dic setValue:RECEIVED_SCAN_BARCODE_DATA forKey:@"method"];
    [_currentChannel invokeMethod:RECEIVED_SCAN_BARCODE_DATA arguments:dic result:^(id  _Nullable result) {
    }];
}
- (void)didGetSleepBuzzerReceived:(int)sleepBuzzer{
    NSMutableDictionary * dic = [[NSMutableDictionary alloc] init];
    [dic setValue:[NSNumber numberWithInt:sleepBuzzer] forKey:@"result"];
    [dic setValue:DID_GET_SLEEP_BUZZER_RECEIVED forKey:@"method"];
    [_currentChannel invokeMethod:DID_GET_SLEEP_BUZZER_RECEIVED arguments:dic result:^(id  _Nullable result) {
    }];
}
- (void)didSetSleepBuzzer:(int)status{
    NSMutableDictionary * dic = [[NSMutableDictionary alloc] init];
    [dic setValue:[NSNumber numberWithInt:status] forKey:@"result"];
    [dic setValue:DID_SET_SLEEP_BUZZER forKey:@"method"];
    [_currentChannel invokeMethod:DID_SET_SLEEP_BUZZER arguments:dic result:^(id  _Nullable result) {
    }];
}
- (void)didGetBarcodeTimeOutReceived:(int)barcodeTimeOut{
    NSMutableDictionary * dic = [[NSMutableDictionary alloc] init];
    [dic setValue:[NSNumber numberWithInt:barcodeTimeOut] forKey:@"result"];
    [dic setValue:DID_GET_BARCODE_TIME_OUT_RECEIVED forKey:@"method"];
    [_currentChannel invokeMethod:DID_GET_BARCODE_TIME_OUT_RECEIVED arguments:dic result:^(id  _Nullable result) {
    }];
}
- (void)didSetBarcodeTimeOut:(int)status{
    NSMutableDictionary * dic = [[NSMutableDictionary alloc] init];
    [dic setValue:[NSNumber numberWithInt:status] forKey:@"result"];
    [dic setValue:DID_SET_BARCODE_TIME_OUT forKey:@"method"];
    [_currentChannel invokeMethod:DID_SET_BARCODE_TIME_OUT arguments:dic result:^(id  _Nullable result) {
    }];
}
#pragma mark ----AsReaderBarcodeProtocol----END

#pragma mark ----AsReaderRFIDProtocol----START
- (void)epcReceived:(NSData *)epc tid:(NSData *)tid{
    NSMutableDictionary * dic = [[NSMutableDictionary alloc] init];
    [dic setValue:[FlutterStandardTypedData typedDataWithBytes:epc] forKey:@"epc"];
    [dic setValue:[FlutterStandardTypedData typedDataWithBytes:tid] forKey:@"tid"];
    [dic setValue:EPC_RECEIVED_AND_TID forKey:@"method"];
    [_currentChannel invokeMethod:EPC_RECEIVED_AND_TID arguments:dic result:^(id  _Nullable result) {
    }];
}
- (void)pcEpcReceived:(NSData *)pcEpc{
    NSMutableDictionary * dic = [[NSMutableDictionary alloc] init];
    [dic setValue:[FlutterStandardTypedData typedDataWithBytes:pcEpc] forKey:@"result"];
    [dic setValue:PC_EPC_RECEIVED forKey:@"method"];
    [_currentChannel invokeMethod:PC_EPC_RECEIVED arguments:dic result:^(id  _Nullable result) {
    }];
}
- (void)pcEpcRssiReceived:(NSData *)pcEpc rssi:(int)rssi{
    NSMutableDictionary * dic = [[NSMutableDictionary alloc] init];
    [dic setValue:[FlutterStandardTypedData typedDataWithBytes:pcEpc] forKey:@"pcEpc"];
    [dic setValue:[NSNumber numberWithInt:rssi] forKey:@"rssi"];
    [dic setValue:PC_EPC_RSSI_RECEIVED_AND_RSSI forKey:@"method"];
    [_currentChannel invokeMethod:PC_EPC_RSSI_RECEIVED_AND_RSSI arguments:dic result:^(id  _Nullable result) {
    }];
}
- (void)pcEpcSensorDataReceived:(NSData *)pcEpc sensorData:(NSData *)sensorData{
    NSMutableDictionary * dic = [[NSMutableDictionary alloc] init];
    [dic setValue:[FlutterStandardTypedData typedDataWithBytes:pcEpc] forKey:@"pcEpc"];
    [dic setValue:[FlutterStandardTypedData typedDataWithBytes:sensorData] forKey:@"sensorData"];
    [dic setValue:PC_EPC_SENSOR_DATA_RECEIVED forKey:@"method"];
    [_currentChannel invokeMethod:PC_EPC_SENSOR_DATA_RECEIVED arguments:dic result:^(id  _Nullable result) {
    }];
}

- (void)pcEpcSensorDataReceived:(NSData *)pcEpc sensorData:(NSData *)sensorData rssi:(int8_t)rssi{
    NSMutableDictionary * dic = [[NSMutableDictionary alloc] init];
    [dic setValue:[FlutterStandardTypedData typedDataWithBytes:pcEpc] forKey:@"pcEpc"];
    [dic setValue:[FlutterStandardTypedData typedDataWithBytes:sensorData] forKey:@"sensorData"];
    [dic setValue:[NSNumber numberWithInt:rssi] forKey:@"rssi"];
    [dic setValue:PC_EPC_SENSOR_DATA_RECEIVED_RSSI forKey:@"method"];
    [_currentChannel invokeMethod:PC_EPC_SENSOR_DATA_RECEIVED_RSSI arguments:dic result:^(id  _Nullable result) {
    }];
}

- (void)didSetOutputPowerLevel:(int)status{
    NSMutableDictionary * dic = [[NSMutableDictionary alloc] init];
    [dic setValue:[NSNumber numberWithInt:status] forKey:@"result"];
    [dic setValue:DID_SET_OUTPUT_POWER_LEVEL forKey:@"method"];
    [_currentChannel invokeMethod:DID_SET_OUTPUT_POWER_LEVEL arguments:dic result:^(id  _Nullable result) {
    }];
}

- (void)didSetChannelParamReceived:(int)statusCode{
    NSMutableDictionary * dic = [[NSMutableDictionary alloc] init];
    [dic setValue:[NSNumber numberWithInt:statusCode] forKey:@"result"];
    [dic setValue:DID_SET_CHANNEL_PARAM_RECEIVED forKey:@"method"];
    [_currentChannel invokeMethod:DID_SET_CHANNEL_PARAM_RECEIVED arguments:dic result:^(id  _Nullable result) {
    }];
}

- (void)didSetAntiCollision:(int)status{
    NSMutableDictionary * dic = [[NSMutableDictionary alloc] init];
    [dic setValue:[NSNumber numberWithInt:status] forKey:@"result"];
    [dic setValue:DID_SET_ANTI_COLLISION forKey:@"method"];
    [_currentChannel invokeMethod:DID_SET_ANTI_COLLISION arguments:dic result:^(id  _Nullable result) {
    }];
}

- (void)didSetSession:(int)status{
    NSMutableDictionary * dic = [[NSMutableDictionary alloc] init];
    [dic setValue:[NSNumber numberWithInt:status] forKey:@"result"];
    [dic setValue:DID_SET_SESSION forKey:@"method"];
    [_currentChannel invokeMethod:DID_SET_SESSION arguments:dic result:^(id  _Nullable result) {
    }];
}
- (void)didSetBeep:(int)status{
    NSMutableDictionary * dic = [[NSMutableDictionary alloc] init];
    [dic setValue:[NSNumber numberWithInt:status] forKey:@"result"];
    [dic setValue:DID_SET_BEEP forKey:@"method"];
    [_currentChannel invokeMethod:DID_SET_BEEP arguments:dic result:^(id  _Nullable result) {
    }];
}
//- (void)didSetStopCondition:(int)status{
//}
- (void)channelReceived:(int)channel channelOffset:(int)channelOffset{
    NSMutableDictionary * dic = [[NSMutableDictionary alloc] init];
    [dic setValue:[NSNumber numberWithInt:channel] forKey:@"channel"];
    [dic setValue:[NSNumber numberWithInt:channelOffset] forKey:@"channelOffset"];
    [dic setValue:CHANNEL_RECEIVED_AND_CHANNEL_OFFSET forKey:@"method"];
    [_currentChannel invokeMethod:CHANNEL_RECEIVED_AND_CHANNEL_OFFSET arguments:dic result:^(id  _Nullable result) {
    }];
}

- (void)anticolParamReceived:(int)mode Counter:(int)counter{
    NSMutableDictionary * dic = [[NSMutableDictionary alloc] init];
    [dic setValue:[NSNumber numberWithInt:mode] forKey:@"mode"];
    [dic setValue:[NSNumber numberWithInt:counter] forKey:@"counter"];
    [dic setValue:ANTICOL_PARAM_RECEIVED_AND_COUNTER forKey:@"method"];
    [_currentChannel invokeMethod:ANTICOL_PARAM_RECEIVED_AND_COUNTER arguments:dic result:^(id  _Nullable result) {
    }];
}

- (void)modulationParamReceived:(int)blf rxMod:(int)rxMod dr:(int)dr{
    NSMutableDictionary * dic = [[NSMutableDictionary alloc] init];
    [dic setValue:[NSNumber numberWithInt:blf] forKey:@"blf"];
    [dic setValue:[NSNumber numberWithInt:rxMod] forKey:@"rxMod"];
    [dic setValue:[NSNumber numberWithInt:dr] forKey:@"dr"];
    [dic setValue:MODULATION_PARAM_RECEIVED_RXMOD_DR forKey:@"method"];
    [_currentChannel invokeMethod:MODULATION_PARAM_RECEIVED_RXMOD_DR arguments:dic result:^(id  _Nullable result) {
    }];
}

- (void)txPowerLevelReceived:(NSData*)power{
    NSMutableDictionary * dic = [[NSMutableDictionary alloc] init];
    [dic setValue:[FlutterStandardTypedData typedDataWithBytes:power] forKey:@"result"];
    [dic setValue:TX_POWER_LEVEL_RECEIVED_POWER forKey:@"method"];
    [_currentChannel invokeMethod:TX_POWER_LEVEL_RECEIVED_POWER arguments:dic result:^(id  _Nullable result) {
    }];
}

- (void)regionReceived:(int)region{
    NSMutableDictionary * dic = [[NSMutableDictionary alloc] init];
    [dic setValue:[NSNumber numberWithInt:region] forKey:@"result"];
    [dic setValue:REGION_RECEIVED forKey:@"method"];
    [_currentChannel invokeMethod:REGION_RECEIVED arguments:dic result:^(id  _Nullable result) {
    }];
}
//- (void)stopConditionsReceived:(NSData *)data{
//    
//}
- (void)selectParamReceived:(NSData *)selParam{
    NSMutableDictionary * dic = [[NSMutableDictionary alloc] init];
    [dic setValue:[FlutterStandardTypedData typedDataWithBytes:selParam] forKey:@"result"];
    [dic setValue:SELECT_PARAM_RECEIVED forKey:@"method"];
    [_currentChannel invokeMethod:SELECT_PARAM_RECEIVED arguments:dic result:^(id  _Nullable result) {
    }];
}
- (void)queryParamReceived:(NSData *)qryParam{
    NSMutableDictionary * dic = [[NSMutableDictionary alloc] init];
    [dic setValue:[FlutterStandardTypedData typedDataWithBytes:qryParam] forKey:@"result"];
    [dic setValue:QUERY_PARAM_RECEIVED forKey:@"method"];
    [_currentChannel invokeMethod:QUERY_PARAM_RECEIVED arguments:dic result:^(id  _Nullable result) {
    }];
}
- (void)onOffTimeChanged{
    NSMutableDictionary * dic = [[NSMutableDictionary alloc] init];
    [dic setValue:ON_OFF_TIME_CHANGED forKey:@"method"];
    [_currentChannel invokeMethod:ON_OFF_TIME_CHANGED arguments:dic result:^(id  _Nullable result) {
    }];
}
- (void)freqHPTableReceived:(int)status{
    NSMutableDictionary * dic = [[NSMutableDictionary alloc] init];
    [dic setValue:[NSNumber numberWithInt:status] forKey:@"result"];
    [dic setValue:FREQ_HP_TABLE_RECEIVED forKey:@"method"];
    [_currentChannel invokeMethod:FREQ_HP_TABLE_RECEIVED arguments:dic result:^(id  _Nullable result) {
    }];
}
- (void)fhLbtReceived:(NSData *)fhLb{
    NSMutableDictionary * dic = [[NSMutableDictionary alloc] init];
    [dic setValue:[FlutterStandardTypedData typedDataWithBytes:fhLb] forKey:@"result"];
    [dic setValue:FHLBT_RECEIVED forKey:@"method"];
    [_currentChannel invokeMethod:FHLBT_RECEIVED arguments:dic result:^(id  _Nullable result) {
    }];
}
- (void)hoppingTableReceived:(NSData *)table{
    NSMutableDictionary * dic = [[NSMutableDictionary alloc] init];
    [dic setValue:[FlutterStandardTypedData typedDataWithBytes:table] forKey:@"result"];
    [dic setValue:HOPPING_TABLE_RECEIVED forKey:@"method"];
    [_currentChannel invokeMethod:HOPPING_TABLE_RECEIVED arguments:dic result:^(id  _Nullable result) {
    }];
}
- (void)didSetFreqHPTable:(int)status{
    NSMutableDictionary * dic = [[NSMutableDictionary alloc] init];
    [dic setValue:[NSNumber numberWithInt:status] forKey:@"result"];
    [dic setValue:DID_SET_FREQ_HP_TABLE forKey:@"method"];
    [_currentChannel invokeMethod:DID_SET_FREQ_HP_TABLE arguments:dic result:^(id  _Nullable result) {
    }];
}
- (void)didSetFhLbt:(int)status{
    NSMutableDictionary * dic = [[NSMutableDictionary alloc] init];
    [dic setValue:[NSNumber numberWithInt:status] forKey:@"result"];
    [dic setValue:DID_SET_FHLBT forKey:@"method"];
    [_currentChannel invokeMethod:DID_SET_FHLBT arguments:dic result:^(id  _Nullable result) {
    }];
}

- (void)didSetOptiFreqHPTable:(int)status{
    NSMutableDictionary * dic = [[NSMutableDictionary alloc] init];
    [dic setValue:[NSNumber numberWithInt:status] forKey:@"result"];
    [dic setValue:DID_SET_OPTI_FREQ_HPTABLE forKey:@"method"];
    [_currentChannel invokeMethod:DID_SET_OPTI_FREQ_HPTABLE arguments:dic result:^(id  _Nullable result) {
    }];
}

- (void)didSetFHmodeChanged{
    NSMutableDictionary * dic = [[NSMutableDictionary alloc] init];
    [dic setValue:DID_SET_FHMODE_CHANGED forKey:@"method"];
    [_currentChannel invokeMethod:DID_SET_FHMODE_CHANGED arguments:dic result:^(id  _Nullable result) {
    }];
}
- (void)responseGetFHmode{
    NSMutableDictionary * dic = [[NSMutableDictionary alloc] init];
    [_currentChannel invokeMethod:RESPONSE_GET_FH_MODE arguments:dic result:^(id  _Nullable result) {
    }];
}

- (void)didSetModulation:(int)status{
    NSMutableDictionary * dic = [[NSMutableDictionary alloc] init];
    [dic setValue:[NSNumber numberWithInt:status] forKey:@"result"];
    [dic setValue:DID_SET_MODULATION forKey:@"method"];
    [_currentChannel invokeMethod:DID_SET_MODULATION arguments:dic result:^(id  _Nullable result) {
    }];
}

- (void)rfidModuleVersionReceived{
    NSMutableDictionary * dic = [[NSMutableDictionary alloc] init];
    [dic setValue:RFID_MODULE_VERSION_RECEIVED forKey:@"method"];
    [_currentChannel invokeMethod:RFID_MODULE_VERSION_RECEIVED arguments:dic result:^(id  _Nullable result) {
    }];
}
//- (void)readerInfoReceived:(NSData *)data{
//}
- (void)rfidOnOffTimeReceived:(NSData*)data{
    NSMutableDictionary * dic = [[NSMutableDictionary alloc] init];
    [dic setValue:[FlutterStandardTypedData typedDataWithBytes:data] forKey:@"result"];
    [dic setValue:RFID_ON_OFF_TIME_RECEIVED forKey:@"method"];
    [_currentChannel invokeMethod:RFID_ON_OFF_TIME_RECEIVED arguments:dic result:^(id  _Nullable result) {
    }];
}

- (void)rssiThresholdReceived:(uint16_t)threshold{
    NSMutableDictionary * dic = [[NSMutableDictionary alloc] init];
    [dic setValue:[NSNumber numberWithInt:threshold] forKey:@"result"];
    [dic setValue:RSSI_THRESHOLD_RECEIVED forKey:@"method"];
    [_currentChannel invokeMethod:RSSI_THRESHOLD_RECEIVED arguments:dic result:^(id  _Nullable result) {
    }];
}

- (void)writtenReceived:(int)statusCode{
    NSMutableDictionary * dic = [[NSMutableDictionary alloc] init];
    [dic setValue:[NSNumber numberWithInt:statusCode] forKey:@"result"];
    [dic setValue:WRITTEN_RECEIVED forKey:@"method"];
    [_currentChannel invokeMethod:WRITTEN_RECEIVED arguments:dic result:^(id  _Nullable result) {
    }];
}

- (void)sessionReceived:(int)session{
    NSMutableDictionary * dic = [[NSMutableDictionary alloc] init];
    [dic setValue:[NSNumber numberWithInt:session] forKey:@"result"];
    [dic setValue:SESSION_RECEIVED forKey:@"method"];
    [_currentChannel invokeMethod:SESSION_RECEIVED arguments:dic result:^(id  _Nullable result) {
    }];
}
- (void)tagMemoryReceived:(NSData *)data{
    NSMutableDictionary * dic = [[NSMutableDictionary alloc] init];
    [dic setValue:[FlutterStandardTypedData typedDataWithBytes:data] forKey:@"result"];
    [dic setValue:TAG_MEMORY_RECEIVED forKey:@"method"];
    [_currentChannel invokeMethod:TAG_MEMORY_RECEIVED arguments:dic result:^(id  _Nullable result) {
    }];
}

- (void)killedReceived:(int)statusCode{
    NSMutableDictionary * dic = [[NSMutableDictionary alloc] init];
    [dic setValue:[NSNumber numberWithInt:statusCode] forKey:@"result"];
    [dic setValue:KILL_RECEIVED forKey:@"method"];
    [_currentChannel invokeMethod:KILL_RECEIVED arguments:dic result:^(id  _Nullable result) {
    }];
}

- (void)lockedReceived:(int)statusCode{
    NSMutableDictionary * dic = [[NSMutableDictionary alloc] init];
    [dic setValue:[NSNumber numberWithInt:statusCode] forKey:@"result"];
    [dic setValue:LOCKED_RECEIVED forKey:@"method"];
    [_currentChannel invokeMethod:LOCKED_RECEIVED arguments:dic result:^(id  _Nullable result) {
    }];
}
- (void)registeryItemReceived:(NSData *)item{
    NSMutableDictionary * dic = [[NSMutableDictionary alloc] init];
    [dic setValue:[FlutterStandardTypedData typedDataWithBytes:item] forKey:@"result"];
    [dic setValue:REGISTERY_ITEM_RECEIVED forKey:@"method"];
    [_currentChannel invokeMethod:REGISTERY_ITEM_RECEIVED arguments:dic result:^(id  _Nullable result) {
    }];
}
- (void)genericReceived:(NSData*)data{
    NSMutableDictionary * dic = [[NSMutableDictionary alloc] init];
    [dic setValue:[FlutterStandardTypedData typedDataWithBytes:data] forKey:@"result"];
    [dic setValue:GENERIC_RECEIVED forKey:@"method"];
    [_currentChannel invokeMethod:GENERIC_RECEIVED arguments:dic result:^(id  _Nullable result) {
    }];
}
- (void)responseReboot:(int)status{
    NSMutableDictionary * dic = [[NSMutableDictionary alloc] init];
    [dic setValue:[NSNumber numberWithInt:status] forKey:@"result"];
    [dic setValue:RESPONSE_REBOOT forKey:@"method"];
    [_currentChannel invokeMethod:RESPONSE_REBOOT arguments:dic result:^(id  _Nullable result) {
    }];
}

- (void)updatedRegistry:(int)statusCode{
    NSMutableDictionary * dic = [[NSMutableDictionary alloc] init];
    [dic setValue:[NSNumber numberWithInt:statusCode] forKey:@"result"];
    [dic setValue:UPDATED_REGISTERY forKey:@"method"];
    [_currentChannel invokeMethod:UPDATED_REGISTERY arguments:dic result:^(id  _Nullable result) {
    }];
}
//- (void)responseFWData:(NSData *)FWData{
//}
- (void)rfidDataReceived:(NSData *)data{
    NSMutableDictionary * dic = [[NSMutableDictionary alloc] init];
    [dic setValue:[FlutterStandardTypedData typedDataWithBytes:data] forKey:@"result"];
    [dic setValue:RFID_DATA_RECEIVED forKey:@"method"];
    [_currentChannel invokeMethod:RFID_DATA_RECEIVED arguments:dic result:^(id  _Nullable result) {
    }];
}
-(void)responseSetLeakage:(int)status{
    NSMutableDictionary * dic = [[NSMutableDictionary alloc] init];
    [dic setValue:[NSNumber numberWithInt:status] forKey:@"result"];
    [dic setValue:RESPONSE_SET_LEAKAGE forKey:@"method"];
    [_currentChannel invokeMethod:RESPONSE_SET_LEAKAGE arguments:dic result:^(id  _Nullable result) {
    }];
}
- (void)didGetAutoOffTimeReceived:(int)time{
    NSMutableDictionary * dic = [[NSMutableDictionary alloc] init];
    [dic setValue:[NSNumber numberWithInt:time] forKey:@"result"];
    [dic setValue:DID_GET_AUTO_OFF_TIME_RECEIVED forKey:@"method"];
    [_currentChannel invokeMethod:DID_GET_AUTO_OFF_TIME_RECEIVED arguments:dic result:^(id  _Nullable result) {
    }];
}
- (void)didSetAutoOffTime:(int)status{
    NSMutableDictionary * dic = [[NSMutableDictionary alloc] init];
    [dic setValue:[NSNumber numberWithInt:status] forKey:@"result"];
    [dic setValue:DID_SET_AUTO_OFF_TIME forKey:@"method"];
    [_currentChannel invokeMethod:DID_SET_AUTO_OFF_TIME arguments:dic result:^(id  _Nullable result) {
    }];
}
- (void)didGetContinuousModeReceived:(BOOL)continuousMode{
    NSMutableDictionary * dic = [[NSMutableDictionary alloc] init];
    [dic setValue:[NSNumber numberWithBool:continuousMode] forKey:@"result"];
    [dic setValue:DID_GET_CONTINUOUS_MODE_RECEIVED forKey:@"method"];
    [_currentChannel invokeMethod:DID_GET_CONTINUOUS_MODE_RECEIVED arguments:dic result:^(id  _Nullable result) {
    }];
}
- (void)didSetContinuousMode:(int)status{
    NSMutableDictionary * dic = [[NSMutableDictionary alloc] init];
    [dic setValue:[NSNumber numberWithInt:status] forKey:@"result"];
    [dic setValue:DID_SET_CONTINUOUS_MODE forKey:@"method"];
    [_currentChannel invokeMethod:DID_SET_CONTINUOUS_MODE arguments:dic result:^(id  _Nullable result) {
    }];
}
- (void)didGetQValueReceived:(NSString *)value{
    NSMutableDictionary * dic = [[NSMutableDictionary alloc] init];
    [dic setValue:value forKey:@"result"];
    [dic setValue:DID_GET_Q_VALUE_RECEIVED forKey:@"method"];
    [_currentChannel invokeMethod:DID_GET_Q_VALUE_RECEIVED arguments:dic result:^(id  _Nullable result) {
    }];
}
- (void)didSetQValue:(int)status{
    NSMutableDictionary * dic = [[NSMutableDictionary alloc] init];
    [dic setValue:[NSNumber numberWithInt:status] forKey:@"result"];
    [dic setValue:DID_SET_Q_VALUE forKey:@"method"];
    [_currentChannel invokeMethod:DID_SET_Q_VALUE arguments:dic result:^(id  _Nullable result) {
    }];
}
- (void)didGetSessionFlagReceived:(int)value{
    NSMutableDictionary * dic = [[NSMutableDictionary alloc] init];
    [dic setValue:[NSNumber numberWithInt:value] forKey:@"result"];
    [dic setValue:DID_GET_SESSION_FLAG_RECEIVED forKey:@"method"];
    [_currentChannel invokeMethod:DID_GET_SESSION_FLAG_RECEIVED arguments:dic result:^(id  _Nullable result) {
    }];
}
- (void)didSetSessionFlag:(int)status{
    NSMutableDictionary * dic = [[NSMutableDictionary alloc] init];
    [dic setValue:[NSNumber numberWithInt:status] forKey:@"result"];
    [dic setValue:DID_SET_SESSION_FLAG forKey:@"method"];
    [_currentChannel invokeMethod:DID_SET_SESSION_FLAG arguments:dic result:^(id  _Nullable result) {
    }];
}
- (void)didGetHidModeReceived:(BOOL)value{
    NSMutableDictionary * dic = [[NSMutableDictionary alloc] init];
    [dic setValue:[NSNumber numberWithBool:value] forKey:@"result"];
    [dic setValue:DID_GET_HID_MODE_RECEIVED forKey:@"method"];
    [_currentChannel invokeMethod:DID_GET_HID_MODE_RECEIVED arguments:dic result:^(id  _Nullable result) {
    }];
}
- (void)didSetHidMode:(int)status{
    NSMutableDictionary * dic = [[NSMutableDictionary alloc] init];
    [dic setValue:[NSNumber numberWithInt:status] forKey:@"result"];
    [dic setValue:DID_SET_HID_MODE forKey:@"method"];
    [_currentChannel invokeMethod:DID_SET_HID_MODE arguments:dic result:^(id  _Nullable result) {
    }];
}
- (void)didGetDutyRatioReceived:(int)value{
    NSMutableDictionary * dic = [[NSMutableDictionary alloc] init];
    [dic setValue:[NSNumber numberWithInt:value] forKey:@"result"];
    [dic setValue:DID_GET_DUTY_RATIO_RECEIVED forKey:@"method"];
    [_currentChannel invokeMethod:DID_GET_DUTY_RATIO_RECEIVED arguments:dic result:^(id  _Nullable result) {
    }];
}
- (void)didSetDutyRatio:(int)status{
    NSMutableDictionary * dic = [[NSMutableDictionary alloc] init];
    [dic setValue:[NSNumber numberWithInt:status] forKey:@"result"];
    [dic setValue:DID_SET_DUTY_RATIO forKey:@"method"];
    [_currentChannel invokeMethod:DID_SET_DUTY_RATIO arguments:dic result:^(id  _Nullable result) {
    }];
}
- (void)didGetDutyRatioBaseTimeReceived:(int)value{
    NSMutableDictionary * dic = [[NSMutableDictionary alloc] init];
    [dic setValue:[NSNumber numberWithInt:value] forKey:@"result"];
    [dic setValue:DID_GET_DUTY_RATIO_BASE_TIME_RECEIVED forKey:@"method"];
    [_currentChannel invokeMethod:DID_GET_DUTY_RATIO_BASE_TIME_RECEIVED arguments:dic result:^(id  _Nullable result) {
    }];
}
- (void)didSetDutyRatioBaseTime:(int)status{
    NSMutableDictionary * dic = [[NSMutableDictionary alloc] init];
    [dic setValue:[NSNumber numberWithInt:status] forKey:@"result"];
    [dic setValue:DID_SET_DUTY_RATIO_BASE_TIME forKey:@"method"];
    [_currentChannel invokeMethod:DID_SET_DUTY_RATIO_BASE_TIME arguments:dic result:^(id  _Nullable result) {
    }];
}
#pragma mark ----AsReaderRFIDProtocol----END

#pragma mark ----AsReaderNFCProtocol----START
- (void)nfcReadMultiBlockReceived:(NSArray *)dataArray
                       statusCode:(SDK4StatusCode)statusCode{
    NSMutableDictionary * dic = [[NSMutableDictionary alloc] init];
    [dic setValue:dataArray forKey:@"dataArray"];
    [dic setValue:[NSNumber numberWithInt:(int)statusCode] forKey:@"statusCode"];
    [dic setValue:NFC_READ_MULTI_BLOCK_RECEIVED forKey:@"method"];
    [_currentChannel invokeMethod:NFC_READ_MULTI_BLOCK_RECEIVED arguments:dic result:^(id  _Nullable result) {
    }];
}

- (void)nfcWriteSingleBlockStatusCode:(SDK4StatusCode)statusCode{
    NSMutableDictionary * dic = [[NSMutableDictionary alloc] init];
    [dic setValue:[NSNumber numberWithInt:(int)statusCode] forKey:@"result"];
    [dic setValue:NFC_WRITE_SINGLE_BLOCK_STATUS_CODE forKey:@"method"];
    [_currentChannel invokeMethod:NFC_WRITE_SINGLE_BLOCK_STATUS_CODE arguments:dic result:^(id  _Nullable result) {
    }];
}
    
- (void)nfcWriteBytesStatusCode:(SDK4StatusCode)statusCode{
    NSMutableDictionary * dic = [[NSMutableDictionary alloc] init];
    [dic setValue:[NSNumber numberWithInt:(int)statusCode] forKey:@"result"];
    [dic setValue:NFC_WRITE_BYTES_STATUS_CODE forKey:@"method"];
    [_currentChannel invokeMethod:NFC_WRITE_BYTES_STATUS_CODE arguments:dic result:^(id  _Nullable result) {
    }];
}
#pragma mark ----AsReaderNFCProtocol----END

#pragma mark ----AsReaderBLEProtocols----START
- (void)scanningBleDeive:(CBPeripheral*)device{
    if (![scanBLEDevice containsObject:device]) {
        [scanBLEDevice addObject:device];
    }
    NSMutableDictionary * dic = [[NSMutableDictionary alloc] init];
    [dic setValue:device.name forKey:@"name"];
    [_currentChannel invokeMethod:SCANING_BLE_DEVICE arguments:dic result:^(id  _Nullable result) {
    }];
}
 
- (void)scanBleStatus:(BleStatusCodes)status{
    NSMutableDictionary * dic = [[NSMutableDictionary alloc] init];
    [dic setValue:[NSString stringWithFormat:@"%lu",static_cast<unsigned long>(status)] forKey:@"status"];
    [_currentChannel invokeMethod:SCAN_BLE_STATUS arguments:dic result:^(id  _Nullable result) {
    }];
}
#pragma mark ----AsReaderBLEProtocols----END

#pragma mark ----AsReaderLfDeviceDelegate----START
- (void)lfTagReceived:(NSData *)lfTag{
    
}
#pragma mark ----AsReaderLfDeviceDelegate----END

@end
