#import "AsreaderSdk4Plugin.h"
#import "AsReaderSDK4Manager.h"
#define GET_PLATFORM_VERSION                  @"getPlatformVersion"
#define GET_PLUGGED_STATUS                    @"getPluggedStatus"
#define GET_SDK_VERSION                       @"getSDKVersion"
#define GET_FLUTTER_SDK_VERSION               @"getFlutterSDKVersion"
#define SHOW_PRINT_NSLOG                      @"showPrintNSLog"
#define GET_READER_INFO                       @"getReaderInfo"
#define GET_CURRENT_BATTERY                   @"getCurrentBattery"
#define SET_BEEP_VIBRATION_LED_AIMER          @"setBeepVibrationLedAimer"
#define SET_BEEP_VIBRATION_LED_AIMER_POWERONBEEP  @"setBeepVibrationLedAimerPoweronbeep"
#define SET_READERPOWER                       @"setReaderPower"
#define SET_TAG_COUNT                         @"setTagCount"
#define SET_CHARGING_CONTROL                  @"setChargingControl"
#define SET_DELAY_DISCONNECT_ON_BACKGROUND    @"setDelayDisconnectOnBackground"
#define GET_DELAY_DISCONNECT_ON_BACKGROUND    @"getDelayDisconnectOnBackground"
#define IS_OPEN                               @"isOpened"
#define SET_STOP_TAG_NUM                      @"setStopTagNum"
#define GET_STOP_CONDITION                    @"getStopCondition"
#define SET_TRIGGER_MODE                      @"setTriggerMode"
#define RESET                                 @"reset"
#define GET_AUTO_LAUNCH                       @"getAutoLaunch"
#define SET_AUTO_LAUNCH_BUNDLEID              @"setAutoLaunchBundleID"
#define SET_SLEEP_BEEP                        @"setSleepBeep"
#define SET_SLEEP_TIME                        @"setSleepTime"
#define GET_SLEEP_TIME                        @"getSleepTime"
#define START_BLE_SCAN                        @"startBleScan"
#define STOP_BLE_SCAN                         @"stopBleScan"
#define DIS_CONNECT_BLE                       @"disConnectBLE"
#define CONNECT_BLE                           @"connectBLE"
#define GET_SLEEP_TIME_FOR_BLE_DEVICE         @"getSleepTimeForBLEDevice"
#define SET_SLEEP_TIME_FOR_BLE_DEVICE_TYPE    @"setSleepTimeForBLEDeviceType"
#define START_BARCODE_SCAN                    @"startBarcodeScan"
#define STOP_BARCODE_SCAN                     @"stopBarcodeScan"
#define DO_FACTORY_RESET                      @"doFactoryReset"
#define SEND_BARCODE_SETTING_DATA             @"sendBarcodeSettingData"
#define SEND_BARCODE_HONEYWELL_SETTING_DATA   @"sendBarcodeHoneywellSettingWithData"
#define SET_CUSTOM_PREFIX                     @"setCustomPrefix"
#define SET_DISABLE_CUSTOM_PREFIX             @"setDisableCustomPrefix"
#define SET_CUSTOM_SUFFIX                     @"setCustomSuffix"
#define SET_DISABLE_CUSTOM_SUFFIX             @"setDisableCustomSuffix"
#define SET_SYMBOLOGY_PREFIX                  @"setSymbologyPrefix"
#define SET_DISABLE_SYMBOLOGY_PREFIX          @"setDisableSymbologyPrefix"
#define SET_BARCODE_ENGINE_USER_COMMAND       @"setBarcodeEngineUserCommand"
#define SET_CODEID_ISBEEPON                   @"setCodeIDIsBeepOn"
#define SET_OCRTYPE_ISBEEPON                  @"setOCRTypeIsBeepOn"
#define SET_ANDROID_HID_ENABLE                @"setAndroidHIDEnable"
#define SET_IOS_HID_ENABLE                    @"setIOSHIDEnable"
#define SET_PRESENTATION_MODE                 @"setPresentationMode"
#define GET_CODE_ID                           @"getCodeID"
#define GET_OCR                               @"getOCR"
#define GET_HID                               @"getHID"
#define GET_SYMBOLOGIES                       @"getSymbologies"
#define SET_SSI_PARAM_WITH_DATA               @"setSsiParamWithData"
#define SET_SSI_PARAM_WITH_DICTIONARY         @"setSsiParamWithDictionary"
#define GET_PRESENTATION_MODE                 @"getPresentationMode"
#define GET_SECURITY                          @"getSecurity"
#define START_SCAN                            @"startScan"
#define STOP_RFID_SCAN                        @"stopRfidScan"
#define START_READ_TAGS_AND_RSSI              @"startReadTagsAndRssi"
#define START_READ_TAG_AND_TID                @"startReadTagAndTid"
#define START_READ_TAGS_RFM                   @"startReadTagsRFM"
#define GET_SELECT_PARAMETER                  @"getSelectParameter"
#define SET_SELECT_PARAMETER                  @"setSelectParameter"
#define GET_CHANNEL                           @"getChannel"
#define SET_READ_TIME                         @"setReadTime"
#define SET_CHANNEL                           @"setChannel"
#define GET_FHLBT_PARAMETER                   @"getFhLbtParameter"
#define SET_FHLBT_PARAMETER                   @"setFhLbtParameter"
#define GET_OUTPUT_POWER_LEVEL                @"getOutputPowerLevel"
#define SET_OUTPUT_POWER_LEVEL                @"setOutputPowerLevel"
#define WRITE_TAG_MEMORY_WITH_ACCESS_PASSWORD @"writeTagMemoryWithAccessPassword"
#define KILL_TAG_WITH_PASSWORD                @"killTagWithPassword"
#define LOCK_TAG_MEMORY_WITH_ACCESS_PASSWORD  @"lockTagMemoryWithAccessPassword"
#define GET_FREQUENCY_HOPPING_TABLE           @"getFrequencyHoppingTable"
#define SET_FREQUENCY_HOPPING_TABLE           @"setFrequencyHoppingTableSize"
#define GET_RSSI                              @"getRssi"
#define GET_SESSION                           @"getSession"
#define SET_SESSION                           @"setSession"
#define GET_ANTICOLLISION                     @"getAnticollision"
#define SET_ANTICOLLISION                     @"setAnticollision"
#define UPDATE_REGISTRY                       @"updateRegistry"
#define GET_RFID_MODULE_VERSION               @"getRFIDModuleVersion"
#define SET_HOPPING_ON_OFF                    @"setHoppingOnOff"
#define WRITE_TAG_MEMORY_WITH_EPC             @"writeTagMemoryWithEPC"
#define SET_RSSI_THRESHOLD                    @"setRSSIThreshold"
#define GET_RSSI_THRESHOLD                    @"getRSSIThreshold"
#define GET_QUERY_PARAMETER                   @"getQueryParameter"
#define READ_TAG_WITH_ACCESS_PASSWORD         @"readTagWithAccessPassword"
#define SET_QUERY_PARAM                       @"setQueryParam"
#define SET_RF_CW                             @"setRfCw"
#define GET_MODULATION                        @"getModulation"
#define SET_MODULATION_BLF                    @"setModulationBLF"
#define BLOCK_ERASE_TAG_MEMORY_WITH_ACCESS_PASSWORD @"blockEraseTagMemoryWithAccessPassword"
#define GENERIC_TRANSPORT_WITH_ACCESS_PASSWORD  @"genericTransportWithAccessPassword"
#define GET_TEMPERATURE                       @"getTemperature"
#define GET_REGISTRY_ITEM                     @"getRegistryItem"
#define SET_OPTIMUM_FREQUENCY_HOPPING_TABLE   @"setOptimumFrequencyHoppingTable"
#define SET_FREQUENCY_HOPPING_MODE            @"setFrequencyHoppingMode"
#define GET_FREQUENCY_HOPPING_MODE            @"getFrequencyHoppingMode"
#define SET_SMART_HOPPING_ON_OFF              @"setSmartHoppingOnOff"
#define GET_REGION                            @"getRegion"
#define SET_READ_RSSI_MODE                    @"setReadRSSIMode"
#define GET_RFID_MODULE_INFORMATION           @"getRfidModuleInformation"
#define GET_HOPPING_ON_OFF                    @"getHoppingOnOff"
#define GET_AUTO_OFF_TIME                     @"getAutoOffTime"
#define SET_AUTO_OFF_TIME                     @"setAutoOffTime"
#define GET_CONTINUOUS_MODE                   @"getContinuousMode"
#define SET_CONTINUOUS_MODE                   @"setContinuousMode"
#define GET_Q_VALUE                           @"getQValue"
#define SET_Q_VALUE                           @"setQValue"
#define GET_SESSION_FLAG                      @"getSessionFlag"
#define SET_SESSION_FLAG                      @"setSessionFlag"
#define GET_HID_MODE                          @"getHidMode"
#define SET_HID_MODE                          @"setHidMode"
#define GET_DUTY_RATIO                        @"getDutyRatio"
#define SET_DUTY_RATIO                        @"setDutyRatio"
#define GET_DUTY_RATIO_BASE_TIME              @"getDutyRatioBaseTime"
#define SET_DUTY_RATIO_BASE_TIME              @"setDutyRatioBaseTime"
#define SEND_DATA                             @"sendData"
#define SET_INVENTORY_TIME                    @"setInventoryTime"
#define START_NFC_SCAN                        @"startNFCScan"
#define STOP_NFC_SCAN                         @"stopNFCScan"
#define READ_MULTI_BLOCK_WITH_BLOCK_INDEX     @"readMultiBlockWithBlockIndex"
#define WRITE_SINGLE_BLOCK_WITH_BLOCK_INDEX   @"writeSingleBlockWithBlockIndex"
#define WRITE_BYTES_WITH_BLOCK_INDEX          @"writeBytesWithBlockIndex"
#define START_LF_SCAN                         @"startLfScan"
#define STOP_LF_SCAN                          @"stopLfScan"
#define IS_SHOW_PRINT_NSLOG                   @"isShowPrintNSLog"
#define BUNDLE_IDENTIFIER                     @"bundleIdentifier"
#define DEVICE_NAME                           @"deviceName"
#define DEVICE_FIRMWARE                       @"deviceFirmware"
#define DEVICE_HARDWARE                       @"deviceHardware"
#define DEVICE_ID                             @"deviceID"
#define DEVICE_MANUFACTURER                   @"deviceManufacturer"
#define DEVICE_MODEL_NUMBER                   @"deviceModelNumber"
#define DEVICE_SERIAL_NUMBER                  @"deviceSerialNumber"
#define DEVICE_PROTOCOL                       @"deviceProtocol"
#define CURRENT_SELECT_DEVICE                 @"currentSelectDevice"
#define IS_POWER_ON                           @"isPowerOn"
#define SUPPORT_MODE                          @"supportMode"
#define CURRENT_READER_MODE                   @"currentReaderMode"
#define RECEIVE_DATA_TYPE                     @"receiveDataType"
#define DUAL_SAME_TIME                        @"dualSameTime"
#define IS_BEEP                               @"isBeep"
#define IS_VIBRATION                          @"isVibration"
#define IS_LED                                @"isLED"
#define IS_ILLUMINATION                       @"isIllumination"
#define COUNT                                 @"count"
#define SCAN_TIME                             @"scanTime"
#define CYCLE                                 @"cycle"
#define IS_TRIGGER_MODE_DEFAULT               @"isTriggerModeDefault"
#define IS_READ_RSSI_MODE                     @"isReadRSSIMode"
#define IS_ENGINE_POWER_ALWAYS_ON             @"isEnginePowerAlwaysOn"
#define BARCODE_ENGINE_TYPE                   @"barcodeEngineType"
#define CARRIER_SENSE_TIME                    @"carrierSenseTime"
#define TARGET_RF_POWER_LEVEL                 @"targetRFPowerLevel"
#define IS_SMART_HOPPING                      @"isSmartHopping"
#define RFID_POWER                            @"rfidPower"
#define RFID_POWER_MAX                        @"rfidPowerMax"
#define RFID_POWER_MIN                        @"rfidPowerMin"
#define RFID_ON_TIME                          @"rfidOnTime"
#define RFID_OFF_TIME                         @"rfidOffTime"
#define RFID_CHANNEL                          @"rfidChannel"
#define RFID_LISTEN_BEFORE_TALK               @"rfidListenBeforeTalk"
#define RFID_FREQUENCY_HOPPING                @"rfidFrequencyHopping"
#define RFID_CONTINOUS_WAVE                   @"rfidContinuousWave"
#define RFID_MODULE_VERSION                   @"rfidModuleVersion"
#define IS_SUPPORT_TYPE                       @"isSupportType"
#define GET_SUPPORT_TYPE_ARRAY                @"getSupportTypeArray"
#define SET_CONNECTION_TYPE                   @"setConnectionType"
#define GET_CONNECTION_TYPE                   @"getConnectionType"
#define PARSE_DARA_BY_PROTOCOL_TYPE           @"parseDataByProtocolType"
#define GET_SLEEP_BUZZER                      @"getSleepBuzzer"
#define SET_SLEEP_BUZZER                      @"setSleepBuzzer"
#define GET_BARCODE_TIME_OUT                  @"getBarcodeTimeOut"
#define SET_BARCODE_TIME_OUT                  @"setBarcodeTimeOut"
@implementation AsreaderSdk4Plugin

+ (void)registerWithRegistrar:(NSObject<FlutterPluginRegistrar>*)registrar {
    FlutterMethodChannel* channel = [FlutterMethodChannel
                                     methodChannelWithName:@"asreader_sdk4"
                                     binaryMessenger:[registrar messenger]];
    AsreaderSdk4Plugin* instance = [[AsreaderSdk4Plugin alloc] init];
    [AsReaderSDK4Manager sharedInstance].currentChannel =  channel;
    [registrar addMethodCallDelegate:instance channel:channel];
}

- (void)handleMethodCall:(FlutterMethodCall*)call result:(FlutterResult)result {
    NSString *method = [call method];
    AsReaderSDK4Manager * manager = [AsReaderSDK4Manager sharedInstance];
    if ([GET_PLATFORM_VERSION isEqualToString:method]) {
        result([@"iOS " stringByAppendingString:[[UIDevice currentDevice] systemVersion]]);
    }else if ([GET_PLUGGED_STATUS isEqualToString:method]) {
        result([NSString stringWithFormat:@"pluged : %d",manager.isPlugged]);
    }else if ([GET_SDK_VERSION isEqualToString:method]) {
        result([manager getSDKVersion]);
    }else if ([GET_FLUTTER_SDK_VERSION isEqualToString:method]) {
        result([manager getFlutterSDKVersion]);
    }else if ([SHOW_PRINT_NSLOG isEqualToString:method]) {
        NSDictionary *arguments = [call arguments];
        BOOL isShow = [[arguments valueForKey:@"isShow"] boolValue];
        [manager showPrintNSLog:isShow];
    }else if ([GET_READER_INFO isEqualToString:method]){
        NSDictionary *arguments = [call arguments];
        int infoType = [[arguments valueForKey:@"infoType"] intValue];
        BOOL res = [manager getReaderInfo:infoType];
        NSMutableDictionary * dic = [[NSMutableDictionary alloc] init];
        [dic setValue:[NSNumber numberWithInt:res] forKey:@"result"];
        result(dic);
    }else if ([GET_CURRENT_BATTERY isEqualToString:method]){
        int res = [manager getCurrentBattery];
        NSMutableDictionary * dic = [[NSMutableDictionary alloc] init];
        [dic setValue:[NSNumber numberWithInt:res] forKey:@"result"];
        result(dic);
    }else if ([SET_BEEP_VIBRATION_LED_AIMER isEqualToString:method]){
        NSDictionary *arguments = [call arguments];
        BOOL isBeep = [[arguments valueForKey:@"isBeep"] boolValue];
        BOOL isVibration = [[arguments valueForKey:@"isVibration"] boolValue];
        BOOL isbatteryGaugeLed = [[arguments valueForKey:@"isbatteryGaugeLed"] boolValue];
        BOOL isBarcodeAimer = [[arguments valueForKey:@"isBarcodeAimer"] boolValue];
        BOOL res = [manager setBeep:isBeep vibration:isVibration batteryGaugeLed:isbatteryGaugeLed barcodeAimer:isBarcodeAimer];
        NSMutableDictionary * dic = [[NSMutableDictionary alloc] init];
        [dic setValue:[NSNumber numberWithInt:res] forKey:@"result"];
        result(dic);
    }else if ([SET_BEEP_VIBRATION_LED_AIMER_POWERONBEEP isEqualToString:method]){
        NSDictionary *arguments = [call arguments];
        BOOL isBeep = [[arguments valueForKey:@"isBeep"] boolValue];
        BOOL isVibration = [[arguments valueForKey:@"isVibration"] boolValue];
        BOOL isbatteryGaugeLed = [[arguments valueForKey:@"isbatteryGaugeLed"] boolValue];
        BOOL isBarcodeAimer = [[arguments valueForKey:@"isBarcodeAimer"] boolValue];
        BOOL isBarcodePowerOnBeep = [[arguments valueForKey:@"isBarcodePowerOnBeep"] boolValue];
        BOOL res = [manager setBeep:isBeep vibration:isVibration batteryGaugeLed:isbatteryGaugeLed barcodeAimer:isBarcodeAimer barcodePowerOnBeep:isBarcodePowerOnBeep];
        NSMutableDictionary * dic = [[NSMutableDictionary alloc] init];
        [dic setValue:[NSNumber numberWithInt:res] forKey:@"result"];
        result(dic);
    }else if ([SET_READERPOWER isEqualToString:method]){
        NSDictionary *arguments = [call arguments];
        BOOL isOn = [[arguments valueForKey:@"isOn"] boolValue];
        BOOL isBeep = [[arguments valueForKey:@"isBeep"] boolValue];
        BOOL isVib = [[arguments valueForKey:@"isVib"] boolValue];
        BOOL isbatteryGaugeLed = [[arguments valueForKey:@"isbatteryGaugeLed"] boolValue];
        BOOL isBarcodeAimer = [[arguments valueForKey:@"isBarcodeAimer"] boolValue];
        BOOL isBarcodePowerOnBeep = [[arguments valueForKey:@"isBarcodePowerOnBeep"] boolValue];
        int nDeviceType = [[arguments valueForKey:@"nDeviceType"] intValue];
        int res = [manager setReaderPower:isOn beep:isBeep vibration:isVib batteryGaugeLed:isbatteryGaugeLed barcodeAimer:isBarcodeAimer barcodePowerOnBeep:isBarcodePowerOnBeep mode:nDeviceType];
        NSMutableDictionary * dic = [[NSMutableDictionary alloc] init];
        [dic setValue:[NSNumber numberWithInt:res] forKey:@"result"];
        result(dic);
    }else if ([SET_TAG_COUNT isEqualToString:method]){
        NSDictionary *arguments = [call arguments];
        int mtnu = [[arguments valueForKey:@"mtnu"] intValue];
        int mtime = [[arguments valueForKey:@"mtime"] intValue];
        int repeatCycle = [[arguments valueForKey:@"repeatCycle"] intValue];
        [manager setTagCount:mtnu setScanTime:mtime setCycle:repeatCycle];
    }else if ([SET_CHARGING_CONTROL isEqualToString:method]){
        NSDictionary *arguments = [call arguments];
        BOOL isOn = [[arguments valueForKey:@"isOn"] boolValue];
        BOOL res = [manager setChargingControl:isOn];
        NSMutableDictionary * dic = [[NSMutableDictionary alloc] init];
        [dic setValue:[NSNumber numberWithInt:res] forKey:@"result"];
        result(dic);
    }else if ([SET_DELAY_DISCONNECT_ON_BACKGROUND isEqualToString:method]){
        NSDictionary *arguments = [call arguments];
        int time = [[arguments valueForKey:@"time"] intValue];
        [manager setDelayDisconnectOnBackground:time];
    }else if ([GET_DELAY_DISCONNECT_ON_BACKGROUND isEqualToString:method]){
        double res = [manager getDelayDisconnectOnBackground];
        NSMutableDictionary * dic = [[NSMutableDictionary alloc] init];
        [dic setValue:[NSNumber numberWithDouble:res] forKey:@"result"];
        result(dic);
    }else if ([IS_OPEN isEqualToString:method]){
        BOOL res = [manager isOpened];
        NSMutableDictionary * dic = [[NSMutableDictionary alloc] init];
        [dic setValue:[NSNumber numberWithInt:res] forKey:@"result"];
        result(dic);
    }else if ([SET_STOP_TAG_NUM isEqualToString:method]){
        NSDictionary *arguments = [call arguments];
        int maxTags = [[arguments valueForKey:@"maxTags"] intValue];
        int maxTime = [[arguments valueForKey:@"maxTime"] intValue];
        int repeatCycle = [[arguments valueForKey:@"repeatCycle"] intValue];
        BOOL res = [manager setStopTagNum:maxTags maxTime:maxTime repeatCycle:repeatCycle];
        NSMutableDictionary * dic = [[NSMutableDictionary alloc] init];
        [dic setValue:[NSNumber numberWithInt:res] forKey:@"result"];
        result(dic);
    }else if ([GET_STOP_CONDITION isEqualToString:method]){
        BOOL res = [manager getStopCondition];
        NSMutableDictionary * dic = [[NSMutableDictionary alloc] init];
        [dic setValue:[NSNumber numberWithInt:res] forKey:@"result"];
        result(dic);
    }else if ([SET_TRIGGER_MODE isEqualToString:method]){
        NSDictionary *arguments = [call arguments];
        BOOL isDefault = [[arguments valueForKey:@"isDefault"] boolValue];
        BOOL res = [manager setTriggerMode:isDefault];
        NSMutableDictionary * dic = [[NSMutableDictionary alloc] init];
        [dic setValue:[NSNumber numberWithInt:res] forKey:@"result"];
        result(dic);
    }else if ([RESET isEqualToString:method]){
        BOOL res = [manager reset];
        NSMutableDictionary * dic = [[NSMutableDictionary alloc] init];
        [dic setValue:[NSNumber numberWithInt:res] forKey:@"result"];
        result(dic);
    }else if ([GET_AUTO_LAUNCH isEqualToString:method]){
        BOOL res = [manager getAutoLaunch];
        NSMutableDictionary * dic = [[NSMutableDictionary alloc] init];
        [dic setValue:[NSNumber numberWithInt:res] forKey:@"result"];
        result(dic);
    }else if ([SET_AUTO_LAUNCH_BUNDLEID isEqualToString:method]){
        NSDictionary *arguments = [call arguments];
        BOOL enable = [[arguments valueForKey:@"enable"] boolValue];
        NSString* bundleId = [[arguments valueForKey:@"bundleId"] stringValue];
        BOOL res = [manager setAutoLaunch:enable bundleId:bundleId];
        NSMutableDictionary * dic = [[NSMutableDictionary alloc] init];
        [dic setValue:[NSNumber numberWithInt:res] forKey:@"result"];
        result(dic);
    }else if ([SET_SLEEP_BEEP isEqualToString:method]){
        NSDictionary *arguments = [call arguments];
        BOOL isOn = [[arguments valueForKey:@"isOn"] boolValue];
        BOOL res = [manager setSleepBeep:isOn];
        NSMutableDictionary * dic = [[NSMutableDictionary alloc] init];
        [dic setValue:[NSNumber numberWithInt:res] forKey:@"result"];
        result(dic);
    }else if ([SET_SLEEP_TIME isEqualToString:method]){
        NSDictionary *arguments = [call arguments];
        int time = [[arguments valueForKey:@"time"] intValue];
        BOOL res = [manager setSleepTime:time];
        NSMutableDictionary * dic = [[NSMutableDictionary alloc] init];
        [dic setValue:[NSNumber numberWithInt:res] forKey:@"result"];
        result(dic);
    }else if ([GET_SLEEP_TIME isEqualToString:method]){
        BOOL res = [manager getSleepTime];
        NSMutableDictionary * dic = [[NSMutableDictionary alloc] init];
        [dic setValue:[NSNumber numberWithInt:res] forKey:@"result"];
        result(dic);
    }else if ([START_BLE_SCAN isEqualToString:method]){
        BOOL res = [manager startBleScan];
        NSMutableDictionary * dic = [[NSMutableDictionary alloc] init];
        [dic setValue:[NSNumber numberWithInt:res] forKey:@"result"];
        result(dic);
    }else if ([STOP_BLE_SCAN isEqualToString:method]){
        [manager stopBleScan];
    }else if ([DIS_CONNECT_BLE isEqualToString:method]){
        [manager disConnectBLE];
    }else if ([CONNECT_BLE isEqualToString:method]){
        NSDictionary *arguments = [call arguments];
        NSString * deviceName = [arguments valueForKey:@"name"];
        bool res = [manager connectBLE:deviceName];
        NSMutableDictionary * dic = [[NSMutableDictionary alloc] init];
        [dic setValue:[NSNumber numberWithInt:res] forKey:@"result"];
        result(dic);
    }else if ([GET_SLEEP_TIME_FOR_BLE_DEVICE isEqualToString:method]){
        int res = [manager getSleepTimeForBLEDevice];
        NSMutableDictionary * dic = [[NSMutableDictionary alloc] init];
        [dic setValue:[NSNumber numberWithInt:res] forKey:@"result"];
        result(dic);
    }else if ([SET_SLEEP_TIME_FOR_BLE_DEVICE_TYPE isEqualToString:method]){
        NSDictionary *arguments = [call arguments];
        int min = [[arguments valueForKey:@"min"] intValue];
        int type = [[arguments valueForKey:@"type"] intValue];
        int res = [manager setSleepTimeForBLEDevice:min type:type];
        NSMutableDictionary * dic = [[NSMutableDictionary alloc] init];
        [dic setValue:[NSNumber numberWithInt:res] forKey:@"result"];
        result(dic);
    }else if ([START_BARCODE_SCAN isEqualToString:method]){
        NSDictionary *arguments = [call arguments];
        int numberOfTags = [[arguments valueForKey:@"numberOfTags"] intValue];
        int readUntilInSec = [[arguments valueForKey:@"readUntilInSec"] intValue];
        BOOL res = [manager startBarcodeScan:numberOfTags readUntilInSec:readUntilInSec];
        NSMutableDictionary * dic = [[NSMutableDictionary alloc] init];
        [dic setValue:[NSNumber numberWithInt:res] forKey:@"result"];
        result(dic);
    }else if ([STOP_BARCODE_SCAN isEqualToString:method]){
        BOOL res = [manager stopBarcodeScan];
        NSMutableDictionary * dic = [[NSMutableDictionary alloc] init];
        [dic setValue:[NSNumber numberWithInt:res] forKey:@"result"];
        result(dic);
    }else if ([DO_FACTORY_RESET isEqualToString:method]){
        BOOL res = [manager doFactoryReset];
        NSMutableDictionary * dic = [[NSMutableDictionary alloc] init];
        [dic setValue:[NSNumber numberWithInt:res] forKey:@"result"];
        result(dic);
    }else if ([SEND_BARCODE_SETTING_DATA isEqualToString:method]){
        NSArray * array = [call arguments];
        FlutterStandardTypedData* sendData = array[0];
        BOOL res = [manager sendBarcodeSettingData:sendData.data];
        NSMutableDictionary * dic = [[NSMutableDictionary alloc] init];
        [dic setValue:[NSNumber numberWithInt:res] forKey:@"result"];
        result(dic);
    }else if ([SEND_BARCODE_HONEYWELL_SETTING_DATA isEqualToString:method]){
        NSArray * array = [call arguments];
        FlutterStandardTypedData* sendData = array[0];
        BOOL res = [manager sendBarcodeHoneywellSettingWithData:sendData.data];
        NSMutableDictionary * dic = [[NSMutableDictionary alloc] init];
        [dic setValue:[NSNumber numberWithInt:res] forKey:@"result"];
        result(dic);
    }else if ([SET_CUSTOM_PREFIX isEqualToString:method]){
        NSDictionary *arguments = [call arguments];
        NSString* prefix = [arguments valueForKey:@"prefix"];
        BOOL res = [manager setCustomPrefix:prefix];
        NSMutableDictionary * dic = [[NSMutableDictionary alloc] init];
        [dic setValue:[NSNumber numberWithInt:res] forKey:@"result"];
        result(dic);
    }else if ([SET_DISABLE_CUSTOM_PREFIX isEqualToString:method]){
        BOOL res = [manager setDisableCustomPrefix];
        NSMutableDictionary * dic = [[NSMutableDictionary alloc] init];
        [dic setValue:[NSNumber numberWithInt:res] forKey:@"result"];
        result(dic);
    }else if ([SET_CUSTOM_SUFFIX isEqualToString:method]){
        NSDictionary *arguments = [call arguments];
        NSString* suffix = [arguments valueForKey:@"suffix"];
        BOOL res = [manager setCustomSuffix:suffix];
        NSMutableDictionary * dic = [[NSMutableDictionary alloc] init];
        [dic setValue:[NSNumber numberWithInt:res] forKey:@"result"];
        result(dic);
    }else if ([SET_DISABLE_CUSTOM_SUFFIX isEqualToString:method]){
        BOOL res = [manager setDisableCustomSuffix];
        NSMutableDictionary * dic = [[NSMutableDictionary alloc] init];
        [dic setValue:[NSNumber numberWithInt:res] forKey:@"result"];
        result(dic);
    }else if ([SET_SYMBOLOGY_PREFIX isEqualToString:method]){
        BOOL res = [manager setSymbologyPrefix];
        NSMutableDictionary * dic = [[NSMutableDictionary alloc] init];
        [dic setValue:[NSNumber numberWithInt:res] forKey:@"result"];
        result(dic);
    }else if ([SET_DISABLE_SYMBOLOGY_PREFIX isEqualToString:method]){
        BOOL res = [manager setDisableSymbologyPrefix];
        NSMutableDictionary * dic = [[NSMutableDictionary alloc] init];
        [dic setValue:[NSNumber numberWithInt:res] forKey:@"result"];
        result(dic);
    }else if ([SET_BARCODE_ENGINE_USER_COMMAND isEqualToString:method]){
        NSDictionary *arguments = [call arguments];
        NSString* command = [arguments valueForKey:@"command"];
        BOOL res = [manager setBarcodeEngineUserCommand:command];
        NSMutableDictionary * dic = [[NSMutableDictionary alloc] init];
        [dic setValue:[NSNumber numberWithInt:res] forKey:@"result"];
        result(dic);
    }else if ([SET_CODEID_ISBEEPON isEqualToString:method]){
        NSDictionary *arguments = [call arguments];
        int type = [[arguments valueForKey:@"type"] intValue];
        BOOL isBeepOn = [[arguments valueForKey:@"isBeepOn"] boolValue];
        BOOL res = [manager setCodeID:type isBeepOn:isBeepOn];
        NSMutableDictionary * dic = [[NSMutableDictionary alloc] init];
        [dic setValue:[NSNumber numberWithInt:res] forKey:@"result"];
        result(dic);
    }else if ([SET_OCRTYPE_ISBEEPON isEqualToString:method]){
        NSDictionary *arguments = [call arguments];
        int type = [[arguments valueForKey:@"type"] intValue];
        BOOL isBeepOn = [[arguments valueForKey:@"isBeepOn"] boolValue];
        BOOL res = [manager setOCRType:type isBeepOn:isBeepOn];
        NSMutableDictionary * dic = [[NSMutableDictionary alloc] init];
        [dic setValue:[NSNumber numberWithInt:res] forKey:@"result"];
        result(dic);
    }else if ([SET_ANDROID_HID_ENABLE isEqualToString:method]){
        NSDictionary *arguments = [call arguments];
        BOOL isOn = [[arguments valueForKey:@"isOn"] boolValue];
        BOOL res = [manager setAndroidHIDEnable:isOn];
        NSMutableDictionary * dic = [[NSMutableDictionary alloc] init];
        [dic setValue:[NSNumber numberWithInt:res] forKey:@"result"];
        result(dic);
    }else if ([SET_IOS_HID_ENABLE isEqualToString:method]){
        NSDictionary *arguments = [call arguments];
        BOOL isOn = [[arguments valueForKey:@"isOn"] boolValue];
        BOOL res = [manager setiOSHIDEnable:isOn];
        NSMutableDictionary * dic = [[NSMutableDictionary alloc] init];
        [dic setValue:[NSNumber numberWithInt:res] forKey:@"result"];
        result(dic);
    }else if ([SET_PRESENTATION_MODE isEqualToString:method]){
        NSDictionary *arguments = [call arguments];
        BOOL isOn = [[arguments valueForKey:@"isOn"] boolValue];
        BOOL isBeepOn = [[arguments valueForKey:@"isBeepOn"] boolValue];
        BOOL res = [manager setPresentationMode:isOn isBeepOn:isBeepOn];
        NSMutableDictionary * dic = [[NSMutableDictionary alloc] init];
        [dic setValue:[NSNumber numberWithInt:res] forKey:@"result"];
        result(dic);
    }else if ([GET_CODE_ID isEqualToString:method]){
        BOOL res = [manager getCodeID];
        NSMutableDictionary * dic = [[NSMutableDictionary alloc] init];
        [dic setValue:[NSNumber numberWithInt:res] forKey:@"result"];
        result(dic);
    }else if ([GET_OCR isEqualToString:method]){
        BOOL res = [manager getOCR];
        NSMutableDictionary * dic = [[NSMutableDictionary alloc] init];
        [dic setValue:[NSNumber numberWithInt:res] forKey:@"result"];
        result(dic);
    }else if ([GET_HID isEqualToString:method]){
        BOOL res = [manager getHID];
        NSMutableDictionary * dic = [[NSMutableDictionary alloc] init];
        [dic setValue:[NSNumber numberWithInt:res] forKey:@"result"];
        result(dic);
    }else if ([GET_SYMBOLOGIES isEqualToString:method]){
        BOOL res = [manager getSymbologies];
        NSMutableDictionary * dic = [[NSMutableDictionary alloc] init];
        [dic setValue:[NSNumber numberWithInt:res] forKey:@"result"];
        result(dic);
    }else if ([SET_SSI_PARAM_WITH_DATA isEqualToString:method]){
        NSArray * array = [call arguments];
        FlutterStandardTypedData* symbolData = array[0];
        BOOL beepOn = [array[1] boolValue];
        BOOL res = [manager setSsiParamWithData:symbolData.data beepOn:beepOn];
        NSMutableDictionary * dic = [[NSMutableDictionary alloc] init];
        [dic setValue:[NSNumber numberWithInt:res] forKey:@"result"];
        result(dic);
    }else if ([SET_SSI_PARAM_WITH_DICTIONARY isEqualToString:method]){
        NSDictionary *arguments = [call arguments];
        NSMutableArray *symbologies = [arguments valueForKey:@"symbologies"];
        BOOL beepOn = [[arguments valueForKey:@"beepOn"] boolValue];
        BOOL res = [manager setSsiParamWithDictionary:symbologies beepOn:beepOn];
        NSMutableDictionary * dic = [[NSMutableDictionary alloc] init];
        [dic setValue:[NSNumber numberWithInt:res] forKey:@"result"];
        result(dic);
    }else if ([GET_PRESENTATION_MODE isEqualToString:method]){
        BOOL res = [manager getPresentationMode];
        NSMutableDictionary * dic = [[NSMutableDictionary alloc] init];
        [dic setValue:[NSNumber numberWithInt:res] forKey:@"result"];
        result(dic);
    }else if ([GET_SECURITY isEqualToString:method]){
        BOOL res = [manager getSecurity];
        NSMutableDictionary * dic = [[NSMutableDictionary alloc] init];
        [dic setValue:[NSNumber numberWithInt:res] forKey:@"result"];
        result(dic);
    }else if ([START_SCAN isEqualToString:method]){
        NSDictionary *arguments = [call arguments];
        int numberOfTags = [[arguments valueForKey:@"numberOfTags"] intValue];
        int readUntilInSec = [[arguments valueForKey:@"readUntilInSec"] intValue];
        int repeatCycle = [[arguments valueForKey:@"repeatCycle"] intValue];
        BOOL res = [manager startScan:numberOfTags readUntilInSec:readUntilInSec repeatCycle:repeatCycle];
        NSMutableDictionary * dic = [[NSMutableDictionary alloc] init];
        [dic setValue:[NSNumber numberWithInt:res] forKey:@"result"];
        result(dic);
    }else if ([STOP_RFID_SCAN isEqualToString:method]){
        BOOL res = [manager stopRfidScan];
        NSMutableDictionary * dic = [[NSMutableDictionary alloc] init];
        [dic setValue:[NSNumber numberWithInt:res] forKey:@"result"];
        result(dic);
    }else if ([START_READ_TAGS_AND_RSSI isEqualToString:method]){
        NSDictionary *arguments = [call arguments];
        int maxTags = [[arguments valueForKey:@"maxTags"] intValue];
        int maxTime = [[arguments valueForKey:@"maxTime"] intValue];
        int repeatCycle = [[arguments valueForKey:@"repeatCycle"] intValue];
        BOOL res = [manager startReadTagsAndRssiWithTagNum:maxTags
                                                   maxTime:maxTime
                                               repeatCycle:repeatCycle];
        NSMutableDictionary * dic = [[NSMutableDictionary alloc] init];
        [dic setValue:[NSNumber numberWithInt:res] forKey:@"result"];
        result(dic);
    }else if ([START_READ_TAG_AND_TID isEqualToString:method]){
        NSDictionary *arguments = [call arguments];
        int maxTags = [[arguments valueForKey:@"maxTags"] intValue];
        int maxTime = [[arguments valueForKey:@"maxTime"] intValue];
        int repeatCycle = [[arguments valueForKey:@"repeatCycle"] intValue];
        BOOL res = [manager startReadTagAndTidWithTagNum:maxTags
                                                 maxTime:maxTime
                                             repeatCycle:repeatCycle];
        NSMutableDictionary * dic = [[NSMutableDictionary alloc] init];
        [dic setValue:[NSNumber numberWithInt:res] forKey:@"result"];
        result(dic);
    }else if ([START_READ_TAGS_RFM isEqualToString:method]){
        NSDictionary *arguments = [call arguments];
        int codeType = [[arguments valueForKey:@"codeType"] intValue];
        int maxTags = [[arguments valueForKey:@"maxTags"] intValue];
        int maxTime = [[arguments valueForKey:@"maxTime"] intValue];
        int repeatCycle = [[arguments valueForKey:@"repeatCycle"] intValue];
        BOOL res = [manager startReadTagsRFM:codeType
                                     maxTags:maxTags
                                     maxTime:maxTime
                                 repeatCycle:repeatCycle];
        NSMutableDictionary * dic = [[NSMutableDictionary alloc] init];
        [dic setValue:[NSNumber numberWithInt:res] forKey:@"result"];
        result(dic);
    }else if ([GET_SELECT_PARAMETER isEqualToString:method]){
        BOOL res = [manager getSelectParameter];
        NSMutableDictionary * dic = [[NSMutableDictionary alloc] init];
        [dic setValue:[NSNumber numberWithInt:res] forKey:@"result"];
        result(dic);
    }else if ([SET_SELECT_PARAMETER isEqualToString:method]){
        NSArray * array = [call arguments];
        int target = [array[0] intValue];
        int action = [array[1] intValue];
        int memoryBank = [array[2] intValue];
        int pointer = [array[3] intValue];
        int length = [array[4] intValue];
        int truncate = [array[5] intValue];
        FlutterStandardTypedData* mask = array[6];
        BOOL res = [manager setSelectParameter:target
                                        action:action
                                    memoryBank:memoryBank
                                       pointer:pointer
                                        length:length
                                      truncate:truncate
                                          mask:mask.data];
        NSMutableDictionary * dic = [[NSMutableDictionary alloc] init];
        [dic setValue:[NSNumber numberWithInt:res] forKey:@"result"];
        result(dic);
    }else if ([GET_CHANNEL isEqualToString:method]){
        BOOL res = [manager getChannel];
        NSMutableDictionary * dic = [[NSMutableDictionary alloc] init];
        [dic setValue:[NSNumber numberWithInt:res] forKey:@"result"];
        result(dic);
    }else if ([SET_READ_TIME isEqualToString:method]){
        NSDictionary *arguments = [call arguments];
        int ReadTime = [[arguments valueForKey:@"ReadTime"] intValue];
        int IdleTime = [[arguments valueForKey:@"IdleTime"] intValue];
        BOOL res = [manager setReadTime:ReadTime
                               idleTime:IdleTime];
        NSMutableDictionary * dic = [[NSMutableDictionary alloc] init];
        [dic setValue:[NSNumber numberWithInt:res] forKey:@"result"];
        result(dic);
    }else if ([SET_CHANNEL isEqualToString:method]){
        NSDictionary *arguments = [call arguments];
        int channel = [[arguments valueForKey:@"channel"] intValue];
        int channelOffset = [[arguments valueForKey:@"channelOffset"] intValue];
        BOOL res = [manager setChannel:channel
                         channelOffset:channelOffset];
        NSMutableDictionary * dic = [[NSMutableDictionary alloc] init];
        [dic setValue:[NSNumber numberWithInt:res] forKey:@"result"];
        result(dic);
    }else if ([GET_FHLBT_PARAMETER isEqualToString:method]){
        BOOL res = [manager getFhLbtParameter];
        NSMutableDictionary * dic = [[NSMutableDictionary alloc] init];
        [dic setValue:[NSNumber numberWithInt:res] forKey:@"result"];
        result(dic);
    }else if ([SET_FHLBT_PARAMETER isEqualToString:method]){
        NSDictionary *arguments = [call arguments];
        int ReadTime = [[arguments valueForKey:@"ReadTime"] intValue];
        int IdleTime = [[arguments valueForKey:@"IdleTime"] intValue];
        int carrierSenseTime = [[arguments valueForKey:@"carrierSenseTime"] intValue];
        int targetRFPowerLevel = [[arguments valueForKey:@"targetRFPowerLevel"] intValue];
        int frequencyHopping = [[arguments valueForKey:@"frequencyHopping"] intValue];
        int listenBeforeTalk = [[arguments valueForKey:@"listenBeforeTalk"] intValue];
        int continuousWave = [[arguments valueForKey:@"continuousWave"] intValue];
        BOOL res = [manager setFhLbtParameter:ReadTime
                                     idleTime:IdleTime
                             carrierSenseTime:carrierSenseTime
                           targetRFPowerLevel:targetRFPowerLevel
                             frequencyHopping:frequencyHopping
                             listenBeforeTalk:listenBeforeTalk
                               continuousWave:continuousWave];
        NSMutableDictionary * dic = [[NSMutableDictionary alloc] init];
        [dic setValue:[NSNumber numberWithInt:res] forKey:@"result"];
        result(dic);
    }else if ([GET_OUTPUT_POWER_LEVEL isEqualToString:method]){
        BOOL res = [manager getOutputPowerLevel];
        NSMutableDictionary * dic = [[NSMutableDictionary alloc] init];
        [dic setValue:[NSNumber numberWithInt:res] forKey:@"result"];
        result(dic);
    }else if ([SET_OUTPUT_POWER_LEVEL isEqualToString:method]){
        NSDictionary *arguments = [call arguments];
        int powerLevel = [[arguments valueForKey:@"powerLevel"] intValue];
        BOOL res = [manager setOutputPowerLevel:powerLevel];
        NSMutableDictionary * dic = [[NSMutableDictionary alloc] init];
        [dic setValue:[NSNumber numberWithInt:res] forKey:@"result"];
        result(dic);
    }else if ([WRITE_TAG_MEMORY_WITH_ACCESS_PASSWORD isEqualToString:method]){
        NSArray * array = [call arguments];
        int accessPassword = [array[0] intValue];
        FlutterStandardTypedData * epc = array[1];
        int memoryBank = [array[2] intValue];
        int startAddress = [array[3] intValue];
        FlutterStandardTypedData * dataToWrite = array[4];
        BOOL res = [manager writeTagMemoryWithAccessPassword:accessPassword
                                                         epc:epc.data
                                                  memoryBank:memoryBank
                                                startAddress:startAddress
                                                 dataToWrite:dataToWrite.data];
        NSMutableDictionary * dic = [[NSMutableDictionary alloc] init];
        [dic setValue:[NSNumber numberWithInt:res] forKey:@"result"];
        result(dic);
    }else if ([KILL_TAG_WITH_PASSWORD isEqualToString:method]){
        NSArray * array = [call arguments];
        int password = [array[0] intValue];
        FlutterStandardTypedData * epc = array[1];
        BOOL res = [manager killTagWithPassword:password
                                            epc:epc.data];
        NSMutableDictionary * dic = [[NSMutableDictionary alloc] init];
        [dic setValue:[NSNumber numberWithInt:res] forKey:@"result"];
        result(dic);
    }else if ([LOCK_TAG_MEMORY_WITH_ACCESS_PASSWORD isEqualToString:method]){
        NSArray * array = [call arguments];
        int password = [array[0] intValue];
        FlutterStandardTypedData * epc = array[1];
        int lockData =  [array[2] intValue];
        BOOL res = [manager lockTagMemoryWithAccessPassword:password
                                                        epc:epc.data
                                                   lockData:lockData];
        NSMutableDictionary * dic = [[NSMutableDictionary alloc] init];
        [dic setValue:[NSNumber numberWithInt:res] forKey:@"result"];
        result(dic);
    }else if ([GET_FREQUENCY_HOPPING_TABLE isEqualToString:method]){
        BOOL res = [manager getFrequencyHoppingTable];
        NSMutableDictionary * dic = [[NSMutableDictionary alloc] init];
        [dic setValue:[NSNumber numberWithInt:res] forKey:@"result"];
        result(dic);
    }else if ([SET_FREQUENCY_HOPPING_TABLE isEqualToString:method]){
        NSArray * array = [call arguments];
        int tableSize = [array[0] intValue];
        FlutterStandardTypedData * channels = array[1];
        BOOL res = [manager setFrequencyHoppingTableSize:tableSize
                                                channels:channels.data];
        NSMutableDictionary * dic = [[NSMutableDictionary alloc] init];
        [dic setValue:[NSNumber numberWithInt:res] forKey:@"result"];
        result(dic);
    }else if ([GET_RSSI isEqualToString:method]){
        BOOL res = [manager getRssi];
        NSMutableDictionary * dic = [[NSMutableDictionary alloc] init];
        [dic setValue:[NSNumber numberWithInt:res] forKey:@"result"];
        result(dic);
    }else if ([GET_SESSION isEqualToString:method]){
        BOOL res = [manager getSession];
        NSMutableDictionary * dic = [[NSMutableDictionary alloc] init];
        [dic setValue:[NSNumber numberWithInt:res] forKey:@"result"];
        result(dic);
    }else if ([SET_SESSION isEqualToString:method]){
        NSDictionary *arguments = [call arguments];
        int session = [[arguments valueForKey:@"session"] intValue];
        BOOL res = [manager setSession:session];
        NSMutableDictionary * dic = [[NSMutableDictionary alloc] init];
        [dic setValue:[NSNumber numberWithInt:res] forKey:@"result"];
        result(dic);
    }else if ([GET_ANTICOLLISION isEqualToString:method]){
        BOOL res = [manager getAnticollision];
        NSMutableDictionary * dic = [[NSMutableDictionary alloc] init];
        [dic setValue:[NSNumber numberWithInt:res] forKey:@"result"];
        result(dic);
    }else if ([SET_ANTICOLLISION isEqualToString:method]){
        NSDictionary *arguments = [call arguments];
        int mode = [[arguments valueForKey:@"mode"] intValue];
        int counter = [[arguments valueForKey:@"counter"] intValue];
        BOOL res = [manager setAnticollision:mode
                                     Counter:counter];
        NSMutableDictionary * dic = [[NSMutableDictionary alloc] init];
        [dic setValue:[NSNumber numberWithInt:res] forKey:@"result"];
        result(dic);
    }else if ([UPDATE_REGISTRY isEqualToString:method]){
        BOOL res = [manager updateRegistry];
        NSMutableDictionary * dic = [[NSMutableDictionary alloc] init];
        [dic setValue:[NSNumber numberWithInt:res] forKey:@"result"];
        result(dic);
    }else if ([GET_RFID_MODULE_VERSION isEqualToString:method]){
        BOOL res = [manager getRFIDModuleVersion];
        NSMutableDictionary * dic = [[NSMutableDictionary alloc] init];
        [dic setValue:[NSNumber numberWithInt:res] forKey:@"result"];
        result(dic);
    }else if ([SET_HOPPING_ON_OFF isEqualToString:method]){
        NSDictionary *arguments = [call arguments];
        BOOL isOn = [[arguments valueForKey:@"isOn"] boolValue];
        BOOL res = [manager setHoppingOnOff:isOn];
        NSMutableDictionary * dic = [[NSMutableDictionary alloc] init];
        [dic setValue:[NSNumber numberWithInt:res] forKey:@"result"];
        result(dic);
    }else if ([WRITE_TAG_MEMORY_WITH_EPC isEqualToString:method]){
        NSArray * array = [call arguments];
        FlutterStandardTypedData * epc = array[0];
        NSString * dataToWrite = array[1];
        BOOL res = [manager writeTagMemoryWithEPC:epc.data
                                 dataToWriteAscii:dataToWrite];
        NSMutableDictionary * dic = [[NSMutableDictionary alloc] init];
        [dic setValue:[NSNumber numberWithInt:res] forKey:@"result"];
        result(dic);
    }else if ([SET_RSSI_THRESHOLD isEqualToString:method]){
        NSDictionary *arguments = [call arguments];
        int threshold = [[arguments valueForKey:@"threshold"] intValue];
        BOOL res = [manager setRSSIThreshold:threshold];
        NSMutableDictionary * dic = [[NSMutableDictionary alloc] init];
        [dic setValue:[NSNumber numberWithInt:res] forKey:@"result"];
        result(dic);
    }else if ([GET_RSSI_THRESHOLD isEqualToString:method]){
        BOOL res = [manager getRSSIThreshold];
        NSMutableDictionary * dic = [[NSMutableDictionary alloc] init];
        [dic setValue:[NSNumber numberWithInt:res] forKey:@"result"];
        result(dic);
    }else if ([GET_QUERY_PARAMETER isEqualToString:method]){
        BOOL res = [manager getQueryParameter];
        NSMutableDictionary * dic = [[NSMutableDictionary alloc] init];
        [dic setValue:[NSNumber numberWithInt:res] forKey:@"result"];
        result(dic);
    }else if ([READ_TAG_WITH_ACCESS_PASSWORD isEqualToString:method]){
        NSArray *array = [call arguments];
        int accessPassword = [array[0] intValue];
        FlutterStandardTypedData * epc = array[1];
        int memoryBank = [array[2] intValue];
        int startAddress = [array[3] intValue];
        int dataLength = [array[4] intValue];
        BOOL res = [manager readTagWithAccessPassword:accessPassword
                                                  epc:epc.data
                                           memoryBank:memoryBank
                                         startAddress:startAddress
                                           dataLength:dataLength];
        NSMutableDictionary * dic = [[NSMutableDictionary alloc] init];
        [dic setValue:[NSNumber numberWithInt:res] forKey:@"result"];
        result(dic);
    }else if ([SET_QUERY_PARAM isEqualToString:method]){
        NSDictionary *arguments = [call arguments];
        int divideRatio = [[arguments valueForKey:@"divideRatio"] intValue];
        int m = [[arguments valueForKey:@"m"] intValue];
        int trext = [[arguments valueForKey:@"trext"] intValue];
        int selection = [[arguments valueForKey:@"selection"] intValue];
        int session = [[arguments valueForKey:@"session"] intValue];
        int target = [[arguments valueForKey:@"target"] intValue];
        int qValue = [[arguments valueForKey:@"qValue"] intValue];
        BOOL res = [manager setQueryParam:divideRatio
                                        m:m
                                    trext:trext
                                selection:selection
                                  session:session
                                   target:target
                                   qValue:qValue];
        NSMutableDictionary * dic = [[NSMutableDictionary alloc] init];
        [dic setValue:[NSNumber numberWithInt:res] forKey:@"result"];
        result(dic);
    }else if ([SET_RF_CW isEqualToString:method]){
        NSDictionary *arguments = [call arguments];
        BOOL on = [[arguments valueForKey:@"on"] boolValue];
        BOOL res = [manager setRfCw:on];
        NSMutableDictionary * dic = [[NSMutableDictionary alloc] init];
        [dic setValue:[NSNumber numberWithInt:res] forKey:@"result"];
        result(dic);
    }else if ([GET_MODULATION isEqualToString:method]){
        BOOL res = [manager getModulation];
        NSMutableDictionary * dic = [[NSMutableDictionary alloc] init];
        [dic setValue:[NSNumber numberWithInt:res] forKey:@"result"];
        result(dic);
    }else if ([SET_MODULATION_BLF isEqualToString:method]){
        NSDictionary *arguments = [call arguments];
        int blf = [[arguments valueForKey:@"blf"] intValue];
        int rxMod = [[arguments valueForKey:@"rxMod"] intValue];
        int dr = [[arguments valueForKey:@"dr"] intValue];
        BOOL res = [manager setModulationBLF:blf rxMod:rxMod dr:dr];
        NSMutableDictionary * dic = [[NSMutableDictionary alloc] init];
        [dic setValue:[NSNumber numberWithInt:res] forKey:@"result"];
        result(dic);
    }else if ([BLOCK_ERASE_TAG_MEMORY_WITH_ACCESS_PASSWORD isEqualToString:method]){
        NSArray *array = [call arguments];
        int accessPassword = [array[0] intValue];
        FlutterStandardTypedData * epc = array[1];
        int memoryBank = [array[2] intValue];
        int startAddress = [array[3] intValue];
        int dataLength = [array[4] intValue];
        BOOL res = [manager blockEraseTagMemoryWithAccessPassword:accessPassword
                                                              epc:epc.data
                                                       memoryBank:memoryBank
                                                     startAddress:startAddress
                                                       dataLength:dataLength];
        NSMutableDictionary * dic = [[NSMutableDictionary alloc] init];
        [dic setValue:[NSNumber numberWithInt:res] forKey:@"result"];
        result(dic);
    }else if ([GENERIC_TRANSPORT_WITH_ACCESS_PASSWORD isEqualToString:method]){
        NSArray *array = [call arguments];
        int accessPassword = [array[0] intValue];
        FlutterStandardTypedData * epc = array[1];
        int transmissionState = [array[2] intValue];
        int rm = [array[3] intValue];
        int size = [array[4] intValue];
        FlutterStandardTypedData * genericCommand = array[5];
        BOOL res = [manager genericTransportWithAccessPassword:accessPassword
                                                           epc:epc.data
                                             transmissionState:transmissionState
                                                            rm:rm
                                                          size:size
                                                genericCommand:genericCommand.data];
        NSMutableDictionary * dic = [[NSMutableDictionary alloc] init];
        [dic setValue:[NSNumber numberWithInt:res] forKey:@"result"];
        result(dic);
    }else if ([GET_TEMPERATURE isEqualToString:method]){
        BOOL res = [manager getTemperature];
        NSMutableDictionary * dic = [[NSMutableDictionary alloc] init];
        [dic setValue:[NSNumber numberWithInt:res] forKey:@"result"];
        result(dic);
    }else if ([GET_REGISTRY_ITEM isEqualToString:method]){
        NSDictionary *arguments = [call arguments];
        int registryItem = [[arguments valueForKey:@"registryItem"] intValue];
        BOOL res = [manager getRegistryItem:registryItem];
        NSMutableDictionary * dic = [[NSMutableDictionary alloc] init];
        [dic setValue:[NSNumber numberWithInt:res] forKey:@"result"];
        result(dic);
    }else if ([SET_OPTIMUM_FREQUENCY_HOPPING_TABLE isEqualToString:method]){
        BOOL res = [manager setOptimumFrequencyHoppingTable];
        NSMutableDictionary * dic = [[NSMutableDictionary alloc] init];
        [dic setValue:[NSNumber numberWithInt:res] forKey:@"result"];
        result(dic);
    }else if ([SET_FREQUENCY_HOPPING_MODE isEqualToString:method]){
        NSDictionary *arguments = [call arguments];
        int mode = [[arguments valueForKey:@"mode"] intValue];
        BOOL res = [manager setFrequencyHoppingMode:mode];
        NSMutableDictionary * dic = [[NSMutableDictionary alloc] init];
        [dic setValue:[NSNumber numberWithInt:res] forKey:@"result"];
        result(dic);
    }else if ([GET_FREQUENCY_HOPPING_MODE isEqualToString:method]){
        BOOL res = [manager getFrequencyHoppingMode];
        NSMutableDictionary * dic = [[NSMutableDictionary alloc] init];
        [dic setValue:[NSNumber numberWithInt:res] forKey:@"result"];
        result(dic);
    }else if ([SET_SMART_HOPPING_ON_OFF isEqualToString:method]){
        NSDictionary *arguments = [call arguments];
        BOOL isOn = [[arguments valueForKey:@"isOn"] boolValue];
        BOOL res = [manager setSmartHoppingOnOff:isOn];
        NSMutableDictionary * dic = [[NSMutableDictionary alloc] init];
        [dic setValue:[NSNumber numberWithInt:res] forKey:@"result"];
        result(dic);
    }else if ([GET_REGION isEqualToString:method]){
        BOOL res = [manager getRegion];
        NSMutableDictionary * dic = [[NSMutableDictionary alloc] init];
        [dic setValue:[NSNumber numberWithInt:res] forKey:@"result"];
        result(dic);
    }else if ([SET_READ_RSSI_MODE isEqualToString:method]){
        NSDictionary *arguments = [call arguments];
        BOOL isReadRSSIMode = [[arguments valueForKey:@"isReadRSSIMode"] boolValue];
        [manager setReadRSSIMode:isReadRSSIMode];
    }else if ([GET_RFID_MODULE_INFORMATION isEqualToString:method]){
        BOOL res = [manager getRfidModuleInformation];
        NSMutableDictionary * dic = [[NSMutableDictionary alloc] init];
        [dic setValue:[NSNumber numberWithInt:res] forKey:@"result"];
        result(dic);
    }else if ([GET_HOPPING_ON_OFF isEqualToString:method]){
        BOOL res = [manager getHoppingOnOff];
        NSMutableDictionary * dic = [[NSMutableDictionary alloc] init];
        [dic setValue:[NSNumber numberWithInt:res] forKey:@"result"];
        result(dic);
    }else if ([GET_AUTO_OFF_TIME isEqualToString:method]){
        BOOL res = [manager getAutoOffTime];
        NSMutableDictionary * dic = [[NSMutableDictionary alloc] init];
        [dic setValue:[NSNumber numberWithInt:res] forKey:@"result"];
        result(dic);
    }else if ([SET_AUTO_OFF_TIME isEqualToString:method]){
        NSDictionary *arguments = [call arguments];
        int time = [[arguments valueForKey:@"time"] intValue];
        BOOL res = [manager setAutoOffTime:time];
        NSMutableDictionary * dic = [[NSMutableDictionary alloc] init];
        [dic setValue:[NSNumber numberWithInt:res] forKey:@"result"];
        result(dic);
    }else if ([GET_CONTINUOUS_MODE isEqualToString:method]){
        BOOL res = [manager getContinuousMode];
        NSMutableDictionary * dic = [[NSMutableDictionary alloc] init];
        [dic setValue:[NSNumber numberWithInt:res] forKey:@"result"];
        result(dic);
    }else if ([SET_CONTINUOUS_MODE isEqualToString:method]){
        NSDictionary *arguments = [call arguments];
        BOOL continuousMode = [[arguments valueForKey:@"continuousMode"] boolValue];
        BOOL res = [manager setContinuousMode:continuousMode];
        NSMutableDictionary * dic = [[NSMutableDictionary alloc] init];
        [dic setValue:[NSNumber numberWithInt:res] forKey:@"result"];
        result(dic);
    }else if ([GET_Q_VALUE isEqualToString:method]){
        BOOL res = [manager getQValue];
        NSMutableDictionary * dic = [[NSMutableDictionary alloc] init];
        [dic setValue:[NSNumber numberWithInt:res] forKey:@"result"];
        result(dic);
    }else if ([SET_Q_VALUE isEqualToString:method]){
        NSDictionary *arguments = [call arguments];
        int qValue = [[arguments valueForKey:@"qValue"] intValue];
        BOOL res = [manager setQValue:qValue];
        NSMutableDictionary * dic = [[NSMutableDictionary alloc] init];
        [dic setValue:[NSNumber numberWithInt:res] forKey:@"result"];
        result(dic);
    }else if ([GET_SESSION_FLAG isEqualToString:method]){
        BOOL res = [manager getSessionFlag];
        NSMutableDictionary * dic = [[NSMutableDictionary alloc] init];
        [dic setValue:[NSNumber numberWithInt:res] forKey:@"result"];
        result(dic);
    }else if ([SET_SESSION_FLAG isEqualToString:method]){
        NSDictionary *arguments = [call arguments];
        int sessionFlag = [[arguments valueForKey:@"sessionFlag"] intValue];
        BOOL res = [manager setSessionFlag:sessionFlag];
        NSMutableDictionary * dic = [[NSMutableDictionary alloc] init];
        [dic setValue:[NSNumber numberWithInt:res] forKey:@"result"];
        result(dic);
    }else if ([GET_HID_MODE isEqualToString:method]){
        BOOL res = [manager getHidMode];
        NSMutableDictionary * dic = [[NSMutableDictionary alloc] init];
        [dic setValue:[NSNumber numberWithInt:res] forKey:@"result"];
        result(dic);
    }else if ([SET_HID_MODE isEqualToString:method]){
        NSDictionary *arguments = [call arguments];
        BOOL hidMode = [[arguments valueForKey:@"hidMode"] boolValue];
        BOOL res = [manager setHidMode:hidMode];
        NSMutableDictionary * dic = [[NSMutableDictionary alloc] init];
        [dic setValue:[NSNumber numberWithInt:res] forKey:@"result"];
        result(dic);
    }else if ([GET_DUTY_RATIO isEqualToString:method]){
        BOOL res = [manager getDutyRatio];
        NSMutableDictionary * dic = [[NSMutableDictionary alloc] init];
        [dic setValue:[NSNumber numberWithInt:res] forKey:@"result"];
        result(dic);
    }else if ([SET_DUTY_RATIO isEqualToString:method]){
        NSDictionary *arguments = [call arguments];
        int dutyRatio = [[arguments valueForKey:@"dutyRatio"] intValue];
        BOOL res = [manager setDutyRatio:dutyRatio];
        NSMutableDictionary * dic = [[NSMutableDictionary alloc] init];
        [dic setValue:[NSNumber numberWithInt:res] forKey:@"result"];
        result(dic);
    }else if ([GET_DUTY_RATIO_BASE_TIME isEqualToString:method]){
        BOOL res = [manager getDutyRatioBaseTime];
        NSMutableDictionary * dic = [[NSMutableDictionary alloc] init];
        [dic setValue:[NSNumber numberWithInt:res] forKey:@"result"];
        result(dic);
    }else if ([SET_DUTY_RATIO_BASE_TIME isEqualToString:method]){
        NSDictionary *arguments = [call arguments];
        int dutyRatioBaseTime = [[arguments valueForKey:@"dutyRatioBaseTime"] intValue];
        BOOL res = [manager setDutyRatioBaseTime:dutyRatioBaseTime];
        NSMutableDictionary * dic = [[NSMutableDictionary alloc] init];
        [dic setValue:[NSNumber numberWithInt:res] forKey:@"result"];
        result(dic);
    }else if ([SEND_DATA isEqualToString:method]){
        NSArray *array = [call arguments];
        FlutterStandardTypedData * sendData = array[0];
        BOOL res = [manager sendData:sendData.data];
        NSMutableDictionary * dic = [[NSMutableDictionary alloc] init];
        [dic setValue:[NSNumber numberWithInt:res] forKey:@"result"];
        result(dic);
    }else if ([SET_INVENTORY_TIME isEqualToString:method]){
        NSDictionary *arguments = [call arguments];
        float inventoryTime = [[arguments valueForKey:@"inventoryTime"] floatValue];
        BOOL res = [manager setInventoryTime:inventoryTime];
        NSMutableDictionary * dic = [[NSMutableDictionary alloc] init];
        [dic setValue:[NSNumber numberWithInt:res] forKey:@"result"];
        result(dic);
    }else if ([START_NFC_SCAN isEqualToString:method]){
        BOOL res = [manager startNFCScan];
        NSMutableDictionary * dic = [[NSMutableDictionary alloc] init];
        [dic setValue:[NSNumber numberWithInt:res] forKey:@"result"];
        result(dic);
    }else if ([STOP_NFC_SCAN isEqualToString:method]){
        BOOL res = [manager stopNFCScan];
        NSMutableDictionary * dic = [[NSMutableDictionary alloc] init];
        [dic setValue:[NSNumber numberWithInt:res] forKey:@"result"];
        result(dic);
    }else if ([READ_MULTI_BLOCK_WITH_BLOCK_INDEX isEqualToString:method]){
        NSDictionary *arguments = [call arguments];
        int index = [[arguments valueForKey:@"index"] intValue];
        int count = [[arguments valueForKey:@"count"] intValue];
        BOOL res = [manager readMultiBlockWithBlockIndex:index
                                                   count:count];
        NSMutableDictionary * dic = [[NSMutableDictionary alloc] init];
        [dic setValue:[NSNumber numberWithInt:res] forKey:@"result"];
        result(dic);
    }else if ([WRITE_SINGLE_BLOCK_WITH_BLOCK_INDEX isEqualToString:method]){
        NSArray *array = [call arguments];
        int index = [array[0] intValue];
        FlutterStandardTypedData* writeData = array[1];
        FlutterStandardTypedData* uid = array[2];
        BOOL res = [manager writeSingleBlockWithBlockIndex:index
                                                 writeData:writeData.data
                                                       uid:uid.data];
        NSMutableDictionary * dic = [[NSMutableDictionary alloc] init];
        [dic setValue:[NSNumber numberWithInt:res] forKey:@"result"];
        result(dic);
    }else if ([WRITE_BYTES_WITH_BLOCK_INDEX isEqualToString:method]){
        NSArray *array = [call arguments];
        int index = [array[0] intValue];
        FlutterStandardTypedData* writeData = array[1];
        FlutterStandardTypedData* uid = array[2];
        BOOL res = [manager writeBytesWithBlockIndex:index
                                                 writeData:writeData.data
                                                       uid:uid.data];
        NSMutableDictionary * dic = [[NSMutableDictionary alloc] init];
        [dic setValue:[NSNumber numberWithInt:res] forKey:@"result"];
        result(dic);
    }else if ([START_LF_SCAN isEqualToString:method]){
        NSDictionary *arguments = [call arguments];
        int numberOfTags = [[arguments valueForKey:@"numberOfTags"] intValue];
        int readUntilInSec = [[arguments valueForKey:@"readUntilInSec"] intValue];
        int repeatCycle = [[arguments valueForKey:@"repeatCycle"] intValue];
        BOOL res = [manager startLfScan:numberOfTags
                         readUntilInSec:readUntilInSec
                              repeatCycle:repeatCycle];
        NSMutableDictionary * dic = [[NSMutableDictionary alloc] init];
        [dic setValue:[NSNumber numberWithInt:res] forKey:@"result"];
        result(dic);
    }else if ([STOP_LF_SCAN isEqualToString:method]){
        BOOL res = [manager stopLfScan];
        NSMutableDictionary * dic = [[NSMutableDictionary alloc] init];
        [dic setValue:[NSNumber numberWithInt:res] forKey:@"result"];
        result(dic);
    }else if ([IS_SHOW_PRINT_NSLOG isEqualToString:method]){
        BOOL res = [manager isShowPrintNSLog];
        NSMutableDictionary * dic = [[NSMutableDictionary alloc] init];
        [dic setValue:[NSNumber numberWithInt:res] forKey:@"result"];
        result(dic);
    }else if ([BUNDLE_IDENTIFIER isEqualToString:method]){
        NSString* res = [manager bundleIdentifier];
        NSMutableDictionary * dic = [[NSMutableDictionary alloc] init];
        [dic setValue:res forKey:@"result"];
        result(dic);
    }else if ([DEVICE_NAME isEqualToString:method]){
        NSString* res = [manager deviceName];
        NSMutableDictionary * dic = [[NSMutableDictionary alloc] init];
        [dic setValue:res forKey:@"result"];
        result(dic);
    }else if ([DEVICE_FIRMWARE isEqualToString:method]){
        NSString* res = [manager deviceFirmware];
        NSMutableDictionary * dic = [[NSMutableDictionary alloc] init];
        [dic setValue:res forKey:@"result"];
        result(dic);
    }else if ([DEVICE_HARDWARE isEqualToString:method]){
        NSString* res = [manager deviceHardware];
        NSMutableDictionary * dic = [[NSMutableDictionary alloc] init];
        [dic setValue:res forKey:@"result"];
        result(dic);
    }else if ([DEVICE_ID isEqualToString:method]){
        NSString* res = [manager deviceID];
        NSMutableDictionary * dic = [[NSMutableDictionary alloc] init];
        [dic setValue:res forKey:@"result"];
        result(dic);
    }else if ([DEVICE_MANUFACTURER isEqualToString:method]){
        NSString* res = [manager deviceManufacturer];
        NSMutableDictionary * dic = [[NSMutableDictionary alloc] init];
        [dic setValue:res forKey:@"result"];
        result(dic);
    }else if ([DEVICE_MODEL_NUMBER isEqualToString:method]){
        NSString* res = [manager deviceModelNumber];
        NSMutableDictionary * dic = [[NSMutableDictionary alloc] init];
        [dic setValue:res forKey:@"result"];
        result(dic);
    }else if ([DEVICE_SERIAL_NUMBER isEqualToString:method]){
        NSString* res = [manager deviceSerialNumber];
        NSMutableDictionary * dic = [[NSMutableDictionary alloc] init];
        [dic setValue:res forKey:@"result"];
        result(dic);
    }else if ([DEVICE_PROTOCOL isEqualToString:method]){
        NSString* res = [manager deviceProtocol];
        NSMutableDictionary * dic = [[NSMutableDictionary alloc] init];
        [dic setValue:res forKey:@"result"];
        result(dic);
    }else if ([CURRENT_SELECT_DEVICE isEqualToString:method]){
        int res = [manager currentSelectDevice];
        NSMutableDictionary * dic = [[NSMutableDictionary alloc] init];
        [dic setValue:[NSNumber numberWithInt:res] forKey:@"result"];
        result(dic);
    }else if ([IS_POWER_ON isEqualToString:method]){
        BOOL res = [manager isPowerOn];
        NSMutableDictionary * dic = [[NSMutableDictionary alloc] init];
        [dic setValue:[NSNumber numberWithInt:res] forKey:@"result"];
        result(dic);
    }else if ([SUPPORT_MODE isEqualToString:method]){
        int res = [manager supportMode];
        NSMutableDictionary * dic = [[NSMutableDictionary alloc] init];
        [dic setValue:[NSNumber numberWithInt:res] forKey:@"result"];
        result(dic);
    }else if ([CURRENT_READER_MODE isEqualToString:method]){
        int res = [manager currentReaderMode];
        NSMutableDictionary * dic = [[NSMutableDictionary alloc] init];
        [dic setValue:[NSNumber numberWithInt:res] forKey:@"result"];
        result(dic);
    }else if ([RECEIVE_DATA_TYPE isEqualToString:method]){
        int res = [manager receiveDataType];
        NSMutableDictionary * dic = [[NSMutableDictionary alloc] init];
        [dic setValue:[NSNumber numberWithInt:res] forKey:@"result"];
        result(dic);
    }else if ([DUAL_SAME_TIME isEqualToString:method]){
        BOOL res = [manager dualSameTime];
        NSMutableDictionary * dic = [[NSMutableDictionary alloc] init];
        [dic setValue:[NSNumber numberWithInt:res] forKey:@"result"];
        result(dic);
    }else if ([IS_BEEP isEqualToString:method]){
        BOOL res = [manager isBeep];
        NSMutableDictionary * dic = [[NSMutableDictionary alloc] init];
        [dic setValue:[NSNumber numberWithInt:res] forKey:@"result"];
        result(dic);
    }else if ([IS_VIBRATION isEqualToString:method]){
        BOOL res = [manager isVibration];
        NSMutableDictionary * dic = [[NSMutableDictionary alloc] init];
        [dic setValue:[NSNumber numberWithInt:res] forKey:@"result"];
        result(dic);
    }else if ([IS_LED isEqualToString:method]){
        BOOL res = [manager isLED];
        NSMutableDictionary * dic = [[NSMutableDictionary alloc] init];
        [dic setValue:[NSNumber numberWithInt:res] forKey:@"result"];
        result(dic);
    }else if ([IS_ILLUMINATION isEqualToString:method]){
        BOOL res = [manager isIllumination];
        NSMutableDictionary * dic = [[NSMutableDictionary alloc] init];
        [dic setValue:[NSNumber numberWithInt:res] forKey:@"result"];
        result(dic);
    }else if ([COUNT isEqualToString:method]){
        int res = [manager count];
        NSMutableDictionary * dic = [[NSMutableDictionary alloc] init];
        [dic setValue:[NSNumber numberWithInt:res] forKey:@"result"];
        result(dic);
    }else if ([SCAN_TIME isEqualToString:method]){
        int res = [manager scanTime];
        NSMutableDictionary * dic = [[NSMutableDictionary alloc] init];
        [dic setValue:[NSNumber numberWithInt:res] forKey:@"result"];
        result(dic);
    }else if ([CYCLE isEqualToString:method]){
        int res = [manager cycle];
        NSMutableDictionary * dic = [[NSMutableDictionary alloc] init];
        [dic setValue:[NSNumber numberWithInt:res] forKey:@"result"];
        result(dic);
    }else if ([IS_TRIGGER_MODE_DEFAULT isEqualToString:method]){
        BOOL res = [manager isTriggerModeDefault];
        NSMutableDictionary * dic = [[NSMutableDictionary alloc] init];
        [dic setValue:[NSNumber numberWithInt:res] forKey:@"result"];
        result(dic);
    }else if ([IS_READ_RSSI_MODE isEqualToString:method]){
        BOOL res = [manager isReadRSSIMode];
        NSMutableDictionary * dic = [[NSMutableDictionary alloc] init];
        [dic setValue:[NSNumber numberWithInt:res] forKey:@"result"];
        result(dic);
    }else if ([IS_ENGINE_POWER_ALWAYS_ON isEqualToString:method]){
        BOOL res = [manager isEnginePowerAlwaysOn];
        NSMutableDictionary * dic = [[NSMutableDictionary alloc] init];
        [dic setValue:[NSNumber numberWithInt:res] forKey:@"result"];
        result(dic);
    }else if ([BARCODE_ENGINE_TYPE isEqualToString:method]){
        int res = [manager barcodeEngineType];
        NSMutableDictionary * dic = [[NSMutableDictionary alloc] init];
        [dic setValue:[NSNumber numberWithInt:res] forKey:@"result"];
        result(dic);
    }else if ([CARRIER_SENSE_TIME isEqualToString:method]){
        int res = [manager carrierSenseTime];
        NSMutableDictionary * dic = [[NSMutableDictionary alloc] init];
        [dic setValue:[NSNumber numberWithInt:res] forKey:@"result"];
        result(dic);
    }else if ([TARGET_RF_POWER_LEVEL isEqualToString:method]){
        int res = [manager targetRFPowerLevel];
        NSMutableDictionary * dic = [[NSMutableDictionary alloc] init];
        [dic setValue:[NSNumber numberWithInt:res] forKey:@"result"];
        result(dic);
    }else if ([IS_SMART_HOPPING isEqualToString:method]){
        BOOL res = [manager isSmartHopping];
        NSMutableDictionary * dic = [[NSMutableDictionary alloc] init];
        [dic setValue:[NSNumber numberWithInt:res] forKey:@"result"];
        result(dic);
    }else if ([RFID_POWER isEqualToString:method]){
        float res = [manager rfidPower];
        NSMutableDictionary * dic = [[NSMutableDictionary alloc] init];
        [dic setValue:[NSNumber numberWithFloat:res] forKey:@"result"];
        result(dic);
    }else if ([RFID_POWER_MAX isEqualToString:method]){
        float res = [manager rfidPowerMax];
        NSMutableDictionary * dic = [[NSMutableDictionary alloc] init];
        [dic setValue:[NSNumber numberWithFloat:res] forKey:@"result"];
        result(dic);
    }else if ([RFID_POWER_MIN isEqualToString:method]){
        float res = [manager rfidPowerMin];
        NSMutableDictionary * dic = [[NSMutableDictionary alloc] init];
        [dic setValue:[NSNumber numberWithFloat:res] forKey:@"result"];
        result(dic);
    }else if ([RFID_ON_TIME isEqualToString:method]){
        int res = [manager rfidOnTime];
        NSMutableDictionary * dic = [[NSMutableDictionary alloc] init];
        [dic setValue:[NSNumber numberWithInt:res] forKey:@"result"];
        result(dic);
    }else if ([RFID_OFF_TIME isEqualToString:method]){
        int res = [manager rfidOffTime];
        NSMutableDictionary * dic = [[NSMutableDictionary alloc] init];
        [dic setValue:[NSNumber numberWithInt:res] forKey:@"result"];
        result(dic);
    }else if ([RFID_CHANNEL isEqualToString:method]){
        int res = [manager rfidChannel];
        NSMutableDictionary * dic = [[NSMutableDictionary alloc] init];
        [dic setValue:[NSNumber numberWithInt:res] forKey:@"result"];
        result(dic);
    }else if ([RFID_LISTEN_BEFORE_TALK isEqualToString:method]){
        int res = [manager rfidListenBeforeTalk];
        NSMutableDictionary * dic = [[NSMutableDictionary alloc] init];
        [dic setValue:[NSNumber numberWithInt:res] forKey:@"result"];
        result(dic);
    }else if ([RFID_FREQUENCY_HOPPING isEqualToString:method]){
        int res = [manager rfidFrequencyHopping];
        NSMutableDictionary * dic = [[NSMutableDictionary alloc] init];
        [dic setValue:[NSNumber numberWithInt:res] forKey:@"result"];
        result(dic);
    }else if ([RFID_CONTINOUS_WAVE isEqualToString:method]){
        int res = [manager rfidContinuousWave];
        NSMutableDictionary * dic = [[NSMutableDictionary alloc] init];
        [dic setValue:[NSNumber numberWithInt:res] forKey:@"result"];
        result(dic);
    }else if ([RFID_MODULE_VERSION isEqualToString:method]){
        NSString* res = [manager rfidModuleVersion];
        NSMutableDictionary * dic = [[NSMutableDictionary alloc] init];
        [dic setValue:res forKey:@"result"];
        result(dic);
    }else if ([IS_SUPPORT_TYPE isEqualToString:method]){
        NSDictionary *arguments = [call arguments];
        int supportType = [[arguments valueForKey:@"supportType"] intValue];
        BOOL res = [manager isSupportType:supportType];
        NSMutableDictionary * dic = [[NSMutableDictionary alloc] init];
        [dic setValue:[NSNumber numberWithInt:res] forKey:@"result"];
        result(dic);
    }else if ([GET_SUPPORT_TYPE_ARRAY isEqualToString:method]){
        NSArray* res = [manager getSupportTypeArray];
        NSMutableDictionary * dic = [[NSMutableDictionary alloc] init];
        [dic setValue:res forKey:@"result"];
        result(dic);
    }else if ([SET_CONNECTION_TYPE isEqualToString:method]){
        NSDictionary *arguments = [call arguments];
        int type = [[arguments valueForKey:@"type"] intValue];
        [manager setConnectionType:type];
        NSMutableDictionary * dic = [[NSMutableDictionary alloc] init];
        [dic setValue:[NSNumber numberWithInt:YES] forKey:@"result"];
        result(dic);
    }else if ([GET_CONNECTION_TYPE isEqualToString:method]){
        int res = [manager getConnectionType];
        NSMutableDictionary * dic = [[NSMutableDictionary alloc] init];
        [dic setValue:[NSNumber numberWithInt:res] forKey:@"result"];
        result(dic);
    }else if ([PARSE_DARA_BY_PROTOCOL_TYPE isEqualToString:method]){
        NSArray *array = [call arguments];
        int type = [array[1] intValue];
        FlutterStandardTypedData* data = array[0];
        NSDictionary * res = [manager parseDataByProtocolType:data.data protocolType:type];
        NSMutableDictionary * dic = [[NSMutableDictionary alloc] init];
        if (res) {
            dic = [[NSMutableDictionary alloc] initWithDictionary:res];
            [dic setValue:[NSNumber numberWithInt:YES] forKey:@"result"];
        } else {
            [dic setValue:[NSNumber numberWithInt:NO] forKey:@"result"];
        }
        result(dic);
    }else if ([SET_SLEEP_BUZZER isEqualToString:method]){
        NSDictionary *arguments = [call arguments];
        BOOL buzzer = [[arguments valueForKey:@"sleepBuzzer"] boolValue];
        BOOL status = [manager setSleepBuzzer:buzzer];
        NSMutableDictionary * dic = [[NSMutableDictionary alloc] init];
        [dic setValue:[NSNumber numberWithBool:status] forKey:@"result"];
        result(dic);
    }else if ([GET_SLEEP_BUZZER isEqualToString:method]){
        BOOL buzzer = [manager getSleepBuzzer];
        NSMutableDictionary * dic = [[NSMutableDictionary alloc] init];
        [dic setValue:[NSNumber numberWithBool:buzzer] forKey:@"result"];
        result(dic);
    }else if ([SET_BARCODE_TIME_OUT isEqualToString:method]){
        NSDictionary *arguments = [call arguments];
        int time = [[arguments valueForKey:@"timeout"] intValue];
        BOOL status = [manager setBarcodeTimeOut:time];
        NSMutableDictionary * dic = [[NSMutableDictionary alloc] init];
        [dic setValue:[NSNumber numberWithBool:status] forKey:@"result"];
        result(dic);
    }else if ([GET_BARCODE_TIME_OUT isEqualToString:method]){
        BOOL status = [manager getBarcodeTimeOut];
        NSMutableDictionary * dic = [[NSMutableDictionary alloc] init];
        [dic setValue:[NSNumber numberWithBool:status] forKey:@"result"];
        result(dic);
    } else {
        result(FlutterMethodNotImplemented);
    }
}

@end
