//
//  AsReaderProtocol.h
//  AsReaderDockSDK
//
//  @brief  The AsReaderProtocol.h file defines a protocol for handling communication with an external reader device, specifically for low-level interaction with hardware. This protocol provides methods for processing data received from the reader and handling connection status changes.
//
//  Created by mac on 2017/9/7.
//  Copyright © 2017年 ZYL. All rights reserved.
//
#import <Foundation/Foundation.h>

#ifndef AsReaderProtocol_h
#define AsReaderProtocol_h
#endif /* AsReaderProtocol_h */

/**
 *  @brief      sioMgrDelegate
 *  @details    Delegate for hardware event callback.
 */
@protocol RcpReceiverProtocol <NSObject>// <AsReaderBLEProtocols>

@optional
/**
 *  @brief      [ONLY SDK USE] Response of all
 *  @details    This function is called when receive data from the reader.
 *  @param      data : Data sent by the reader
 */
- (BOOL)dispatchBootloaderS0FrmReader:(NSData*)data;

@required
/**
 *  @brief      [ONLY SDK USE] Response of all
 *  @details    This function is called when receive data from the reader.
 *  @param      data : Data sent by the reader
 */
- (BOOL)dispatchRcpFrmReader:(NSData *)data;

/**
 *  @brief      [ONLY SDK USE] Response of connection state
 *  @details    Called when open session, close session, connected and disconnected
 *  @param      status : connected (0), disconnected (1)
 */
- (void)plugChangedStatus:(int)status;
@end
