
import 'dart:ffi';
import 'dart:typed_data';

import 'asreader_sdk4_platform_interface.dart';


class AsreaderSdk4 {
  String PLUGGED_STATUS                         ="PLUGGED_STATUS";
  String CONNECTED_STATUS                       ="CONNECTED_STATUS";
  String TRIGGER_STATUS                         ="TRIGGER_STATUS";
  String POWER_ON_OFF                           ="POWER_ON_OFF";
  String RELEASED_TRIGGER_BUTTON                ="RELEASED_TRIGGER_BUTTON";
  String PUSHED_TRIGGER_BUTTON                  ="PUSHED_TRIGGER_BUTTON";
  String ON_ASREADER_TRIGGER_KEY_EVENT_STATUS   ="ON_ASREADER_TRIGGER_KEY_EVENT_STATUS";
  String RECEIVED_SCAN_DATA                     ="RECEIVED_SCAN_DATA";
  String RECEIVED_SCAN_DATA_AND_DATA_TYPE       ="RECEIVED_SCAN_DATA_AND_DATA_TYPE";
  String UNKNOWN_COMMAND_RECEIVED               ="UNKNOWN_COMMAND_RECEIVED";
  String ALL_DATA_RECEIVED                      ="ALL_DATA_RECEIVED";
  String BATTERY_RECEIVED                       ="BATTERY_RECEIVED";
  String STOP_READ_SCAN                         ="STOP_READ_SCAN";
  String STARTED_READ_SCAN                      ="STARTED_READ_SCAN";
  String ERROR_RECEIVED                         ="ERROR_RECEIVED";
  String RECEIVED_SLEEP_TIME_AND_ISACK          ="RECEIVED_SLEEP_TIME_AND_ISACK";
  String RECEIVED_SLEEP_TIME                    ="RECEIVED_SLEEP_TIME";
  String RECEIVED_BEEP                          ="RECEIVED_BEEP";
  String READER_INFO_RECEIVED                   ="READER_INFO_RECEIVED";
  String DID_SET_STOP_CONDITION                 ="DID_SET_STOP_CONDITION";
  String STOP_CONDITIONS_RECEIVED               ="STOP_CONDITIONS_RECEIVED";
  String RESPONSE_BOOT_LOADER_S0                ="RESPONSE_BOOT_LOADER_S0";
  String RECEIVED_BARCODE_DATA                  ="RECEIVED_BARCODE_DATA";
  String RECEIVED_FACTORY_RESET                 ="RECEIVED_FACTORY_RESET";
  String ACK_USER_COMMAND_RECEIVED              ="ACK_USER_COMMAND_RECEIVED";
  String RECEIVED_BYPASS_PAYLOAD                ="RECEIVED_BYPASS_PAYLOAD";
  String RECEIVED_CODE_ID                       ="RECEIVED_CODE_ID";
  String RECEIVED_OCR                           ="RECEIVED_OCR";
  String RECEIVED_HID                           ="RECEIVED_HID";
  String RECEIVED_PRESENTATION_MODE             ="RECEIVED_PRESENTATION_MODE";
  String RECEIVED_SLEEP_BEEP                    ="RECEIVED_SLEEP_BEEP";
  String RECEIVED_BARCODE_SET_SSI_SUCCESS       ="RECEIVED_BARCODE_SET_SSI_SUCCESS";
  String RECEIVED_SYMBOLOGIES                   ="RECEIVED_SYMBOLOGIES";
  String RECEIVED_GET_AUTO_LAUNCH               ="RECEIVED_GET_AUTO_LAUNCH";
  String RECEIVED_BARCODE_SECURITY              ="RECEIVED_BARCODE_SECURITY";
  String EPC_RECEIVED_AND_TID                   ="EPC_RECEIVED_AND_TID";
  String PC_EPC_RECEIVED                        ="PC_EPC_RECEIVED";
  String PC_EPC_RSSI_RECEIVED_AND_RSSI          ="PC_EPC_RSSI_RECEIVED_AND_RSSI";
  String PC_EPC_SENSOR_DATA_RECEIVED            ="PC_EPC_SENSOR_DATA_RECEIVED";
  String PC_EPC_SENSOR_DATA_RECEIVED_RSSI       ="PC_EPC_SENSOR_DATA_RECEIVED_RSSI";
  String DID_SET_OUTPUT_POWER_LEVEL             ="DID_SET_OUTPUT_POWER_LEVEL";
  String DID_SET_CHANNEL_PARAM_RECEIVED         ="DID_SET_CHANNEL_PARAM_RECEIVED";
  String DID_SET_ANTI_COLLISION                 ="DID_SET_ANTI_COLLISION";
  String DID_SET_SESSION                        ="DID_SET_SESSION";
  String DID_SET_BEEP                           ="DID_SET_BEEP";
  String CHANNEL_RECEIVED_AND_CHANNEL_OFFSET    ="CHANNEL_RECEIVED_AND_CHANNEL_OFFSET";
  String ANTICOL_PARAM_RECEIVED_AND_COUNTER     ="ANTICOL_PARAM_RECEIVED_AND_COUNTER";
  String MODULATION_PARAM_RECEIVED_RXMOD_DR     ="MODULATION_PARAM_RECEIVED_RXMOD_DR";
  String TX_POWER_LEVEL_RECEIVED_POWER          ="TX_POWER_LEVEL_RECEIVED_POWER";
  String REGION_RECEIVED                        ="REGION_RECEIVED";
  String SELECT_PARAM_RECEIVED                  ="SELECT_PARAM_RECEIVED";
  String QUERY_PARAM_RECEIVED                   ="QUERY_PARAM_RECEIVED";
  String ON_OFF_TIME_CHANGED                    ="ON_OFF_TIME_CHANGED";
  String FREQ_HP_TABLE_RECEIVED                 ="FREQ_HP_TABLE_RECEIVED";
  String FHLBT_RECEIVED                         ="FHLBT_RECEIVED";
  String HOPPING_TABLE_RECEIVED                 ="HOPPING_TABLE_RECEIVED";
  String DID_SET_FREQ_HP_TABLE                  ="DID_SET_FREQ_HP_TABLE";
  String DID_SET_FHLBT                          ="DID_SET_FHLBT";
  String DID_SET_OPTI_FREQ_HPTABLE              ="DID_SET_OPTI_FREQ_HPTABLE";
  String DID_SET_FHMODE_CHANGED                 ="DID_SET_FHMODE_CHANGED";
  String RESPONSE_GET_FH_MODE                   ="RESPONSE_GET_FH_MODE";
  String DID_SET_MODULATION                     ="DID_SET_MODULATION";
  String RFID_MODULE_VERSION_RECEIVED           ="RFID_MODULE_VERSION_RECEIVED";
  String RFID_ON_OFF_TIME_RECEIVED              ="RFID_ON_OFF_TIME_RECEIVED";
  String RSSI_THRESHOLD_RECEIVED                ="RSSI_THRESHOLD_RECEIVED";
  String WRITTEN_RECEIVED                       ="WRITTEN_RECEIVED";
  String SESSION_RECEIVED                       ="SESSION_RECEIVED";
  String TAG_MEMORY_RECEIVED                    ="TAG_MEMORY_RECEIVED";
  String KILL_RECEIVED                          ="KILL_RECEIVED";
  String LOCKED_RECEIVED                        ="LOCKED_RECEIVED";
  String REGISTERY_ITEM_RECEIVED                ="REGISTERY_ITEM_RECEIVED";
  String RESPONSE_REBOOT                        ="RESPONSE_REBOOT";
  String GENERIC_RECEIVED                       ="GENERIC_RECEIVED";
  String UPDATED_REGISTERY                      ="UPDATED_REGISTERY";
  String RFID_DATA_RECEIVED                     ="RFID_DATA_RECEIVED";
  String RESPONSE_SET_LEAKAGE                   ="RESPONSE_SET_LEAKAGE";
  String DID_GET_AUTO_OFF_TIME_RECEIVED         ="DID_GET_AUTO_OFF_TIME_RECEIVED";
  String DID_SET_AUTO_OFF_TIME                  ="DID_SET_AUTO_OFF_TIME";
  String DID_GET_CONTINUOUS_MODE_RECEIVED       ="DID_GET_CONTINUOUS_MODE_RECEIVED";
  String DID_SET_CONTINUOUS_MODE                ="DID_SET_CONTINUOUS_MODE";
  String DID_GET_Q_VALUE_RECEIVED               ="DID_GET_Q_VALUE_RECEIVED";
  String DID_SET_Q_VALUE                        ="DID_SET_Q_VALUE";
  String DID_GET_SESSION_FLAG_RECEIVED          ="DID_GET_SESSION_FLAG_RECEIVED";
  String DID_SET_SESSION_FLAG                   ="DID_SET_SESSION_FLAG";
  String DID_GET_HID_MODE_RECEIVED              ="DID_GET_HID_MODE_RECEIVED";
  String DID_SET_HID_MODE                       ="DID_SET_HID_MODE";
  String DID_GET_DUTY_RATIO_RECEIVED            ="DID_GET_DUTY_RATIO_RECEIVED";
  String DID_SET_DUTY_RATIO                     ="DID_SET_DUTY_RATIO";
  String DID_GET_DUTY_RATIO_BASE_TIME_RECEIVED  ="DID_GET_DUTY_RATIO_BASE_TIME_RECEIVED";
  String DID_SET_DUTY_RATIO_BASE_TIME           ="DID_SET_DUTY_RATIO_BASE_TIME";
  String NFC_READ_MULTI_BLOCK_RECEIVED          ="NFC_READ_MULTI_BLOCK_RECEIVED";
  String NFC_WRITE_SINGLE_BLOCK_STATUS_CODE     ="NFC_WRITE_SINGLE_BLOCK_STATUS_CODE";
  String NFC_WRITE_BYTES_STATUS_CODE            ="NFC_WRITE_BYTES_STATUS_CODE";
  String SCANING_BLE_DEVICE                     ="SCANING_BLE_DEVICE";
  String SCAN_BLE_STATUS                        ="SCAN_BLE_STATUS";
  String RECEIVED_SCAN_BARCODE_DATA             ="RECEIVED_SCAN_BARCODE_DATA";
  String DID_GET_SLEEP_BUZZER_RECEIVED          ="DID_GET_SLEEP_BUZZER_RECEIVED";
  String DID_SET_SLEEP_BUZZER                   ="DID_SET_SLEEP_BUZZER";
  String DID_GET_BARCODE_TIME_OUT_RECEIVED      ="DID_GET_BARCODE_TIME_OUT_RECEIVED";
  String DID_SET_BARCODE_TIME_OUT               ="DID_SET_BARCODE_TIME_OUT";
  Future<String?> getPlatformVersion() {
    return AsreaderSdk4Platform.instance.getPlatformVersion();
  }
  Future<bool> getPluggedStatus() {
    return AsreaderSdk4Platform.instance.getPluggedStatus();
  }
  Future<String?> getSDKVersion(){
    return AsreaderSdk4Platform.instance.getSDKVersion();
  }
  Future<String?> getFlutterSDKVersion(){
    return AsreaderSdk4Platform.instance.getFlutterSDKVersion();
  }
  Future<void> showPrintNSLog(bool isShow) async{
    AsreaderSdk4Platform.instance.showPrintNSLog(isShow);
  }
  Future<bool> getReaderInfo(int infoType){
    return AsreaderSdk4Platform.instance.getReaderInfo(infoType);
  }
  Future<int> getCurrentBattery(){
    return AsreaderSdk4Platform.instance.getCurrentBattery();
  }
  Future<bool> setBeep(bool isBeep,bool vibration,bool batteryGaugeLed,bool barcodeAimer){
    return AsreaderSdk4Platform.instance.setBeep(isBeep, vibration, batteryGaugeLed, barcodeAimer);
  }
  Future<bool> setBeepIncludePowerOnBeep(bool isBeep,bool vibration,bool batteryGaugeLed,bool barcodeAimer,bool barcodePowerOnBeep){
    return AsreaderSdk4Platform.instance.setBeepIncludePowerOnBeep(isBeep, vibration, batteryGaugeLed, barcodeAimer,barcodePowerOnBeep);
  }
  Future<int> setReaderPower(bool isOn,bool beep,bool vibration,bool led,bool illumination,bool connectedBeep,int mode){
    return AsreaderSdk4Platform.instance.setReaderPower(isOn,beep,vibration,led,illumination,connectedBeep,mode);
  }
  Future<void> setTagCount(int mtnu,int mtime,int repeatCycle) async{
    AsreaderSdk4Platform.instance.setTagCount(mtnu, mtime, repeatCycle);
  }
  Future<void> setChargingControl(bool isOn){
    return AsreaderSdk4Platform.instance.setChargingControl(isOn);
  }
  Future<void> setDelayDisconnectOnBackground(double time){
    return AsreaderSdk4Platform.instance.setDelayDisconnectOnBackground(time);
  }
  Future<double> getDelayDisconnectOnBackground(){
    return AsreaderSdk4Platform.instance.getDelayDisconnectOnBackground();
  }
  Future<bool> isOpened(){
    return AsreaderSdk4Platform.instance.isOpened();
  }
  Future<bool> setStopTagNum(int maxTags,int maxTime,int repeatCycle) {
    return AsreaderSdk4Platform.instance.setStopTagNum(maxTags,maxTime,repeatCycle);
  }
  Future<bool> getStopCondition() {
    return AsreaderSdk4Platform.instance.getStopCondition();
  }
  Future<bool> setTriggerMode(bool isDefault) {
    return AsreaderSdk4Platform.instance.setTriggerMode(isDefault);
  }
  Future<bool> reset(){
    return AsreaderSdk4Platform.instance.reset();
  }
  Future<bool> getAutoLaunch(){
    return AsreaderSdk4Platform.instance.getAutoLaunch();
  }
  Future<bool> setAutoLaunch(bool enable,String bundleId){
    return AsreaderSdk4Platform.instance.setAutoLaunch(enable,bundleId);
  }
  Future<bool> setSleepBeep(bool isOn){
    return AsreaderSdk4Platform.instance.setSleepBeep(isOn);
  }
  Future<bool> setSleepTime(int time){
    return AsreaderSdk4Platform.instance.setSleepTime(time);
  }
  Future<bool> getSleepTime(){
    return AsreaderSdk4Platform.instance.getSleepTime();
  }
  Future<bool> startBleScan(){
    return AsreaderSdk4Platform.instance.startBleScan();
  }
  Future<void> stopBleScan(){
    return AsreaderSdk4Platform.instance.stopBleScan();
  }
  Future<void> disConnectBLE(){
    return AsreaderSdk4Platform.instance.disConnectBLE();
  }
  Future<bool> connectBLE(String deviceName){
    return AsreaderSdk4Platform.instance.connectBLE(deviceName);
  }
  Future<int> getSleepTimeForBLEDevice(){
    return AsreaderSdk4Platform.instance.getSleepTimeForBLEDevice();
  }
  Future<int> setSleepTimeForBLEDeviceType(int min,int type){
    return AsreaderSdk4Platform.instance.setSleepTimeForBLEDeviceType(min,type);
  }
  Future<bool> startBarcodeScan(int numberOfTags,int readUntilInSec){
    return AsreaderSdk4Platform.instance.startBarcodeScan(numberOfTags,readUntilInSec);
  }
  Future<bool> stopBarcodeScan(){
    return AsreaderSdk4Platform.instance.stopBarcodeScan();
  }
  Future<bool> doFactoryReset(){
    return AsreaderSdk4Platform.instance.doFactoryReset();
  }
  Future<bool> sendBarcodeSettingData(Uint8List sendData){
    return AsreaderSdk4Platform.instance.sendBarcodeSettingData(sendData);
  }
  Future<bool> setCustomPrefix(String prefix){
    return AsreaderSdk4Platform.instance.setCustomPrefix(prefix);
  }
  Future<bool> setDisableCustomPrefix(){
    return AsreaderSdk4Platform.instance.setDisableCustomPrefix();
  }
  Future<bool> setCustomSuffix(String suffix){
    return AsreaderSdk4Platform.instance.setCustomSuffix(suffix);
  }
  Future<bool> setDisableCustomSuffix(){
    return AsreaderSdk4Platform.instance.setDisableCustomSuffix();
  }
  Future<bool> setSymbologyPrefix(){
    return AsreaderSdk4Platform.instance.setSymbologyPrefix();
  }
  Future<bool> setDisableSymbologyPrefix(){
    return AsreaderSdk4Platform.instance.setDisableSymbologyPrefix();
  }
  Future<bool> setBarcodeEngineUserCommand(String command){
    return AsreaderSdk4Platform.instance.setBarcodeEngineUserCommand(command);
  }
  Future<bool> setCodeID(int type,bool isBeepOn){
    return AsreaderSdk4Platform.instance.setCodeID(type,isBeepOn);
  }
  Future<bool> setOCRType(int type,bool isBeepOn){
    return AsreaderSdk4Platform.instance.setOCRType(type,isBeepOn);
  }
  Future<bool> setAndroidHIDEnable(int isOn){
    return AsreaderSdk4Platform.instance.setAndroidHIDEnable(isOn);
  }
  Future<bool> setiOSHIDEnable(int isOn){
    return AsreaderSdk4Platform.instance.setiOSHIDEnable(isOn);
  }
  Future<bool> setPresentationMode(bool isOn,bool isBeepOn){
    return AsreaderSdk4Platform.instance.setPresentationMode(isOn,isBeepOn);
  }
  Future<bool> getCodeID(){
    return AsreaderSdk4Platform.instance.getCodeID();
  }
  Future<bool> getOCR(){
    return AsreaderSdk4Platform.instance.getOCR();
  }
  Future<bool> getHID(){
    return AsreaderSdk4Platform.instance.getHID();
  }
  Future<bool> getSymbologies(){
    return AsreaderSdk4Platform.instance.getSymbologies();
  }
  Future<bool> setSsiParamWithData(Uint8List symbolData,bool beepOn){
    return AsreaderSdk4Platform.instance.setSsiParamWithData(symbolData,beepOn);
  }
  Future<bool> setSsiParamWithDictionary(List<Map<String, String>> symbologies,bool beepOn){
    return AsreaderSdk4Platform.instance.setSsiParamWithDictionary(symbologies,beepOn);
  }
  Future<bool> getPresentationMode(){
    return AsreaderSdk4Platform.instance.getPresentationMode();
  }
  Future<bool> getSecurity(){
    return AsreaderSdk4Platform.instance.getSecurity();
  }
  Future<bool> startScan(int numberOfTags,int readUntilInSec,int repeatCycle){
    return AsreaderSdk4Platform.instance.startScan(numberOfTags,readUntilInSec,repeatCycle);
  }
  Future<bool> stopRfidScan(){
    return AsreaderSdk4Platform.instance.stopRfidScan();
  }
  Future<bool> startReadTagsAndRssiWithTagNum(int maxTags,int maxTime,int repeatCycle){
    return AsreaderSdk4Platform.instance.startReadTagsAndRssiWithTagNum(maxTags,maxTime,repeatCycle);
  }
  Future<bool> startReadTagAndTidWithTagNum(int maxTags,int maxTime,int repeatCycle){
    return AsreaderSdk4Platform.instance.startReadTagAndTidWithTagNum(maxTags,maxTime,repeatCycle);
  }
  Future<bool> startReadTagsRFM(int codeType,int maxTags,int maxTime,int repeatCycle){
    return AsreaderSdk4Platform.instance.startReadTagsRFM(codeType,maxTags,maxTime,repeatCycle);
  }
  Future<bool> getSelectParameter(){
    return AsreaderSdk4Platform.instance.getSelectParameter();
  }
  Future<bool> setSelectParameter(int target,int action,int memoryBank,int pointer,int length,int truncate,Uint8List mask){
    return AsreaderSdk4Platform.instance.setSelectParameter(target, action, memoryBank, pointer, length, truncate, mask);
  }
  Future<bool> getChannel(){
    return AsreaderSdk4Platform.instance.getChannel();
  }
  Future<bool> setReadTime(int readTime,int idleTime){
    return AsreaderSdk4Platform.instance.setReadTime(readTime,idleTime);
  }
  Future<bool> setChannel(int channel,int channelOffset){
    return AsreaderSdk4Platform.instance.setChannel(channel,channelOffset);
  }
  Future<bool> getFhLbtParameter(){
    return AsreaderSdk4Platform.instance.getFhLbtParameter();
  }
  Future<bool> setFhLbtParameter(int readTime, int idleTime,
      int carrierSenseTime, int targetRFPowerLevel, int frequencyHopping,
      int listenBeforeTalk, int continuousWave){
    return AsreaderSdk4Platform.instance.setFhLbtParameter(readTime, idleTime,
        carrierSenseTime, targetRFPowerLevel, frequencyHopping,
        listenBeforeTalk, continuousWave);
  }
  Future<bool> getOutputPowerLevel(){
    return AsreaderSdk4Platform.instance.getOutputPowerLevel();
  }
  Future<bool> setOutputPowerLevel(int powerLevel){
    return AsreaderSdk4Platform.instance.setOutputPowerLevel(powerLevel);
  }
  Future<bool> writeTagMemoryWithAccessPassword(int accessPassword, Uint8List epc, int memoryBank, int startAddress, Uint8List dataToWrite){
    return AsreaderSdk4Platform.instance.writeTagMemoryWithAccessPassword(accessPassword, epc, memoryBank, startAddress, dataToWrite);
  }
  Future<bool> killTagWithPassword(int accessPassword, Uint8List epc){
    return AsreaderSdk4Platform.instance.killTagWithPassword(accessPassword, epc);
  }
  Future<bool> lockTagMemoryWithAccessPassword(int accessPassword, Uint8List epc,int lockData){
    return AsreaderSdk4Platform.instance.lockTagMemoryWithAccessPassword(accessPassword, epc, lockData);
  }
  Future<bool> getFrequencyHoppingTable(){
    return AsreaderSdk4Platform.instance.getFrequencyHoppingTable();
  }
  Future<bool> setFrequencyHoppingTableSize(int tableSize, Uint8List channels){
    return AsreaderSdk4Platform.instance.setFrequencyHoppingTableSize(tableSize, channels);
  }
  Future<bool> getRssi(){
    return AsreaderSdk4Platform.instance.getRssi();
  }
  Future<bool> getSession(){
    return AsreaderSdk4Platform.instance.getSession();
  }
  Future<bool> setSession(int session){
    return AsreaderSdk4Platform.instance.setSession(session);
  }
  Future<bool> getAnticollision(){
    return AsreaderSdk4Platform.instance.getAnticollision();
  }
  Future<bool> setAnticollision(int mode,int counter){
    return AsreaderSdk4Platform.instance.setAnticollision(mode,counter);
  }
  Future<bool> updateRegistry(){
    return AsreaderSdk4Platform.instance.updateRegistry();
  }
  Future<bool> getRFIDModuleVersion(){
    return AsreaderSdk4Platform.instance.getRFIDModuleVersion();
  }
  Future<bool> setHoppingOnOff(bool isOn){
    return AsreaderSdk4Platform.instance.setHoppingOnOff(isOn);
  }
  Future<bool> writeTagMemoryWithEPC(Uint8List epc,String dataToWrite){
    return AsreaderSdk4Platform.instance.writeTagMemoryWithEPC(epc, dataToWrite);
  }
  Future<bool> setRSSIThreshold(int threshold){
    return AsreaderSdk4Platform.instance.setRSSIThreshold(threshold);
  }
  Future<bool> getRSSIThreshold(){
    return AsreaderSdk4Platform.instance.getRSSIThreshold();
  }
  Future<bool> getQueryParameter(){
    return AsreaderSdk4Platform.instance.getQueryParameter();
  }
  Future<bool> readTagWithAccessPassword(int accessPassword, Uint8List epc, int memoryBank, int startAddress, int dataLength) {
    return AsreaderSdk4Platform.instance.readTagWithAccessPassword(accessPassword, epc, memoryBank, startAddress, dataLength);
  }
  Future<bool> setQueryParam(int divideRatio,int m,int trext,int selection,int session,int target,int qValue) {
    return AsreaderSdk4Platform.instance.setQueryParam(divideRatio,m,trext,selection,session,target,qValue);
  }
  Future<bool> setRfCw(bool on){
    return AsreaderSdk4Platform.instance.setRfCw(on);
  }
  Future<bool> getModulation(){
    return AsreaderSdk4Platform.instance.getModulation();
  }
  Future<bool> setModulationBLF(int blf,int rxMod,int dr){
    return AsreaderSdk4Platform.instance.setModulationBLF(blf,rxMod,dr);
  }
  Future<bool> blockEraseTagMemoryWithAccessPassword(int accessPassword, Uint8List epc, int memoryBank, int startAddress, int dataLength) {
    return AsreaderSdk4Platform.instance.blockEraseTagMemoryWithAccessPassword(accessPassword, epc, memoryBank, startAddress, dataLength);
  }
  Future<bool> genericTransportWithAccessPassword(int accessPassword, Uint8List epc, int transmissionState, int rm, int size, Uint8List genericCommand) {
    return AsreaderSdk4Platform.instance.genericTransportWithAccessPassword(accessPassword, epc, transmissionState, rm, size, genericCommand);
  }
  Future<bool> getTemperature(){
    return AsreaderSdk4Platform.instance.getTemperature();
  }
  Future<bool> getRegistryItem(int registryItem){
    return AsreaderSdk4Platform.instance.getRegistryItem(registryItem);
  }
  Future<bool> setOptimumFrequencyHoppingTable(){
    return AsreaderSdk4Platform.instance.setOptimumFrequencyHoppingTable();
  }
  Future<bool> setFrequencyHoppingMode(int mode){
    return AsreaderSdk4Platform.instance.setFrequencyHoppingMode(mode);
  }
  Future<bool> getFrequencyHoppingMode(){
    return AsreaderSdk4Platform.instance.getFrequencyHoppingMode();
  }
  Future<bool> setSmartHoppingOnOff(bool isOn){
    return AsreaderSdk4Platform.instance.setSmartHoppingOnOff(isOn);
  }
  Future<bool> getRegion(){
    return AsreaderSdk4Platform.instance.getRegion();
  }
  Future<void> setReadRSSIMode(bool isReadRSSIMode) async {
    AsreaderSdk4Platform.instance.setReadRSSIMode(isReadRSSIMode);
  }
  Future<bool> getRfidModuleInformation(){
    return AsreaderSdk4Platform.instance.getRfidModuleInformation();
  }
  Future<bool> getHoppingOnOff(){
    return AsreaderSdk4Platform.instance.getHoppingOnOff();
  }
  Future<bool> getAutoOffTime(){
    return AsreaderSdk4Platform.instance.getAutoOffTime();
  }
  Future<bool> setAutoOffTime(int time){
    return AsreaderSdk4Platform.instance.setAutoOffTime(time);
  }
  Future<bool> getContinuousMode(){
    return AsreaderSdk4Platform.instance.getContinuousMode();
  }
  Future<bool> setContinuousMode(bool isContinuousMode){
    return AsreaderSdk4Platform.instance.setContinuousMode(isContinuousMode);
  }
  Future<bool> getQValue(){
    return AsreaderSdk4Platform.instance.getQValue();
  }
  Future<bool> setQValue(int value){
    return AsreaderSdk4Platform.instance.setQValue(value);
  }
  Future<bool> getSessionFlag(){
    return AsreaderSdk4Platform.instance.getSessionFlag();
  }
  Future<bool> setSessionFlag(int sessionFlag){
    return AsreaderSdk4Platform.instance.setSessionFlag(sessionFlag);
  }
  Future<bool> getHidMode(){
    return AsreaderSdk4Platform.instance.getHidMode();
  }
  Future<bool> setHidMode(bool hidMode){
    return AsreaderSdk4Platform.instance.setHidMode(hidMode);
  }
  Future<bool> getDutyRatio(){
    return AsreaderSdk4Platform.instance.getDutyRatio();
  }
  Future<bool> setDutyRatio(int dutyRatio){
    return AsreaderSdk4Platform.instance.setDutyRatio(dutyRatio);
  }
  Future<bool> getDutyRatioBaseTime(){
    return AsreaderSdk4Platform.instance.getDutyRatioBaseTime();
  }
  Future<bool> setDutyRatioBaseTime(int dutyRatioBaseTime){
    return AsreaderSdk4Platform.instance.setDutyRatioBaseTime(dutyRatioBaseTime);
  }
  Future<bool> sendData(Uint8List sendData){
    return AsreaderSdk4Platform.instance.sendData(sendData);
  }
  Future<bool> setInventoryTime(double inventoryTime){
    return AsreaderSdk4Platform.instance.setInventoryTime(inventoryTime);
  }
  Future<bool> startNFCScan(){
    return AsreaderSdk4Platform.instance.startNFCScan();
  }
  Future<bool> stopNFCScan(){
    return AsreaderSdk4Platform.instance.stopNFCScan();
  }
  Future<bool> readMultiBlockWithBlockIndex(int index, int count){
    return AsreaderSdk4Platform.instance.readMultiBlockWithBlockIndex(index, count);
  }
  Future<bool> writeSingleBlockWithBlockIndex(int index, Uint8List writeData, Uint8List uid){
    return AsreaderSdk4Platform.instance.writeSingleBlockWithBlockIndex(index, writeData, uid);
  }
  Future<bool> writeBytesWithBlockIndex(int index, Uint8List writeData, Uint8List uid){
    return AsreaderSdk4Platform.instance.writeBytesWithBlockIndex(index, writeData, uid);
  }
  Future<bool> startLfScan(int numberOfTags, int readUntilInSec, int repeatCycle){
    return AsreaderSdk4Platform.instance.startLfScan(numberOfTags, readUntilInSec, repeatCycle);
  }
  Future<bool> stopLfScan(){
    return AsreaderSdk4Platform.instance.stopLfScan();
  }
  Future<bool> isShowPrintNSLog(){
    return AsreaderSdk4Platform.instance.isShowPrintNSLog();
  }
  Future<String> bundleIdentifier(){
    return AsreaderSdk4Platform.instance.bundleIdentifier();
  }
  Future<String> deviceName(){
    return AsreaderSdk4Platform.instance.deviceName();
  }
  Future<String> deviceFirmware(){
    return AsreaderSdk4Platform.instance.deviceFirmware();
  }
  Future<String> deviceHardware(){
    return AsreaderSdk4Platform.instance.deviceHardware();
  }
  Future<String> deviceID(){
    return AsreaderSdk4Platform.instance.deviceID();
  }
  Future<String> deviceManufacturer(){
    return AsreaderSdk4Platform.instance.deviceManufacturer();
  }
  Future<String> deviceModelNumber(){
    return AsreaderSdk4Platform.instance.deviceModelNumber();
  }
  Future<String> deviceSerialNumber(){
    return AsreaderSdk4Platform.instance.deviceSerialNumber();
  }
  Future<String> deviceProtocol(){
    return AsreaderSdk4Platform.instance.deviceProtocol();
  }
  Future<int> currentSelectDevice(){
    return AsreaderSdk4Platform.instance.currentSelectDevice();
  }
  Future<bool> isPowerOn(){
    return AsreaderSdk4Platform.instance.isPowerOn();
  }
  Future<int> supportMode(){
    return AsreaderSdk4Platform.instance.supportMode();
  }
  Future<int> currentReaderMode(){
    return AsreaderSdk4Platform.instance.currentReaderMode();
  }
  Future<int> receiveDataType(){
    return AsreaderSdk4Platform.instance.receiveDataType();
  }
  Future<bool> dualSameTime(){
    return AsreaderSdk4Platform.instance.dualSameTime();
  }
  Future<bool> isBeep(){
    return AsreaderSdk4Platform.instance.isBeep();
  }
  Future<bool> isVibration(){
    return AsreaderSdk4Platform.instance.isVibration();
  }
  Future<bool> isLED(){
    return AsreaderSdk4Platform.instance.isLED();
  }
  Future<bool> isIllumination(){
    return AsreaderSdk4Platform.instance.isIllumination();
  }
  Future<int> count(){
    return AsreaderSdk4Platform.instance.count();
  }
  Future<int> scanTime(){
    return AsreaderSdk4Platform.instance.scanTime();
  }
  Future<int> cycle(){
    return AsreaderSdk4Platform.instance.cycle();
  }
  Future<bool> isTriggerModeDefault(){
    return AsreaderSdk4Platform.instance.isTriggerModeDefault();
  }
  Future<bool> isReadRSSIMode(){
    return AsreaderSdk4Platform.instance.isReadRSSIMode();
  }
  Future<bool> isEnginePowerAlwaysOn(){
    return AsreaderSdk4Platform.instance.isEnginePowerAlwaysOn();
  }
  Future<int> barcodeEngineType(){
    return AsreaderSdk4Platform.instance.barcodeEngineType();
  }
  Future<int> carrierSenseTime(){
    return AsreaderSdk4Platform.instance.carrierSenseTime();
  }
  Future<int> targetRFPowerLevel(){
    return AsreaderSdk4Platform.instance.targetRFPowerLevel();
  }
  Future<bool> isSmartHopping(){
    return AsreaderSdk4Platform.instance.isSmartHopping();
  }
  Future<double> rfidPower(){
    return AsreaderSdk4Platform.instance.rfidPower();
  }
  Future<double> rfidPowerMax(){
    return AsreaderSdk4Platform.instance.rfidPowerMax();
  }
  Future<double> rfidPowerMin(){
    return AsreaderSdk4Platform.instance.rfidPowerMin();
  }
  Future<int> rfidOnTime(){
    return AsreaderSdk4Platform.instance.rfidOnTime();
  }
  Future<int> rfidOffTime(){
    return AsreaderSdk4Platform.instance.rfidOffTime();
  }
  Future<int> rfidChannel(){
    return AsreaderSdk4Platform.instance.rfidChannel();
  }
  Future<int> rfidListenBeforeTalk(){
    return AsreaderSdk4Platform.instance.rfidListenBeforeTalk();
  }
  Future<int> rfidFrequencyHopping(){
    return AsreaderSdk4Platform.instance.rfidFrequencyHopping();
  }
  Future<int> rfidContinuousWave(){
    return AsreaderSdk4Platform.instance.rfidContinuousWave();
  }
  Future<String> rfidModuleVersion(){
    return AsreaderSdk4Platform.instance.rfidModuleVersion();
  }
  Future<bool> isSupportType(int supportType){
    return AsreaderSdk4Platform.instance.isSupportType(supportType);
  }
  Future<List<int>> getSupportTypeArray(){
    return AsreaderSdk4Platform.instance.getSupportTypeArray();
  }
  Future<bool> setConnectionType(int type){
    return AsreaderSdk4Platform.instance.setConnectionType(type);
  }
  Future<int> getConnectionType(){
    return AsreaderSdk4Platform.instance.getConnectionType();
  }
  Future<Map<String,String>> parseDataByProtocolType(Uint8List data,int type){
    return AsreaderSdk4Platform.instance.parseDataByProtocolType(data, type);
  }
  Future<bool> getSleepBuzzer(){
    return AsreaderSdk4Platform.instance.getSleepBuzzer();
  }
  Future<bool> setSleepBuzzer(bool sleepBuzzer){
    return AsreaderSdk4Platform.instance.setSleepBuzzer(sleepBuzzer);
  }
  Future<bool> getBarcodeTimeOut(){
    return AsreaderSdk4Platform.instance.getBarcodeTimeOut();
  }
  Future<bool> setBarcodeTimeOut(int timeout){
    return AsreaderSdk4Platform.instance.setBarcodeTimeOut(timeout);
  }
}
