import 'dart:core';
import 'dart:async';
import 'dart:ffi';

import 'package:flutter/foundation.dart';
import 'package:flutter/services.dart';

import 'asreader_sdk4_platform_interface.dart';

/// An implementation of [AsreaderSdk4Platform] that uses method channels.
class MethodChannelAsreaderSdk4 extends AsreaderSdk4Platform {
  /// The method channel used to interact with the native platform.
  @visibleForTesting
  final methodChannel = const MethodChannel('asreader_sdk4');

  @override
  Future<String?> getPlatformVersion() async{
    final version =
        await methodChannel.invokeMethod<String>('getPlatformVersion');
    return version;
  }

  @override
  Future<bool> getPluggedStatus() async{
    final version =
        await methodChannel.invokeMethod<String>('getPluggedStatus');
    return version.toString() == '1';
  }

  @override
  Future<String?> getSDKVersion() async{
    final version = await methodChannel.invokeMethod<String>('getSDKVersion');
    return version;
  }

  @override
  Future<String?> getFlutterSDKVersion() async{
    final version = await methodChannel.invokeMethod<String>('getFlutterSDKVersion');
    return version;
  }

  @override
  Future<void> showPrintNSLog(bool isShow) async{
    await methodChannel
        .invokeMethod<String>('showPrintNSLog', {'isShow': isShow});
  }

  @override
  Future<int> setReaderPower(bool isOn, bool beep, bool vibration, bool led,
      bool illumination, bool connectedBeep, int mode) async{
    print('_setReaderPower start');
    try {
      Map<Object?, Object?> result =
          await methodChannel.invokeMethod('setReaderPower', {
        'isOn': isOn,
        'isBeep': beep,
        'isVib': vibration,
        'isbatteryGaugeLed': led,
        'isBarcodeAimer': illumination,
        'isBarcodePowerOnBeep': connectedBeep,
        'nDeviceType': mode
      });
      return int.parse(result['result'].toString());
    } on PlatformException catch (e) {
      print('Failed : ${e.message} .');
    }
    return -1;
  }

  @override
  Future<bool> getReaderInfo(int infoType) async{
    Map<Object?, Object?> result = await methodChannel
        .invokeMethod('getReaderInfo', {'infoType': infoType});
    return result['result'].toString() == '1';
  }

  @override
  Future<int> getCurrentBattery() async{
    Map<Object?, Object?> result =
        await methodChannel.invokeMethod('getCurrentBattery');
    return int.parse(result['result'].toString());
  }

  @override
  Future<bool> setBeep(bool isBeep, bool vibration, bool batteryGaugeLed,
      bool barcodeAimer) async{
    Map<Object?, Object?> result =
        await methodChannel.invokeMethod('setBeepVibrationLedAimer', {
      'isBeep': isBeep,
      'isVibration': vibration,
      'isbatteryGaugeLed': batteryGaugeLed,
      'isBarcodeAimer': barcodeAimer
    });
    return result['result'].toString() == '1';
  }

  @override
  Future<bool> setBeepIncludePowerOnBeep(bool isBeep, bool vibration,
      bool batteryGaugeLed, bool barcodeAimer, bool barcodePowerOnBeep) async{
    Map<Object?, Object?> result = await methodChannel
        .invokeMethod('setBeepVibrationLedAimerPoweronbeep', {
      'isBeep': isBeep,
      'isVibration': vibration,
      'isbatteryGaugeLed': batteryGaugeLed,
      'isBarcodeAimer': barcodeAimer,
      'isBarcodePowerOnBeep': barcodePowerOnBeep
    });
    return result['result'].toString() == '1';
  }

  @override
  Future<void> setTagCount(int mtnu, int mtime, int repeatCycle) async{
    await methodChannel.invokeMethod('setTagCount',
        {'mtnu': mtnu, 'mtime': mtime, 'repeatCycle': repeatCycle});
  }

  @override
  Future<bool> setChargingControl(bool isOn) async{
    Map<Object?, Object?> result =
        await methodChannel.invokeMethod('setChargingControl', {'isOn': isOn});
    return result['result'].toString() == '1';
  }
  @override
  Future<void> setDelayDisconnectOnBackground(double time) async{
     await methodChannel.invokeMethod(
        'setDelayDisconnectOnBackground', {'time': time});
  }
  @override
  Future<double> getDelayDisconnectOnBackground() async{
    Map<Object?, Object?> result =
        await methodChannel.invokeMethod('getDelayDisconnectOnBackground');
    return double.parse(result['result'].toString());
  }

  @override
  Future<bool> isOpened() async{
    Map<Object?, Object?> result = await methodChannel.invokeMethod('isOpened');
    return result['result'].toString() == '1';
  }

  @override
  Future<bool> setStopTagNum(int maxTags, int maxTime, int repeatCycle) async{
    Map<Object?, Object?> result = await methodChannel.invokeMethod(
        'setStopTagNum',
        {'maxTags': maxTags, 'maxTime': maxTime, 'repeatCycle': repeatCycle});
    return result['result'].toString() == '1';
  }

  @override
  Future<bool> getStopCondition() async{
    Map<Object?, Object?> result = await methodChannel.invokeMethod('getStopCondition');
    return result['result'].toString() == '1';
  }

  @override
  Future<bool> setTriggerMode(bool isDefault) async {
    Map<Object?, Object?> result = await methodChannel
        .invokeMethod('setTriggerMode', {'isDefault': isDefault});
    return result['result'].toString() == '1';
  }

  @override
  Future<bool> reset() async{
    Map<Object?, Object?> result = await methodChannel.invokeMethod('reset');
    return result['result'].toString() == '1';
  }

  @override
  Future<bool> getAutoLaunch() async{
    Map<Object?, Object?> result = await methodChannel.invokeMethod('getAutoLaunch');
    return result['result'].toString() == '1';
  }

  @override
  Future<bool> setAutoLaunch(bool enable,String bundleId) async{
    Map<Object?, Object?> result = await methodChannel.invokeMethod(
        'setAutoLaunchBundleID', {'enable': enable, 'bundleId': bundleId});
    return result['result'].toString() == '1';
  }

  @override
  Future<bool> setSleepBeep(bool isOn) async{
    Map<Object?, Object?> result = await methodChannel.invokeMethod(
        'setSleepBeep', {'isOn': isOn});
    return result['result'].toString() == '1';
  }

  @override
  Future<bool> setSleepTime(int time) async{
    Map<Object?, Object?> result = await methodChannel.invokeMethod(
        'setSleepTime', {'time': time});
    return result['result'].toString() == '1';
  }

  @override
  Future<bool> getSleepTime() async{
    Map<Object?, Object?> result = await methodChannel.invokeMethod(
        'getSleepTime');
    return result['result'].toString() == '1';
  }

  @override
  Future<bool> startBleScan() async{
    Map<Object?, Object?> result = await methodChannel.invokeMethod(
        'startBleScan');
    return result['result'].toString() == '1';
  }

  @override
  Future<void> stopBleScan() async{
    await methodChannel.invokeMethod(
        'stopBleScan');
  }

  @override
  Future<void> disConnectBLE() async{
    await methodChannel.invokeMethod(
        'disConnectBLE');
  }
  @override
  Future<bool> connectBLE(String deviceName) async {
    Map<Object?, Object?> result = await methodChannel.invokeMethod(
        'connectBLE',{'deviceName':deviceName});
    return result['result'].toString() == '1';
  }
  @override
  Future<int> getSleepTimeForBLEDevice() async{
    Map<Object?, Object?> result = await methodChannel.invokeMethod(
        'getSleepTimeForBLEDevice');
    return int.parse(result['result'].toString());
  }

  @override
  Future<int> setSleepTimeForBLEDeviceType(int min,int type) async{
    Map<Object?, Object?> result = await methodChannel.invokeMethod(
        'setSleepTimeForBLEDeviceType',{'min':min,'type':type});
    return int.parse(result['result'].toString());
  }

  @override
  Future<bool> startBarcodeScan(int numberOfTags,int readUntilInSec) async{
    Map<Object?, Object?> result = await methodChannel.invokeMethod(
        'startBarcodeScan',{'numberOfTags':numberOfTags,'readUntilInSec':readUntilInSec});
    return result['result'].toString() == '1';
  }

  @override
  Future<bool> stopBarcodeScan() async{
    Map<Object?, Object?> result = await methodChannel.invokeMethod(
        'stopBarcodeScan');
    return result['result'].toString() == '1';
  }
  @override
  Future<bool> doFactoryReset() async{
    Map<Object?, Object?> result = await methodChannel.invokeMethod(
        'doFactoryReset');
    return result['result'].toString() == '1';
  }
  @override
  Future<bool> sendBarcodeSettingData(Uint8List sendData) async {
    Map<Object?, Object?> result = await methodChannel.invokeMethod(
        'sendBarcodeSettingData', [sendData]);
    return result['result'].toString() == '1';
  }
  @override
  Future<bool> sendBarcodeHoneywellSettingWithData(Uint8List sendData) async {
    Map<Object?, Object?> result = await methodChannel.invokeMethod(
        'sendBarcodeSettingData',[sendData]);
    return result['result'].toString() == '1';
  }
  @override
  Future<bool> setCustomPrefix(String prefix) async{
    Map<Object?, Object?> result = await methodChannel.invokeMethod(
        'setCustomPrefix',{'prefix':prefix});
    return result['result'].toString() == '1';
  }
  @override
  Future<bool> setDisableCustomPrefix() async{
    Map<Object?, Object?> result = await methodChannel.invokeMethod(
        'setDisableCustomPrefix');
    return result['result'].toString() == '1';
  }
  @override
  Future<bool> setCustomSuffix(String suffix) async{
    Map<Object?, Object?> result = await methodChannel.invokeMethod(
        'setCustomSuffix',{'suffix':suffix});
    return result['result'].toString() == '1';
  }
  @override
  Future<bool> setDisableCustomSuffix() async{
    Map<Object?, Object?> result = await methodChannel.invokeMethod(
        'setDisableCustomSuffix');
    return result['result'].toString() == '1';
  }
  @override
  Future<bool> setSymbologyPrefix() async{
    Map<Object?, Object?> result = await methodChannel.invokeMethod(
        'setSymbologyPrefix');
    return result['result'].toString() == '1';
  }
  @override
  Future<bool> setDisableSymbologyPrefix() async{
    Map<Object?, Object?> result = await methodChannel.invokeMethod(
        'setDisableSymbologyPrefix');
    return result['result'].toString() == '1';
  }
  @override
  Future<bool> setBarcodeEngineUserCommand(String command) async{
    Map<Object?, Object?> result = await methodChannel.invokeMethod(
        'setBarcodeEngineUserCommand',{'command':command});
    return result['result'].toString() == '1';
  }
  @override
  Future<bool> setCodeID(int type,bool isBeepOn) async{
    Map<Object?, Object?> result = await methodChannel.invokeMethod(
        'setCodeIDIsBeepOn',{'type':type,'isBeepOn':isBeepOn});
    return result['result'].toString() == '1';
  }
  @override
  Future<bool> setOCRType(int type,bool isBeepOn) async{
    Map<Object?, Object?> result = await methodChannel.invokeMethod(
        'setOCRTypeIsBeepOn',{'type':type,'isBeepOn':isBeepOn});
    return result['result'].toString() == '1';
  }
  @override
  Future<bool> setAndroidHIDEnable(int isOn) async{
    Map<Object?, Object?> result = await methodChannel.invokeMethod(
        'setAndroidHIDEnable',{'isOn':isOn});
    return result['result'].toString() == '1';
  }
  @override
  Future<bool> setiOSHIDEnable(int isOn) async{
    Map<Object?, Object?> result = await methodChannel.invokeMethod(
        'setIOSHIDEnable',{'isOn':isOn});
    return result['result'].toString() == '1';
  }
  @override
  Future<bool> setPresentationMode(bool isOn,bool isBeepOn) async{
    Map<Object?, Object?> result = await methodChannel.invokeMethod(
        'setPresentationMode',{'isOn':isOn,'isBeepOn':isBeepOn});
    return result['result'].toString() == '1';
  }
  @override
  Future<bool> getCodeID() async{
    Map<Object?, Object?> result = await methodChannel.invokeMethod(
        'getCodeID');
    return result['result'].toString() == '1';
  }
  @override
  Future<bool> getOCR() async{
    Map<Object?, Object?> result = await methodChannel.invokeMethod(
        'getOCR');
    return result['result'].toString() == '1';
  }
  @override
  Future<bool> getHID() async{
    Map<Object?, Object?> result = await methodChannel.invokeMethod(
        'getHID');
    return result['result'].toString() == '1';
  }
  @override
  Future<bool> getSymbologies() async{
    Map<Object?, Object?> result = await methodChannel.invokeMethod(
        'getSymbologies');
    return result['result'].toString() == '1';
  }
  @override
  Future<bool> setSsiParamWithData(Uint8List symbolData,bool beepOn) async{
    Map<Object?, Object?> result = await methodChannel.invokeMethod(
        'setSsiParamWithData',[symbolData, beepOn]);
    return result['result'].toString() == '1';
  }
  @override
  Future<bool> setSsiParamWithDictionary(List<Map<String, String>> symbologies,bool beepOn) async{
    Map<Object?, Object?> result = await methodChannel.invokeMethod(
        'setSsiParamWithDictionary',{'symbologies':symbologies,'beepOn':beepOn});
    return result['result'].toString() == '1';
  }
  @override
  Future<bool> getPresentationMode() async{
    Map<Object?, Object?> result = await methodChannel.invokeMethod(
        'getPresentationMode');
    return result['result'].toString() == '1';
  }
  @override
  Future<bool> getSecurity() async{
    Map<Object?, Object?> result = await methodChannel.invokeMethod(
        'getSecurity');
    return result['result'].toString() == '1';
  }
  @override
  Future<bool> startScan(int numberOfTags,int readUntilInSec,int repeatCycle) async{
    Map<Object?, Object?> result = await methodChannel.invokeMethod(
        'startScan',{'numberOfTags':numberOfTags,'readUntilInSec':readUntilInSec,'repeatCycle':repeatCycle});
    return result['result'].toString() == '1';
  }
  @override
  Future<bool> stopRfidScan() async{
    Map<Object?, Object?> result = await methodChannel.invokeMethod(
        'stopRfidScan');
    return result['result'].toString() == '1';
  }
  @override
  Future<bool> startReadTagsAndRssiWithTagNum(int maxTags,int maxTime,int repeatCycle) async{
    Map<Object?, Object?> result = await methodChannel.invokeMethod(
        'startReadTagsAndRssi',{'maxTags':maxTags,'maxTime':maxTime,'repeatCycle':repeatCycle});
    return result['result'].toString() == '1';
  }
  @override
  Future<bool> startReadTagAndTidWithTagNum(int maxTags,int maxTime,int repeatCycle) async{
    Map<Object?, Object?> result = await methodChannel.invokeMethod(
        'startReadTagAndTid',{'maxTags':maxTags,'maxTime':maxTime,'repeatCycle':repeatCycle});
    return result['result'].toString() == '1';
  }
  @override
  Future<bool> startReadTagsRFM(int codeType,int maxTags,int maxTime,int repeatCycle) async{
    Map<Object?, Object?> result = await methodChannel.invokeMethod(
        'startReadTagsRFM',{'codeType':codeType,'maxTags':maxTags,'maxTime':maxTime,'repeatCycle':repeatCycle});
    return result['result'].toString() == '1';
  }
  @override
  Future<bool> getSelectParameter() async{
    Map<Object?, Object?> result = await methodChannel.invokeMethod(
        'getSelectParameter');
    return result['result'].toString() == '1';
  }
  @override
  Future<bool> setSelectParameter(int target,int action,int memoryBank,int pointer,int length,int truncate,Uint8List mask) async {
     Map<Object?, Object?> result = await methodChannel.invokeMethod(
        'setSelectParameter',[target, action, memoryBank, pointer, length, truncate, mask]);
    return result['result'].toString() == '1';
  }
  @override
  Future<bool> getChannel() async{
    Map<Object?, Object?> result = await methodChannel.invokeMethod(
        'getChannel');
    return result['result'].toString() == '1';
  }
  @override
  Future<bool> setReadTime(int readTime,int idleTime) async {
    Map<Object?, Object?> result = await methodChannel.invokeMethod(
        'setReadTime',{'ReadTime':readTime,'IdleTime':idleTime});
    return result['result'].toString() == '1';
  }
  @override
  Future<bool> setChannel(int channel,int channelOffset) async {
    Map<Object?, Object?> result = await methodChannel.invokeMethod(
        'setChannel',{'channel':channel,'channelOffset':channelOffset});
    return result['result'].toString() == '1';
  }
  @override
  Future<bool> getFhLbtParameter() async {
    Map<Object?, Object?> result = await methodChannel.invokeMethod(
        'getFhLbtParameter');
    return result['result'].toString() == '1';
  }
  @override
  Future<bool> setFhLbtParameter(int readTime,int idleTime,int carrierSenseTime,int targetRFPowerLevel,int frequencyHopping,int listenBeforeTalk,int continuousWave) async {
    Map<Object?, Object?> result = await methodChannel.invokeMethod(
        'setFhLbtParameter',
        {'ReadTime':readTime,
          'IdleTime':idleTime,
          'carrierSenseTime':carrierSenseTime,
          'targetRFPowerLevel':targetRFPowerLevel,
          'frequencyHopping':frequencyHopping,
        'listenBeforeTalk':listenBeforeTalk,
        'continuousWave':continuousWave});
    return result['result'].toString() == '1';
  }
  @override
  Future<bool> getOutputPowerLevel() async {
    Map<Object?, Object?> result = await methodChannel.invokeMethod(
        'getOutputPowerLevel');
    return result['result'].toString() == '1';
  }
  @override
  Future<bool> setOutputPowerLevel(int powerLevel) async {
    Map<Object?, Object?> result = await methodChannel.invokeMethod(
        'setOutputPowerLevel',{'powerLevel':powerLevel});
    return result['result'].toString() == '1';
  }
  @override
  Future<bool> writeTagMemoryWithAccessPassword(int accessPassword, Uint8List epc, int memoryBank, int startAddress, Uint8List dataToWrite) async {
    Map<Object?, Object?> result = await methodChannel.invokeMethod(
        'writeTagMemoryWithAccessPassword',[accessPassword, epc, memoryBank, startAddress, dataToWrite]);
    return result['result'].toString() == '1';
  }
  @override
  Future<bool> killTagWithPassword(int accessPassword, Uint8List epc) async {
    Map<Object?, Object?> result = await methodChannel.invokeMethod(
        'killTagWithPassword',[accessPassword, epc]);
    return result['result'].toString() == '1';
  }
  @override
  Future<bool> lockTagMemoryWithAccessPassword(int accessPassword, Uint8List epc,int lockData) async {
    Map<Object?, Object?> result = await methodChannel.invokeMethod(
        'lockTagMemoryWithAccessPassword',[accessPassword, epc, lockData]);
    return result['result'].toString() == '1';
  }
  @override
  Future<bool> getFrequencyHoppingTable() async {
    Map<Object?, Object?> result = await methodChannel.invokeMethod(
        'getFrequencyHoppingTable');
    return result['result'].toString() == '1';
  }
  @override
  Future<bool> setFrequencyHoppingTableSize(int tableSize, Uint8List channels) async {
    Map<Object?, Object?> result = await methodChannel.invokeMethod(
        'setFrequencyHoppingTableSize',[tableSize, channels]);
    return result['result'].toString() == '1';
  }
  @override
  Future<bool> getRssi() async {
    Map<Object?, Object?> result = await methodChannel.invokeMethod(
        'getRssi');
    return result['result'].toString() == '1';
  }
  @override
  Future<bool> getSession() async {
    Map<Object?, Object?> result = await methodChannel.invokeMethod(
        'getSession');
    return result['result'].toString() == '1';
  }
  @override
  Future<bool> setSession(int session) async {
    Map<Object?, Object?> result = await methodChannel.invokeMethod(
        'setSession',{'session':session});
    return result['result'].toString() == '1';
  }
  @override
  Future<bool> getAnticollision() async {
    Map<Object?, Object?> result = await methodChannel.invokeMethod(
        'getAnticollision');
    return result['result'].toString() == '1';
  }
  @override
  Future<bool> setAnticollision(int mode,int counter) async {
    Map<Object?, Object?> result = await methodChannel.invokeMethod(
        'setAnticollision',{'mode':mode,'counter':counter});
    return result['result'].toString() == '1';
  }
  @override
  Future<bool> updateRegistry() async {
    Map<Object?, Object?> result = await methodChannel.invokeMethod(
        'updateRegistry');
    return result['result'].toString() == '1';
  }
  @override
  Future<bool> getRFIDModuleVersion() async {
    Map<Object?, Object?> result = await methodChannel.invokeMethod(
        'getRFIDModuleVersion');
    return result['result'].toString() == '1';
  }
  @override
  Future<bool> setHoppingOnOff(bool isOn) async {
    Map<Object?, Object?> result = await methodChannel.invokeMethod(
        'setHoppingOnOff',{'isOn':isOn});
    return result['result'].toString() == '1';
  }
  @override
  Future<bool> writeTagMemoryWithEPC(Uint8List epc,String dataToWrite) async {
    Map<Object?, Object?> result = await methodChannel.invokeMethod(
        'writeTagMemoryWithEPC',[epc, dataToWrite]);
    return result['result'].toString() == '1';
  }
  @override
  Future<bool> setRSSIThreshold(int threshold) async {
    Map<Object?, Object?> result = await methodChannel.invokeMethod(
        'setRSSIThreshold',{'threshold':threshold});
    return result['result'].toString() == '1';
  }
  @override
  Future<bool> getRSSIThreshold() async {
    Map<Object?, Object?> result = await methodChannel.invokeMethod(
        'getRSSIThreshold');
    return result['result'].toString() == '1';
  }
  @override
  Future<bool> getQueryParameter() async {
    Map<Object?, Object?> result = await methodChannel.invokeMethod(
        'getQueryParameter');
    return result['result'].toString() == '1';
  }
  @override
  Future<bool> readTagWithAccessPassword(int accessPassword, Uint8List epc, int memoryBank, int startAddress, int dataLength) async {
    Map<Object?, Object?> result = await methodChannel.invokeMethod(
        'readTagWithAccessPassword',[accessPassword, epc, memoryBank, startAddress, dataLength]);
    return result['result'].toString() == '1';
  }
  @override
  Future<bool> setQueryParam(int divideRatio,int m,int trext,int selection,int session,int target,int qValue) async {
    Map<Object?, Object?> result = await methodChannel.invokeMethod(
        'setQueryParam',{'divideRatio':divideRatio,'m':m,'trext':trext,'selection':selection,'session':session,'target':target,'qValue':qValue});
    return result['result'].toString() == '1';
  }
  @override
  Future<bool> setRfCw(bool on) async {
    Map<Object?, Object?> result = await methodChannel.invokeMethod(
        'setRfCw',{'on':on});
    return result['result'].toString() == '1';
  }
  @override
  Future<bool> getModulation() async {
    Map<Object?, Object?> result = await methodChannel.invokeMethod(
        'getModulation');
    return result['result'].toString() == '1';
  }
  @override
  Future<bool> setModulationBLF(int blf,int rxMod,int dr) async {
    Map<Object?, Object?> result = await methodChannel.invokeMethod(
        'setModulationBLF',{'blf':blf,'rxMod':rxMod,'dr':dr});
    return result['result'].toString() == '1';
  }
  @override
  Future<bool> blockEraseTagMemoryWithAccessPassword(int accessPassword, Uint8List epc, int memoryBank, int startAddress, int dataLength) async {
    Map<Object?, Object?> result = await methodChannel.invokeMethod(
        'blockEraseTagMemoryWithAccessPassword',[accessPassword, epc, memoryBank, startAddress, dataLength]);
    return result['result'].toString() == '1';
  }
  @override
  Future<bool> genericTransportWithAccessPassword(int accessPassword, Uint8List epc, int transmissionState, int rm, int size, Uint8List genericCommand) async {
    Map<Object?, Object?> result = await methodChannel.invokeMethod(
        'genericTransportWithAccessPassword',[accessPassword, epc, transmissionState, rm, size, genericCommand]);
    return result['result'].toString() == '1';
  }
  @override
  Future<bool> getTemperature() async {
    Map<Object?, Object?> result = await methodChannel.invokeMethod(
        'getTemperature');
    return result['result'].toString() == '1';
  }
  @override
  Future<bool> getRegistryItem(int registryItem) async {
    Map<Object?, Object?> result = await methodChannel.invokeMethod(
        'getRegistryItem',{'registryItem':registryItem});
    return result['result'].toString() == '1';
  }
  @override
  Future<bool> setOptimumFrequencyHoppingTable() async {
    Map<Object?, Object?> result = await methodChannel.invokeMethod(
        'setOptimumFrequencyHoppingTable');
    return result['result'].toString() == '1';
  }
  @override
  Future<bool> setFrequencyHoppingMode(int mode) async {
    Map<Object?, Object?> result = await methodChannel.invokeMethod(
        'setFrequencyHoppingMode',{'mode':mode});
    return result['result'].toString() == '1';
  }
  @override
  Future<bool> getFrequencyHoppingMode() async {
    Map<Object?, Object?> result = await methodChannel.invokeMethod(
        'getFrequencyHoppingMode');
    return result['result'].toString() == '1';
  }
  @override
  Future<bool> setSmartHoppingOnOff(bool isOn) async {
    Map<Object?, Object?> result = await methodChannel.invokeMethod(
        'setSmartHoppingOnOff',{'isOn':isOn});
    return result['result'].toString() == '1';
  }
  @override
  Future<bool> getRegion() async {
    Map<Object?, Object?> result = await methodChannel.invokeMethod(
        'getRegion');
    return result['result'].toString() == '1';
  }
  @override
  Future<void> setReadRSSIMode(bool isReadRSSIMode) async {
    await methodChannel.invokeMethod(
        'setReadRSSIMode',{'isReadRSSIMode':isReadRSSIMode});
  }
  @override
  Future<bool> getRfidModuleInformation() async {
    Map<Object?, Object?> result = await methodChannel.invokeMethod(
        'getRfidModuleInformation');
    return result['result'].toString() == '1';
  }

  @override
  Future<bool> getHoppingOnOff() async {
    Map<Object?, Object?> result = await methodChannel.invokeMethod(
        'getHoppingOnOff');
    return result['result'].toString() == '1';
  }
  @override
  Future<bool> getAutoOffTime() async {
    Map<Object?, Object?> result = await methodChannel.invokeMethod(
        'getAutoOffTime');
    return result['result'].toString() == '1';
  }
  @override
  Future<bool> setAutoOffTime(int time) async {
    Map<Object?, Object?> result = await methodChannel.invokeMethod(
        'setAutoOffTime',{'time':time});
    return result['result'].toString() == '1';
  }
  Future<bool> getContinuousMode() async {
    Map<Object?, Object?> result = await methodChannel.invokeMethod(
        'getContinuousMode');
    return result['result'].toString() == '1';
  }
  @override
  Future<bool> setContinuousMode(bool isContinuousMode) async {
    Map<Object?, Object?> result = await methodChannel.invokeMethod(
        'setContinuousMode',{'continuousMode':isContinuousMode});
    return result['result'].toString() == '1';
  }
  @override
  Future<bool> getQValue() async {
    Map<Object?, Object?> result = await methodChannel.invokeMethod(
        'getQValue');
    return result['result'].toString() == '1';
  }
  @override
  Future<bool> setQValue(int value) async {
    Map<Object?, Object?> result = await methodChannel.invokeMethod(
        'setQValue',{'qValue':value});
    return result['result'].toString() == '1';
  }
  @override
  Future<bool> getSessionFlag() async {
    Map<Object?, Object?> result = await methodChannel.invokeMethod(
        'getSessionFlag');
    return result['result'].toString() == '1';
  }
  @override
  Future<bool> setSessionFlag(int sessionFlag) async {
    Map<Object?, Object?> result = await methodChannel.invokeMethod(
        'setSessionFlag',{'sessionFlag':sessionFlag});
    return result['result'].toString() == '1';
  }
  @override
  Future<bool> getHidMode() async {
    Map<Object?, Object?> result = await methodChannel.invokeMethod(
        'getHidMode');
    return result['result'].toString() == '1';
  }
  @override
  Future<bool> setHidMode(bool hidMode) async {
    Map<Object?, Object?> result = await methodChannel.invokeMethod(
        'setHidMode',{'hidMode':hidMode});
    return result['result'].toString() == '1';
  }
  @override
  Future<bool> getDutyRatio() async {
    Map<Object?, Object?> result = await methodChannel.invokeMethod(
        'getDutyRatio');
    return result['result'].toString() == '1';
  }
  @override
  Future<bool> setDutyRatio(int dutyRatio) async {
    Map<Object?, Object?> result = await methodChannel.invokeMethod(
        'setDutyRatio',{'dutyRatio':dutyRatio});
    return result['result'].toString() == '1';
  }
  @override
  Future<bool> getDutyRatioBaseTime() async {
    Map<Object?, Object?> result = await methodChannel.invokeMethod(
        'getDutyRatioBaseTime');
    return result['result'].toString() == '1';
  }
  @override
  Future<bool> setDutyRatioBaseTime(int dutyRatioBaseTime) async {
    Map<Object?, Object?> result = await methodChannel.invokeMethod(
        'setDutyRatioBaseTime',{'dutyRatioBaseTime':dutyRatioBaseTime});
    return result['result'].toString() == '1';
  }

  @override
  Future<bool> sendData(Uint8List sendData) async {
    Map<Object?, Object?> result = await methodChannel.invokeMethod(
        'sendData',[sendData]);
    return result['result'].toString() == '1';
  }
  @override
  Future<bool> setInventoryTime(double inventoryTime) async {
    Map<Object?, Object?> result = await methodChannel.invokeMethod(
        'setInventoryTime',{'inventoryTime':inventoryTime});
    return result['result'].toString() == '1';
  }
  @override
  Future<bool> startNFCScan() async {
    Map<Object?, Object?> result = await methodChannel.invokeMethod(
        'startNFCScan');
    return result['result'].toString() == '1';
  }
  @override
  Future<bool> stopNFCScan() async {
    Map<Object?, Object?> result = await methodChannel.invokeMethod(
        'stopNFCScan');
    return result['result'].toString() == '1';
  }
 @override
  Future<bool> readMultiBlockWithBlockIndex(int index, int count) async {
   Map<Object?, Object?> result = await methodChannel.invokeMethod(
       'readMultiBlockWithBlockIndex',{'index': index, 'count': count});
    return result['result'].toString() == '1';
  }
  @override
  Future<bool> writeSingleBlockWithBlockIndex(int index, Uint8List writeData, Uint8List uid) async {
    Map<Object?, Object?> result = await methodChannel.invokeMethod(
        'writeSingleBlockWithBlockIndex',[ index, writeData,  uid]);
    return result['result'].toString() == '1';
  }
  @override
  Future<bool> writeBytesWithBlockIndex(int index, Uint8List writeData, Uint8List uid) async {
    Map<Object?, Object?> result = await methodChannel.invokeMethod(
        'writeBytesWithBlockIndex',[index, writeData, uid]);
    return result['result'].toString() == '1';
  }
  @override
  Future<bool> startLfScan(int numberOfTags, int readUntilInSec, int repeatCycle) async {
    Map<Object?, Object?> result = await methodChannel.invokeMethod(
        'startLfScan', {'numberOfTags': numberOfTags, 'readUntilInSec': readUntilInSec, 'repeatCycle': repeatCycle});
    return result['result'].toString() == '1';
  }
  @override
  Future<bool> stopLfScan() async {
    Map<Object?, Object?> result = await methodChannel.invokeMethod(
        'stopLfScan');
    return result['result'].toString() == '1';
  }
  @override
  Future<bool> isShowPrintNSLog() async {
    Map<Object?, Object?> result = await methodChannel.invokeMethod(
        'isShowPrintNSLog');
    return result['result'].toString() == '1';
  }
  @override
  Future<String> bundleIdentifier() async {
    Map<Object?, Object?> result = await methodChannel.invokeMethod(
        'bundleIdentifier');
    return result['result'].toString();
  } 
  @override
  Future<String> deviceName() async {
    Map<Object?, Object?> result = await methodChannel.invokeMethod(
        'deviceName');
    return result['result'].toString();
  }
  @override
  Future<String> deviceFirmware() async {
    Map<Object?, Object?> result = await methodChannel.invokeMethod(
        'deviceFirmware');
    return result['result'].toString();
  }
  @override
  Future<String> deviceHardware() async {
    Map<Object?, Object?> result = await methodChannel.invokeMethod(
        'deviceHardware');
    return result['result'].toString();
  } 
  @override
  Future<String> deviceID() async {
    Map<Object?, Object?> result = await methodChannel.invokeMethod(
        'deviceID');
    return result['result'].toString();
  }
  @override
  Future<String> deviceManufacturer() async {
    Map<Object?, Object?> result = await methodChannel.invokeMethod(
        'deviceManufacturer');
    return result['result'].toString();
  } 
  @override
  Future<String> deviceModelNumber() async {
    Map<Object?, Object?> result = await methodChannel.invokeMethod(
        'deviceModelNumber');
    return result['result'].toString();
  }
  @override
  Future<String> deviceSerialNumber() async {
    Map<Object?, Object?> result = await methodChannel.invokeMethod(
        'deviceSerialNumber');
    return result['result'].toString();
  }
  @override
  Future<String> deviceProtocol() async {
    Map<Object?, Object?> result = await methodChannel.invokeMethod(
        'deviceProtocol');
    return result['result'].toString();
  }
  @override
  Future<int> currentSelectDevice() async {
    Map<Object?, Object?> result = await methodChannel.invokeMethod(
        'currentSelectDevice');
    return int.parse(result['result'].toString());
  }
  @override
  Future<bool> isPowerOn() async {
    Map<Object?, Object?> result = await methodChannel.invokeMethod(
        'isPowerOn');
    return result['result'].toString() == '1';
  }
  @override
  Future<int> supportMode() async {
    Map<Object?, Object?> result = await methodChannel.invokeMethod(
        'supportMode');
    return int.parse(result['result'].toString());
  } 
  @override
  Future<int> currentReaderMode() async {
    Map<Object?, Object?> result = await methodChannel.invokeMethod(
        'currentReaderMode');
    return int.parse(result['result'].toString());
  }
  @override
  Future<int> receiveDataType() async {
    Map<Object?, Object?> result = await methodChannel.invokeMethod(
        'receiveDataType');
    return int.parse(result['result'].toString());
  } 
  @override
  Future<bool> dualSameTime() async {
    Map<Object?, Object?> result = await methodChannel.invokeMethod(
        'dualSameTime');
    return result['result'].toString() == '1';
  } 
  @override
  Future<bool> isBeep() async {
    Map<Object?, Object?> result = await methodChannel.invokeMethod(
        'isBeep');
    return result['result'].toString() == '1';
  } 
  @override
  Future<bool> isVibration() async {
    Map<Object?, Object?> result = await methodChannel.invokeMethod(
        'isVibration');
    return result['result'].toString() == '1';
  } 
  @override
  Future<bool> isLED() async {
    Map<Object?, Object?> result = await methodChannel.invokeMethod(
        'isLED');
    return result['result'].toString() == '1';
  } 
  @override
  Future<bool> isIllumination() async {
    Map<Object?, Object?> result = await methodChannel.invokeMethod(
        'isIllumination');
    return result['result'].toString() == '1';
  }
  @override
  Future<int> count() async {
    Map<Object?, Object?> result = await methodChannel.invokeMethod(
        'count');
    return int.parse(result['result'].toString());
  }
  @override
  Future<int> scanTime() async {
    Map<Object?, Object?> result = await methodChannel.invokeMethod(
        'scanTime');
    return int.parse(result['result'].toString());
  }
  @override
  Future<int> cycle() async {
    Map<Object?, Object?> result = await methodChannel.invokeMethod(
        'cycle');
    return int.parse(result['result'].toString());
  } 
  @override
  Future<bool> isTriggerModeDefault() async {
    Map<Object?, Object?> result = await methodChannel.invokeMethod(
        'isTriggerModeDefault');
    return result['result'].toString() == '1';
  }
  @override
  Future<bool> isReadRSSIMode() async {
    Map<Object?, Object?> result = await methodChannel.invokeMethod(
        'isReadRSSIMode');
    return result['result'].toString() == '1';
  } 
  @override
  Future<bool> isEnginePowerAlwaysOn() async {
    Map<Object?, Object?> result = await methodChannel.invokeMethod(
        'isEnginePowerAlwaysOn');
    return result['result'].toString() == '1';
  } 
  @override
  Future<int> barcodeEngineType() async {
    Map<Object?, Object?> result = await methodChannel.invokeMethod(
        'barcodeEngineType');
    return int.parse(result['result'].toString());
  }
  @override
  Future<int> carrierSenseTime() async {
    Map<Object?, Object?> result = await methodChannel.invokeMethod(
        'carrierSenseTime');
    return int.parse(result['result'].toString());
  } 
  @override
  Future<int> targetRFPowerLevel() async {
    Map<Object?, Object?> result = await methodChannel.invokeMethod(
        'targetRFPowerLevel');
    return int.parse(result['result'].toString());
  }
  @override
  Future<bool> isSmartHopping() async {
    Map<Object?, Object?> result = await methodChannel.invokeMethod(
        'isSmartHopping');
    return result['result'].toString() == '1';
  } 
  @override
  Future<double> rfidPower() async {
    Map<Object?, Object?> result = await methodChannel.invokeMethod(
        'rfidPower');
    return double.parse(result['result'].toString());
  } 
  @override
  Future<double> rfidPowerMax() async {
    Map<Object?, Object?> result = await methodChannel.invokeMethod(
        'rfidPowerMax');
    return double.parse(result['result'].toString());
  }
  @override
  Future<double> rfidPowerMin() async {
    Map<Object?, Object?> result = await methodChannel.invokeMethod(
        'rfidPowerMin');
    return double.parse(result['result'].toString());
  }
  @override
  Future<int> rfidOnTime() async {
    Map<Object?, Object?> result = await methodChannel.invokeMethod(
        'rfidOnTime');
    return int.parse(result['result'].toString());
  }
  @override
  Future<int> rfidOffTime() async {
    Map<Object?, Object?> result = await methodChannel.invokeMethod(
        'rfidOffTime');
    return int.parse(result['result'].toString());
  } 
  @override
  Future<int> rfidChannel() async {
    Map<Object?, Object?> result = await methodChannel.invokeMethod(
        'rfidChannel');
    return int.parse(result['result'].toString());
  } 
  @override
  Future<int> rfidListenBeforeTalk() async {
    Map<Object?, Object?> result = await methodChannel.invokeMethod(
        'rfidListenBeforeTalk');
    return int.parse(result['result'].toString());
  }
  @override
  Future<int> rfidFrequencyHopping() async {
    Map<Object?, Object?> result = await methodChannel.invokeMethod(
        'rfidFrequencyHopping');
    return int.parse(result['result'].toString());
  }
  @override
  Future<int> rfidContinuousWave() async {
    Map<Object?, Object?> result = await methodChannel.invokeMethod(
        'rfidContinuousWave');
    return int.parse(result['result'].toString());
  }
  @override
  Future<String> rfidModuleVersion() async {
    Map<Object?, Object?> result = await methodChannel.invokeMethod(
        'rfidModuleVersion');
    return result['result'].toString();
  } 
  @override
  Future<bool> isSupportType(int supportType) async {
    Map<Object?, Object?> result = await methodChannel.invokeMethod(
        'isSupportType',{'supportType': supportType});
    return result['result'].toString() == '1';
  } 
  @override
  Future<List<int>> getSupportTypeArray() async {
    Map<Object?, Object?> result = await methodChannel.invokeMethod(
        'getSupportTypeArray');
    List  resultList = result['result'] as List;
    List<int> list = [];
    for (var value in resultList) {
      list.add(value);
    }
    return list;
  }
  @override
  Future<bool> setConnectionType(int type) async {
    Map<Object?, Object?> result = await methodChannel.invokeMethod(
        'setConnectionType',{'type': type});
    return result['result'].toString() == '1';
  }
  @override
  Future<int> getConnectionType() async {
    Map<Object?, Object?> result = await methodChannel.invokeMethod(
        'getConnectionType');
    return int.parse(result['result'].toString());
  }
  @override

  Future<Map<String,String>> parseDataByProtocolType(Uint8List data,int type) async {
    Map<Object?, Object?> result = await methodChannel.invokeMethod(
        'parseDataByProtocolType',[data, type]);
    Map<String,String> resultMap = {};
    for (var key in result.keys) {
      resultMap[key.toString()] = result[key].toString();
    }
    return resultMap;
  }
  @override
  Future<bool> getSleepBuzzer() async {
    Map<Object?, Object?> result = await methodChannel.invokeMethod(
        'getSleepBuzzer');
    return result['result'].toString() == '1';
  }
  @override
  Future<bool> setSleepBuzzer(bool sleepBuzzer) async {
    Map<Object?, Object?> result = await methodChannel.invokeMethod(
        'setSleepBuzzer',{'sleepBuzzer':sleepBuzzer});
    return result['result'].toString() == '1';
  }
  @override
  Future<bool> getBarcodeTimeOut() async {
    Map<Object?, Object?> result = await methodChannel.invokeMethod(
        'getBarcodeTimeOut');
    return result['result'].toString() == '1';
  }
  @override
  Future<bool> setBarcodeTimeOut(int timeout) async {
    Map<Object?, Object?> result = await methodChannel.invokeMethod(
        'setBarcodeTimeOut',{'timeout':timeout});
    return result['result'].toString() == '1';
  }
}

