import 'dart:ffi';

import 'dart:typed_data';

import 'package:flutter_test/flutter_test.dart';
import 'package:asreader_sdk4/asreader_sdk4.dart';
import 'package:asreader_sdk4/asreader_sdk4_platform_interface.dart';
import 'package:asreader_sdk4/asreader_sdk4_method_channel.dart';
import 'package:plugin_platform_interface/plugin_platform_interface.dart';

class MockAsreaderSdk4Platform
    with MockPlatformInterfaceMixin
    implements AsreaderSdk4Platform {

  @override
  Future<String?> getPlatformVersion() => Future.value('42');

  @override
  Future<void> disConnectBLE() {
    // TODO: implement disConnectBLE
    throw UnimplementedError();
  }

  @override
  Future<bool> doFactoryReset() {
    // TODO: implement doFactoryReset
    throw UnimplementedError();
  }

  @override
  Future<bool> getAnticollision() {
    // TODO: implement getAnticollision
    throw UnimplementedError();
  }

  @override
  Future<bool> getAutoLaunch() {
    // TODO: implement getAutoLaunch
    throw UnimplementedError();
  }

  @override
  Future<bool> getChannel() {
    // TODO: implement getChannel
    throw UnimplementedError();
  }

  @override
  Future<bool> getCodeID() {
    // TODO: implement getCodeID
    throw UnimplementedError();
  }

  @override
  Future<int> getCurrentBattery() {
    // TODO: implement getCurrentBattery
    throw UnimplementedError();
  }
  Future<void> setDelayDisconnectOnBackground(double time) {
    // TODO: implement setDelayDisconnectOnBackground
    throw UnimplementedError();
  }
  @override
  Future<double> getDelayDisconnectOnBackground() {
    // TODO: implement getDelayDisconnectOnBackground
    throw UnimplementedError();
  }

  @override
  Future<bool> getFhLbtParameter() {
    // TODO: implement getFhLbtParameter
    throw UnimplementedError();
  }

  @override
  Future<bool> getFrequencyHoppingMode() {
    // TODO: implement getFrequencyHoppingMode
    throw UnimplementedError();
  }

  @override
  Future<bool> getFrequencyHoppingTable() {
    // TODO: implement getFrequencyHoppingTable
    throw UnimplementedError();
  }

  @override
  Future<bool> getHID() {
    // TODO: implement getHID
    throw UnimplementedError();
  }

  @override
  Future<bool> getModulation() {
    // TODO: implement getModulation
    throw UnimplementedError();
  }

  @override
  Future<bool> getOCR() {
    // TODO: implement getOCR
    throw UnimplementedError();
  }

  @override
  Future<bool> getOutputPowerLevel() {
    // TODO: implement getOutputPowerLevel
    throw UnimplementedError();
  }

  @override
  Future<bool> getPluggedStatus() {
    // TODO: implement getPluggedStatus
    throw UnimplementedError();
  }

  @override
  Future<bool> getPresentationMode() {
    // TODO: implement getPresentationMode
    throw UnimplementedError();
  }

  @override
  Future<bool> getQueryParameter() {
    // TODO: implement getQueryParameter
    throw UnimplementedError();
  }

  @override
  Future<bool> getRFIDModuleVersion() {
    // TODO: implement getRFIDModuleVersion
    throw UnimplementedError();
  }

  @override
  Future<bool> getRSSIThreshold() {
    // TODO: implement getRSSIThreshold
    throw UnimplementedError();
  }

  @override
  Future<bool> getReaderInfo(int infoType) {
    // TODO: implement getReaderInfo
    throw UnimplementedError();
  }

  @override
  Future<bool> getRegion() {
    // TODO: implement getRegion
    throw UnimplementedError();
  }

  @override
  Future<bool> getRegistryItem(int registryItem) {
    // TODO: implement getRegistryItem
    throw UnimplementedError();
  }

  @override
  Future<bool> getRfidModuleInformation() {
    // TODO: implement getRfidModuleInformation
    throw UnimplementedError();
  }

  @override
  Future<bool> getRssi() {
    // TODO: implement getRssi
    throw UnimplementedError();
  }

  @override
  Future<String?> getSDKVersion() {
    // TODO: implement getSDKVersion
    throw UnimplementedError();
  }

  @override
  Future<bool> getSecurity() {
    // TODO: implement getSecurity
    throw UnimplementedError();
  }

  @override
  Future<bool> getSelectParameter() {
    // TODO: implement getSelectParameter
    throw UnimplementedError();
  }

  @override
  Future<bool> getSession() {
    // TODO: implement getSession
    throw UnimplementedError();
  }

  @override
  Future<bool> getSleepTime() {
    // TODO: implement getSleepTime
    throw UnimplementedError();
  }

  @override
  Future<int> getSleepTimeForBLEDevice() {
    // TODO: implement getSleepTimeForBLEDevice
    throw UnimplementedError();
  }

  @override
  Future<bool> getStopCondition() {
    // TODO: implement getStopCondition
    throw UnimplementedError();
  }

  @override
  Future<bool> getSymbologies() {
    // TODO: implement getSymbologies
    throw UnimplementedError();
  }

  @override
  Future<bool> getTemperature() {
    // TODO: implement getTemperature
    throw UnimplementedError();
  }

  @override
  Future<bool> isOpened() {
    // TODO: implement isOpened
    throw UnimplementedError();
  }

  @override
  Future<bool> reset() {
    // TODO: implement reset
    throw UnimplementedError();
  }

  @override
  Future<bool> setAndroidHIDEnable(int isOn) {
    // TODO: implement setAndroidHIDEnable
    throw UnimplementedError();
  }

  @override
  Future<bool> setAnticollision(int mode, int counter) {
    // TODO: implement setAnticollision
    throw UnimplementedError();
  }

  @override
  Future<bool> setAutoLaunch(bool enable, String bundleId) {
    // TODO: implement setAutoLaunch
    throw UnimplementedError();
  }

  @override
  Future<bool> setBarcodeEngineUserCommand(String command) {
    // TODO: implement setBarcodeEngineUserCommand
    throw UnimplementedError();
  }

  @override
  Future<bool> setBeep(bool isBeep, bool vibration, bool batteryGaugeLed, bool barcodeAimer) {
    // TODO: implement setBeep
    throw UnimplementedError();
  }

  @override
  Future<bool> setBeepIncludePowerOnBeep(bool isBeep, bool vibration, bool batteryGaugeLed, bool barcodeAimer, bool barcodePowerOnBeep) {
    // TODO: implement setBeepIncludePowerOnBeep
    throw UnimplementedError();
  }

  @override
  Future<bool> setChannel(int channel, int channelOffset) {
    // TODO: implement setChannel
    throw UnimplementedError();
  }

  @override
  Future<bool> setChargingControl(bool isOn) {
    // TODO: implement setChargingControl
    throw UnimplementedError();
  }

  @override
  Future<bool> setCodeID(int type, bool isBeepOn) {
    // TODO: implement setCodeID
    throw UnimplementedError();
  }

  @override
  Future<bool> setCustomPrefix(String prefix) {
    // TODO: implement setCustomPrefix
    throw UnimplementedError();
  }

  @override
  Future<bool> setCustomSuffix(String suffix) {
    // TODO: implement setCustomSuffix
    throw UnimplementedError();
  }

  @override
  Future<bool> setDisableCustomPrefix() {
    // TODO: implement setDisableCustomPrefix
    throw UnimplementedError();
  }

  @override
  Future<bool> setDisableCustomSuffix() {
    // TODO: implement setDisableCustomSuffix
    throw UnimplementedError();
  }

  @override
  Future<bool> setDisableSymbologyPrefix() {
    // TODO: implement setDisableSymbologyPrefix
    throw UnimplementedError();
  }

  @override
  Future<bool> setFhLbtParameter(int readTime, int idleTime, int carrierSenseTime, int targetRFPowerLevel, int frequencyHopping, int listenBeforeTalk, int continuousWave) {
    // TODO: implement setFhLbtParameter
    throw UnimplementedError();
  }

  @override
  Future<bool> setFrequencyHoppingMode(int mode) {
    // TODO: implement setFrequencyHoppingMode
    throw UnimplementedError();
  }

  @override
  Future<bool> setHoppingOnOff(bool isOn) {
    // TODO: implement setHoppingOnOff
    throw UnimplementedError();
  }

  @override
  Future<bool> setInventoryTime(double inventoryTime) {
    // TODO: implement setInventoryTime
    throw UnimplementedError();
  }

  @override
  Future<bool> setModulationBLF(int blf, int rxMod, int dr) {
    // TODO: implement setModulationBLF
    throw UnimplementedError();
  }

  @override
  Future<bool> setOCRType(int type, bool isBeepOn) {
    // TODO: implement setOCRType
    throw UnimplementedError();
  }

  @override
  Future<bool> setOptimumFrequencyHoppingTable() {
    // TODO: implement setOptimumFrequencyHoppingTable
    throw UnimplementedError();
  }

  @override
  Future<bool> setOutputPowerLevel(int powerLevel) {
    // TODO: implement setOutputPowerLevel
    throw UnimplementedError();
  }

  @override
  Future<bool> setPresentationMode(bool isOn, bool isBeepOn) {
    // TODO: implement setPresentationMode
    throw UnimplementedError();
  }

  @override
  Future<bool> setQueryParam(int divideRatio, int m, int trext, int selection, int session, int target, int qValue) {
    // TODO: implement setQueryParam
    throw UnimplementedError();
  }

  @override
  Future<bool> setRSSIThreshold(int threshold) {
    // TODO: implement setRSSIThreshold
    throw UnimplementedError();
  }

  @override
  Future<void> setReadRSSIMode(bool isReadRSSIMode) {
    // TODO: implement setReadRSSIMode
    throw UnimplementedError();
  }

  @override
  Future<bool> setReadTime(int readTime, int idleTime) {
    // TODO: implement setReadTime
    throw UnimplementedError();
  }

  @override
  Future<int> setReaderPower(bool isOn, bool beep, bool vibration, bool led, bool illumination, bool connectedBeep, int mode) {
    // TODO: implement setReaderPower
    throw UnimplementedError();
  }

  @override
  Future<bool> setRfCw(bool on) {
    // TODO: implement setRfCw
    throw UnimplementedError();
  }

  @override
  Future<bool> setSession(int session) {
    // TODO: implement setSession
    throw UnimplementedError();
  }

  @override
  Future<bool> setSleepBeep(bool isOn) {
    // TODO: implement setSleepBeep
    throw UnimplementedError();
  }

  @override
  Future<bool> setSleepTime(int time) {
    // TODO: implement setSleepTime
    throw UnimplementedError();
  }

  @override
  Future<int> setSleepTimeForBLEDeviceType(int min, int type) {
    // TODO: implement setSleepTimeForBLEDeviceType
    throw UnimplementedError();
  }

  @override
  Future<bool> setSmartHoppingOnOff(bool isOn) {
    // TODO: implement setSmartHoppingOnOff
    throw UnimplementedError();
  }

  @override
  Future<bool> setSsiParamWithDictionary(List<Map<String, String>> symbologies, bool beepOn) {
    // TODO: implement setSsiParamWithDictionary
    throw UnimplementedError();
  }

  @override
  Future<bool> setStopTagNum(int maxTags, int maxTime, int repeatCycle) {
    // TODO: implement setStopTagNum
    throw UnimplementedError();
  }

  @override
  Future<bool> setSymbologyPrefix() {
    // TODO: implement setSymbologyPrefix
    throw UnimplementedError();
  }

  @override
  Future<void> setTagCount(int mtnu, int mtime, int repeatCycle) {
    // TODO: implement setTagCount
    throw UnimplementedError();
  }

  @override
  Future<bool> setTriggerMode(bool isDefault) {
    // TODO: implement setTriggerMode
    throw UnimplementedError();
  }

  @override
  Future<bool> setiOSHIDEnable(int isOn) {
    // TODO: implement setiOSHIDEnable
    throw UnimplementedError();
  }

  @override
  Future<void> showPrintNSLog(bool isShow) {
    // TODO: implement showPrintNSLog
    throw UnimplementedError();
  }

  @override
  Future<bool> startBarcodeScan(int numberOfTags, int readUntilInSec) {
    // TODO: implement startBarcodeScan
    throw UnimplementedError();
  }

  @override
  Future<bool> startBleScan() {
    // TODO: implement startBleScan
    throw UnimplementedError();
  }

  @override
  Future<bool> startNFCScan() {
    // TODO: implement startNFCScan
    throw UnimplementedError();
  }

  @override
  Future<bool> startReadTagAndTidWithTagNum(int maxTags, int maxTime, int repeatCycle) {
    // TODO: implement startReadTagAndTidWithTagNum
    throw UnimplementedError();
  }

  @override
  Future<bool> startReadTagsAndRssiWithTagNum(int maxTags, int maxTime, int repeatCycle) {
    // TODO: implement startReadTagsAndRssiWithTagNum
    throw UnimplementedError();
  }

  @override
  Future<bool> startReadTagsRFM(int codeType, int maxTags, int maxTime, int repeatCycle) {
    // TODO: implement startReadTagsRFM
    throw UnimplementedError();
  }

  @override
  Future<bool> startScan(int numberOfTags, int readUntilInSec, int repeatCycle) {
    // TODO: implement startScan
    throw UnimplementedError();
  }

  @override
  Future<bool> stopBarcodeScan() {
    // TODO: implement stopBarcodeScan
    throw UnimplementedError();
  }

  @override
  Future<void> stopBleScan() {
    // TODO: implement stopBleScan
    throw UnimplementedError();
  }

  @override
  Future<bool> stopNFCScan() {
    // TODO: implement stopNFCScan
    throw UnimplementedError();
  }

  @override
  Future<bool> stopRfidScan() {
    // TODO: implement stopRfidScan
    throw UnimplementedError();
  }

  @override
  Future<bool> updateRegistry() {
    // TODO: implement updateRegistry
    throw UnimplementedError();
  }

  @override
  Future<bool> blockEraseTagMemoryWithAccessPassword(int accessPassword, Uint8List epc, int memoryBank, int startAddress, int dataLength) {
    // TODO: implement blockEraseTagMemoryWithAccessPassword
    throw UnimplementedError();
  }

  @override
  Future<bool> connectBLE(String deviceName) {
    // TODO: implement connectBLE
    throw UnimplementedError();
  }

  @override
  Future<bool> genericTransportWithAccessPassword(int accessPassword, Uint8List epc, int transmissionState, int rm, int size, Uint8List genericCommand) {
    // TODO: implement genericTransportWithAccessPassword
    throw UnimplementedError();
  }

  @override
  Future<bool> killTagWithPassword(int accessPassword, Uint8List epc) {
    // TODO: implement killTagWithPassword
    throw UnimplementedError();
  }

  @override
  Future<bool> lockTagMemoryWithAccessPassword(int accessPassword, Uint8List epc, int lockData) {
    // TODO: implement lockTagMemoryWithAccessPassword
    throw UnimplementedError();
  }

  @override
  Future<bool> readMultiBlockWithBlockIndex(int index, int count) {
    // TODO: implement readMultiBlockWithBlockIndex
    throw UnimplementedError();
  }

  @override
  Future<bool> readTagWithAccessPassword(int accessPassword, Uint8List epc, int memoryBank, int startAddress, int dataLength) {
    // TODO: implement readTagWithAccessPassword
    throw UnimplementedError();
  }

  @override
  Future<bool> sendBarcodeHoneywellSettingWithData(Uint8List sendData) {
    // TODO: implement sendBarcodeHoneywellSettingWithData
    throw UnimplementedError();
  }

  @override
  Future<bool> sendBarcodeSettingData(Uint8List sendData) {
    // TODO: implement sendBarcodeSettingData
    throw UnimplementedError();
  }

  @override
  Future<bool> sendData(Uint8List sendData) {
    // TODO: implement sendData
    throw UnimplementedError();
  }

  @override
  Future<bool> setFrequencyHoppingTableSize(int tableSize, Uint8List channels) {
    // TODO: implement setFrequencyHoppingTableSize
    throw UnimplementedError();
  }

  @override
  Future<bool> setSelectParameter(int target, int action, int memoryBank, int pointer, int length, int truncate, Uint8List mask) {
    // TODO: implement setSelectParameter
    throw UnimplementedError();
  }

  @override
  Future<bool> setSsiParamWithData(Uint8List symbolData, bool beepOn) {
    // TODO: implement setSsiParamWithData
    throw UnimplementedError();
  }

  @override
  Future<bool> writeBytesWithBlockIndex(int index, Uint8List writeData, Uint8List uid) {
    // TODO: implement writeBytesWithBlockIndex
    throw UnimplementedError();
  }

  @override
  Future<bool> writeSingleBlockWithBlockIndex(int index, Uint8List writeData, Uint8List uid) {
    // TODO: implement writeSingleBlockWithBlockIndex
    throw UnimplementedError();
  }

  @override
  Future<bool> writeTagMemoryWithAccessPassword(int accessPassword, Uint8List epc, int memoryBank, int startAddress, Uint8List dataToWrite) {
    // TODO: implement writeTagMemoryWithAccessPassword
    throw UnimplementedError();
  }

  @override
  Future<bool> writeTagMemoryWithEPC(Uint8List epc, String dataToWrite) {
    // TODO: implement writeTagMemoryWithEPC
    throw UnimplementedError();
  }

  @override
  Future<int> barcodeEngineType() {
    // TODO: implement barcodeEngineType
    throw UnimplementedError();
  }

  @override
  Future<String> bundleIdentifier() {
    // TODO: implement bundleIdentifier
    throw UnimplementedError();
  }

  @override
  Future<int> carrierSenseTime() {
    // TODO: implement carrierSenseTime
    throw UnimplementedError();
  }

  @override
  Future<int> count() {
    // TODO: implement count
    throw UnimplementedError();
  }

  @override
  Future<int> currentReaderMode() {
    // TODO: implement currentReaderMode
    throw UnimplementedError();
  }

  @override
  Future<int> currentSelectDevice() {
    // TODO: implement currentSelectDevice
    throw UnimplementedError();
  }

  @override
  Future<int> cycle() {
    // TODO: implement cycle
    throw UnimplementedError();
  }

  @override
  Future<String> deviceFirmware() {
    // TODO: implement deviceFirmware
    throw UnimplementedError();
  }

  @override
  Future<String> deviceHardware() {
    // TODO: implement deviceHardware
    throw UnimplementedError();
  }

  @override
  Future<String> deviceID() {
    // TODO: implement deviceID
    throw UnimplementedError();
  }

  @override
  Future<String> deviceManufacturer() {
    // TODO: implement deviceManufacturer
    throw UnimplementedError();
  }

  @override
  Future<String> deviceModelNumber() {
    // TODO: implement deviceModelNumber
    throw UnimplementedError();
  }

  @override
  Future<String> deviceName() {
    // TODO: implement deviceName
    throw UnimplementedError();
  }

  @override
  Future<String> deviceProtocol() {
    // TODO: implement deviceProtocol
    throw UnimplementedError();
  }

  @override
  Future<String> deviceSerialNumber() {
    // TODO: implement deviceSerialNumber
    throw UnimplementedError();
  }

  @override
  Future<bool> dualSameTime() {
    // TODO: implement dualSameTime
    throw UnimplementedError();
  }

  @override
  Future<List<int>> getSupportTypeArray() {
    // TODO: implement getSupportTypeArray
    throw UnimplementedError();
  }

  @override
  Future<bool> isBeep() {
    // TODO: implement isBeep
    throw UnimplementedError();
  }

  @override
  Future<bool> isEnginePowerAlwaysOn() {
    // TODO: implement isEnginePowerAlwaysOn
    throw UnimplementedError();
  }

  @override
  Future<bool> isIllumination() {
    // TODO: implement isIllumination
    throw UnimplementedError();
  }

  @override
  Future<bool> isLED() {
    // TODO: implement isLED
    throw UnimplementedError();
  }

  @override
  Future<bool> isPowerOn() {
    // TODO: implement isPowerOn
    throw UnimplementedError();
  }

  @override
  Future<bool> isReadRSSIMode() {
    // TODO: implement isReadRSSIMode
    throw UnimplementedError();
  }

  @override
  Future<bool> isShowPrintNSLog() {
    // TODO: implement isShowPrintNSLog
    throw UnimplementedError();
  }

  @override
  Future<bool> isSmartHopping() {
    // TODO: implement isSmartHopping
    throw UnimplementedError();
  }

  @override
  Future<bool> isSupportType(int supportType) {
    // TODO: implement isSupportType
    throw UnimplementedError();
  }

  @override
  Future<bool> isTriggerModeDefault() {
    // TODO: implement isTriggerModeDefault
    throw UnimplementedError();
  }

  @override
  Future<bool> isVibration() {
    // TODO: implement isVibration
    throw UnimplementedError();
  }

  @override
  Future<int> receiveDataType() {
    // TODO: implement receiveDataType
    throw UnimplementedError();
  }

  @override
  Future<int> rfidChannel() {
    // TODO: implement rfidChannel
    throw UnimplementedError();
  }

  @override
  Future<int> rfidContinuousWave() {
    // TODO: implement rfidContinuousWave
    throw UnimplementedError();
  }

  @override
  Future<int> rfidFrequencyHopping() {
    // TODO: implement rfidFrequencyHopping
    throw UnimplementedError();
  }

  @override
  Future<int> rfidListenBeforeTalk() {
    // TODO: implement rfidListenBeforeTalk
    throw UnimplementedError();
  }

  @override
  Future<String> rfidModuleVersion() {
    // TODO: implement rfidModuleVersion
    throw UnimplementedError();
  }

  @override
  Future<int> rfidOffTime() {
    // TODO: implement rfidOffTime
    throw UnimplementedError();
  }

  @override
  Future<int> rfidOnTime() {
    // TODO: implement rfidOnTime
    throw UnimplementedError();
  }

  @override
  Future<double> rfidPower() {
    // TODO: implement rfidPower
    throw UnimplementedError();
  }

  @override
  Future<double> rfidPowerMax() {
    // TODO: implement rfidPowerMax
    throw UnimplementedError();
  }

  @override
  Future<double> rfidPowerMin() {
    // TODO: implement rfidPowerMin
    throw UnimplementedError();
  }

  @override
  Future<int> scanTime() {
    // TODO: implement scanTime
    throw UnimplementedError();
  }

  @override
  Future<bool> startLfScan(int numberOfTags, int readUntilInSec, int repeatCycle) {
    // TODO: implement startLfScan
    throw UnimplementedError();
  }

  @override
  Future<bool> stopLfScan() {
    // TODO: implement stopLfScan
    throw UnimplementedError();
  }

  @override
  Future<int> supportMode() {
    // TODO: implement supportMode
    throw UnimplementedError();
  }

  @override
  Future<int> targetRFPowerLevel() {
    // TODO: implement targetRFPowerLevel
    throw UnimplementedError();
  }

  @override
  Future<int> getConnectionType() {
    // TODO: implement getConnectionType
    throw UnimplementedError();
  }

  @override
  Future<bool> setConnectionType(int type) {
    // TODO: implement setConnectionType
    throw UnimplementedError();
  }

  @override
  Future<Map<String, String>> parseDataByProtocolType(Uint8List data, int type) {
    // TODO: implement parseDataByProtocolType
    throw UnimplementedError();
  }

  @override
  Future<bool> getAutoOffTime() {
    // TODO: implement getAutoOffTime
    throw UnimplementedError();
  }

  @override
  Future<bool> getContinuousMode() {
    // TODO: implement getContinuousMode
    throw UnimplementedError();
  }

  @override
  Future<bool> getDutyRatio() {
    // TODO: implement getDutyRatio
    throw UnimplementedError();
  }

  @override
  Future<bool> getDutyRatioBaseTime() {
    // TODO: implement getDutyRatioBaseTime
    throw UnimplementedError();
  }

  @override
  Future<bool> getHidMode() {
    // TODO: implement getHidMode
    throw UnimplementedError();
  }

  @override
  Future<bool> getHoppingOnOff() {
    // TODO: implement getHoppingOnOff
    throw UnimplementedError();
  }

  @override
  Future<bool> getQValue() {
    // TODO: implement getQValue
    throw UnimplementedError();
  }

  @override
  Future<bool> getSessionFlag() {
    // TODO: implement getSessionFlag
    throw UnimplementedError();
  }

  @override
  Future<bool> setAutoOffTime(int time) {
    // TODO: implement setAutoOffTime
    throw UnimplementedError();
  }

  @override
  Future<bool> setContinuousMode(bool isContinuousMode) {
    // TODO: implement setContinuousMode
    throw UnimplementedError();
  }

  @override
  Future<bool> setDutyRatio(int dutyRatio) {
    // TODO: implement setDutyRatio
    throw UnimplementedError();
  }

  @override
  Future<bool> setDutyRatioBaseTime(int dutyRatioBaseTime) {
    // TODO: implement setDutyRatioBaseTime
    throw UnimplementedError();
  }

  @override
  Future<bool> setHidMode(bool hidMode) {
    // TODO: implement setHidMode
    throw UnimplementedError();
  }

  @override
  Future<bool> setQValue(int value) {
    // TODO: implement setQValue
    throw UnimplementedError();
  }

  @override
  Future<bool> setSessionFlag(int sessionFlag) {
    // TODO: implement setSessionFlag
    throw UnimplementedError();
  }

  @override
  Future<String?> getFlutterSDKVersion() {
    // TODO: implement getFlutterSDKVersion
    throw UnimplementedError();
  }

  @override
  Future<bool> getBarcodeTimeOut() {
    // TODO: implement getBarcodeTimeOut
    throw UnimplementedError();
  }

  @override
  Future<bool> getSleepBuzzer() {
    // TODO: implement getSleepBuzzer
    throw UnimplementedError();
  }

  @override
  Future<bool> setBarcodeTimeOut(int timeout) {
    // TODO: implement setBarcodeTimeOut
    throw UnimplementedError();
  }

  @override
  Future<bool> setSleepBuzzer(bool sleepBuzzer) {
    // TODO: implement setSleepBuzzer
    throw UnimplementedError();
  }
}

void main() {
  final AsreaderSdk4Platform initialPlatform = AsreaderSdk4Platform.instance;

  test('$MethodChannelAsreaderSdk4 is the default instance', () {
    expect(initialPlatform, isInstanceOf<MethodChannelAsreaderSdk4>());
  });

  test('getPlatformVersion', () async {
    AsreaderSdk4 asreaderSdk4Plugin = AsreaderSdk4();
    MockAsreaderSdk4Platform fakePlatform = MockAsreaderSdk4Platform();
    AsreaderSdk4Platform.instance = fakePlatform;

    expect(await asreaderSdk4Plugin.getPlatformVersion(), '42');
  });
}
