import 'package:shared_preferences/shared_preferences.dart';

class LocalCache {

  Future<void> setBeep(bool value) async {
    setCache('BEEP', value);
  }

  Future<bool> getBeep() async {
    bool beep = await getCache('BEEP');
    return beep;
  }

  Future<void> setVibration(bool value) async {
    setCache('VIBRATION', value);
  }

  Future<bool> getVibration() async {
    bool vibration = await getCache('VIBRATION');
    return vibration;
  }

  Future<void> setCache(String key, bool value) async {
    SharedPreferences prefs = await SharedPreferences.getInstance();
    await prefs.setBool(key, value);
  }

  Future<bool> getCache(String key) async {
    SharedPreferences prefs = await SharedPreferences.getInstance();
    return prefs.getBool(key) ?? true;
  }

  Future<void> removeCache(String key) async {
    SharedPreferences prefs = await SharedPreferences.getInstance();
    await prefs.remove(key);
  }
}