import 'dart:async';
import 'package:asreader_sdk4_example/setting.dart';
import 'package:asreader_sdk4_example/information.dart';
import 'package:flutter/material.dart';
import 'package:flutter/services.dart';
import 'package:asreader_sdk4/asreader_sdk4.dart';

class MoreWidget extends StatefulWidget {
  @override
  State<StatefulWidget> createState() => MoreState();
}

class MoreState extends State<MoreWidget> {
  static const iosCallPlatform = MethodChannel('asreader_sdk4');
  final _asreaderSdk4Plugin = AsreaderSdk4();

  @override
  void initState() {
    super.initState();
    initPlatformState();
  }
  Future<void> initPlatformState() async {
    Future<dynamic> _handler(MethodCall methodCall) {
      print('methodCall.method:${methodCall.method}, methodCall.arguments:${methodCall.arguments}');
      if (_asreaderSdk4Plugin.PLUGGED_STATUS == methodCall.method) {
        bool isPluged = methodCall.arguments['result'];
        print('More isPluged:$isPluged, methodCall.arguments:${methodCall.arguments}');
        plugged(isPluged);
      } else if (_asreaderSdk4Plugin.CONNECTED_STATUS == methodCall.method) {
        bool isConnected = methodCall.arguments['result'];
        print('More isConnected:$isConnected, methodCall.arguments:${methodCall.arguments}');
        connected(isConnected);
      }
      return Future.value('success');
    }
    iosCallPlatform.setMethodCallHandler(_handler);
  }
  @override
  Widget build(BuildContext context) {
    var upContainer = Container(
      margin: const EdgeInsets.fromLTRB(0, 20, 0, 0),
      alignment: Alignment.center,
      child: ElevatedButton(
          style: ButtonStyle(
            backgroundColor: MaterialStateProperty.all(const Color(0xFFFFFFFF)),
          ),
          onPressed: () async {
            final result = await Navigator.push(
                context, MaterialPageRoute(builder: (context) => SettingWidget()));
            if (result != null) {
              if (result == 'NO') {
                plugged(false);
              }
            }
            initPlatformState();
          },
          child: const Text('            Setting            ')),
    );
    var upContainer1 = Container(
      margin: const EdgeInsets.fromLTRB(0, 20, 0, 0),
      alignment: Alignment.center,
      child: ElevatedButton(
          style: ButtonStyle(
            backgroundColor: MaterialStateProperty.all(const Color(0xFFFFFFFF)),
          ),
          onPressed: () async {
            final result = await Navigator.push(
                context, MaterialPageRoute(builder: (context) => InformationWidget()));
            if (result != null) {
              if (result == 'NO') {
                plugged(false);
              }
            }
            initPlatformState();
          },
          child: const Text('         Information         ')),
    );
    return Scaffold(
      appBar: AppBar(
        title: const Text('More'),
        backgroundColor: Colors.white,
        leading: IconButton(
          icon: Image.asset(
            'images/back.png',
            width: 25,
            height: 25,
            fit: BoxFit.cover,
          ),
          onPressed: () {
            Navigator.pop(context);
          },
        ),
      ),
      body: Container(
        color: Colors.white,
        child: Column(
          children: <Widget>[
            upContainer,
            upContainer1,
          ],
        ),
      ),
    );
  }
  void plugged(bool isPluged) {
    setState(() {
      if (!isPluged) {
        Navigator.pop(context, "NO");
      }
    });
  }
  void connected(bool isConnected) {
    setState(() {
      if (!isConnected) {
        Navigator.pop(context, "NO");
      }
    });
  }
}
