import 'dart:async';
import 'package:flutter/material.dart';
import 'package:flutter/services.dart';
import 'package:asreader_sdk4/asreader_sdk4.dart';
import 'package:asreader_sdk4_example/LocalCache.dart';

class SettingWidget extends StatefulWidget {
  const SettingWidget({super.key});

  @override
  State<StatefulWidget> createState() => SettingState();
}

class SettingState extends State<SettingWidget> {
  final _asreaderSdk4Plugin = AsreaderSdk4();
  static const iosCallPlatform = MethodChannel('asreader_sdk4');

  bool isBeep = false;
  bool isVibration = false;
  final cache = LocalCache();

  @override
  void initState() {
    super.initState();
    initPlatformState();
  }
  Future<void> initPlatformState() async {
    Future<dynamic> _handler(MethodCall methodCall) {
      print('methodCall.method:${methodCall.method}, methodCall.arguments:${methodCall.arguments}');
      if (_asreaderSdk4Plugin.PLUGGED_STATUS == methodCall.method) {
        bool isPluged = methodCall.arguments['result'];
        print('Setting isPluged:$isPluged, methodCall.arguments:${methodCall.arguments}');
        plugged(isPluged);
      } else if (_asreaderSdk4Plugin.CONNECTED_STATUS == methodCall.method) {
        bool isConnected = methodCall.arguments['result'];
        print('Setting isConnected:$isConnected, methodCall.arguments:${methodCall
            .arguments}');
        connected(isConnected);
      }
      return Future.value('success');
    }
    iosCallPlatform.setMethodCallHandler(_handler);
    Future.delayed(const Duration(milliseconds:500), () {
      setState(() {
        getData();
      });
    });
  }
  @override
  Widget build(BuildContext context) {
    var container1 = Container(
      color: Colors.white,
      padding: const EdgeInsets.fromLTRB(20, 7, 0, 7),
      child: Row(
        children: <Widget>[
          const Expanded(
            child:Text(
              'Beep',
              style: TextStyle(height: 1.5,color: Colors.black,fontSize: 16.0,fontWeight: FontWeight.w400,backgroundColor: Colors.white),
              textAlign: TextAlign.left,
            ),
          ),
          Expanded(
            child:Switch(
              value: isBeep,
              onChanged: (bool value) {
                setState(() {
                  isBeep = value;
                  cache.setBeep(isBeep);
                  _asreaderSdk4Plugin.setBeep(isBeep, isVibration, true, true);
                });
              },
            )
          ),
        ],
      ),
    );
    var container2 = Container(
      color: Colors.white,
      padding: const EdgeInsets.fromLTRB(20, 7, 0, 7),
      child: Row(
        children: <Widget>[
          const Expanded(
            child:Text(
              'isVibration',
              style: TextStyle(height: 1.5,color: Colors.black,fontSize: 16.0,fontWeight: FontWeight.w400,backgroundColor: Colors.white),
              textAlign: TextAlign.left,
            ),
          ),
          Expanded(
              child:Switch(
                value: isVibration,
                onChanged: (bool value) {
                  setState(() {
                    isVibration = value;
                    cache.setVibration(isVibration);
                    _asreaderSdk4Plugin.setBeep(isBeep, isVibration, true, true);
                  });
                },
              )
          ),
        ],
      ),
    );
    return Scaffold(
      appBar: AppBar(
        title: const Text('Setting'),
        backgroundColor: Colors.white,
        leading: IconButton(
          icon: Image.asset(
            'images/back.png',
            width: 25,
            height: 25,
            fit: BoxFit.cover,
          ),
          onPressed: () {
            Navigator.pop(context);
          },
        ),
      ),
      body: Container(
        color: Colors.white,
        child: Column(
          children: <Widget>[
            container1,
            container2,
          ],
        ),
      ),
    );
  }
  void plugged(bool isPluged) {
    setState(() {
      if (!isPluged) {
        Navigator.pop(context, "NO");
      }
    });
  }
  void connected(bool isConnected) {
    setState(() {
      if (!isConnected) {
        Navigator.pop(context, "NO");
      }
    });
  }
  void getData() {
    Future<bool> status1 = cache.getBeep();
    status1.then((futureResult) {
      isBeep = futureResult;
      print('isBeep:$isBeep');
    });
    Future<bool> status2 = cache.getVibration();
    status2.then((futureResult) {
      isVibration = futureResult;
      print('isVibration:$isVibration');
    });
  }
}
