//
//  BarcodeZebraHelper.h
//  AsReaderDockSDK
//
//  Created by Mikiko on 11/7/24.
//  Copyright © 2024 SPS INC. All rights reserved.
//

#import <Foundation/Foundation.h>



/**
 *  @brief      This code defines a helper class, BarcodeZebraHelper, which is responsible for managing and converting barcoding symbologies and security standards into dictionaries and arrays for easy access. This can be used to handle different types of barcode symbologies and security codes within the context of the Zebra barcode scanning system.
 */
@interface BarcodeZebraHelper: NSObject
+ (NSDictionary*)getSymbologyDictionary;
+ (NSArray*)getSymbologyArray;
+ (NSDictionary*)getSecurityDictionary;
+ (NSArray*)getSecurityArray;
@end




