﻿using AsReaderSDK4MAUIDemo.Platforms.iOS;

namespace AsReaderSDK4MAUIDemo;

public partial class SettingPage : ContentPage
{
    private AsReaderDockManagerDelegate asReaderDockManagerDelegate;

    public SettingPage()
	{
		InitializeComponent();
		Title = "More";
        asReaderDockManagerDelegate = AsReaderDockManagerDelegate.sharedInstance();

        var tapGestureRecognizer = new TapGestureRecognizer();
        tapGestureRecognizer.Tapped += (s, e) =>
        {
            Navigation.PushAsync(new SettingsPage());
        };
        settings.GestureRecognizers.Add(tapGestureRecognizer);


        var tapGestureRecognizer2 = new TapGestureRecognizer();
        tapGestureRecognizer2.Tapped += (s, e) =>
        {
            Navigation.PushAsync(new InformationPage());
        };
        information.GestureRecognizers.Add(tapGestureRecognizer2);
    }
    protected override void OnAppearing()
    {
        base.OnAppearing();
        asReaderDockManagerDelegate.Plugged = (plug) =>
        {
            Plugged(plug);
        };
    }
    protected override void OnDisappearing()
    {
        base.OnDisappearing();
        asReaderDockManagerDelegate.Plugged = null;
    }
    private void Plugged(bool plug)
    {
        MainThread.BeginInvokeOnMainThread(() =>
        {
            if (!plug)
            {
                Navigation.PopToRootAsync();
            }
        });
    }
}
