﻿using CoreBluetooth;
using Foundation;
using ObjCRuntime;

namespace AsReaderDock4
{
    // @protocol AsReaderRFIDDeviceDelegate <NSObject>
    [Protocol, Model(AutoGeneratedName = true)]
    [BaseType(typeof(NSObject))]
    interface AsReaderRFIDDeviceDelegate
    {
        // @optional -(void)epcReceived:(NSData *)epc tid:(NSData *)tid;
        [Export("epcReceived:tid:")]
        void EpcReceived(NSData epc, NSData tid);
        // @optional -(void)pcEpcReceived:(NSData *)pcEpc;
        [Export("pcEpcReceived:")]
        void PcEpcReceived(NSData pcEpc);
        // @optional -(void)pcEpcRssiReceived:(NSData *)pcEpc rssi:(int)rssi;
        [Export("pcEpcRssiReceived:rssi:")]
        void PcEpcRssiReceived(NSData pcEpc, int rssi);
        // @optional -(void)rssiReceived:(int)rssi;
        [Export("rssiReceived:")]
        void RssiReceived(int rssi);
        // @optional -(void)pcEpcSensorDataReceived:(NSData *)pcEpc sensorData:(NSData *)sensorData;
        [Export("pcEpcSensorDataReceived:sensorData:")]
        void PcEpcSensorDataReceived(NSData pcEpc, NSData sensorData);
        // @optional -(void)pcEpcSensorDataReceived:(NSData *)pcEpc sensorData:(NSData *)sensorData rssi:(int8_t)rssi;
        [Export("pcEpcSensorDataReceived:sensorData:rssi:")]
        void PcEpcSensorDataReceived(NSData pcEpc, NSData sensorData, int rssi);
        // @optional -(void)didSetOutputPowerLevel:(int)status;
        [Export("didSetOutputPowerLevel:")]
        void DidSetOutputPowerLevel(int status);
        // @optional -(void)didSetChannelParamReceived:(int)statusCode;
        [Export("didSetChannelParamReceived:")]
        void DidSetChannelParamReceived(int statusCode);
        // @optional -(void)didSetAntiCollision:(int)status;
        [Export("didSetAntiCollision:")]
        void DidSetAntiCollision(int status);
        // @optional -(void)didSetSession:(int)status;
        [Export("didSetSession:")]
        void DidSetSession(int status);
        // @optional -(void)didSetBeep:(int)status;
        [Export("didSetBeep:")]
        void DidSetBeep(int status);
        // @optional -(void)didSetStopCondition:(int)status;
        [Export("didSetStopCondition:")]
        void DidSetStopCondition(int status);
        // @optional -(void)channelReceived:(int)channel channelOffset:(int)channelOffset;
        [Export("channelReceived:channelOffset:")]
        void ChannelReceived(int channel, int channelOffset);
        // @optional -(void)anticolParamReceived:(int)mode Counter:(int)counter;
        [Export("anticolParamReceived:Counter:")]
        void AnticolParamReceived(int mode, int counter);
        // @optional - (void)modulationParamReceived:(int)blf rxMod:(int)rxMod dr:(int)dr;
        [Export("modulationParamReceived:rxMod:dr:")]
        void ModulationParamReceived(int param, int rxMod, int dr);
        // @optional - (void) didSetModulation:(int)status;
        [Export("didSetModulation:")]
        void DidSetModulation(int status);

        // @optional -(void)txPowerLevelReceived:(NSData *)power;
        [Export("txPowerLevelReceived:")]
        void TxPowerLevelReceived(NSData power);
        // @optional -(void)regionReceived:(int)region;
        [Export("regionReceived:")]
        void RegionReceived(int region);
        // @optional -(void)stopConditionsReceived:(NSData *)data;
        [Export("stopConditionsReceived:")]
        void StopConditionsReceived(NSData data);
        // @optional -(void)selectParamReceived:(NSData *)selParam;
        [Export("selectParamReceived:")]
        void SelectParamReceived(NSData selParam);
        // @optional -(void)queryParamReceived:(NSData *)qryParam;
        [Export("queryParamReceived:")]
        void QueryParamReceived(NSData qryParam);
        // @optional -(void)onOffTimeChanged;
        [Export("onOffTimeChanged")]
        void OnOffTimeChanged();
        // @optional -(void)freqHPTableReceived:(int)status;
        [Export("freqHPTableReceived:")]
        void FreqHPTableReceived(int status);
        // @optional -(void)fhLbtReceived:(NSData *)fhLb;
        [Export("fhLbtReceived:")]
        void FhLbtReceived(NSData fhLb);
        // @optional -(void)hoppingTableReceived:(NSData *)table;
        [Export("hoppingTableReceived:")]
        void HoppingTableReceived(NSData table);
        // @optional -(void)didSetFreqHPTable:(int)status;
        [Export("didSetFreqHPTable:")]
        void DidSetFreqHPTable(int status);
        // @optional -(void)didSetFhLbt:(int)status;
        [Export("didSetFhLbt:")]
        void DidSetFhLbt(int status);
        // @optional -(void)didSetOptiFreqHPTable:(int)status;
        [Export("didSetOptiFreqHPTable:")]
        void DidSetOptiFreqHPTable(int status);
        // @optional -(void)didSetFHmodeChanged;
        [Export("didSetFHmodeChanged")]
        void DidSetFHmodeChanged();
        // @optional -(void)responseGetFHmode;
        [Export("responseGetFHmode")]
        void ResponseGetFHmode();
        // @optional -(void)rfidModuleVersionReceived;
        [Export("rfidModuleVersionReceived")]
        void RfidModuleVersionReceived();
        // @optional -(void)readerInfoReceived:(NSData *)data;
        [Export("readerInfoReceived:")]
        void ReaderInfoReceived(NSData data);
        // @optional -(void)rfidOnOffTimeReceived:(NSData *)data;
        [Export("rfidOnOffTimeReceived:")]
        void RfidOnOffTimeReceived(NSData data);
        // @optional -(void)rssiThresholdReceived:(uint16_t)threshold;
        [Export("rssiThresholdReceived:")]
        void RssiThresholdReceived(int threshold);
        // @optional -(void)writtenReceived:(int)statusCode;
        [Export("writtenReceived:")]
        void WrittenReceived(int statusCode);
        // @optional -(void)sessionReceived:(int)session;
        [Export("sessionReceived:")]
        void SessionReceived(int session);
        // @optional -(void)tagMemoryReceived:(NSData *)data;
        [Export("tagMemoryReceived:")]
        void TagMemoryReceived(NSData data);
        // @optional -(void)killedReceived:(int)statusCode;
        [Export("killedReceived:")]
        void KilledReceived(int statusCode);
        // @optional -(void)lockedReceived:(int)statusCode;
        [Export("lockedReceived:")]
        void LockedReceived(int statusCode);
        // @optional -(void)registeryItemReceived:(NSData *)item;
        [Export("registeryItemReceived:")]
        void RegisteryItemReceived(NSData item);
        // @optional -(void)genericReceived:(NSData *)data;
        [Export("genericReceived:")]
        void GenericReceived(NSData data);
        // @optional -(void)responseReboot:(int)status;
        [Export("responseReboot:")]
        void ResponseReboot(int status);
        // @optional -(void)updatedRegistry:(int)statusCode;
        [Export("updatedRegistry:")]
        void UpdatedRegistry(int statusCode);
        // @optional -(void)responseFWData:(NSData *)FWData;
        [Export("responseFWData:")]
        void ResponseFWData(NSData FWData);
        // @optional -(void)rfidDataReceived:(NSData *)data;
        [Export("rfidDataReceived:")]
        void RfidDataReceived(NSData data);
        // @optional -(void)responseSetLeakage:(int)status;
        [Export("responseSetLeakage:")]
        void ResponseSetLeakage(int status);
    }
    // @protocol AsreaderBarcodeDeviceDelegate <NSObject>
    [Protocol, Model(AutoGeneratedName = true)]
    [BaseType(typeof(NSObject))]
    interface AsreaderBarcodeDeviceDelegate
    {
        // @optional -(void)barcodeDataReceived:(NSData *)data;
        [Export("barcodeDataReceived:")]
        void BarcodeDataReceived(NSData data);
        // @optional -(void)receiveFactoryReset:(int)status;
        [Export("receiveFactoryReset:")]
        void ReceiveFactoryReset(int status);
        // @optional -(void)ackUserCommandReceived:(NSData *)rawData;
        [Export("ackUserCommandReceived:")]
        void AckUserCommandReceived(NSData rawData);
    }
    // @protocol AsReaderNFCDeviceDelegate <NSObject>
    [Protocol, Model(AutoGeneratedName = true)]
    [BaseType(typeof(NSObject))]
    interface AsReaderNFCDeviceDelegate
    {
        // @optional -(void)nfcDataReceived:(NSData *)data;
        [Export("nfcDataReceived:")]
        void NfcDataReceived(NSData data);
        // @optional -(void)nfcReadMultiBlockReceived:(NSArray *)dataArray statusCode:(SDK4StatusCode)statusCode;
        [Export("nfcReadMultiBlockReceived:statusCode:")]
        void NfcReadMultiBlockReceived(NSObject[] dataArray, SDK4StatusCode statusCode);
        // @optional -(void)nfcWriteSingleBlockStatusCode:(SDK4StatusCode)statusCode;
        [Export("nfcWriteSingleBlockStatusCode:")]
        void NfcWriteSingleBlockStatusCode(SDK4StatusCode statusCode);
        // @optional -(void)nfcWriteBytesStatusCode:(SDK4StatusCode)statusCode;
        [Export("nfcWriteBytesStatusCode:")]
        void NfcWriteBytesStatusCode(SDK4StatusCode statusCode);
    }
    // @protocol AsReaderDeviceDelegate <AsReaderBLEDelegate>
    [Protocol, Model(AutoGeneratedName = true)]
    [BaseType(typeof(AsReaderBLEDelegate))]
    interface AsReaderDeviceDelegate
    {
        // @required -(void)plugged:(BOOL)plug;
        [Abstract]
        [Export("plugged:")]
        void Plugged(bool plug);
        // @required -(void)readerConnected:(int)status;
        [Abstract]
        [Export("readerConnected:")]
        void ReaderConnected(int status);
        // @optional -(void)checkTriggerStatus:(NSString *)strStatus;
        [Export("checkTriggerStatus:")]
        void CheckTriggerStatus(string strStatus);
        // @optional - (void)responsePowerOnOff:(BOOL)isOn HWModeChange:(BOOL)isHWModeChange;
        [Export("responsePowerOnOff:HWModeChange:")]
        void ResponsePowerOnOff(bool isOn, bool isHWModeChange);
        // @optional -(void)releasedTriggerButton;
        [Export("releasedTriggerButton")]
        void ReleasedTriggerButton();
        // @optional -(void)pushedTriggerButton;
        [Export("pushedTriggerButton")]
        void PushedTriggerButton();
        // @optional -(void)onAsReaderTriggerKeyEventStatus:(NSString *)status;
        [Export("onAsReaderTriggerKeyEventStatus:")]
        void OnAsReaderTriggerKeyEventStatus(string status);
        // @optional -(void)receivedScanData:(NSData *)readData;
        [Export("receivedScanData:")]
        void ReceivedScanData(NSData readData);
        // @optional -(void)receivedScanData:(NSData *)readData dataType:(int)dataType;
        [Export("receivedScanData:dataType:")]
        void ReceivedScanData(NSData readData, int dataType);
        // @optional -(void)unknownCommandReceived:(int)commandCode;
        [Export("unknownCommandReceived:")]
        void UnknownCommandReceived(int commandCode);
        // @optional -(void)allDataReceived:(NSData *)data;
        [Export("allDataReceived:")]
        void AllDataReceived(NSData data);
        // @optional -(void)batteryReceived:(int)battery;
        [Export("batteryReceived:")]
        void BatteryReceived(int battery);
        // @optional -(void)stopReadScan:(int)status;
        [Export("stopReadScan:")]
        void StopReadScan(int status);
        // @optional -(void)startedReadScan:(int)status;
        [Export("startedReadScan:")]
        void StartedReadScan(int status);
        // @optional -(void)errorReceived:(NSData *)errorCode;
        [Export("errorReceived:")]
        void ErrorReceived(NSData errorCode);
    }
    // @interface AsReaderDevice : NSObject
    [BaseType(typeof(NSObject))]
    interface AsReaderDevice
    {
        // +(NSString *)getSDKVersion;
        [Static]
        [Export("getSDKVersion")]
        string SDKVersion { get; }
        // +(void)showPrintNSLog:(BOOL)isShow;
        [Static]
        [Export("showPrintNSLog:")]
        void ShowPrintNSLog(bool isShow);
        // +(void)setTriggerModeDefault:(BOOL)isDefault;
        [Static]
        [Export("setTriggerModeDefault:")]
        void SetTriggerModeDefault(bool isDefault);
        // +(void)setReadRSSIMode:(BOOL)isReadRSSIMode;
        [Static]
        [Export("setReadRSSIMode:")]
        void SetReadRSSIMode(bool isReadRSSIMode);
        // -(BOOL)getReaderInformation;
        [Export("getReaderInformation")]
        bool ReaderInformation { get; }
        // -(BOOL)getReaderInfo:(int)infoType;
        [Export("getReaderInfo:")]
        bool GetReaderInfo(int infoType);
        // -(int)getCurrentBattery;
        [Export("getCurrentBattery")]
        int CurrentBattery { get; }
        // -(BOOL)setBeep:(BOOL)beepOn setVibration:(BOOL)vibrationOn setIllumination:(BOOL)illuminationOn setLED:(BOOL) led;
        [Export("setBeep:setVibration:setIllumination:setLED:")]
        bool SetBeep(bool beepOn, bool vibrationOn, bool illuminationOn, bool led);
        // -(int)setReaderPower:(BOOL)isOn beep:(BOOL)isBeep vibration:(BOOL)isVib led:(BOOL)isLed illumination:(BOOL)isIllu mode:(int) nDeviceType;
        [Export("setReaderPower:beep:vibration:led:illumination:mode:")]
        int SetReaderPower(bool isOn, bool isBeep, bool isVib, bool isLed, bool isIllu, int nDeviceType);
        // -(int)setReaderPower:(BOOL)isOn beep:(BOOL)isBeep vibration:(BOOL)isVib led:(BOOL)isLed illumination:(BOOL)isIllu connectedBeep:(BOOL) isConnectedBeep mode:(int) nDeviceType;
        [Export("setReaderPower:beep:vibration:led:illumination:connectedBeep:mode:")]
        int SetReaderPower(bool isOn, bool isBeep, bool isVib, bool isLed, bool isIllu, bool isConnectedBeep, int nDeviceType);
        // -(BOOL)setReaderProgMode:(int)mode;
        [Export("setReaderProgMode:")]
        bool SetReaderProgMode(int mode);
        // -(void)setTagCount:(int)mtnu setScanTime:(int)mtime setCycle:(int)repeatCycle;
        [Export("setTagCount:setScanTime:setCycle:")]
        void SetTagCount(int mtnu, int mtime, int repeatCycle);
        // -(BOOL)setChargingControl:(BOOL)isOn;
        [Export("setChargingControl:")]
        bool SetChargingControl(bool isOn);
        // -(void)setDelayDisconnectOnBackground:(NSTimeInterval)time;
        [Export("setDelayDisconnectOnBackground:")]
        void SetDelayDisconnectOnBackground(double time);
        // -(NSTimeInterval)getDelayDisconnectOnBackground;
        [Export("getDelayDisconnectOnBackground")]
        double DelayDisconnectOnBackground { get; }
        // @property (nonatomic, setter = setDelegateRFID:, weak) id<AsReaderRFIDDeviceDelegate> delegateRFID;
        [Export("delegateRFID", ArgumentSemantic.Weak)]
        AsReaderRFIDDeviceDelegate DelegateRFID { get; [Bind("setDelegateRFID:")] set; }
        // @property (nonatomic, setter = setDelegateBarcode:, weak) id<AsreaderBarcodeDeviceDelegate> delegateBarcode;
        [Export("delegateBarcode", ArgumentSemantic.Weak)]
        AsreaderBarcodeDeviceDelegate DelegateBarcode { get; [Bind("setDelegateBarcode:")] set; }
        // @property (nonatomic, setter = setDelegateNFC:, weak) id<AsReaderNFCDeviceDelegate> delegateNFC;
        [Export("delegateNFC", ArgumentSemantic.Weak)]
        AsReaderNFCDeviceDelegate DelegateNFC { get; [Bind("setDelegateNFC:")] set; }
        // @property (nonatomic, setter = setDelegateDevice:, weak) id<AsReaderDeviceDelegate> delegateDevice;
        [Export("delegateDevice", ArgumentSemantic.Weak)]
        AsReaderDeviceDelegate DelegateDevice { get; [Bind("setDelegateDevice:")] set; }
    }
    // @interface AsReaderBarcodeDevice : AsReaderDevice
    [BaseType(typeof(AsReaderDevice))]
    interface AsReaderBarcodeDevice
    {
        // +(instancetype)sharedInstance;
        [Static]
        [Export("sharedInstance")]
        AsReaderBarcodeDevice SharedInstance();
        // -(BOOL)startScan;
        [Export("startScan")]
        bool StartScan { get; }
        // -(BOOL)stopScan;
        [Export("stopScan")]
        bool StopScan { get; }
        // -(BOOL)doFactoryReset;
        [Export("doFactoryReset")]
        bool DoFactoryReset { get; }
        // -(BOOL)sendBarcodeSettingData:(NSData *)sendData;
        [Export("sendBarcodeSettingData:")]
        bool SendBarcodeSettingData(NSData sendData);
        // -(BOOL)setCustomPrefix:(NSString *)prefix;
        [Export("setCustomPrefix:")]
        bool SetCustomPrefix(string prefix);
        // -(BOOL)setDisableCustomPrefix;
        [Export("setDisableCustomPrefix")]
        bool SetDisableCustomPrefix { get; }
        // -(BOOL)setCustomSuffix:(NSString *)suffix;
        [Export("setCustomSuffix:")]
        bool SetCustomSuffix(string suffix);
        // -(BOOL)setDisableCustomSuffix;
        [Export("setDisableCustomSuffix")]
        bool SetDisableCustomSuffix { get; }
        // -(BOOL)setSymbologyPrefix;
        [Export("setSymbologyPrefix")]
        bool SetSymbologyPrefix { get; }
        // -(BOOL)setDisableSymbologyPrefix;
        [Export("setDisableSymbologyPrefix")]
        bool SetDisableSymbologyPrefix { get; }
        // -(BOOL)setBarcodeEngineUserCommand:(NSString *)command;
        [Export("setBarcodeEngineUserCommand:")]
        bool SetBarcodeEngineUserCommand(string command);
    }
    //@protocol AsReaderProtocol<AsReaderBLEDelegate>
    [Protocol, Model(AutoGeneratedName = true)]
    [BaseType(typeof(NSObject))]
    interface AsReaderBLEDelegate
    {

        // @optional - (void) scanningBleDeive:(CBPeripheral*) device;
        [Export("scanningBleDeive:")]
        void ScanningBleDeive(CBPeripheral device);
        // @optional - (void) scanBleStatus:(BleStatusCode) status;
        [Export("scanBleStatus:")]
        void ScanBleStatus(BleStatusCode status);
    }
    [Protocol, Model(AutoGeneratedName = true)]
    [BaseType(typeof(AsReaderBLEDelegate))]
    interface AsReaderProtocol 
    {
        // @required -(int)receive:(NSData *)data;
        [Abstract]
        [Export("receive:")]
        int Receive(NSData data);
        // @required -(void)plugChangedStatus:(int)status;
        [Abstract]
        [Export("plugChangedStatus:")]
        void PlugChangedStatus(int status);
    }
    // @interface AsReaderBleMgr : NSObject
    [BaseType(typeof(NSObject))]
    interface AsReaderBleMgr
    {
        [Wrap("WeakDelegate")]
        AsReaderProtocol Delegate { get; set; }
        // @property (nonatomic, weak) id<AsReaderProtocol> delegate;
        [NullAllowed, Export("delegate", ArgumentSemantic.Weak)]
        NSObject WeakDelegate { get; set; }
        // -(BOOL)scanBLE;
        [Export("scanBLE")]
        bool ScanBLE { get; }
        // -(BOOL)stopSacnBLE;
        [Export("stopSacnBLE")]
        bool StopSacnBLE { get; }
        // +(instancetype)sharedInstance;
        [Static]
        [Export("sharedInstance")]
        AsReaderBleMgr SharedInstance();
        // -(NSArray *)getPreripheralList;
        [Export("getPreripheralList")]
        NSArray PreripheralList { get; }
        // -(BOOL)open;
        [Export("open")]
        bool Open { get; }
        // -(BOOL)isOpened;
        [Export("isOpened")]
        bool IsOpened { get; }
        // -(void)close;
        [Export("close")]
        void Close();
        // -(BOOL)send:(NSData *)data;
        [Export("send:")]
        bool Send(NSData data);
        // -(BOOL)sendPower:(NSData *)data;
        [Export("sendPower:")]
        bool SendPower(NSData data);
        // -(void)connectBLE:(NSString *)name;
        [Export("connectBLE:")]
        void ConnectBLE(string name);
    }
    // @interface AsReaderInfo : NSObject
    [BaseType(typeof(NSObject))]
    interface AsReaderInfo
    {
        // +(instancetype)sharedInstance;
        [Static]
        [Export("sharedInstance")]
        AsReaderInfo SharedInstance();
        // @property (readonly, nonatomic) NSString * deviceName;
        [Export("deviceName")]
        string DeviceName { get; }
        // @property (readonly, nonatomic) NSString * deviceFirmware;
        [Export("deviceFirmware")]
        string DeviceFirmware { get; }
        // @property (readonly, nonatomic) NSString * deviceHardware;
        [Export("deviceHardware")]
        string DeviceHardware { get; }
        // @property (readonly, nonatomic) NSString * deviceID;
        [Export("deviceID")]
        string DeviceID { get; }
        // @property (readonly, nonatomic) NSString * deviceManufacturer;
        [Export("deviceManufacturer")]
        string DeviceManufacturer { get; }
        // @property (readonly, nonatomic) NSString * deviceModelNumber;
        [Export("deviceModelNumber")]
        string DeviceModelNumber { get; }
        // @property (readonly, nonatomic) NSString * deviceSerialNumber;
        [Export("deviceSerialNumber")]
        string DeviceSerialNumber { get; }
        // @property (readonly, nonatomic) NSString * deviceProtocol;
        [Export("deviceProtocol")]
        string DeviceProtocol { get; }
        // @property (readonly, assign) int currentSelectDevice;
        [Export("currentSelectDevice")]
        int CurrentSelectDevice { get; }
        // @property (readonly, assign) BOOL isPowerOn;
        [Export("isPowerOn")]
        bool IsPowerOn { get; }
        // @property (readonly, assign) BOOL isJacketType;
        [Export("isJacketType")]
        bool IsJacketType { get; }
        // @property (readonly, assign) ReaderMode currentReaderMode;
        [Export("currentReaderMode", ArgumentSemantic.Assign)]
        ReaderMode CurrentReaderMode { get; }
        // @property (assign, nonatomic) ReceiveDataType receiveDataType;
        [Export("receiveDataType", ArgumentSemantic.Assign)]
        ReceiveDataType CurrentReceiveDataType { get; set; }
        // @property (readonly, assign) BOOL isShowPrintNSLog;
        [Export("isShowPrintNSLog")]
        bool IsShowPrintNSLog { get; }
        // @property (readonly, assign) BOOL isBeep;
        [Export("isBeep")]
        bool IsBeep { get; }
        // @property (readonly, assign) BOOL isVibration;
        [Export("isVibration")]
        bool IsVibration { get; }
        // @property (readonly, assign) BOOL isLED;
        [Export("isLED")]
        bool IsLED { get; }
        // @property (readonly, assign) BOOL isIllumination;
        [Export("isIllumination")]
        bool IsIllumination { get; }
        // @property (readonly, assign) BOOL isSymbologyPrefix;
        [Export("isSymbologyPrefix")]
        bool IsSymbologyPrefix { get; }
        // @property (readonly, assign) BOOL isTriggerModeDefault;
        [Export("isTriggerModeDefault")]
        bool IsTriggerModeDefault { get; }
        // @property (readonly, assign) BOOL isReadRSSIMode;
        [Export("isReadRSSIMode")]
        bool IsReadRSSIMode { get; }
        // @property (readonly, assign) float rfidPower;
        [Export("rfidPower")]
        float RfidPower { get; }
        // @property (readonly, assign) float rfidPowerMax;
        [Export("rfidPowerMax")]
        float RfidPowerMax { get; }
        // @property (readonly, assign) float rfidPowerMin;
        [Export("rfidPowerMin")]
        float RfidPowerMin { get; }
        // @property (readonly, assign) int rfidOnTime;
        [Export("rfidOnTime")]
        int RfidOnTime { get; }
        // @property (readonly, assign) int rfidOffTime;
        [Export("rfidOffTime")]
        int RfidOffTime { get; }
        // @property (readonly, assign) int nRFIDchannel;
        [Export("nRFIDchannel")]
        int NRFIDchannel { get; }
        // @property (readonly, assign) int count;
        [Export("count")]
        int Count { get; }
        // @property (readonly, assign) int scanTime;
        [Export("scanTime")]
        int ScanTime { get; }
        // @property (readonly, assign) int cycle;
        [Export("cycle")]
        int Cycle { get; }
        // @property (readonly, assign) int carrierSenseTime;
        [Export("carrierSenseTime")]
        int CarrierSenseTime { get; }
        // @property (readonly, assign) int targetRFPowerLevel;
        [Export("targetRFPowerLevel")]
        int TargetRFPowerLevel { get; }
        // @property (readonly, assign) int rfidListenBeforeTalk;
        [Export("rfidListenBeforeTalk")]
        int RfidListenBeforeTalk { get; }
        // @property (readonly, assign) int rfidFrequencyHopping;
        [Export("rfidFrequencyHopping")]
        int RfidFrequencyHopping { get; }
        // @property (readonly, assign) int rfidContinuousWave;
        [Export("rfidContinuousWave")]
        int RfidContinuousWave { get; }
        // @property (readonly, assign) BOOL isSmartHopping;
        [Export("isSmartHopping")]
        bool IsSmartHopping { get; }
        // @property (readonly, nonatomic) NSString * rfidModuleVersion;
        [Export("rfidModuleVersion")]
        string RfidModuleVersion { get; }
        // @property (readonly, assign) BOOL bDualModeOnAndPreFix;
        [Export("bDualModeOnAndPreFix")]
        bool BDualModeOnAndPreFix { get; }
        // -(BOOL)isSupportType:(SupportType)supportType;
        [Export("isSupportType:")]
        bool IsSupportType(SupportType supportType);
        // -(NSArray *)getSupportTypeArray;
        [Export("getSupportTypeArray")]
        NSArray SupportTypeArray { get; }
    }
    // @interface LFTagParser : NSObject
    [BaseType(typeof(NSObject))]
    interface LFTagParser
    {
        // +(instancetype _Nonnull)sharedInstance;
        [Static]
        [Export("sharedInstance")]
        LFTagParser SharedInstance();
        // -(NSDictionary * _Nonnull)parseDataByProtocolType:(NSData * _Nonnull)data protocolType:(ProtocolTypeLF) protocolType;
        [Export("parseDataByProtocolType:protocolType:")]
        NSDictionary ParseDataByProtocolType(NSData data, ProtocolTypeLF protocolType);
    }
    // @interface AsReaderNFCDevice : AsReaderDevice
    [BaseType(typeof(AsReaderDevice))]
    interface AsReaderNFCDevice
    {
        // +(instancetype)sharedInstance;
        [Static]
        [Export("sharedInstance")]
        AsReaderNFCDevice SharedInstance();
        // -(BOOL)sendData:(NSData *)sendData;
        [Export("sendData:")]
        bool SendData(NSData sendData);
        // -(BOOL)setInventoryTime:(float)inventoryTime;
        [Export("setInventoryTime:")]
        bool SetInventoryTime(float inventoryTime);
        // -(BOOL)startScan;
        [Export("startScan")]
        bool StartScan { get; }
        // -(BOOL)stopScan;
        [Export("stopScan")]
        bool StopScan { get; }
        // -(BOOL)readMultiBlockWithBlockIndex:(int)index count:(int)count;
        [Export("readMultiBlockWithBlockIndex:count:")]
        bool ReadMultiBlockWithBlockIndex(int index, int count);
        // -(BOOL)writeSingleBlockWithBlockIndex:(int)index writeData:(NSData *)writeData uid:(NSData *)uid;
        [Export("writeSingleBlockWithBlockIndex:writeData:uid:")]
        bool WriteSingleBlockWithBlockIndex(int index, NSData writeData, NSData uid);
        // -(BOOL)writeBytesWithBlockIndex:(int)index writeData:(NSData *)writeData uid:(NSData *)uid;
        [Export("writeBytesWithBlockIndex:writeData:uid:")]
        bool WriteBytesWithBlockIndex(int index, NSData writeData, NSData uid);
    }
    // @interface AsReaderRFIDDevice : AsReaderDevice
    [BaseType(typeof(AsReaderDevice))]
    interface AsReaderRFIDDevice
    {
        // +(instancetype)sharedInstance;
        [Static]
        [Export("sharedInstance")]
        AsReaderRFIDDevice SharedInstance();
        // -(BOOL)startScan:(int)mtnu mtime:(int)mtime repeatCycle:(int)repeatCycle;
        [Export("startScan:mtime:repeatCycle:")]
        bool StartScan(int mtnu, int mtime, int repeatCycle);
        // -(BOOL)stopScan;
        [Export("stopScan")]
        bool StopScan { get; }
        // -(BOOL)startReadTagsAndRssiWithTagNum:(int)maxTags maxTime:(int)maxTime repeatCycle:(int)repeatCycle;
        [Export("startReadTagsAndRssiWithTagNum:maxTime:repeatCycle:")]
        bool StartReadTagsAndRssiWithTagNum(int maxTags, int maxTime, int repeatCycle);
        // -(BOOL)startReadTagAndTidWithTagNum:(int)maxTags maxTime:(int)maxTime repeatCycle:(int)repeatCycle;
        [Export("startReadTagAndTidWithTagNum:maxTime:repeatCycle:")]
        bool StartReadTagAndTidWithTagNum(int maxTags, int maxTime, int repeatCycle);
        // -(BOOL)startReadTagsRFM:(int)codeType maxTags:(int)maxTags maxTime:(int)maxTime repeatCycle:(int)repeatCycle;
        [Export("startReadTagsRFM:maxTags:maxTime:repeatCycle:")]
        bool StartReadTagsRFM(int codeType, int maxTags, int maxTime, int repeatCycle);
        // -(BOOL)getSelectParameter;
        [Export("getSelectParameter")]
        bool SelectParameter { get; }
        // -(BOOL)setSelectParameter:(int)target action:(int)action memoryBank:(int)memoryBank pointer:(int)pointer length:(int)length truncate:(int) truncate mask:(NSData*) mask;
        [Export("setSelectParameter:action:memoryBank:pointer:length:truncate:mask:")]
        bool SetSelectParameter(int target, int action, int memoryBank, int pointer, int length, int truncate, NSData mask);
        // -(BOOL)getChannel;
        [Export("getChannel")]
        bool Channel { get; }
        // -(BOOL)setReadTime:(int)ReadTime idleTime:(int)IdleTime;
        [Export("setReadTime:idleTime:")]
        bool SetReadTime(int ReadTime, int IdleTime);
        // -(BOOL)setChannel:(int)channel channelOffset:(int)channelOffset;
        [Export("setChannel:channelOffset:")]
        bool SetChannel(int channel, int channelOffset);
        // -(BOOL)getFhLbtParameter;
        [Export("getFhLbtParameter")]
        bool FhLbtParameter { get; }
        // -(BOOL)setFhLbtParameter:(int)ReadTime idleTime:(int)IdleTime carrierSenseTime:(int)carrierSenseTime targetRFPowerLevel:(int) targetRFPowerLevel frequencyHopping:(int) frequencyHopping listenBeforeTalk:(int)listenBeforeTalk continuousWave:(int) continuousWave;
        [Export("setFhLbtParameter:idleTime:carrierSenseTime:targetRFPowerLevel:frequencyHopping:listenBeforeTalk:continuousWave:")]
        bool SetFhLbtParameter(int ReadTime, int IdleTime, int carrierSenseTime, int targetRFPowerLevel, int frequencyHopping, int listenBeforeTalk, int continuousWave);
        // -(BOOL)getOutputPowerLevel;
        [Export("getOutputPowerLevel")]
        bool OutputPowerLevel { get; }
        // -(BOOL)setOutputPowerLevel:(int)powerLevel;
        [Export("setOutputPowerLevel:")]
        bool SetOutputPowerLevel(int powerLevel);
        // -(BOOL)writeTagMemoryWithAccessPassword:(int)accessPassword epc:(NSData *)epc memoryBank:(int)memoryBank startAddress:(int) startAddress dataToWrite:(NSData*) dataToWrite;
        [Export("writeTagMemoryWithAccessPassword:epc:memoryBank:startAddress:dataToWrite:")]
        bool WriteTagMemoryWithAccessPassword(int accessPassword, NSData epc, int memoryBank, int startAddress, NSData dataToWrite);
        // -(BOOL)killTagWithPassword:(int)password epc:(NSData *)epc;
        [Export("killTagWithPassword:epc:")]
        bool KillTagWithPassword(int password, NSData epc);
        // -(BOOL)lockTagMemoryWithAccessPassword:(int)accessPassword epc:(NSData *)epc lockData:(int)lockData;
        [Export("lockTagMemoryWithAccessPassword:epc:lockData:")]
        bool LockTagMemoryWithAccessPassword(int accessPassword, NSData epc, int lockData);
        // -(BOOL)getFrequencyHoppingTable;
        [Export("getFrequencyHoppingTable")]
        bool FrequencyHoppingTable { get; }
        // -(BOOL)setFrequencyHoppingTableSize:(int)tableSize channels:(NSData *)channels;
        [Export("setFrequencyHoppingTableSize:channels:")]
        bool SetFrequencyHoppingTableSize(int tableSize, NSData channels);
        // -(BOOL)getRssi;
        [Export("getRssi")]
        bool Rssi { get; }
        // -(BOOL)getSession;
        [Export("getSession")]
        bool Session { get; }
        // -(BOOL)setSession:(int)session;
        [Export("setSession:")]
        bool SetSession(int session);
        // -(BOOL)getAnticollision;
        [Export("getAnticollision")]
        bool Anticollision { get; }
        // -(BOOL)setAnticollision:(int)mode Counter:(int)counter;
        [Export("setAnticollision:Counter:")]
        bool SetAnticollision(int mode, int counter);
        // -(BOOL)updateRegistry;
        [Export("updateRegistry")]
        bool UpdateRegistry { get; }
        // -(BOOL)setStopTagNum:(int)maxTags maxTime:(int)maxTime repeatCycle:(int)repeatCycle;
        [Export("setStopTagNum:maxTime:repeatCycle:")]
        bool SetStopTagNum(int maxTags, int maxTime, int repeatCycle);
        // -(BOOL)getRFIDModuleVersion;
        [Export("getRFIDModuleVersion")]
        bool RFIDModuleVersion { get; }
        // -(BOOL)setHoppingOnOff:(BOOL)isOn;
        [Export("setHoppingOnOff:")]
        bool SetHoppingOnOff(bool isOn);
        // -(BOOL)writeTagMemoryWithEPC:(NSData *)epc dataToWriteAscii:(NSString *)dataToWrite;
        [Export("writeTagMemoryWithEPC:dataToWriteAscii:")]
        bool WriteTagMemoryWithEPC(NSData epc, string dataToWrite);
        // -(BOOL)setRSSIThreshold:(uint16_t)threshold;
        [Export("setRSSIThreshold:")]
        bool SetRSSIThreshold(int threshold);
        // -(BOOL)getRSSIThreshold;
        [Export("getRSSIThreshold")]
        bool RSSIThreshold { get; }
        // -(BOOL)getQueryParameter;
        [Export("getQueryParameter")]
        bool QueryParameter { get; }
        // -(BOOL)setReaderProgMode:(int)mode;
        [Export("setReaderProgMode:")]
        bool SetReaderProgMode(int mode);
        // -(BOOL)readTagWithAccessPassword:(int)accessPassword epc:(NSData *)epc memoryBank:(int)memoryBank startAddress:(int) startAddress dataLength:(int) dataLength;
        [Export("readTagWithAccessPassword:epc:memoryBank:startAddress:dataLength:")]
        bool ReadTagWithAccessPassword(int accessPassword, NSData epc, int memoryBank, int startAddress, int dataLength);
        // -(BOOL)setQueryParam:(int)divideRatio m:(int)m trext:(int)trext selection:(int)selection session:(int)session target:(int) target qValue:(int) qValue;
        [Export("setQueryParam:m:trext:selection:session:target:qValue:")]
        bool SetQueryParam(int divideRatio, int m, int trext, int selection, int session, int target, int qValue);
        // -(BOOL)setRfCw:(BOOL)on;
        [Export("setRfCw:")]
        bool SetRfCw(bool on);
        // -(BOOL)getModulation;
        [Export("getModulation")]
        bool Modulation { get; }
        //- (BOOL)setModulationBLF:(int)blf rxMod:(int)rxMod dr:(int)dr;
        [Export("setModulationBLF:rxMod:dr:")]
        bool SetModulationBLF(int blf, int rxMod, int dr);
        // -(BOOL)blockEraseTagMemoryWithAccessPassword:(int)accessPassword epc:(NSData *)epc memoryBank:(int) memoryBank startAddress:(int) startAddress dataLength:(int) dataLength;
        [Export("blockEraseTagMemoryWithAccessPassword:epc:memoryBank:startAddress:dataLength:")]
        bool BlockEraseTagMemoryWithAccessPassword(int accessPassword, NSData epc, int memoryBank, int startAddress, int dataLength);
        // -(BOOL)genericTransportWithAccessPassword:(int)accessPassword epc:(NSData *)epc transmissionState:(int) transmissionState rm:(int) rm size:(int) size genericCommand:(NSData*) genericCommand;
        [Export("genericTransportWithAccessPassword:epc:transmissionState:rm:size:genericCommand:")]
        bool GenericTransportWithAccessPassword(int accessPassword, NSData epc, int transmissionState, int rm, int size, NSData genericCommand);
        // -(BOOL)getTemperature;
        [Export("getTemperature")]
        bool Temperature { get; }
        // -(BOOL)getRegistryItem:(int)registryItem;
        [Export("getRegistryItem:")]
        bool GetRegistryItem(int registryItem);
        // -(BOOL)setOptimumFrequencyHoppingTable;
        [Export("setOptimumFrequencyHoppingTable")]
        bool SetOptimumFrequencyHoppingTable { get; }
        // -(BOOL)setFrequencyHoppingMode:(int)mode;
        [Export("setFrequencyHoppingMode:")]
        bool SetFrequencyHoppingMode(int mode);
        // -(BOOL)getFrequencyHoppingMode;
        [Export("getFrequencyHoppingMode")]
        bool FrequencyHoppingMode { get; }
        // -(BOOL)getStopCondition;
        [Export("getStopCondition")]
        bool StopCondition { get; }
        // -(BOOL)setSmartHoppingOnOff:(BOOL)isOn;
        [Export("setSmartHoppingOnOff:")]
        bool SetSmartHoppingOnOff(bool isOn);
        // -(BOOL)getRegion;
        [Export("getRegion")]
        bool Region { get; }
        // -(int)setTriggerMode:(BOOL)isDefault;
        [Export("setTriggerMode:")]
        int SetTriggerMode(bool isDefault);
    } 
}