﻿using AsReaderBLESDK.IOS;
using AsReaderSDK4.IOS;
using Foundation;
using CoreBluetooth;
using Microsoft.Maui.Controls;
using static AVFoundation.AVMetadataIdentifiers;
using static ObjCRuntime.Dlfcn;

namespace AsReaderSDK4MAUIDemo.Platforms.iOS
{
    public enum SelectSegment : uint
    {
        SelectSegmentBarcode,
        SelectSegmentRFID,
        SelectSegmentNFC,
        SelectSegmentDual,
        SelectSegmentRFIDLF
    }
    public enum SelectType : uint
    {
        SelectTypeUSB,
        SelectTypeBLE
    }
    public class AsReaderDockManager
    {
        public static NSString Key_FDBX_NationalCode = new NSString("Key_FDBX_NationalCode");
        public static NSString Key_FDBX_CountryCode = new NSString("Key_FDBX_CountryCode");
        public static NSString Key_FDBX_StatusFlag = new NSString("Key_FDBX_StatusFlag");
        public static NSString Key_FDBX_AnimalIndicator = new NSString("Key_FDBX_AnimalIndicator");
        public static NSString Key_FDBX_Reserved = new NSString("Key_FDBX_Reserved");
        
        public class AsReaderDockManagerDeviceDelegate : AsReaderDeviceDelegate
        {
            AsReaderDockManagerDelegate asReaderDockManagerDelegate = AsReaderDockManagerDelegate.sharedInstance();
            [Export("plugged:")]
            public override void Plugged(bool plug)
            {
                if (asReaderDockManagerDelegate.Plugged != null)
                    asReaderDockManagerDelegate.Plugged(plug);
            }
            [Export("readerConnected:")]
            public override void ReaderConnected(int status)
            {
                if (asReaderDockManagerDelegate.ReaderConnected != null)
                    asReaderDockManagerDelegate.ReaderConnected(status);
            }
            [Export("batteryReceived:")]
            public override void BatteryReceived(int battery)
            {
                if (asReaderDockManagerDelegate.BatteryReceived != null)
                    asReaderDockManagerDelegate.BatteryReceived(battery);
            }
            [Export("errorReceived:")]
            public override void ErrorReceived(NSData errorCode)
            {
                if (asReaderDockManagerDelegate.ErrorReceived != null)
                    asReaderDockManagerDelegate.ErrorReceived(errorCode);
            }
            [Export("responsePowerOnOff:HWModeChange:")]
            public override void ResponsePowerOnOff(bool isOn, bool isHWModeChange)
            {
                if (asReaderDockManagerDelegate.ResponsePowerOnOff != null)
                    asReaderDockManagerDelegate.ResponsePowerOnOff(isOn, isHWModeChange);
            }
            [Export("pushedTriggerButton")]
            public override void PushedTriggerButton()
            {
                if (asReaderDockManagerDelegate.PushedTriggerButton != null)
                    asReaderDockManagerDelegate.PushedTriggerButton();
            }
            [Export("releasedTriggerButton")]
            public override void ReleasedTriggerButton()
            {
                if (asReaderDockManagerDelegate.ReleasedTriggerButton != null)
                    asReaderDockManagerDelegate.ReleasedTriggerButton();
            }
            [Export("checkTriggerStatus:")]
            public override void CheckTriggerStatus(string strStatus)
            {
                if (asReaderDockManagerDelegate.CheckTriggerStatus != null)
                    asReaderDockManagerDelegate.CheckTriggerStatus(strStatus);
            }
            [Export("receivedScanData:")]
            public override void ReceivedScanData(NSData readData)
            {
                if (asReaderDockManagerDelegate.ReceivedScanData != null)
                    asReaderDockManagerDelegate.ReceivedScanData(readData);
            }
            [Export("scanningBleDeive:")]
            public override void ScanningBleDeive(CBPeripheral device)
            {
                if (asReaderDockManagerDelegate.ScanningBleDeive != null)
                    asReaderDockManagerDelegate.ScanningBleDeive(device);
            }
            [Export("scanBleStatus:")]
            public override void ScanBleStatus(BleStatusCodes status)
            {
                if (asReaderDockManagerDelegate.ScanBleStatus != null)
                    asReaderDockManagerDelegate.ScanBleStatus(status);
            }
        }
        public class AsReaderDockManagerRFIDDelegate : AsReaderRFIDDeviceDelegate
        {
            AsReaderDockManagerDelegate asReaderDockManagerDelegate = AsReaderDockManagerDelegate.sharedInstance();
            [Export("pcEpcRssiReceived:rssi:")]
            public override void PcEpcRssiReceived(NSData pcEpc, int rssi)
            {
                if (asReaderDockManagerDelegate.PcEpcRssiReceived != null)
                    asReaderDockManagerDelegate.PcEpcRssiReceived(pcEpc, rssi);
            }
            [Export("regionReceived:")]
            public override void RegionReceived(int region)
            {
                if(asReaderDockManagerDelegate.RegionReceived != null)
                    asReaderDockManagerDelegate.RegionReceived(region);
            }
            [Export("rfidModuleVersionReceived")]
            public override void RfidModuleVersionReceived()
            {
                if (asReaderDockManagerDelegate.RfidModuleVersionReceived != null)
                    asReaderDockManagerDelegate.RfidModuleVersionReceived();
            }
        }
        public class AsReaderDockManagerBarcodeDelegate : AsreaderBarcodeDeviceDelegate
        {
            [Export("barcodeDataReceived:")]
            public override void BarcodeDataReceived(NSData data)
            {

            }
        }
        public class AsReaderDockManagerNFCDelegate : AsReaderNFCDeviceDelegate
        {
            [Export("nfcDataReceived:")]
            public override void NfcDataReceived(NSData data)
            {

            }
        }
        static AsReaderDockManager uniqueInstance;
        static readonly object locker = new object();
        public static AsReaderDockManager sharedInstance()
        {
            if (uniqueInstance == null)
            {
                lock (locker)
                {
                    if (uniqueInstance == null)
                    {
                        uniqueInstance = new AsReaderDockManager();
                    }
                }
            }
            return uniqueInstance;
        }
        public AsReaderDockManager()
        {
            AsReaderDevice readerDevice = AsReaderRFIDDevice.SharedInstance();
            readerDevice.DelegateDevice = new AsReaderDockManagerDeviceDelegate();

            AsReaderRFIDDevice asReaderRFIDDevice = AsReaderRFIDDevice.SharedInstance();
            asReaderRFIDDevice.DelegateRFID = new AsReaderDockManagerRFIDDelegate();

            AsReaderBarcodeDevice asReaderBarcodeDevice = AsReaderBarcodeDevice.SharedInstance();
            asReaderBarcodeDevice.DelegateBarcode = new AsReaderDockManagerBarcodeDelegate();

            AsReaderNFCDevice asReaderNFCDevice = AsReaderNFCDevice.SharedInstance();
            asReaderNFCDevice.DelegateNFC = new AsReaderDockManagerNFCDelegate();
        }
        public void setPower(bool isOn, SelectSegment mode)
        {
            AsReaderDevice device = AsReaderRFIDDevice.SharedInstance();
            string beep = Preferences.Get("beep", "true");
            bool beepStatus;
            if (beep == "true")
            {
                beepStatus = true;
            }
            else
            {
                beepStatus = false;
            }
            string vibration = Preferences.Get("vibration", "true");
            bool vibrationStatus;
            if (vibration == "true")
            {
                vibrationStatus = true;
            }
            else
            {
                vibrationStatus = false;
            }

            AsReaderInfo asReaderInfo = AsReaderInfo.SharedInstance();
            if (asReaderInfo.IsEnginePowerAlwaysOn)
            {
                device.SetBeep(beepStatus, vibrationStatus, true, true, true);
            }
            else
            {
                device.SetReaderPowerWithPowerOnBeep(isOn, beepStatus, vibrationStatus, true, true, true, (int)mode);
            }
        }
        public void read(SelectSegment mode)
        {
            int tagCount = AsReaderInfo.SharedInstance().Count;
            int scanTime = AsReaderInfo.SharedInstance().ScanTime;
            int cycle = AsReaderInfo.SharedInstance().Cycle;
            switch (mode)
            {
                case SelectSegment.SelectSegmentBarcode:
                    _ = AsReaderBarcodeDevice.SharedInstance().StartScan;
                    break;
                case SelectSegment.SelectSegmentNFC:
                    _ = AsReaderNFCDevice.SharedInstance().StartScan;
                    break;
                case SelectSegment.SelectSegmentDual:
                    _ = AsReaderBarcodeDevice.SharedInstance().StartScan;
                    AsReaderRFIDDevice.SharedInstance().StartScan(tagCount, scanTime, cycle);
                    break;
                case SelectSegment.SelectSegmentRFID:
                case SelectSegment.SelectSegmentRFIDLF:
                    AsReaderRFIDDevice.SharedInstance().StartScan(tagCount, scanTime, cycle);
                    break;
                default:
                    break;
            }
        }
        public void stop(SelectSegment mode)
        {
            switch (mode)
            {
                case SelectSegment.SelectSegmentBarcode:
                    _ = AsReaderBarcodeDevice.SharedInstance().StopScan;
                    break;
                case SelectSegment.SelectSegmentNFC:
                    _ = AsReaderNFCDevice.SharedInstance().StopScan;
                    break;
                case SelectSegment.SelectSegmentDual:
                    _ = AsReaderBarcodeDevice.SharedInstance().StopScan;
                    _ = AsReaderRFIDDevice.SharedInstance().StopScan;
                    break;
                case SelectSegment.SelectSegmentRFID:
                case SelectSegment.SelectSegmentRFIDLF:
                    _ = AsReaderRFIDDevice.SharedInstance().StopScan;
                    break;
                default:
                    break;
            }
        }
        public bool isPowerOn()
        {
            return AsReaderInfo.SharedInstance().IsPowerOn;
        }
        public string deviceName()
        {
            return AsReaderInfo.SharedInstance().DeviceName;
        }
        public bool supportTypeBarcode()
        {
            bool sta = AsReaderInfo.SharedInstance().IsSupportType((int)SupportType.Barcode);
            return sta;
        }
        public bool supportTypeRFID()
        {
            bool sta = AsReaderInfo.SharedInstance().IsSupportType((int)SupportType.Rfid);
            return sta;
        }
        public bool supportTypeNFC()
        {
            bool sta = AsReaderInfo.SharedInstance().IsSupportType((int)SupportType.Nfc);
            return sta;
        }
        public bool supportTypeDual()
        {
            bool sta = AsReaderInfo.SharedInstance().IsSupportType((int)SupportType.Dual);
            return sta;
        }
        public bool supportTypeRFIDLF()
        {
            bool sta = AsReaderInfo.SharedInstance().IsSupportType((int)SupportType.Rfidlf);
            return sta;
        }
        public ReaderMode currentReaderMode()
        {
            return AsReaderInfo.SharedInstance().CurrentReaderMode;
        }
        public ReaderMode receiveDataType()
        {
            return AsReaderInfo.SharedInstance().ReceiveDataType;
        }
        public SupportType getSupportType()
        {
            NSArray supportTypeArray = AsReaderInfo.SharedInstance().SupportTypeArray;
            if (supportTypeArray.Count > 0)
            {
                NSNumber number = supportTypeArray.GetItem<NSNumber>(0);
                int prevMode = number.Int16Value;
                SupportType supportType = (SupportType)prevMode;
                return supportType;
            }
            return SupportType.None;
        }
        public void setBeepAndVibration(bool beep, bool vibration)
        {
            AsReaderInfo asReaderInfo = AsReaderInfo.SharedInstance();
            if (asReaderInfo.IsEnginePowerAlwaysOn)
            {
                AsReaderRFIDDevice.SharedInstance().SetBeep(beep, vibration, true, true, true);
            }
            else
            {
                AsReaderRFIDDevice.SharedInstance().SetBeep(beep, vibration, true, true);
            }
        }
        public void setConnectionType(SelectType type)
        {
            if (type == SelectType.SelectTypeUSB) {
                AsReaderRFIDDevice.SharedInstance().CurrentConnectionType = ConnectionType.Usb;
            } else
            {
                AsReaderRFIDDevice.SharedInstance().CurrentConnectionType = ConnectionType.Ble;
            }
        }
        public bool isOpened()
        {
           return AsReaderRFIDDevice.SharedInstance().IsOpened();
        }
        public void startBleScan()
        {
            AsReaderRFIDDevice.SharedInstance().StartBleScan();
        }
        public void connectBle(CBPeripheral device)
        {
            AsReaderRFIDDevice.SharedInstance().ConnectBLE(device);
        }
        public void disConnectBle()
        {
            AsReaderRFIDDevice.SharedInstance().DisConnectBLE();
        }
        public string getAsReaderDockSDK4SDKVersion()
        {
            return AsReaderDevice.SDKVersion;
        }
        public string getAsReaderDockSDK4Model()
        {
            return AsReaderInfo.SharedInstance().DeviceModelNumber;
        }
        public string getAsReaderDockSDK4HWVVersion()
        {
            return AsReaderInfo.SharedInstance().DeviceHardware;
        }
        public string getAsReaderDockSDK4FWVVersion()
        {
            return AsReaderInfo.SharedInstance().DeviceFirmware;
        }
        public bool getAsReaderDockSDK4Region()
        {
            return AsReaderRFIDDevice.SharedInstance().Region;
        }
        public bool getAsReaderDockSDK4RFIDModule()
        {
            return AsReaderRFIDDevice.SharedInstance().RFIDModuleVersion;
        }
        public string getAsReaderDockSDK4RFIDModuleVersion()
        {
            return AsReaderInfo.SharedInstance().RfidModuleVersion;
        }
        public string getAsReaderDockSDK4DLLVersion()
        {
            return AsReaderSDK4DLL.DLLVersion();
        }
        public string getAsReaderBLESDKDLLVersion()
        {
            return AsReaderBLESDKDLL.DLLVersion();
        }
        public void setTriggerMode(bool status)
        {
            AsReaderRFIDDevice.SharedInstance().SetTriggerMode(status);
        }
        public bool getIs025S()
        {
            AsReaderInfo asReaderInfo = AsReaderInfo.SharedInstance();
            if (asReaderInfo.DeviceName.Contains("025S"))
            {
                return true;
            }
            else
            {
                return false;
            }
        }
        public bool getIsM30S()
        {
            AsReaderInfo asReaderInfo = AsReaderInfo.SharedInstance();
            if (asReaderInfo.DeviceName.Contains("M30S"))
            {
                return true;
            }
            else
            {
                return false;
            }
        }
        public void setM30SContinuousMode(bool isContinuousMode)
        {
            AsReaderRFIDDevice.SharedInstance().SetContinuousMode(isContinuousMode);
        }
        public int getBattery()
        {
            AsReaderDevice device = AsReaderRFIDDevice.SharedInstance();
            return device.CurrentBattery;
        }
    }
}

