﻿using AsReaderSDK4MAUIDemo.Platforms.iOS;

namespace AsReaderSDK4MAUIDemo;

public partial class DetailPage : ContentPage
{
    private string _receivedString;
    private AsReaderDockManager asReaderDockManager;
    private AsReaderDockManagerDelegate asReaderDockManagerDelegate;
    public DetailPage(string param)
    {
        InitializeComponent();
        Title = "Detail";
        asReaderDockManager = AsReaderDockManager.sharedInstance();
        asReaderDockManagerDelegate = AsReaderDockManagerDelegate.sharedInstance();
        _receivedString = param;
    }
    protected override void OnAppearing()
    {
        base.OnAppearing();
        asReaderDockManagerDelegate.Plugged = (plug) =>
        {
            Plugged(plug);
        };
        detailLabel.Text = _receivedString;
    }
    private void Plugged(bool plug)
    {
        MainThread.BeginInvokeOnMainThread(() =>
        {
            if (!plug)
            {
                Navigation.PopToRootAsync();
            }
        });
    }
    protected override void OnDisappearing()
    {
        base.OnDisappearing();
        asReaderDockManagerDelegate.Plugged = null;
    }
}
