
//
//  AsReaderDockSDK.h
//  AsReaderDockSDK
//
//  @brief  The AsReaderDockSDK.h file is the main header file for the AsReaderDockSDK framework. It serves as the entry point for integrating the AsReader Dock SDK into an iOS project. This file imports the necessary headers that provide the functionality to interact with various types of devices, such as NFC, RFID, barcode readers, and LF readers, using the SDK.
//
//  Created by Y.Oshiro on 2021/06/09.
//  Copyright © 2021. Asterisk.Inc All rights reserved.
//

#import <Foundation/Foundation.h>
#import "AsReaderInfo.h"
#import "LFTagParser.h"
#import "AsReaderCommonDevice.h"
#import "AsReaderNFCDevice.h"
#import "AsReaderRFIDDevice.h"
#import "AsReaderBarcodeDevice.h"
#import "AsReaderLfDevice.h"
#import "AsReaderNFCProtocol.h"
#import "AsReaderRFIDProtocol.h"
#import "AsReaderLfProtocol.h"
#import "AsReaderDeviceProtocol.h"
#import "AsReaderBarcodeProtocol.h"
#import "BarcodeZebraSsiEnum.h"
#import "BarcodeZebraSsiParam.h"
#import "BarcodeZebraHelper.h"

//! Project version number for AsReaderDockSDK.
FOUNDATION_EXPORT double AsReaderDockSDK_VersionNumber;

//! Project version string for AsReaderDockSDK.
FOUNDATION_EXPORT const unsigned char AsReaderDockSDK_VersionString[];

// In this header, you should import all the public headers of your framework using statements like #import <AsReaderDockSDK/PublicHeader.h>


