// This file has been autogenerated from a class added in the UI designer.

using System;
using AsReaderDock4;
using Foundation;
using UIKit;

namespace AsReaderDock_VS
{
	public partial class AboutController : UITableViewController
	{
        ModelSettings m_Model = ModelSettings.sharedInstance();
        AsReaderDockManager dockManager = AsReaderDockManager.sharedInstance();
        
		public AboutController (IntPtr handle) : base (handle)
		{
		}

        public override void ViewWillAppear(bool animated)
        {
            base.ViewWillAppear(animated);
            olAppVersion.Text = AsReaderRFIDDevice.SDKVersion;
            updateControl();
            olAppInfo.Text = appNameAndVersionNumberDisplayString();

            dockManager.batteryReceived = BatteryReceived;
            dockManager.regionReceived = RegionReceived;
            dockManager.rfidModuleVersionReceived = RfidModuleVersionReceived;
            if (AsReaderInfo.SharedInstance().IsSupportType(SupportType.Rfid))
            {
                bool finish = dockManager.rfidDevice.Region;
                PerformSelector(new ObjCRuntime.Selector("onTick"), null, 0.5f);
            }
        }

        void RegionReceived(int region)
        {
            string strBand = "";
            switch (region)
            {
                case GlobalDefine.REGION_KOREA_OLD:
                case GlobalDefine.REGION_KOREA:
                    strBand = "KOREA";
                    break;
                case GlobalDefine.REGION_USA_OLD:
                    strBand = "US(OLD Type)";
                    break;
                case GlobalDefine.REGION_USA:
                    strBand = "US1(North)";
                    break;
                case GlobalDefine.REGION_USA2:
                    strBand = "US2";
                    break;
                case GlobalDefine.REGION_EUROPE_OLD:
                case GlobalDefine.REGION_EUROPE:
                    strBand = "EU";
                    break;
                case GlobalDefine.REGION_JAPAN_OLD:
                case GlobalDefine.REGION_JAPAN:
                    strBand = "JAPAN";
                    break;
                case GlobalDefine.REGION_CHINA2_OLD:
                case GlobalDefine.REGION_CHINA1_OLD:
                case GlobalDefine.REGION_CHINA1:
                case GlobalDefine.REGION_CHINA2:
                    strBand = "CHINA";
                    break;
                case GlobalDefine.REGION_AU_HK:
                    strBand = "ASIA";
                    break;
                default:
                    strBand = "Unkown";
                    break;
            }

            olRegion.Text = strBand;
        }
        void RfidModuleVersionReceived()
        {
            AsReaderInfo info = (AsReaderInfo)AsReaderInfo.SharedInstance();
            olRFODModule.Text = info.RfidModuleVersion;
        }

        void BatteryReceived(int battery)
        {
            olBattery.Text = battery.ToString() + "%";
        }

        void updateControl()
        {
            AsReaderInfo info = (AsReaderInfo)AsReaderInfo.SharedInstance();
            olHWV.Text = info.DeviceHardware;
            olFWV.Text = info.DeviceFirmware;
            olModel.Text = info.DeviceModelNumber;
        }

        public override void DidReceiveMemoryWarning()
        {
            base.DidReceiveMemoryWarning();
        }

        [Export("onTick")]         void onTick()
        {
            bool finish = dockManager.rfidDevice.RFIDModuleVersion;
        }

        string appNameAndVersionNumberDisplayString()
        {
            NSDictionary infoDictionary = NSBundle.MainBundle.InfoDictionary;
            string majorVersion = infoDictionary.ObjectForKey(new NSString("CFBundleShortVersionString")).ToString();
            string minorVersion = infoDictionary.ObjectForKey(new NSString("CFBundleVersion")).ToString();
            return "major :" + majorVersion + "(" + minorVersion + ")";
        }
	}
}
