// This file has been autogenerated from a class added in the UI designer.

using System;
using AsReaderDock4;
using Foundation;
using UIKit;

namespace AsReaderDock_VS
{
	public partial class AntiColViewController : UIViewController
	{
        string[] modeList = { "MODE 0", "MODE 1", "MODE 2", "MODE 3", "MODE 4", "MODE 5", "MODE 6" };
        int selectedMode = ModelSettings.sharedInstance().m_RFIDDeviceInfo.m_nAntiMode;

        AsReaderDockManager dockManager = AsReaderDockManager.sharedInstance();
        
		public AntiColViewController (IntPtr handle) : base (handle)
		{
		}
        public override void ViewDidLoad()
        {
            base.ViewDidLoad();
            myTableView.Delegate = new MyTableViewDelegate(this);
            myTableView.DataSource = new MyTableViewSource(this);
        }
        public override void ViewWillAppear(bool animated)
        {
            base.ViewWillAppear(animated);
            dockManager.didSetAntiCollision = DidSetAntiCollision;
        }
        public override void ViewWillDisappear(bool animated)
        {
            base.ViewWillDisappear(animated);
            dockManager.didSetAntiCollision = null;
        }
        public override void DidReceiveMemoryWarning()
        {
            base.DidReceiveMemoryWarning();
        }
        partial void done(UIButton sender)
        {
            int nDefultCounter = 1;
            bool success = dockManager.rfidDevice.SetAnticollision(selectedMode, nDefultCounter);
            if (!success)
            {
                Utils.ShowAlert("", "Error", this);
            }
        }
        void DidSetAntiCollision(int status)
        {
            if (status == 0)
            {
                Utils.ShowAlert("", "Anti-Collision Updated.", this);
            }
        }
        class MyTableViewDelegate : UITableViewDelegate
        {
            AntiColViewController currentViewContorller;
            public MyTableViewDelegate(AntiColViewController controller)
            {
                currentViewContorller = controller;
            }

            public override void RowSelected(UITableView tableView, NSIndexPath indexPath)
            {
                currentViewContorller.selectedMode = indexPath.Row;
                tableView.ReloadData();
            }
        }

        class MyTableViewSource : UITableViewDataSource
        {
            AntiColViewController currentViewContorller;
            public MyTableViewSource(AntiColViewController controller)
            {
                currentViewContorller = controller;
            }

            public override nint NumberOfSections(UITableView tableView)
            {
                return 1;
            }

            public override nint RowsInSection(UITableView tableView, nint section)
            {
                AsReaderInfo info = (AsReaderInfo)AsReaderInfo.SharedInstance();
                if (info.DeviceModelNumber == "ASX-300R") return 7;
                return 5;
            }

            public override UITableViewCell GetCell(UITableView tableView, NSIndexPath indexPath)
            {
                UITableViewCell cell = tableView.DequeueReusableCell("Cell", indexPath);
                cell.TextLabel.Text = currentViewContorller.modeList[indexPath.Row];
                if (currentViewContorller.selectedMode == indexPath.Row)
                {
                    cell.Accessory = UITableViewCellAccessory.Checkmark;
                }
                else
                {
                    cell.Accessory = UITableViewCellAccessory.None;
                }
                return cell;
            }
        }
	}
}
