// This file has been autogenerated from a class added in the UI designer.

using System;
using Foundation;
using UIKit;
using AsReaderDock4;
using System.Runtime.InteropServices;

namespace AsReaderDock_VS
{

    public enum SelectSegment : int
    {
        SelectSegmentBarcode = 0,
        SelectSegmentRFID,
        SelectSegmentNFC,
        SelectSegmentDual,
        SelectSegmentRFIDLF
    }
    public enum DataType : int
    {
        DataTypeBarcode = 0,
        DataTypeRFID,
        DataTypeNFC
    }

    public partial class AreteRfidViewController : UIViewController
    {
        public int mBatteryVal;
        public bool mbIsCahrging;

        TagViewController tagViewController;
        SettingsController settingsController;

        public ModelSettings m_Model = ModelSettings.sharedInstance();

        AsReaderDockManager dockManager = AsReaderDockManager.sharedInstance();

        AsReaderInfo info = (AsReaderInfo)AsReaderInfo.SharedInstance();

        AsReaderNFCDevice nfcDevice = AsReaderDockManager.sharedInstance().nfcDevice;
        AsReaderRFIDDevice rfidDevice = AsReaderDockManager.sharedInstance().rfidDevice;
        AsReaderBarcodeDevice barcodeDevice = AsReaderDockManager.sharedInstance().barcodeDevice;

        public AreteRfidViewController(IntPtr handle) : base(handle)
        {
        }
        public override void PrepareForSegue(UIStoryboardSegue segue, NSObject sender)
        {
            if (segue.Identifier == "segueTagTableView")
            {
                tagViewController = (TagViewController)segue.DestinationViewController;
            }
            else if (segue.Identifier == "segueSettings")
            {
                settingsController = (SettingsController)segue.DestinationViewController;
            }
        }
        public override void ViewDidLoad()
        {
            base.ViewDidLoad();
            NSString phoneVersion = (NSString)UIDevice.CurrentDevice.SystemVersion;
            NSString str = (NSString)".";
            NSString[] array = phoneVersion.SeparateComponents(str);
            float version;
            if (array.Length >= 3)
            {
                NSString hard = array[0];
                version = float.Parse(hard);
            }
            else
            {
                version = float.Parse(phoneVersion);
            }
            if (version >= 15)
            { 
                UINavigationBarAppearance appearance = new UINavigationBarAppearance();
                UIBlurEffect blurEffect = UIBlurEffect.FromStyle(UIBlurEffectStyle.Regular);
                appearance.BackgroundColor = UIColor.White;
                NavigationController.NavigationBar.ScrollEdgeAppearance = appearance;
            }

            AppDelegate appDelegate = (AppDelegate)UIApplication.SharedApplication.Delegate;
            appDelegate.RegisterRootNavigation(NavigationController);


            NSObject[] objects =
            {
                new NSString("YES"),
                new NSString("YES"),
                new NSString("YES"),
                new NSString("YES"),
                new NSString("YES"),
                new NSString("YES"),
                new NSString("YES"),
                new NSString("NO"),
                new NSString("NO"),
                new NSString("0"),
                new NSString("0"),
                new NSString("0"),
                new NSString("0")
            };
            NSObject[] keys =
            {
                new NSString("AutoPowerOn"),
                new NSString("beep"),
                new NSString("illumination"),
                new NSString("vibration"),
                new NSString("led"),
                new NSString("powerOnBeep"),
                new NSString("DefaultTriggerOn"),
                new NSString("RSSIOn"),
                new NSString("SymbologyPrefix"),
                new NSString("RFIDScanTagCount"),
                new NSString("RFIDScanTagTime"),
                new NSString("RFIDScanTagInventory"),
                new NSString("RFIDEncoding")
            };

            NSDictionary defaults = NSDictionary.FromObjectsAndKeys(objects, keys);
            NSUserDefaults.StandardUserDefaults.RegisterDefaults(defaults);

            mBatteryVal = 0;
            mbIsCahrging = false;

            int nTagCount = (int)NSUserDefaults.StandardUserDefaults.IntForKey("RFIDScanTagCount");
            int nScanTime = (int)NSUserDefaults.StandardUserDefaults.IntForKey("RFIDScanTagTime");
            int nCycle = (int)NSUserDefaults.StandardUserDefaults.IntForKey("RFIDScanTagInventory");

            bool isDefaultTriggerOn = NSUserDefaults.StandardUserDefaults.BoolForKey("DefaultTriggerOn");
            AsReaderDevice.SetTriggerModeDefault(isDefaultTriggerOn);

            bool isRSSI = NSUserDefaults.StandardUserDefaults.BoolForKey("RSSIOn");
            AsReaderDevice.SetReadRSSIMode(isRSSI);

            rfidDevice.SetTagCount(nTagCount, nScanTime, nCycle);
            NSNotificationCenter.DefaultCenter.AddObserver(new NSString("UIDeviceBatteryStateDidChangeNotification"), batteryLevelChanged);
            //olBtnSettings.Frame = new CoreGraphics.CGRect(0, 0, 50, 30);
            olBtnSettings.TouchUpInside += MorePush;
            //this.NavigationItem.RightBarButtonItem = new UIBarButtonItem(olBtnSettings);
        }
        void MorePush(object sender, EventArgs e)
        {
            this.PerformSegue("segueSettings", this);
        }
        public override void ViewWillAppear(bool animated)
        {
            base.ViewWillAppear(animated);

            dockManager.pcEpcRssiReceived = PcEpcRssiReceived;
            dockManager.receivedScanData = ReceivedScanData;
            dockManager.batteryReceived = BatteryReceived;
            dockManager.onAsReaderTriggerKeyEventStatus = OnAsReaderTriggerKeyEventStatus;
            dockManager.pushedTriggerButton = PushedTriggerButton;
            dockManager.releasedTriggerButton = ReleasedTriggerButton;
            dockManager.responsePowerOnOff = ResponsePowerOnOff;
            dockManager.readerConnected = ReaderConnected;
            dockManager.plugged = Plugged;
            dockManager.unknownCommandReceived = UnknownCommandReceived;
            dockManager.startedReadScan = StartedReadScan;
            dockManager.stopReadScan = StopReadScan;
        }
        public override void ViewDidAppear(bool animated)
        {
            base.ViewDidAppear(animated);
            updateScanData();
            UIDevice.CurrentDevice.BatteryMonitoringEnabled = true;
        }
        public override void ViewWillDisappear(bool animated)
        {
            base.ViewWillDisappear(animated);
            dockManager.pcEpcRssiReceived = null;
            dockManager.receivedScanData = null;
            dockManager.startedReadScan = null;
            dockManager.stopReadScan = null;
            //dockManager.batteryReceived = null;
            //dockManager.onAsReaderTriggerKeyEventStatus = null;
            //dockManager.pushedTriggerButton = null;
            //dockManager.releasedTriggerButton = null;
            //dockManager.responsePowerOnOff = null;
            //dockManager.readerConnected = null;
            //dockManager.plugged = null;
            //dockManager.unknownCommandReceived = null;
        }
        private void batteryLevelChanged(NSNotification notification)
        {
            UIDevice currentDevice = UIDevice.CurrentDevice;
            UIDeviceBatteryState currentState = currentDevice.BatteryState;
            mbIsCahrging = false;
            if (currentState == UIDeviceBatteryState.Charging || currentState == UIDeviceBatteryState.Full) mbIsCahrging = true;

            int nVal = 0;
            if (mBatteryVal > 95) nVal = 4;
            else if (mBatteryVal > 70) nVal = 3;
            else if (mBatteryVal > 45) nVal = 2;
            else if (mBatteryVal > 20) nVal = 1;

            string imageName = "bat_normal_" + nVal.ToString() + ".png";
            if (mbIsCahrging) imageName = "bat_charge_" + nVal.ToString() + ".png";
            olBattery.Image = UIImage.FromBundle(imageName);
        }
        public override void ViewDidDisappear(bool animated)
        {
            UIDevice.CurrentDevice.BatteryMonitoringEnabled = false;
        }
        public override void DidReceiveMemoryWarning()
        {
            base.DidReceiveMemoryWarning();
        }

        partial void actionSwitch(UISwitch sender)
        {
            if (sender.On) olModeSeg.Enabled = false;
            else olModeSeg.Enabled = true;
            olSwitch.Enabled = false;
            setConnectCommand(sender.On);
        }
        partial void btnRead(UIButton sender)
        {
            int nTagCount = info.Count;
            int nScanTime = info.ScanTime;
            int nCycle = info.Cycle;
            bool bIsRSSIOn = NSUserDefaults.StandardUserDefaults.BoolForKey("RSSIOn");

            int nSelectedDevice = (int)olModeSeg.SelectedSegment;

            if (nSelectedDevice == (int)SelectSegment.SelectSegmentRFID)
            {
                if (bIsRSSIOn) rfidDevice.StartReadTagsAndRssiWithTagNum(nTagCount, nScanTime, nCycle);
                else rfidDevice.StartScan(nTagCount, nScanTime, nCycle);
            }
            else if (nSelectedDevice == (int)SelectSegment.SelectSegmentNFC)
            {
                bool scan = nfcDevice.StartScan;
            }
            else if (nSelectedDevice == (int)SelectSegment.SelectSegmentBarcode)
            {
                bool scan = barcodeDevice.StartScan;
            }
            else if (nSelectedDevice == (int)SelectSegment.SelectSegmentDual)
            {
                bool scan = barcodeDevice.StartScan;
                if (bIsRSSIOn) rfidDevice.StartReadTagsAndRssiWithTagNum(nTagCount, nScanTime, nCycle);
                else rfidDevice.StartScan(nTagCount, nScanTime, nCycle);
            }
            else if (nSelectedDevice == (int)SelectSegment.SelectSegmentRFIDLF)
            {
                rfidDevice.StartScan(nTagCount, nScanTime, nCycle);

            }
        }
        partial void btnClear(UIButton sender)
        {
            m_Model.m_arReadTagData.RemoveAllObjects();
            updateScanData();
        }
        partial void btnStop(UIButton sender)
        {
            int nSelectedDevice = (int)olModeSeg.SelectedSegment;

            if (nSelectedDevice == (int)SelectSegment.SelectSegmentRFID || nSelectedDevice == (int)SelectSegment.SelectSegmentRFIDLF)
            {
                bool stop = rfidDevice.StopScan;
            }
            else if (nSelectedDevice == (int)SelectSegment.SelectSegmentNFC)
            {
                bool stop = nfcDevice.StopScan;
            }
            else if (nSelectedDevice == (int)SelectSegment.SelectSegmentBarcode)
            {
                bool stop = barcodeDevice.StopScan;
            }
            else if (nSelectedDevice == (int)SelectSegment.SelectSegmentDual)
            {
                bool stop = barcodeDevice.StopScan;
                stop = rfidDevice.StopScan;
            }
        }
        partial void actionModeSeg(NSObject sender)
        {
            setConnectCommand(false);
        }
        void setConnectCommand(bool isConnect)
        {
            int nSectedType = (int)olModeSeg.SelectedSegment;
            bool isBeepOn = NSUserDefaults.StandardUserDefaults.BoolForKey("beep");
            bool isvibrOn = NSUserDefaults.StandardUserDefaults.BoolForKey("vibration");
            bool isLedOn = NSUserDefaults.StandardUserDefaults.BoolForKey("led");
            bool isIllumOn = NSUserDefaults.StandardUserDefaults.BoolForKey("illumination");
            bool isConnectedBeep = NSUserDefaults.StandardUserDefaults.BoolForKey("powerOnBeep");
            NSUserDefaults.StandardUserDefaults.SetInt(nSectedType, "KeyPrevSelectedMode");

            rfidDevice.SetReaderPower(isConnect, isBeepOn, isvibrOn, isLedOn, isIllumOn, isConnectedBeep, nSectedType);

        }

        void BatteryReceived(int battery)
        {
            mBatteryVal = battery;
            int nVal = 0;
            if (battery > 95) nVal = 4;
            else if (battery > 70) nVal = 3;
            else if (battery > 45) nVal = 2;
            else if (battery > 20) nVal = 1;

            string imageName = "bat_normal_" + nVal.ToString() + ".png";
            if (mbIsCahrging) imageName = "bat_charge_" + nVal.ToString() + ".png";
            olBattery.Image = UIImage.FromBundle(imageName);
        }
        void Plugged(bool plug)
        {
            NSUserDefaults.StandardUserDefaults.SetBool(false, "unknowCommand");
            NSUserDefaults.StandardUserDefaults.Synchronize();

            if (plug) pluggedState();
            else unpluggedState();
        }
        void pluggedState()
        {
            olSwitch.Hidden = false;

            AsReaderInfo info = AsReaderInfo.SharedInstance();

            if (info.IsPowerOn == true)
            {
                olLabelConnectState.Text = " Connected ";
            }
            else
            {
                olLabelConnectState.Text = " Plugged ";
            }

            //#35861-Combo connection issue when AutoPower OFF
            olSwitch.Enabled = true;
            olSwitch.On = false;
            Title = info.DeviceName;

            /* Read Save Last connected Device Info*/
            int prevMode = (int)NSUserDefaults.StandardUserDefaults.IntForKey("KeyPrevSelectedMode");

            // Initialize Segment Enable.
            if (info.IsSupportType(SupportType.Barcode) == true)
            {
                olModeSeg.SetEnabled(true, (int)SelectSegment.SelectSegmentBarcode);
            }

            if (info.IsSupportType(SupportType.Rfid) == true)
            {
                olModeSeg.SetEnabled(true, (int)SelectSegment.SelectSegmentRFID);
            }
            if (info.IsSupportType(SupportType.Nfc) == true)
            {
                olModeSeg.SetEnabled(true, (int)SelectSegment.SelectSegmentNFC);
            }
            if (info.IsSupportType(SupportType.Dual) == true)
            {
                olModeSeg.SetEnabled(true, (int)SelectSegment.SelectSegmentDual);
            }
            if (info.IsSupportType(SupportType.Rfidlf) == true)
            {
                olModeSeg.SetEnabled(true, (int)SelectSegment.SelectSegmentRFIDLF);
            }

            // Decide selected number of segment.
            prevMode = (int)SettingSegmentSelected(prevMode);

            if (prevMode == (int)ReaderMode.Unknown)
            {

                NSArray supportTypeArray = info.SupportTypeArray;

                if (supportTypeArray.Count > 0)
                {
                    NSNumber number = supportTypeArray.GetItem<NSNumber>(0);
                    prevMode = number.Int16Value;
                    prevMode = (int)SettingSegmentSelected(prevMode);
                }
                else
                {
                    prevMode = (int)NSUserDefaults.StandardUserDefaults.IntForKey("KeyPrevSelectedMode");
                }
            }
            // Auto Power
            bool isAutoPower = NSUserDefaults.StandardUserDefaults.BoolForKey("AutoPowerOn");

            if (isAutoPower)
            {
                olSwitch.On = true;
                actionSwitch(olSwitch);
            }

        }
        ReaderMode SettingSegmentSelected(int prevMode)
        {
            ReaderMode setMode = ReaderMode.Unknown;

            switch (prevMode)
            {
                case (int)ReaderMode.Barcode:
                    if (info.IsSupportType(SupportType.Barcode) == true)
                    {
                        setMode = (ReaderMode)prevMode;
                        olModeSeg.SelectedSegment = (int)SelectSegment.SelectSegmentBarcode;
                    }
                    break;

                case (int)ReaderMode.Rfid:
                    if (info.IsSupportType(SupportType.Rfid) == true)
                    {
                        setMode = (ReaderMode)prevMode;
                        olModeSeg.SelectedSegment = (int)SelectSegment.SelectSegmentRFID;
                    }
                    break;

                case (int)ReaderMode.Nfc:
                    if (info.IsSupportType(SupportType.Nfc) == true)
                    {
                        setMode = (ReaderMode)prevMode;
                        olModeSeg.SelectedSegment = (int)SelectSegment.SelectSegmentNFC;

                    }
                    break;

                case (int)ReaderMode.Dual:
                    if (info.IsSupportType(SupportType.Dual) == true)
                    {
                        setMode = (ReaderMode)prevMode;
                        olModeSeg.SelectedSegment = (int)SelectSegment.SelectSegmentDual;

                    }
                    break;

                case (int)ReaderMode.Rfidlf:
                    if (info.IsSupportType(SupportType.Rfidlf) == true)
                    {
                        setMode = (ReaderMode)prevMode;
                        olModeSeg.SelectedSegment = (int)SelectSegment.SelectSegmentRFIDLF;

                    }
                    break;

                default:
                    break;
            }

            return setMode;
        }
        void unpluggedState()
        {
            disConnectedState();
            olLabelConnectState.Text = " UnPlugged ";
            olSwitch.On = false;
            olSwitch.Hidden = true;
            Title = "Unknown Device";

            olModeSeg.SetEnabled(false, 0);
            olModeSeg.SetEnabled(false, 1);
            olModeSeg.SetEnabled(false, 2);
            olModeSeg.SetEnabled(false, 3);
            olModeSeg.SetEnabled(false, 4);
            olModeSeg.SelectedSegment = 0;
        }
        void connectedState()
        {
            olLabelConnectState.TextColor = UIColor.Blue;
            olLabelConnectState.Text = " Connected";
            if (!olSwitch.On) olSwitch.On = true;

            olSwitch.Hidden = false;
            olBtnRead.Hidden = false;
            olBtnClear.Hidden = false;
            olBtnStop.Hidden = false;
            olBtnSettings.Enabled = true;
        }

        void disConnectedState()
        {
            olLabelConnectState.TextColor = UIColor.Red;
            olLabelConnectState.Text = " Disconnected";
            if (olSwitch.On) olSwitch.On = false;

            olSwitch.Hidden = false;
            olBtnRead.Hidden = true;
            olBtnClear.Hidden = true;
            olBtnStop.Hidden = true;
            olBtnSettings.Enabled = false;
        }

        void UnknownCommandReceived(int commandCode)
        {
            bool sta = NSUserDefaults.StandardUserDefaults.BoolForKey("unknowCommand");
            if (sta)
            {
                NSUserDefaults.StandardUserDefaults.SetBool(false, "unknowCommand");
                NSUserDefaults.StandardUserDefaults.Synchronize();
                string alertStr = "Success";
                if (commandCode != 0x00) alertStr = "FAIL";
                UIAlertController alert = UIAlertController.Create(null, alertStr, UIAlertControllerStyle.Alert);
                UIAlertAction action = UIAlertAction.Create("OK", UIAlertActionStyle.Default, null);
                alert.AddAction(action);
                PresentViewController(alert, true, null);
            }
        }
        void ReceivedScanData(NSData readData)
        {
            unsafe
            {
                string tag = "";

                byte[] ptr = new byte[readData.Length];

                Marshal.Copy(readData.Bytes, ptr, 0, Convert.ToInt32(readData.Length));
                int devicetype = (int)info.CurrentReaderMode;
                switch (devicetype)
                {
                    case (int)ReaderMode.Barcode:
                        NSString str = new NSString();
                        try
                        {
                            str = new NSString(readData, NSStringEncoding.ShiftJIS);
                        }
                        catch
                        {
                            try
                            {
                                str = new NSString(readData, NSStringEncoding.UTF8);
                            }
                            catch
                            {
                                try
                                {
                                    str = new NSString(readData, NSStringEncoding.ASCIIStringEncoding);
                                }
                                catch
                                {
                                    str = new NSString("Encoding Error");
                                }
                            }
                        }
                        if (str != null) tag = str.ToString();
                        break;
                    case (int)ReaderMode.Nfc:
                        int df_NFCDATA_HEADER_SIZE = 4;
                        int df_NFCDATA_FOOTER_SIZE = 3;
                        int nNFCDataLen = ptr[3];
                        int nTotalSize = nNFCDataLen + df_NFCDATA_HEADER_SIZE + df_NFCDATA_FOOTER_SIZE;
                        Byte btSum = 0x00;
                        for (int i = 0; i < nNFCDataLen + df_NFCDATA_HEADER_SIZE + 1; i++) btSum = (Byte)(btSum + ptr[i]);
                        if (nTotalSize != (int)readData.Length) tag += "Data Size Err";
                        else if (btSum != ptr[df_NFCDATA_HEADER_SIZE + nNFCDataLen + 1]) tag += "Check Sum Err";
                        else if ((ptr[0] == 0x02) && (ptr[df_NFCDATA_HEADER_SIZE + nNFCDataLen] == 0x03) && (nTotalSize == (int)readData.Length))
                        {
                            for (int i = 0; i < nNFCDataLen; i++) tag += (ptr[i + 4] & 0xFF).ToString("X2");
                        }
                        else tag += "Data Format Err";
                        break;
                    case (int)ReaderMode.Rfid:
                        for (int i = 0; i < (int)readData.Length; i++) tag += (ptr[i] & 0xFF).ToString("X2");
                        break;
                    case (int)ReaderMode.Rfidlf:
                        for (int i = 0; i < (int)readData.Length; i++) tag += (ptr[i] & 0xFF).ToString("X2");
                        break;
                    case (int)ReaderMode.Dual:
                        
                        if (AsReaderInfo.SharedInstance().CurrentReceiveDataType == ReceiveDataType.Barcode)
                        {
                            NSString strin = new NSString();
                            try { strin = new NSString(readData, NSStringEncoding.ShiftJIS); }
                            catch { strin = new NSString(readData, NSStringEncoding.UTF8); }
                            if (strin != null) tag = strin.ToString();
                        }
                        else if (AsReaderInfo.SharedInstance().CurrentReceiveDataType == ReceiveDataType.Rfid)
                        {
                            for (int i = 0; i < (int)readData.Length; i++) tag += (ptr[i] & 0xFF).ToString("X2");

                        }
                        break;
                    default:
                        tag += "Not Found Device Type";
                        break;

                }
                if (tag.Length > 0)
                {
                    addScanDataFiltering(new NSString(tag), readData, 0);
                }
            }
        }
        void addScanDataFiltering(NSString strScanRead, NSData dataRaw, int rssi)
        {
            bool isNewData = true;
            //NSString strDeviceType = new NSString(info.CurrentSelectDevice.ToString());
            NSString deviceMode = new NSString(((int)info.CurrentReaderMode).ToString());
            NSString dataType = new NSString(((int)info.CurrentReceiveDataType).ToString());

            NSString strRSSI = new NSString("");
            if (rssi != 0)
            {
                strRSSI = new NSString(rssi.ToString());
            }

            NSDate timeDate = NSDate.Now;
            NSDateFormatter formatter = new NSDateFormatter();
            formatter.DateStyle = NSDateFormatterStyle.Medium;
            formatter.TimeStyle = NSDateFormatterStyle.Short;
            formatter.DateFormat = "YYYY/MM/dd HH:mm:ss";
            NSString dateTime = new NSString(formatter.ToString(timeDate));

            for (int i = 0; i < (int)m_Model.m_arReadTagData.Count; i++)
            {
                NSDictionary comDic = m_Model.m_arReadTagData.GetItem<NSDictionary>((nuint)i);
                Boolean isSameData = false;
                NSString oldType = (NSString)comDic.ObjectForKey(GlobalDefine.df_CELL_DATA_TYPE);
                if (int.Parse(oldType.ToString()) == (int)ReceiveDataType.Rfid && AsReaderInfo.SharedInstance().CurrentReceiveDataType == ReceiveDataType.Rfid)
                {
                    NSData compare1 = (NSData)comDic.ObjectForKey(GlobalDefine.df_CELL_TAG_RAW);
                    isSameData = RainTagHelper.checkSameTag1WithTag2(compare1, dataRaw);
                } else
                {
                    NSString strCompare = (NSString)comDic.ObjectForKey(GlobalDefine.df_CELL_TAG_INFO);
                    if (strCompare == strScanRead)
                    {
                        isSameData = true;
                    } else {
                        isSameData = false;
                    }
                }
                if (isSameData)
                {
                    int nCount = int.Parse(((NSString)comDic.ObjectForKey(GlobalDefine.df_CELL_TAG_COUNT)).ToString()) + 1;
                    NSString strCount = new NSString(nCount.ToString());

                    NSObject[] keys =
                               {
                        GlobalDefine.df_CELL_TAG_INFO,
                        GlobalDefine.df_CELL_TAG_COUNT,
                        GlobalDefine.df_CELL_TAG_RAW,
                        GlobalDefine.df_CELL_TAG_RSSI,
                        GlobalDefine.df_CELL_TAG_DEVICE_MODE,
                        GlobalDefine.df_CELL_TAG_DATETIME,
                        GlobalDefine.df_CELL_DATA_TYPE

                    };
                    NSObject[] objects =
                    {
                        strScanRead,
                        strCount,
                        dataRaw,
                        strRSSI,
                        deviceMode,
                        dateTime,
                        dataType
                     };

                    NSDictionary inserDic = NSDictionary.FromObjectsAndKeys(objects, keys);

                    m_Model.m_arReadTagData.ReplaceObject(i, inserDic);
                    isNewData = false;
                    break;
                }
            }

            if (isNewData)
            {
                NSString strCount = new NSString("1");
                NSObject[] keys =
                               {
                        GlobalDefine.df_CELL_TAG_INFO,
                        GlobalDefine.df_CELL_TAG_COUNT,
                        GlobalDefine.df_CELL_TAG_RAW,
                        GlobalDefine.df_CELL_TAG_RSSI,
                        GlobalDefine.df_CELL_TAG_DEVICE_MODE,
                        GlobalDefine.df_CELL_TAG_DATETIME,
                        GlobalDefine.df_CELL_DATA_TYPE
                    };
                NSObject[] objects =
                {
                          strScanRead,
                        strCount,
                        dataRaw,
                        strRSSI,
                        deviceMode,
                        dateTime,
                        dataType
                     };

                NSDictionary inserDic = NSDictionary.FromObjectsAndKeys(objects, keys);

                m_Model.m_arReadTagData.Add(inserDic);
            }
            updateScanData();
        }
        void updateScanData()
        {
            tagViewController.updateData();
            olTagCount.Text = m_Model.m_arReadTagData.Count.ToString();
        }


        void PcEpcRssiReceived(NSData pcEpc, int rssi)
        {
            unsafe
            {
                string tag = "";

                byte[] ptr = new byte[pcEpc.Length];

                Marshal.Copy(pcEpc.Bytes, ptr, 0, Convert.ToInt32(pcEpc.Length));

                for (int i = 0; i < (int)pcEpc.Length; i++) tag += (ptr[i] & 0xFF).ToString("X2");
                addScanDataFiltering(new NSString(tag), pcEpc, rssi);
            }
        }
        void ReaderConnected(int status)
        {
            olSwitch.Enabled = true;
            switch (status)
            {
                case 0xff:
                    {
                        connectedState();
                        bool isSymbologyPrefix = NSUserDefaults.StandardUserDefaults.BoolForKey("SymbologyPrefix");
                        if (isSymbologyPrefix)
                        {
                            bool success = barcodeDevice.SetSymbologyPrefix;
                        }
                        System.Threading.Thread.Sleep(1000); //毫秒
                        olModeSeg.Enabled = true;
                    }
                    break;

                default:
                    disConnectedState();
                    break;
            }
        }

        void ResponsePowerOnOff(bool isOn, bool isHWModeChange)
        {
            if (isHWModeChange)
            {
                if (AsReaderInfo.SharedInstance().CurrentReaderMode != ReaderMode.Unknown)
                {
                    olModeSeg.SelectedSegment = (int)AsReaderInfo.SharedInstance().CurrentReaderMode;
                }
                else
                {
                    olModeSeg.Enabled = false;
                }
            }
        }
        void ReleasedTriggerButton()
        {
            Title = "Custom TriggerDownUp";
        }
        void PushedTriggerButton()
        {
            Title = "Custom TriggerDown";
        }
        void OnAsReaderTriggerKeyEventStatus(string status)
        {
            Title = status;
        }

        void StartedReadScan(int status)
        {
            //Utils.ShowAlert("", status.ToString(), this);
        }
        void StopReadScan(int status)
        {
            //Utils.ShowAlert("", status.ToString(), this);
        }

        string decodeBarcodeData(NSData data)
        {
            NSString changeStr = new NSString();
            try { changeStr = new NSString(data, NSStringEncoding.ShiftJIS); }
            catch { changeStr = new NSString(data, NSStringEncoding.UTF8); }
            return changeStr.ToString();
        }

    }
}
