// This file has been autogenerated from a class added in the UI designer.

using System;
using AsReaderDock4;
using Foundation;
using UIKit;

namespace AsReaderDock_VS
{
    public partial class EpcViewController : UIViewController
    {
        AsReaderRFIDDevice m_RFIDDevice = (AsReaderRFIDDevice)AsReaderRFIDDevice.SharedInstance();
        public NSData epc;
        public NSData pcEpc;

        AsReaderDockManager dockManager = AsReaderDockManager.sharedInstance();

        public EpcViewController (IntPtr handle) : base (handle)
        {
        }

        public override void ViewWillAppear(bool animated)
        {
            base.ViewWillAppear(animated);
            ModelSettings model = ModelSettings.sharedInstance();
            NSDictionary dic = model.m_arReadTagData.GetItem<NSDictionary>((nuint)model.m_nSelectTagNum);
            pcEpc = (NSData)dic.ObjectForKey(new NSString(GlobalDefine.df_CELL_TAG_RAW));
            epc = pcEpc.Subdata(new NSRange(2, (int)pcEpc.Length - 2));

            targetLabel.Text = EpcConverter.toHexString(epc);
            inputHex.Text = EpcConverter.toHexString(epc);
            inputText.Text = PhyUtility.toCharString(epc);
            MyTextView.Text = "";
        }
        public override void DidReceiveMemoryWarning()
        {
            base.DidReceiveMemoryWarning();
        }

        partial void done(NSObject sender)
        {
            if (inputText.Text == "")
            {
                Utils.ShowAlert("", "Please input Data.", this);
                return;
            }
            m_RFIDDevice.WriteTagMemoryWithEPC(pcEpc,inputText.Text);
        }

        void pcEpcReceived(NSData _pcEpc)
        {
            pcEpc = _pcEpc;
            NSData data = NSData.FromString(inputText.Text, NSStringEncoding.UTF8);
            m_RFIDDevice.ReadTagWithAccessPassword(0x00000000, data, 0x01, 0x00, 0x00);
        }

        void writedReceived()
        {
            Utils.ShowAlert("", "Writed.", this);
        }

        void tagMemoryReceived(NSData data)
        {
            
        }

    }
}
