// This file has been autogenerated from a class added in the UI designer.

using System;
using AsReaderDock4;
using Foundation;
using UIKit;
using System.Runtime.InteropServices;

namespace AsReaderDock_VS
{
	public partial class HoppingViewController : UIViewController
	{
        AsReaderDockManager dockManager = AsReaderDockManager.sharedInstance();

        public HoppingViewController (IntPtr handle) : base (handle)
		{
		}
        public override void ViewDidLoad()
        {
            base.ViewDidLoad();
            getInfo();
        }
        public override void ViewWillAppear(bool animated)
        {
            base.ViewWillAppear(animated);
            dockManager.fhLbtReceived = FhLbtReceived;
            dockManager.didSetFhLbt = DidSetFhLbt;
            dockManager.responseGetFHmode = ResponseGetFHmode;
            dockManager.didSetFHmodeChanged = DidSetFHmodeChanged;
            dockManager.didSetOptiFreqHPTable = DidSetOptiFreqHPTable;
            dockManager.errorReceived = ErrorReceived;

            PerformSelector(new ObjCRuntime.Selector("onTickGetFHInfo"), null, 0.5f);
            if (AsReaderInfo.SharedInstance().DeviceModelNumber == "ASX-300R" == true) {
                swMode.Hidden = true;
                btnStep.Hidden = true;
            } else
            {
                swMode.Hidden = false;
                btnStep.Hidden = false;
            }
        }
        public override void ViewWillDisappear(bool animated)
        {
            base.ViewWillDisappear(animated);
            dockManager.fhLbtReceived = null;
            dockManager.fhLbtReceived = null;
            dockManager.fhLbtReceived = null;
            dockManager.fhLbtReceived = null;
            dockManager.fhLbtReceived = null;
            dockManager.fhLbtReceived = null;
        }
        partial void btnSelectHoppingmode(UISwitch sender)
        {
            bool status = sender.On;
            if (status)
            {
                Utils.ShowAlert("", "Selected Smart Mode   => push Step2", this);
            }
            else
            {
                Utils.ShowAlert("", "Selected Normal Mode  => push Step2", this);
            }
        }
        partial void actionSwitchHoppingOnOff(UISwitch sender)
        {
            AsReaderRFIDDevice.SharedInstance().SetHoppingOnOff(sender.On);
        }
        partial void btnRefleshInfo(UIButton sender)
        {
            bool status = AsReaderRFIDDevice.SharedInstance().FrequencyHoppingMode;
            bool statusParameter = AsReaderRFIDDevice.SharedInstance().FhLbtParameter;
        }
        partial void btnStep1(UIButton sender)
        {
            bool status = AsReaderRFIDDevice.SharedInstance().SetOptimumFrequencyHoppingTable;
        }
        partial void onClickStepButton(UIButton sender)
        {
            bool bValue = swMode.On;
            bool status = AsReaderRFIDDevice.SharedInstance().SetSmartHoppingOnOff(bValue);
        }
        [Export("onTickGetFHInfo")]
        void onTickGetFHInfo()
        {
            bool finish = AsReaderRFIDDevice.SharedInstance().FrequencyHoppingMode;
        }

        public void getInfo()
        {
            AsReaderInfo info = AsReaderInfo.SharedInstance();
            NSMutableString strInfo = new NSMutableString();
            if (info.RfidFrequencyHopping > info.RfidListenBeforeTalk)
            {
                strInfo.Append((NSString)"FH ON/OFF : ON");
                swOnOff.On = true;
            }
            else
            {
                strInfo.Append((NSString)"FH ON/OFF : OFF");
                swOnOff.On = false;
            }
            string newString = "\n " + "On Time : :" + info.RfidOnTime;
            strInfo.Append((NSString)newString);
            string newString2 = "\n " + "Off Time : :" + info.RfidOffTime;
            strInfo.Append((NSString)newString2);
            string newString3 = "\n " + "CST : :" + info.CarrierSenseTime;
            strInfo.Append((NSString)newString3);
            string newString4 = "\n " + "FH Val : :" + info.RfidFrequencyHopping;
            strInfo.Append((NSString)newString4);
            string newString5 = "\n " + "RFL : :" + info.TargetRFPowerLevel;
            strInfo.Append((NSString)newString5);
            string newString6 = "\n " + "LBT : :" + info.RfidListenBeforeTalk;
            strInfo.Append((NSString)newString6);
            string newString7 = "\n " + "CW : :" + info.RfidContinuousWave;
            strInfo.Append((NSString)newString7);
            if (info.IsSmartHopping == true)
            {
                strInfo.Append((NSString)" FhMode : SMART ");
                swMode.On = true;
            }
            else
            {
                strInfo.Append((NSString)" FhMode : NORMAL ");
                swMode.On = false;
            }
            labelInfo.Text = strInfo;
        }
        void FhLbtReceived(NSData fhLb)
        {
            getInfo();
            Utils.ShowAlert("", "Refreshed Info", this);
        }
        void DidSetFhLbt(int status)
        {
            Utils.ShowAlert("", "Set FH/LBT Param", this);
        }
        void ResponseGetFHmode()
        {
            getInfo();
        }
        void DidSetFHmodeChanged()
        {
            Utils.ShowAlert("", "didSetFhModeChange", this);
        }
        void DidSetOptiFreqHPTable(int status)
        {
            if (status == 0x00)
            {
                Utils.ShowAlert("", "Wait!! Start OptiMum Freq Start", this);
            }
            if (status == 0x01)
            {
                Utils.ShowAlert("", "Finish  OptiMum Freq", this);
            }
        }
        void ErrorReceived(NSData errorCode)
        {
            byte[] ptr = errorCode.ToArray();
            Marshal.Copy(errorCode.Bytes, ptr, 0, Convert.ToInt32(errorCode.Length));
            switch ((int)ptr[1])
            {
                case 0xE4:
                case 0xE6:
                case 0xD2:
                    {
                        Utils.ShowAlert("Error", "The retrun loss of antenna is too large to optimize channel.", this);
                        break;
                    }
                default:
                    break;
            }
        }
    }
}
