// This file has been autogenerated from a class added in the UI designer.

using System;
using AsReaderDock4;
using Foundation;
using UIKit;
using System.Runtime.InteropServices;

namespace AsReaderDock_VS
{
	public partial class KillController : UIViewController
	{
        AsReaderDockManager dockManager = AsReaderDockManager.sharedInstance();

        public KillController (IntPtr handle) : base (handle)
		{
		}
        public override void ViewWillAppear(bool animated)
        {
            base.ViewWillAppear(animated);
            dockManager.killedReceived = KilledReceived;
            dockManager.errorReceived = ErrorReceived;
            int i = ModelSettings.sharedInstance().m_nSelectTagNum;
            NSDictionary dic = ModelSettings.sharedInstance().m_arReadTagData.GetItem<NSDictionary>((nuint)i);
            NSData data = (NSData)dic.ObjectForKey(new NSString(GlobalDefine.df_CELL_TAG_RAW));
            olTargetEpc.Text = PhyUtility.GetEpcStringFromPcEPCData(data);
        }
        public override void ViewWillDisappear(bool animated)
        {
            base.ViewWillDisappear(animated);
            dockManager.killedReceived = null;
            dockManager.errorReceived = null;
        }
        partial void rightBarButtonItemClicked(UIButton sender)
        {
            olTargetEpc.ResignFirstResponder();
            string hexaString = olKillPassword.Text;
            int killpassword = (int)(Utils.hexStringToLong(hexaString));
            NSData epcs = PhyUtility.hexStringToBytes((NSString)olTargetEpc.Text);
            AsReaderRFIDDevice.SharedInstance().KillTagWithPassword(killpassword, epcs);
        }
        void KilledReceived(int statusCode)
        {
            if (statusCode == 0x00)
            {
                Utils.ShowAlert("Confirm", "Killed Tag.", this);
            }
        }
        void ErrorReceived(NSData errorCode)
        {
            byte[] ptr = errorCode.ToArray();
            Marshal.Copy(errorCode.Bytes, ptr, 0, Convert.ToInt32(errorCode.Length));
            string strErrMsg = "Error Code: 0x" + ptr[0].ToString();
            Utils.ShowAlert("Error", strErrMsg, this);
        }
    }
}
