// This file has been autogenerated from a class added in the UI designer.

using System;
using AsReaderDock4;
using Foundation;
using UIKit;
using System.Runtime.InteropServices;

namespace AsReaderDock_VS
{
	public partial class LockController : UIViewController
	{
		AsReaderDockManager dockManager = AsReaderDockManager.sharedInstance();

		public LockController (IntPtr handle) : base (handle)
		{
		}
        public override void ViewWillAppear(bool animated)
        {
            base.ViewWillAppear(animated);
            dockManager.lockedReceived = LockedReceived;
            dockManager.errorReceived = ErrorReceived;
            int i = ModelSettings.sharedInstance().m_nSelectTagNum;
            NSDictionary dic = ModelSettings.sharedInstance().m_arReadTagData.GetItem<NSDictionary>((nuint)i);
            NSData data = (NSData)dic.ObjectForKey(new NSString(GlobalDefine.df_CELL_TAG_RAW));
            olTargetEpc.Text = PhyUtility.GetEpcStringFromPcEPCData(data);
        }
        public override void ViewWillDisappear(bool animated)
        {
            base.ViewWillDisappear(animated);
            dockManager.lockedReceived = null;
            dockManager.errorReceived = null;
        }
        partial void rightBarButtonItemClicked(UIButton sender)
        {
            olTargetEpc.ResignFirstResponder();
            string hexaString = olAccessPassword.Text;
            int accesspassword = (int)(Utils.hexStringToLong(hexaString));
            int locked = 0;
            int seed = (int)olAction.SelectedSegment;

            switch (olTargetMemory.SelectedSegment)
            {
                case 0:
                    locked = (seed << 8) | (3 << 18);
                    break;
                case 1:
                    locked = (seed << 6) | (3 << 16);
                    break;
                case 2:
                    locked = (seed << 4) | (3 << 14);
                    break;
                case 3:
                    locked = (seed << 2) | (3 << 12);
                    break;
                case 4:
                    locked = (seed << 0) | (3 << 10);
                    break;
                default:
                    break;
            }

            NSData epcs = PhyUtility.hexStringToBytes((NSString)olTargetEpc.Text);
            AsReaderRFIDDevice.SharedInstance().LockTagMemoryWithAccessPassword(accesspassword, epcs, locked);
        }
        void LockedReceived(int statusCode)
        {
            if (statusCode == 0x00)
            {
                Utils.ShowAlert("Confirm", "Lock Tag.", this);
            }
        }
        void ErrorReceived(NSData errorCode)
        {
            byte[] ptr = errorCode.ToArray();
            Marshal.Copy(errorCode.Bytes, ptr, 0, Convert.ToInt32(errorCode.Length));
            string strErrMsg = "Error Code: 0x" + ptr[0].ToString();
            Utils.ShowAlert("Error", strErrMsg, this);
        }
    }
}
