﻿using System;
using Foundation;
namespace AsReaderDock_VS
{
    public class ModelSettings:NSObject
    {
        public int df_ENCODINGTYPE_HEX = 0;
        public int df_ENCODINGTYPE_ASCII = 1;
        public int df_ENCODINGTYPE_SGTIN96 = 2;
        public int df_ENCODINGTYPE_EAN13 = 3;

        public RFIDDeviceInfo m_RFIDDeviceInfo;
        public int m_nSelectTagNum;
        public NSMutableArray m_arReadTagData;

        
        static ModelSettings uniqueInstance;

        static readonly object locker = new object();

        public static ModelSettings sharedInstance()
        {
            if (uniqueInstance == null)
            {
                lock (locker)
                {
                    if (uniqueInstance == null)
                    {
                        uniqueInstance = new ModelSettings();
                    }
                }
            }
            return uniqueInstance;
        }
        
        public ModelSettings()
        {
            m_arReadTagData = new NSMutableArray();
            m_RFIDDeviceInfo = new RFIDDeviceInfo();
        }
    }

    public class RFIDDeviceInfo:NSObject
    {
        public int m_nAntiMode;
        public int m_nRFID_RF_CHANNEL;
        public double m_fRFIDPower;
        public RFIDDeviceInfo()
        {
        }
    }

}
