// This file has been autogenerated from a class added in the UI designer.

using System;
using AsReaderDock4;
using Foundation;
using UIKit;

namespace AsReaderDock_VS
{
	public partial class ModulationTableViewController : UITableViewController
	{
		NSMutableArray modulationList;
		int modulation;
		AsReaderDockManager dockManager = AsReaderDockManager.sharedInstance();
        public ModulationTableViewController (IntPtr handle) : base (handle)
		{
		}
        public override void ViewDidLoad()
        {
            base.ViewDidLoad();
            modulation = -1;
            if (modulationList == null)
            {
                modulationList = new NSMutableArray();
            }
            NSString str = (NSString)"160KHz, FM0, DR=64/3";
            modulationList.Add(str);
            NSString str1 = (NSString)"250KHz, FM0, DR=64/3";
            modulationList.Add(str1);
            NSString str2 = (NSString)"320KHz, FM0, DR=64/3";
            modulationList.Add(str2);
            NSString str3 = (NSString)"640KHz, FM0, DR=64/3";
            modulationList.Add(str3);
            NSString str4 = (NSString)"160KHz, M2, DR=64/3";
            modulationList.Add(str4);
            NSString str5 = (NSString)"250KHz, M2, DR=64/3";
            modulationList.Add(str5);
            NSString str6 = (NSString)"320KHz, M2, DR=64/3";
            modulationList.Add(str6);
            NSString str7 = (NSString)"640KHz, M2, DR=64/3";
            modulationList.Add(str7);
            NSString str8 = (NSString)"160KHz, M4, DR=64/3";
            modulationList.Add(str8);
            NSString str9 = (NSString)"250KHz, M4, DR=64/3";
            modulationList.Add(str9);
            NSString str10 = (NSString)"320KHz, M4, DR=64/3";
            modulationList.Add(str10);
            NSString str11 = (NSString)"640KHz, M4, DR=64/3";
            modulationList.Add(str11);
            NSString str12 = (NSString)"160KHz, M8, DR=64/3";
            modulationList.Add(str12);
            NSString str13 = (NSString)"250KHz, M8, DR=64/3";
            modulationList.Add(str13);
            NSString str14 = (NSString)"320KHz, M8, DR=64/3";
            modulationList.Add(str14);
            NSString str15 = (NSString)"640KHz, M8, DR=64/3";
            modulationList.Add(str15);
        }
        public override void ViewWillAppear(bool animated)
        {
            base.ViewWillAppear(animated);
            dockManager.modulationParamReceived = ModulationParamReceived;
            dockManager.didSetModulation = DidSetModulation;
            bool statu = AsReaderRFIDDevice.SharedInstance().Modulation;
        }
        public override void ViewWillDisappear(bool animated)
        {
            base.ViewWillDisappear(animated);
            dockManager.modulationParamReceived = null;
            dockManager.didSetModulation = null;
        }
        partial void rightBarButtonItemClicked(UIButton sender)
        {
            NSString modul = modulationList.GetItem<NSString>((nuint)modulation);
            NSString[] modulationValueArrmodul = modul.SeparateComponents((NSString)",");
            NSString aaa = modulationValueArrmodul[0];
            String bbb = "";
            if (aaa.Contains((NSString)"KHz"))
            {
                bbb = aaa.ToString().Replace("KHz", "");
            }
            int blf = int.Parse(bbb);
            NSString rxMod = modulationValueArrmodul[1];
            NSString dr = modulationValueArrmodul[2];
            int rxModVal = 0;
            int drVal = 0;
            
            if (rxMod.Contains((NSString)"FM0"))
            {
                rxModVal = 0;
            }
            else if (rxMod.Contains((NSString)"M2"))
            {
                rxModVal = 1;
            }
            else if (rxMod.Contains((NSString)"M4"))
            {
                rxModVal = 2;
            }
            else if (rxMod.Contains((NSString)"M8"))
            {
                rxModVal = 3;
            }


            if (dr.Contains((NSString)"8"))
            {
                drVal = 0;
            }
            else if (dr.Contains((NSString)"64/3"))
            {
                drVal = 1;
            }
            AsReaderRFIDDevice.SharedInstance().SetModulationBLF(blf, rxModVal, drVal);
            TableView.ReloadData();
        }
        void ModulationParamReceived(int blf, int rxMod, int dr)
        {
            String blfStr = "";
            String rxModStr = "";

            if (blf == 0x00A0)
            {
                blfStr = "160KHz";
            }
            else if (blf == 0x00FA)
            {
                blfStr = "250KHz";
            }
            else if (blf == 0x0140)
            {
                blfStr = "320KHz";
            }
            else if (blf == 0x0280)
            {
                blfStr = "640KHz";
            }

            if (rxMod == 0x00)
            {
                rxModStr = "FM0";
            }
            else if (rxMod == 0x01)
            {
                rxModStr = "M2";
            }
            else if (rxMod == 0x02)
            {
                rxModStr = "M4";
            }
            else if (rxMod == 0x03)
            {
                rxModStr = @"M8";
            }
            String currentModulation = blfStr + ", " + rxModStr + ", " + "DR=64/3";
            for (nuint i = 0; i < modulationList.Count; i++)
            {
                NSString modul = modulationList.GetItem<NSString>(i);
                if (modul == currentModulation)
                {
                    modulation = (int)i;
                    TableView.ReloadData();
                }
            }
        }
        void DidSetModulation(int status)
        {
            if (status == 0xff)
            {
                Utils.ShowAlert("", "Modulation Setting Fail ", this);
            } else
            {
                Utils.ShowAlert("", "Modulation Setting success ", this);
            }
        }
        public override nint NumberOfSections(UITableView tableView)
        {
            return 1;
        }
        public override nint RowsInSection(UITableView tableView, nint section)
        {
            return (nint)modulationList.Count;
        }
        public override UITableViewCell GetCell(UITableView tableView, NSIndexPath indexPath)
        {
            UITableViewCell cell = (UITableViewCell)tableView.DequeueReusableCell("Cell", indexPath);
            NSString modul = modulationList.GetItem<NSString>((nuint)indexPath.Row);
            cell.TextLabel.Text = modul.ToString();
            if (modulation == indexPath.Row)
            {
                cell.Accessory = UITableViewCellAccessory.Checkmark;
            }
            else
            {
                cell.Accessory = UITableViewCellAccessory.None;
            }
            return cell;
        }
        public override void RowSelected(UITableView tableView, NSIndexPath indexPath)
        {
            modulation = indexPath.Row;
            TableView.ReloadData();
        }
    }
}
