// This file has been autogenerated from a class added in the UI designer.

using System;
using AsReaderDock4;
using Foundation;
using UIKit;
using System.Text;

namespace AsReaderDock_VS
{
	public partial class NFCReadViewController : UIViewController
	{
        AsReaderNFCDevice device = AsReaderDockManager.sharedInstance().nfcDevice;
        ModelSettings m_Model = ModelSettings.sharedInstance();
        AsReaderDockManager dockManager = AsReaderDockManager.sharedInstance();

        public NFCReadViewController (IntPtr handle) : base (handle)
		{
		}

        public override void ViewDidLoad()
        {
            base.ViewDidLoad();
            readButton.Layer.MasksToBounds = true;
            readButton.Layer.CornerRadius = 5;
            readTextView.Layer.MasksToBounds = true;
            readTextView.Layer.CornerRadius = 5;
            readTextView.Layer.BorderColor = UIColor.LightGray.CGColor;
            readTextView.Layer.BorderWidth = 0.5f;
            NSDictionary dic = m_Model.m_arReadTagData.GetItem<NSDictionary>((nuint) m_Model.m_nSelectTagNum);
            string strData = (NSString)dic.ObjectForKey(GlobalDefine.df_CELL_TAG_INFO).ToString();
            SetTextBlockAttributed(new NSString("UID : " + strData));
        }

        public override void ViewWillAppear(bool animated)
        {
            base.ViewWillAppear(animated);

            dockManager.nfcReadMultiBlockReceived = NfcReadMultiBlockReceived;
        }
        public override void ViewDidDisappear(bool animated)
        {
            base.ViewDidDisappear(animated);
            dockManager.nfcReadMultiBlockReceived = null;
        }

        partial void onClickReadButton(UIButton sender)
        {
            View.EndEditing(true);
            if (!Utils.CheckNumberTextLength(blockIndexTextField.Text, 255, 0))
            {
                SetTextBlockAttributed(new NSString("The value of the block index is in the range 0-255. Please enter a valid value"));
            }
            else if (!Utils.CheckNumberTextLength(blockCountTextField.Text, 255, 0))
            {
                SetTextBlockAttributed(new NSString("The value of the block count is in the range 0-255. Please enter a valid value"));
            }
            else
            {
                device.ReadMultiBlockWithBlockIndex(int.Parse(blockIndexTextField.Text), int.Parse(blockCountTextField.Text));
            }
        }

        public override void TouchesBegan(NSSet touches, UIEvent evt)
        {
            View.EndEditing(true);
        }

        void NfcReadMultiBlockReceived(NSObject[] dataAry, SDK4StatusCode statusCode)
        {
            if (statusCode == SDK4StatusCode.Ok)
            {
                int blockIndex = int.Parse(blockIndexTextField.Text);
                StringBuilder str = new StringBuilder("");
                for (int i = 0; i < dataAry.Length; i++)
                {
                    NSString blockString = (NSString)dataAry[i];
                    str.Append("Block ");
                    str.Append(blockIndex.ToString());
                    str.Append(":\n");
                    str.Append(blockString);
                    str.Append("\n");

                    blockIndex++;
                }
                SetTextBlockAttributed(new NSString(str.ToString()));
                Utils.ShowAlert("Read Success", null, this);
            }
            else
            {
                var str = statusCode.ToString();
                Utils.ShowAlert("Read Failed", "StatusCode: " + str, this);
            }
        }

        private void SetTextBlockAttributed(NSString text)
        {
            readTextView.Text = text;
            NSMutableAttributedString str = new NSMutableAttributedString(readTextView.Text);
            str.AddAttribute(new NSString("NSFont"), UIFont.SystemFontOfSize(20), new NSRange(0, readTextView.Text.Length));

            string[] condition = { "\n" };
            string[] result = readTextView.Text.Split(condition, StringSplitOptions.None);

            int i = 0;
            foreach (string blockStr in result)
            {
                if (blockStr.StartsWith("Block"))
                {
                    str.AddAttribute(new NSString("NSColor"), UIColor.Blue, new NSRange(i, blockStr.Length));
                }
                else
                {
                    str.AddAttribute(new NSString("NSColor"), UIColor.Black, new NSRange(i, blockStr.Length));
                }
                i += blockStr.Length+1;
            }
            readTextView.AttributedText = str;
        }
    }
}
