// This file has been autogenerated from a class added in the UI designer.

using System;
using AsReaderDock4;
using Foundation;
using UIKit;

namespace AsReaderDock_VS
{
    public partial class RFIDFuntionsList : UITableViewController
    {
        public static string df_ENCODINGTYPE_HEX = "0";
        public static string df_ENCODINGTYPE_ASCII = "1";
        public static string df_ENCODINGTYPE_SGTIN96 = "2";
        public static string df_ENCODINGTYPE_EAN13 = "3";
        AsReaderDockManager dockManager = AsReaderDockManager.sharedInstance();

        public RFIDFuntionsList(IntPtr handle) : base(handle)
        {
        }
        public override void ViewWillAppear(bool animated)
        {
            base.ViewWillAppear(animated);
            AsReaderDevice device = AsReaderRFIDDevice.SharedInstance();
            dockManager.rssiThresholdReceived = RssiThresholdReceived;
            dockManager.updatedRegistry = UpdatedRegistry;
            dockManager.rfidOnOffTimeReceived = RfidOnOffTimeReceived;
            dockManager.channelReceived = ChannelReceived;
            dockManager.txPowerLevelReceived = TxPowerLevelReceived;
            dockManager.anticolParamReceived = AnticolParamReceived;
            dockManager.modulationParamReceived = ModulationParamReceived;
            olPowerLever.Text = "---";
            olStopCondition.Text = "---";
            olOnOffTime.Text = "---";
            olRFChannel.Text = "---";
            modulationLabel.Text = "---";
            bool isRSSIOn = NSUserDefaults.StandardUserDefaults.BoolForKey("RSSIOn");
            olSwitchRSSIOn.On = isRSSIOn;
            int nTagCount = (int)NSUserDefaults.StandardUserDefaults.IntForKey("RFIDScanTagCount");
            int nScanTime = (int)NSUserDefaults.StandardUserDefaults.IntForKey("RFIDScanTagTime");
            int nCycle = (int)NSUserDefaults.StandardUserDefaults.IntForKey("RFIDScanTagInventory");
            olStopCondition.Text = nTagCount.ToString() + "/" + nScanTime.ToString() + "/" + nCycle.ToString();
            PerformSelector(new ObjCRuntime.Selector("onTickRFIDPowerFuntion"), null, 0.2f);
            PerformSelector(new ObjCRuntime.Selector("onTickStopConditionFuntion"), null, 0.4f);
            PerformSelector(new ObjCRuntime.Selector("onTickOnOffTimeFuntion"), null, 0.6f);
            PerformSelector(new ObjCRuntime.Selector("onTickOnChannelFuntion"), null, 0.8f);
            PerformSelector(new ObjCRuntime.Selector("onTickAnticollisionFuntion"), null, 1.0f);
            PerformSelector(new ObjCRuntime.Selector("onTickModulationFuntion"), null, 1.2f);
            AsReaderInfo info = AsReaderInfo.SharedInstance();
            NSString hardware = (NSString)info.DeviceHardware;
            NSString str = (NSString)".";
            NSString[] array = hardware.SeparateComponents(str);
            float hwVer;
            if (array.Length >= 3)
            {
                NSString hard = array[0];
                hwVer = float.Parse(hard);
            } else
            {
                hwVer = float.Parse(hardware);
            }
            if (hwVer >= 2.0)
            {
                PerformSelector(new ObjCRuntime.Selector("onTickThresholdFuntion"), null, 1.4f);
            }
            else
            {
                this.View.UserInteractionEnabled = true;
            }
        }
        public override void ViewWillDisappear(bool animated)
        {
            base.ViewWillDisappear(animated);
            dockManager.rssiThresholdReceived = null;
            dockManager.updatedRegistry = null;
            dockManager.rfidOnOffTimeReceived = null;
            dockManager.channelReceived = null;
            dockManager.txPowerLevelReceived = null;
            dockManager.anticolParamReceived = null;
            dockManager.modulationParamReceived = null;
        }
        partial void btnSaveRegistry(UIButton sender)
        {
            bool status = AsReaderRFIDDevice.SharedInstance().UpdateRegistry;
        }
        partial void actionRSSISwitch(UISwitch sender)
        {
            AsReaderDevice.SetReadRSSIMode(sender.On);
            NSUserDefaults.StandardUserDefaults.SetBool(sender.On, "RSSIOn");
            NSUserDefaults.StandardUserDefaults.Synchronize();
        }
        void RssiThresholdReceived(int threshold)
        {
           olThresholdValue.Text = threshold.ToString();
        }
        void UpdatedRegistry(int status)
        {
            string strResult;
            if (status == 0x00)
            {
                strResult = "Successfully Stored Data into Registry. Please Reset Hardware.";
            }
            else
            {
                strResult = "Fail Store into Registry";
            }
            Utils.ShowAlert(strResult, "Update Registry Result", this);
        }
        void RfidOnOffTimeReceived(NSData data)
        {
            AsReaderInfo info = AsReaderInfo.SharedInstance();
            string onTime = info.RfidOnTime.ToString();
            string offTime = info.RfidOffTime.ToString();
            olOnOffTime.Text = onTime + "/" + offTime;
        }
        void ChannelReceived(int channel, int channelOffset)
        {
            AsReaderInfo info = AsReaderInfo.SharedInstance();
            ModelSettings.sharedInstance().m_RFIDDeviceInfo.m_nRFID_RF_CHANNEL = info.NRFIDchannel;
            olRFChannel.Text = info.NRFIDchannel.ToString();
        }
        void TxPowerLevelReceived(NSData power)
        {
            AsReaderInfo info = AsReaderInfo.SharedInstance();
            float rfidPower = (float)(info.RfidPower / 10.0);
            olPowerLever.Text = rfidPower.ToString();
        }
        void AnticolParamReceived(int mode, int counter)
        {
            ModelSettings.sharedInstance().m_RFIDDeviceInfo.m_nAntiMode = mode;
            olAntiCollisionMode.Text = ModelSettings.sharedInstance().m_RFIDDeviceInfo.m_nAntiMode.ToString();
        }
        void ModulationParamReceived(int blf, int rxMod, int dr)
        {
            String blfStr = "";
            String rxModStr = "";

            if (blf == 0x00A0)
            {
                blfStr = "160KHz";
            }
            else if (blf == 0x00FA)
            {
                blfStr = "250KHz";
            }
            else if (blf == 0x0140)
            {
                blfStr = "320KHz";
            }
            else if (blf == 0x0280)
            {
                blfStr = "640KHz";
            }

            if (rxMod == 0x00)
            {
                rxModStr = "FM0";
            }
            else if (rxMod == 0x01)
            {
                rxModStr = "M2";
            }
            else if (rxMod == 0x02)
            {
                rxModStr = "M4";
            }
            else if (rxMod == 0x03)
            {
                rxModStr = @"M8";
            }
            String currentModulation = blfStr + "," + rxModStr + "," + "DR=64/3";
            modulationLabel.Text = currentModulation;
        }
        [Export("onTickRFIDPowerFuntion")]
        void onTickRFIDPowerFuntion()
        {
            bool finish = AsReaderRFIDDevice.SharedInstance().OutputPowerLevel;
        }
        [Export("onTickStopConditionFuntion")]
        void onTickStopConditionFuntion()
        {
            bool finish = AsReaderRFIDDevice.SharedInstance().StopCondition;
        }
        [Export("onTickOnOffTimeFuntion")]
        void onTickOnOffTimeFuntion()
        {
            bool finish = AsReaderRFIDDevice.SharedInstance().FhLbtParameter;
        }
        [Export("onTickOnChannelFuntion")]
        void onTickOnChannelFuntion()
        {
            bool finish = AsReaderRFIDDevice.SharedInstance().Channel;
        }
        [Export("onTickAnticollisionFuntion")]
        void onTickAnticollisionFuntion()
        {
            bool finish = dockManager.rfidDevice.Anticollision;
        }
        [Export("onTickThresholdFuntion")]
        void onTickThresholdFuntion()
        {
            bool finish = AsReaderRFIDDevice.SharedInstance().RSSIThreshold;
        }
        [Export("onTickModulationFuntion")]
        void onTickModulationFuntion()
        {
            bool finish = AsReaderRFIDDevice.SharedInstance().Modulation;
        }
        
    }
}
