// This file has been autogenerated from a class added in the UI designer.

using System;
using AsReaderDock4;
using Foundation;
using System.Runtime.InteropServices;

namespace AsReaderDock_VS
{
    public partial class RFMManager : NSObject
    {
        public int filterRSSI;
        public int filterWet;

        public RFMManager()
        {
        }

        public RFMManager(IntPtr handle) : base(handle)
        {
        }

        public void setFilterRSSI(int rssi, int wet)
        {
            filterRSSI = rssi;
            filterWet = wet;
        }
        public double p_temperatureCalc(byte[] sensorData, int typeIndex)
        {
            double result = 0;
            int offset = 0;
            int temp = 0;
            double tempCode_ = 0;
            double code1_ = 0;
            double code2_ = 0;

            double temp1_ = 0;
            double temp2_ = 0;

            offset = typeIndex;
            tempCode_ = sensorData[offset + 0] << 8 | (sensorData[offset + 1] & 0xFF);

            if (sensorData.Length <= offset + 4)
            {
                return result;
            }
            temp = sensorData[offset + 4] & 0xFF;
            temp = (temp << 4) + ((sensorData[offset + 5] >> 4) & 0x0F);
            code1_ = temp;

            if (sensorData.Length <= offset + 5)
            {
                return result;
            }
            temp = sensorData[offset + 5] & 0x0F;
            temp = (temp << 7) + ((sensorData[offset + 6] >> 1) & 0x7F);
            temp1_ = temp;

            if (sensorData.Length <= offset + 6)
            {
                return result;
            }
            temp = sensorData[offset + 6] & 0x01;
            temp = (temp << 8) + sensorData[offset + 7];
            temp = (temp << 3) + ((sensorData[offset + 8] >> 5) & 0x07);
            code2_ = temp;

            if (sensorData.Length <= offset + 8)
            {
                return result;
            }
            temp = sensorData[offset + 8] & 0x1F;
            temp = (temp << 6) + ((sensorData[offset + 9] >> 2) & 0x3F);
            temp2_ = temp;

            result = ((temp2_ - temp1_) / (code2_ - code1_) * (tempCode_ - code1_) + temp1_ - 800) / 10;

            return result;
        }
        public RFMSensorItem parseData(NSData pcEpc, NSData sensorData, int rssi)
        {
            string tagEPC = "";
            string tagSensroData = "";

            byte[] pcEpcPtr = pcEpc.ToArray();
            Marshal.Copy(pcEpc.Bytes, pcEpcPtr, 0, Convert.ToInt32(pcEpc.Length));
            for (int i = 0; i < (int)pcEpc.Length; i++) tagEPC += (pcEpcPtr[i] & 0xFF).ToString("X2");

            byte[] sensPtr = sensorData.ToArray();
            Marshal.Copy(sensorData.Bytes, sensPtr, 0, Convert.ToInt32(sensorData.Length));
            for (int i = 0; i < (int)sensorData.Length; i++) tagSensroData += (sensPtr[i] & 0xFF).ToString("X2");

            int sensorTypeindex = 6;
            int sensorCalcindex = 11;

            AsReaderInfo info = AsReaderInfo.SharedInstance();
            if (info.RfidModuleVersion.Contains("RED4S") == true)
            {
                sensorTypeindex = 6;
                sensorCalcindex = 11;
            }
            else
            {
                sensorTypeindex = 0;
                sensorCalcindex = 3;
            }

            byte[] sensorBytes = sensorData.ToArray();
            double tempValue = p_temperatureCalc(sensorBytes, sensorCalcindex);

            NSString temperature = (NSString)tempValue.ToString("N1");

            NSString cop = (NSString)tagSensroData.Substring(0, 4);
            cop = p_parseCOPHexStringToIntSting(cop);

            NSString cfqH = (NSString)tagSensroData.Substring(4, 4);
            NSString cfqL = (NSString)tagSensroData.Substring(8, 4);
            NSString cfq = p_parseCFQHexStringToIntStingH(cfqH, cfqL);

            NSString ct = (NSString)tagSensroData.Substring(12, 2);
            ct = p_parseCTHexStringToIntSting(ct);

            NSString cd = (NSString)tagSensroData.Substring(14, tagSensroData.Length - 14);
            NSString moisture = (NSString)cd.ToString().Substring(0, 4);
            moisture = (NSString)("0x" + moisture.ToString());
            NSString onChipRSSI = (NSString)cd.ToString().Substring(4, 4);

            RFMSensorItem item = new RFMSensorItem();
            item.pcEpc = tagEPC;
            item.sensorData = tagSensroData;
            item.cop = cop;
            item.cfq = cfq.ToString();
            item.ct = ct;
            item.cd = cd;
            item.temperature = temperature;
            item.moisture = moisture;
            item.rssi = onChipRSSI.ToString();

            int rssiIntVal = p_parseHexStringToInt(onChipRSSI);
            int wetIntVal = p_parseHexStringToInt(moisture);
            if (filterRSSI > rssiIntVal)
            {
                return null;
            }
            if (wetIntVal > filterWet)
            {
                item.moistureResult = "WET";
            }
            else
            {
                item.moistureResult = "DRY";
            }
            return item;
        }
        private int p_parseHexStringToInt(NSString hexString)
        { 
            int result = 0;
            result = (int)(Utils.hexStringToLong(hexString.ToString()));
            return result;
        }

        private NSString p_parseCOPHexStringToIntSting(NSString hexString)
        {
            int result = p_parseHexStringToInt(hexString);
            return (NSString)((result / 10.0).ToString() + " dBm");
        }

        private NSString p_parseCFQHexStringToIntStingH(NSString highString, NSString lowString)
        {
            int resultH = p_parseHexStringToInt(highString);
            int resultL = p_parseHexStringToInt(lowString);
            return (NSString)(resultH.ToString() + "." + resultL.ToString() + " MHz");
        }

        private NSString p_parseCTHexStringToIntSting(NSString hexString)
        {
            int result = p_parseHexStringToInt(hexString);
            if (result == 0x03)
            {
                return (NSString)"S3 Tag";
            }
            else if (result == 0x02)
            {
                return (NSString)"S2 Tag";
            }
            else
            {
                return (NSString)"Unknown Tag";
            }
        }
    }
}
