// This file has been autogenerated from a class added in the UI designer.

using System;
using AsReaderDock4;
using Foundation;
using UIKit;

namespace AsReaderDock_VS
{
	public partial class RSSIThresholdViewController : UIViewController
	{
		AsReaderDockManager dockManager = AsReaderDockManager.sharedInstance();

		public RSSIThresholdViewController (IntPtr handle) : base (handle)
		{
		}
        public override void ViewWillAppear(bool animated)
        {
            base.ViewWillAppear(animated);
            AsReaderDevice device = AsReaderRFIDDevice.SharedInstance();
            dockManager.rssiThresholdReceived = RssiThresholdReceived;
            dockManager.unknownCommandReceived = UnknownCommandReceived;
            bool status = AsReaderRFIDDevice.SharedInstance().RSSIThreshold;
        }
        public override void ViewWillDisappear(bool animated)
        {
            base.ViewWillDisappear(animated);
            dockManager.rssiThresholdReceived = null;
            dockManager.unknownCommandReceived = null;
        }
        partial void btnSetThreshold(UIButton sender)
        {
            olEditThreshold.ResignFirstResponder();
            int nVal = 0;
            int.TryParse(olEditThreshold.Text, out nVal);
            if (!AsReaderRFIDDevice.SharedInstance().SetRSSIThreshold(nVal)) {
                Utils.ShowAlert("", "FAIL", this);
            }
        }
        void RssiThresholdReceived(int threshold)
        {
            olEditThreshold.Text = threshold.ToString();
        }
        void UnknownCommandReceived(int commandCode)
        {
            if (commandCode == 0)
            {
                Utils.ShowAlert("", "Success", this);
            } else
            {
                Utils.ShowAlert("", "FAIL", this);
            }
        }
    }
}
