// This file has been autogenerated from a class added in the UI designer.

using System;
using AsReaderDock4;
using Foundation;
using UIKit;
using System.Runtime.InteropServices;

namespace AsReaderDock_VS
{
	public partial class RfSettingsController : UIViewController
	{
		AsReaderDockManager dockManager = AsReaderDockManager.sharedInstance();

		public RfSettingsController (IntPtr handle) : base (handle)
		{
		}
        public override void ViewDidLoad()
        {
            base.ViewDidLoad();
            olChannel.Text = "--";
            olChannel.Text = ModelSettings.sharedInstance().m_RFIDDeviceInfo.m_nRFID_RF_CHANNEL.ToString();
        }
        public override void ViewWillAppear(bool animated)
        {
            base.ViewWillAppear(animated);
            dockManager.didSetChannelParamReceived = DidSetChannelParamReceived;
            dockManager.errorReceived = ErrorReceived;
            dockManager.hoppingTableReceived = HoppingTableReceived;
            dockManager.channelReceived = ChannelReceived;
            bool status = AsReaderRFIDDevice.SharedInstance().FrequencyHoppingTable;
        }
        public override void ViewWillDisappear(bool animated)
        {
            base.ViewWillDisappear(animated);
            dockManager.didSetChannelParamReceived = null;
            dockManager.errorReceived = null;
            dockManager.hoppingTableReceived = null;
            dockManager.channelReceived = null;
            olChannel.Text = null;
        }
        partial void rightBarButtonItemClicked(UIButton sender)
        {
            olChannel.ResignFirstResponder();
            int eLength = 0;
            int.TryParse(olChannel.Text, out eLength);
            bool status = AsReaderRFIDDevice.SharedInstance().SetChannel(eLength, 0);
        }
        void DidSetChannelParamReceived(int statusCode)
        {
            if (statusCode == 0)
            {
                Utils.ShowAlert("", "Changed Channel Data", this);
            }
        }
        void ErrorReceived(NSData errorCode)
        {
            string strError = "Error" + errorCode.ToString();
            Utils.ShowAlert("", strError, this);
        }
        void HoppingTableReceived(NSData table)
        {
            NSMutableString strChannel = new NSMutableString();
            byte[] ptr = new byte[table.Length];
            Marshal.Copy(table.Bytes, ptr, 0, Convert.ToInt32(table.Length));
            int nLen = ptr[0];
            for (int i = 1; i < nLen + 1; i++)
            {
                strChannel.Append((NSString)ptr[i].ToString());
                strChannel.Append((NSString)",");
            }
            olChannelInfo.Text = strChannel;
        }
        void ChannelReceived(int channel, int channelOffset)
        {
            olChannel.Text = channel.ToString();
        }
    }
}
