// This file has been autogenerated from a class added in the UI designer.

using System;
using AsReaderDock4;
using Foundation;
using UIKit;

namespace AsReaderDock_VS
{
    public partial class SensorViewController : UIViewController
    {
        AsReaderDockManager dockManager = AsReaderDockManager.sharedInstance();
        int nTagCount;
        int nScanTime;
        int nCycle;
        NSMutableArray arrayItems;
        RFMManager rfmManager;
        public static int AllTag = 0x00;
        public static int S3 = 0x03;
        public static int S2 = 0x02;

        public SensorViewController(IntPtr handle) : base(handle)
        {
        }
        public override void ViewDidLoad()
        {
            base.ViewDidLoad();

            tableView.DataSource = new MyTableViewSource(this);
            rfmManager = new RFMManager();
            arrayItems = new NSMutableArray();
            tableView.RowHeight = 100;
            UITapGestureRecognizer gestureRecognizer = new UITapGestureRecognizer(this, new ObjCRuntime.Selector("hideKeyboard"));
            gestureRecognizer.NumberOfTapsRequired = 1;
            gestureRecognizer.CancelsTouchesInView = false;
            tableView.AddGestureRecognizer(gestureRecognizer);
        }
        public override void ViewWillAppear(bool animated)
        {
            base.ViewWillAppear(animated);
            dockManager.pcEpcSensorDataReceived = PcEpcSensorDataReceived;
            bool status = AsReaderRFIDDevice.SharedInstance().RFIDModuleVersion;
            btnStartRead.Enabled = true;
            btnClear.Enabled = true;
            btnStop.Enabled = true;
        }
        public override void ViewWillDisappear(bool animated)
        {
            base.ViewWillDisappear(animated);
            bool status = AsReaderRFIDDevice.SharedInstance().StopScan;
            dockManager.pcEpcSensorDataReceived = null;
        }
        partial void clearBtnAction(UIButton sender)
        {
            arrayItems.RemoveAllObjects();
            tableView.ReloadData();
        }

        partial void stopBtnAction(UIButton sender)
        {
            bool status = AsReaderRFIDDevice.SharedInstance().StopScan;
            btnStop.Enabled = false;
            btnStartRead.Enabled = true;
            btnClear.Enabled = true;
        }
        partial void startBtnAction(UIButton sender)
        {
            int rssi = 0;
            int.TryParse(txtFRSSI.Text, out rssi);
            int wet = 0;
            int.TryParse(txtFWet.Text, out wet);
            if (rssi < 0 || rssi > 31)
            {
                Utils.ShowAlert("", "Check the input range RSSI : (0~31)", this);
                return;
            }
            rfmManager.setFilterRSSI(rssi, wet);
            btnStartRead.Enabled = false;
            btnClear.Enabled = false;
            btnStop.Enabled = true;
            AsReaderRFIDDevice.SharedInstance().StartReadTagsRFM(AllTag, nTagCount, nScanTime, nCycle);
        }
        [Export("hideKeyboard")]
        void hideKeyboard()
        {
            this.View.EndEditing(true);
        }
        void PcEpcSensorDataReceived(NSData pcEpc, NSData sensorData, int rssi)
        {
            RFMSensorItem item = rfmManager.parseData(pcEpc, sensorData, rssi);
            if (item == null)
            {
                return;
            }
            bool isNew = true;
            for (nuint i = 0; i < arrayItems.Count; i++)
            {
                RFMSensorItem oldItem = arrayItems.GetItem<RFMSensorItem>(i);
                if (item.pcEpc == oldItem.pcEpc)
                {
                    oldItem.sensorData = item.sensorData;
                    oldItem.cop = item.cop;
                    oldItem.cfq = item.cfq;
                    oldItem.ct = item.ct;
                    oldItem.cd = item.cd;
                    oldItem.temperature = item.temperature;
                    oldItem.moisture = item.moisture;
                    oldItem.moistureResult = item.moistureResult;
                    oldItem.rssi = item.rssi;
                    oldItem.count = oldItem.count + 1;
                    arrayItems.ReplaceObject((int)i, oldItem);
                    isNew = false;
                    break;
                }
            }
            if (isNew)
            {
                item.count = item.count + 1;
                arrayItems.Add(item);
            }
            tableView.ReloadData();
        }
        class MyTableViewSource : UITableViewDataSource
        {
            SensorViewController currentViewContorller;
            public MyTableViewSource(SensorViewController controller)
            {
                currentViewContorller = controller;
            }

            public override nint NumberOfSections(UITableView tableView)
            {
                return 1;
            }

            public override nint RowsInSection(UITableView tableView, nint section)
            {
                return (nint)currentViewContorller.arrayItems.Count;
            }

            public override UITableViewCell GetCell(UITableView tableView, NSIndexPath indexPath)
            {
                RFMItemCell cell = (RFMItemCell)tableView.DequeueReusableCell("RFMCell", indexPath);
                int row = (int)indexPath.Row;
                RFMSensorItem item = currentViewContorller.arrayItems.GetItem<RFMSensorItem>((nuint)row);
                cell.labelEPC.Text = item.pcEpc;
                cell.labelMois.Text = item.moisture + " [" + item.moistureResult + "]";
                cell.labelTemp.Text = item.temperature;
                cell.labelEtc.Text = item.ct + " " + item.cfq + " " + item.cop + "  [RSSI:" + item.rssi + "]";
                cell.labelCount.Text = item.count.ToString();
                return cell;
            }
        }
    }
}
