// This file has been autogenerated from a class added in the UI designer.

using System;
using AsReaderDock4;
using Foundation;
using UIKit;

namespace AsReaderDock_VS
{
	public partial class SessionController : UITableViewController
	{
        NSMutableArray powerArray;
        int session;
        AsReaderDockManager dockManager = AsReaderDockManager.sharedInstance();

		public SessionController (IntPtr handle) : base (handle)
		{
		}
        public override void ViewDidLoad()
        {
            base.ViewDidLoad();
            session = -1;
        }
        public override void ViewWillAppear(bool animated)
        {
            base.ViewWillAppear(animated);
            dockManager.sessionReceived = SessionReceived;
            dockManager.didSetSession = DidSetSession;
            bool statu = AsReaderRFIDDevice.SharedInstance().Session;
        }
        public override void ViewWillDisappear(bool animated)
        {
            base.ViewWillDisappear(animated);
            dockManager.sessionReceived = null;
            dockManager.didSetSession = null;
        }
        partial void rightBarButtonItemClicked(UIButton sender)
        {
            if (session == -1)
            {
                AsReaderRFIDDevice.SharedInstance().SetSession(0);
                session = 0;
            }
            else
            {
                AsReaderRFIDDevice.SharedInstance().SetSession(session);
            }
            string strMessage = "Set Session" + ":" + session.ToString();
            Utils.ShowAlert("1) Update Registry \n2) Reset Hardware", strMessage, this);
        }
        void SessionReceived(int sessions)
        {
            session = sessions;
            TableView.ReloadData();
        }
        void DidSetSession(int status)
        {
            if (status == 0)
            {
                Utils.ShowAlert("", "Changed Session", this);
            }
        }
        public override nint NumberOfSections(UITableView tableView)
        {
            return 1;
        }
        public override nint RowsInSection(UITableView tableView, nint section)
        {
            return 4;
        }
        public override UITableViewCell GetCell(UITableView tableView, NSIndexPath indexPath)
        {
            UITableViewCell cell = (UITableViewCell)tableView.DequeueReusableCell("Cell", indexPath);
            cell.TextLabel.Text = "S" + indexPath.Row.ToString();
            if (session == indexPath.Row)
            {
                cell.Accessory = UITableViewCellAccessory.Checkmark;
            }
            else
            {
                cell.Accessory = UITableViewCellAccessory.None;
            }
            return cell;
        }
        public override void RowSelected(UITableView tableView, NSIndexPath indexPath)
        {
            session = indexPath.Row;
            TableView.ReloadData();
        }
    }
}
