// This file has been autogenerated from a class added in the UI designer.

using System;
using AsReaderDock4;
using Foundation;
using UIKit;

namespace AsReaderDock_VS
{
	public partial class SettingsFhLbtController : UIViewController
	{
		AsReaderDockManager dockManager = AsReaderDockManager.sharedInstance();

		public SettingsFhLbtController (IntPtr handle) : base (handle)
		{
		}
        public override void ViewDidLoad()
        {
            base.ViewDidLoad();
        }
        public override void ViewWillAppear(bool animated)
        {
            dockManager.onOffTimeChanged = OnOffTimeChanged;
            olOnTime.Text = AsReaderInfo.SharedInstance().RfidOnTime.ToString();
            olOffTime.Text = AsReaderInfo.SharedInstance().RfidOffTime.ToString();
            olOnTime.Delegate = new SettingsFhLbtDelegate(this);
            olOffTime.Delegate = new SettingsFhLbtDelegate(this);
        }
        public override void ViewWillDisappear(bool animated)
        {
            base.ViewWillDisappear(animated);
            dockManager.onOffTimeChanged = null;
            olOnTime.Text = null;
            olOffTime.Text = null;
        }
        partial void rightBarButtonItemClicked(UIButton sender)
        {
            olOnTime.ResignFirstResponder();
            olOffTime.ResignFirstResponder();
            int nSetOnTime = 0;
            int.TryParse(olOnTime.Text, out nSetOnTime);
            int nSetOffTime = 0;
            int.TryParse(olOffTime.Text, out nSetOffTime);
            AsReaderRFIDDevice.SharedInstance().SetReadTime(nSetOnTime, nSetOffTime);
        }
        void OnOffTimeChanged()
        {
            Utils.ShowAlert("", "On/OFF Time Changed", this);
        }
        private class SettingsFhLbtDelegate : UITextFieldDelegate
        {
            SettingsFhLbtController currentViewContorller;
            public SettingsFhLbtDelegate(SettingsFhLbtController controller)
            {
                currentViewContorller = controller;
            }
            public override bool ShouldChangeCharacters(UITextField textField, NSRange range, string replacementString)
            {
                int i = int.Parse(textField.Text + replacementString);
                if (i >= 40000)
                {
                    textField.Text = "40000";
                    return false;
                }
                return true; ;
            }
        }
    }
}
