// This file has been autogenerated from a class added in the UI designer.

using System;
using AsReaderDock4;
using Foundation;
using UIKit;

namespace AsReaderDock_VS
{
	public partial class SettingsPopController : UITableViewController
	{
        public static string KEY_SETTING_SYMBOLOGY_PREFIX_ENABLE = "keySettingSymbologyPrefixEnable";
        public static string KEY_SETTING_CUSTOM_PREFIX_ENABLE = "keySettingCustomPrefixEnable";
        public static string KEY_SETTING_CUSTOM_SUFFIX_ENABLE = "keySettingCustomSuffixEnable";
        public static string KEY_SETTING_CUSTOM_PREFIX_VALUE = "keySettingCustomPrefixValue";
        public static string KEY_SETTING_CUSTOM_SUFFIX_VALUE = "keySettingCustomSuffixValue";
        
        AsReaderDockManager dockManager = AsReaderDockManager.sharedInstance();

        public SettingsPopController (IntPtr handle) : base (handle)
		{
		}
        public override void ViewDidLoad()
        {
            base.ViewDidLoad();
            showHideCell();
        }
        public override void ViewWillAppear(bool animated)
        {
            base.ViewWillAppear(animated);
            dockManager.receiveFactoryReset = ReceiveFactoryReset;
            dockManager.ackUserCommandReceived = AckUserCommandReceived;
            customPrefixField.ShouldReturn = (customPrefixField) =>
            {
                return ShouldReturn();
            };
            customSuffixField.ShouldReturn = (customSuffixField) =>
            {
                return ShouldReturn();
            };
            olUserCommand.ShouldReturn = (olUserCommand) =>
            {
                return ShouldReturn();
            };

            bool isAutoPower = NSUserDefaults.StandardUserDefaults.BoolForKey("AutoPowerOn");
            bool isDefaultTriggerOn = NSUserDefaults.StandardUserDefaults.BoolForKey("DefaultTriggerOn");
            bool isBeepOn = NSUserDefaults.StandardUserDefaults.BoolForKey("beep");
            bool isVirbOn = NSUserDefaults.StandardUserDefaults.BoolForKey("vibration");
            bool isLedOn = NSUserDefaults.StandardUserDefaults.BoolForKey("led");
            bool isIllumOn = NSUserDefaults.StandardUserDefaults.BoolForKey("illumination");
            bool isPowerOnBeep = NSUserDefaults.StandardUserDefaults.BoolForKey("powerOnBeep");

            bool enableCustomPrefix = NSUserDefaults.StandardUserDefaults.BoolForKey(KEY_SETTING_CUSTOM_PREFIX_ENABLE);
            bool enableCustomSuffix = NSUserDefaults.StandardUserDefaults.BoolForKey(KEY_SETTING_CUSTOM_SUFFIX_ENABLE);
            string customPrefixValue = NSUserDefaults.StandardUserDefaults.StringForKey(KEY_SETTING_CUSTOM_PREFIX_VALUE);
            string customSuffixValue = NSUserDefaults.StandardUserDefaults.StringForKey(KEY_SETTING_CUSTOM_SUFFIX_VALUE);
            bool enableSymbologyPrefix = NSUserDefaults.StandardUserDefaults.BoolForKey(KEY_SETTING_SYMBOLOGY_PREFIX_ENABLE);
            customPrefixSwitch.On = enableCustomPrefix;
            customSuffixSwitch.On = enableCustomSuffix;
            if (customPrefixValue == null || customPrefixValue == "")
            {
                customPrefixField.Text = "01";
            }
            else
            {
                customPrefixField.Text = customPrefixValue;
            }
            if (customSuffixValue == null || customSuffixValue == "")
            {
                customSuffixField.Text = "01";
            }
            else
            {
                customSuffixField.Text = customSuffixValue;
            }
            olSymbologyPrefix.On = enableSymbologyPrefix;
            olPowerOnBeep.On = isPowerOnBeep;
            olBeep.On = isBeepOn;
            olVibration.On = isVirbOn;
            olLED.On = isLedOn;
            olIllumination.On = isIllumOn;
            olDefaultTriggerOn.On = isDefaultTriggerOn;
            olAutoPower.On = isAutoPower;
        }
        public override void ViewWillDisappear(bool animated)
        {
            base.ViewWillDisappear(animated);
            dockManager.receiveFactoryReset = null;
            dockManager.ackUserCommandReceived = null;
        }
        partial void eBeepChanged(UISwitch sender)
        {
            saveSettingVal();
        }
        partial void eVibrationChanged(UISwitch sender)
        {
            saveSettingVal();
        }
        partial void eLEDChanged(UISwitch sender)
        {
            saveSettingVal();
        }
        partial void eIlluminationChanged(UISwitch sender)
        {
            saveSettingVal();
        }
        partial void eAutoPower(UISwitch sender)
        {
            NSUserDefaults.StandardUserDefaults.SetBool(sender.On, "AutoPowerOn");
            NSUserDefaults.StandardUserDefaults.Synchronize();
        }
        partial void ePowerOnBeep(UISwitch sender)
        {
            saveSettingVal();
            if (olPowerOnBeep.On == true)
            {
                AsReaderBarcodeDevice.SharedInstance().SetBarcodeEngineUserCommand("BEPPWR1.");
            }
            else
            {
                AsReaderBarcodeDevice.SharedInstance().SetBarcodeEngineUserCommand("BEPPWR0.");
            }
        }
        partial void eChargingControl(UISwitch sender)
        {
            AsReaderBarcodeDevice.SharedInstance().SetChargingControl(sender.On);
            saveSettingVal();
        }
        partial void eTriggerDefault(UISwitch sender)
        {
            AsReaderDevice.SetTriggerModeDefault(sender.On);
            NSUserDefaults.StandardUserDefaults.SetBool(sender.On, "DefaultTriggerOn");
            NSUserDefaults.StandardUserDefaults.Synchronize();
        }
        partial void customPrefix(UISwitch sender)
        {
            NSUserDefaults ud = NSUserDefaults.StandardUserDefaults;
            ud.SetBool(sender.On, KEY_SETTING_CUSTOM_PREFIX_ENABLE);
            ud.SetString(customPrefixField.Text, KEY_SETTING_CUSTOM_PREFIX_VALUE);
            NSUserDefaults.StandardUserDefaults.Synchronize();
            if (sender.On == true)
            {
                AsReaderBarcodeDevice.SharedInstance().SetCustomPrefix(customPrefixField.Text.ToString());
            }
            else
            {
                bool stop = AsReaderBarcodeDevice.SharedInstance().SetDisableCustomPrefix;
            }
        }
        partial void customSuffix(UISwitch sender)
        {
            NSUserDefaults ud = NSUserDefaults.StandardUserDefaults;
            ud.SetBool(sender.On, KEY_SETTING_CUSTOM_SUFFIX_ENABLE);
            ud.SetString(customSuffixField.Text, KEY_SETTING_CUSTOM_SUFFIX_VALUE);
            NSUserDefaults.StandardUserDefaults.Synchronize();
            if (sender.On == true)
            {
                AsReaderBarcodeDevice.SharedInstance().SetCustomSuffix(customSuffixField.Text.ToString());
            }
            else
            {
                bool stop = AsReaderBarcodeDevice.SharedInstance().SetDisableCustomSuffix;
            }
        }
        partial void eSymbologyPrefix(UISwitch sender)
        {
            NSUserDefaults ud = NSUserDefaults.StandardUserDefaults;
            ud.SetBool(sender.On, KEY_SETTING_SYMBOLOGY_PREFIX_ENABLE);
            NSUserDefaults.StandardUserDefaults.Synchronize();
            if (sender.On == true)
            {
                bool stop = AsReaderBarcodeDevice.SharedInstance().SetSymbologyPrefix;
            }
            else
            {
                bool stop = AsReaderBarcodeDevice.SharedInstance().SetDisableSymbologyPrefix;
            }
        }
        partial void eFactoryReset(UIButton sender)
        {
            Utils.ShowAlert("", "Completed Factory Reset",this);
            bool stop = AsReaderBarcodeDevice.SharedInstance().DoFactoryReset;
        }
        partial void eChangeUserCommand(UISegmentedControl sender)
        {
            if (sender.SelectedSegment == 0)
            {
                olUserCommand.Text =@"PAPHHF.";
            }
            else if (sender.SelectedSegment == 1)
            {
                olUserCommand.Text =@"TRGMOD3.";
            }
        }
        partial void eSetUserCommand(UIButton sender)
        {
            string strCmd = olUserCommand.Text;
            if (strCmd.Length < 1)
            {
                Utils.ShowAlert("Error", "Please check User command", this);
                return;
            }
            AsReaderBarcodeDevice.SharedInstance().SetBarcodeEngineUserCommand(strCmd);
        }
        public void getDeviceInfo()
        {
            AsReaderBarcodeDevice.SharedInstance().GetReaderInfo(0);
        }
        public void saveSettingVal()
        {
            AsReaderBarcodeDevice.SharedInstance().SetBeep(olBeep.On, olVibration.On, olIllumination.On, olLED.On);
            NSUserDefaults.StandardUserDefaults.SetBool(olBeep.On, "beep");
            NSUserDefaults.StandardUserDefaults.SetBool(olIllumination.On, "illumination");
            NSUserDefaults.StandardUserDefaults.SetBool(olVibration.On, "vibration");
            NSUserDefaults.StandardUserDefaults.SetBool(olLED.On, "led");
            NSUserDefaults.StandardUserDefaults.SetBool(olPowerOnBeep.On, "powerOnBeep");
            NSUserDefaults.StandardUserDefaults.SetBool(customPrefixSwitch.On, KEY_SETTING_CUSTOM_PREFIX_ENABLE);
            NSUserDefaults.StandardUserDefaults.SetBool(customSuffixSwitch.On, KEY_SETTING_CUSTOM_SUFFIX_ENABLE);
            NSUserDefaults.StandardUserDefaults.SetString(customPrefixField.Text, KEY_SETTING_CUSTOM_PREFIX_VALUE);
            NSUserDefaults.StandardUserDefaults.SetString(customSuffixField.Text, KEY_SETTING_CUSTOM_SUFFIX_VALUE);
            NSUserDefaults.StandardUserDefaults.SetBool(olSymbologyPrefix.On, KEY_SETTING_SYMBOLOGY_PREFIX_ENABLE);
            NSUserDefaults.StandardUserDefaults.Synchronize();
        }
        public void showHideCell()
        {
            AsReaderInfo info = AsReaderInfo.SharedInstance();
            string strModel = info.DeviceModelNumber;
            NSString hardWareString = (NSString)info.DeviceHardware;
            if (!(strModel == "ASR-010D" || strModel == "ASR-010D-V2" || strModel == "ASR-020D" || strModel == "ASR-020D-V2" ||
                  strModel == "ASR-022D" || strModel == "ASR-022D-V2U" || strModel == "ASR-030D" || strModel == "ASR-030D-V3" ||
                strModel == "ASR-031D" || strModel.Contains("ASR-034B") || (strModel.Contains("ASR -023") && hardWareString.HasPrefix((NSString)"2."))))
            {
                olCellChargingControl.Hidden = true;
            }
            if (!(strModel == "ASR-0230D"
                 ||strModel == "ASR -0231D"
                 ||strModel == "ASR -0240D"
                 ||strModel == "ASR-022D"
                 || strModel == "ASR-022D-V2U"
                 || strModel == "ASR-030D"
                 || strModel == "ASR-030D-V3"
                 || strModel == "ASR-031D"
                 || strModel.Contains("034B")
                 ||strModel.Contains("ASR-023")))
            {
                olCellDefaultTrigger.Hidden = true;
            }
            if (!(strModel == "ASR-0230D"
                 || strModel == "ASR-0231D"
                 || strModel == "ASR-0240D"
                 || strModel == "ASR-022D"
                 || strModel == "ASR-022D-V2U"
                 || strModel.Contains("ASR - 023")))
            {
                customPrefixCell.Hidden = true;
                customSuffixCell.Hidden = true;
                symbologyPrefixCell.Hidden = true;
                olCellFactory.Hidden = true;
                olCellBarcodeUserCommand.Hidden = true;
            }
            else
            {
                if (info.CurrentReaderMode == ReaderMode.Rfid)
                {
                    customPrefixCell.Hidden = true;
                    customSuffixCell.Hidden = true;
                    symbologyPrefixCell.Hidden = true;
                    olCellFactory.Hidden = true;
                    olCellBarcodeUserCommand.Hidden = true;

                }
                else if (info.CurrentReaderMode == ReaderMode.Nfc)
                {
                    customPrefixCell.Hidden = true;
                    customSuffixCell.Hidden = true;
                    symbologyPrefixCell.Hidden = true;
                    olCellFactory.Hidden = true;
                    olCellBarcodeUserCommand.Hidden = true;
                }
            }
        }
        void ReceiveFactoryReset(int status)
        {
            switch (status)
            {
                case 0x00:
                    Utils.ShowAlert("", "Res : Doing Reset .... ", this);
                    break;
                case 0xFF:
                    Utils.ShowAlert("", "Completed Factory Reset for Barcode", this);
                    break;
                default:
                    break;
            }
        }
        void AckUserCommandReceived(NSData rawData)
        {
            NSString ackCommand = NSString.FromData(rawData, NSStringEncoding.ASCIIStringEncoding);
            Utils.ShowAlert("Ack from Barcode engine", ackCommand, this);
        }
        bool ShouldReturn()
        {
            return true;
        }
        public override string TitleForHeader(UITableView tableView, nint section)
        {
            AsReaderInfo info = AsReaderInfo.SharedInstance();
            string modelNumber = info.DeviceModelNumber;
            NSString hardWareString = (NSString)info.DeviceHardware;
            switch (section)
            {
                case 0:
                    return "Common funtions";
                case 1:
                    if (!(modelNumber == "ASR-010D" ||
        
                         modelNumber == "ASR-010D-V2" ||
        
                         modelNumber == "ASR-020D" ||
        
                         modelNumber == "ASR-020D-V2" ||
        
                         modelNumber == "ASR-022D" ||
        
                         modelNumber == "ASR-022D-V2U" ||
        
                         modelNumber == "ASR-030D" ||
        
                         modelNumber == "ASR-030D-V3" ||
        
                         modelNumber == "ASR-031D" ||
        
                         modelNumber.Contains("034B") ||
                         (modelNumber.Contains("ASR-023") && hardWareString.HasPrefix((NSString)"2."))))
                    {
                        return "";
                    }
                    else
                    {
                        return "Charging control";
                    }

                case 2:
                    if (!(modelNumber == "ASR-0230D"
                         ||modelNumber == "ASR-0231D"
                         ||modelNumber == "ASR-0240D"
                         ||modelNumber == "ASR-022D"
                         ||modelNumber == "ASR-022D-V2U"
                         ||modelNumber == "ASR-030D"
                         ||modelNumber == "ASR-030D-V3"
                         ||modelNumber == "ASR-031D"
                         ||modelNumber.Contains("034B")
                         ||modelNumber.Contains("ASR-023")))
                    {
                        return "";
                    }
                    else
                    {
                        return "Default Trigger ";
                    }

                case 3:
                    if (!(modelNumber == "ASR-0230D"
                         ||modelNumber == "ASR-0231D"
                         ||modelNumber == "ASR-0240D"
                         ||modelNumber == "ASR-022D"
                         ||modelNumber == "ASR-022D-V2U"
                         ||modelNumber.Contains("ASR-023")))
                    {
                        return "";
                    }
                    else
                    {
                        if (info.CurrentReaderMode == ReaderMode.Rfid)
                        {
                            return "";
                        }
                        else if (info.CurrentReaderMode == ReaderMode.Nfc)
                        {
                            return "";
                        }
                        else
                        {
                            return "Barcode Control";
                        }
                    }

                default:
                    return "";
            }
        }
    }
}
