// This file has been autogenerated from a class added in the UI designer.

using System;
using AsReaderDock4;
using Foundation;
using UIKit;

namespace AsReaderDock_VS
{
	public partial class SettingsPowerController : UITableViewController
	{
		NSMutableArray powerArray;
		int powerLevel;
        AsReaderDockManager dockManager = AsReaderDockManager.sharedInstance();

        public SettingsPowerController (IntPtr handle) : base (handle)
		{
		}
        public override void ViewDidLoad()
        {
            base.ViewDidLoad();
            if (powerArray == null)
            {
                powerArray = new NSMutableArray();
            }
            int nMin = (int)AsReaderInfo.SharedInstance().RfidPowerMin;
            int nMAX = (int)AsReaderInfo.SharedInstance().RfidPowerMax;
            for (int i = nMin; i <= nMAX; i = i + 5)
            {
                NSNumber number = NSNumber.FromNInt(i);
                powerArray.Add(number);
            }
            TableView.ReloadData();
        }
        public override void ViewWillAppear(bool animated)
        {
            base.ViewWillAppear(animated);
            powerLevel = (int)AsReaderInfo.SharedInstance().RfidPower;
            dockManager.didSetOutputPowerLevel = DidSetOutputPowerLevel;
        }
        public override void ViewWillDisappear(bool animated)
        {
            base.ViewWillDisappear(animated);
            dockManager.didSetOutputPowerLevel = null;
        }
        partial void rightBarButtonItemClicked(UIButton sender)
        {
            AsReaderRFIDDevice.SharedInstance().SetOutputPowerLevel(powerLevel);
        }
        void DidSetOutputPowerLevel(int power)
        {
            if (power == 0)
            {
                Utils.ShowAlert("", "Completed TX Power Set", this);
            }
        }
        public override nint NumberOfSections(UITableView tableView)
        {
            return 1;
        }
        public override nint RowsInSection(UITableView tableView, nint section)
        {
            return (nint)powerArray.Count;
        }
        public override UITableViewCell GetCell(UITableView tableView, NSIndexPath indexPath)
        {
            UITableViewCell cell = (UITableViewCell)tableView.DequeueReusableCell("Cell", indexPath);
            NSNumber num = powerArray.GetItem<NSNumber>((nuint)indexPath.Row);
            int ipower = num.Int16Value;
            double power = (double)(ipower / 10.0);
            cell.TextLabel.Text = power.ToString();
            if (powerLevel == ipower)
            {
                cell.Accessory = UITableViewCellAccessory.Checkmark;
            }
            else
            {
                cell.Accessory = UITableViewCellAccessory.None;
            }
            return cell;
        }
        public override void RowSelected(UITableView tableView, NSIndexPath indexPath)
        {
            NSNumber num = powerArray.GetItem<NSNumber>((nuint)indexPath.Row);
            powerLevel = num.Int16Value;
            TableView.ReloadData();
        }
    }
}
