// This file has been autogenerated from a class added in the UI designer.

using System;
using AsReaderDock4;
using Foundation;
using UIKit;

namespace AsReaderDock_VS
{
	public partial class SettingsStopController : UIViewController
	{
		public SettingsStopController (IntPtr handle) : base (handle)
		{
		}
        public override void ViewWillAppear(bool animated)
        {
            base.ViewWillAppear(animated);
            int nTagCount = AsReaderInfo.SharedInstance().Count;
            int nScanTime = AsReaderInfo.SharedInstance().ScanTime;
            int nCycle = AsReaderInfo.SharedInstance().Cycle;
            olStopTagCount.Text = nTagCount.ToString();
            olStopTime.Text = nScanTime.ToString();
            olStopCycle.Text = nCycle.ToString();
            olStopTagCount.Delegate = new SettingsStopDelegate(this);
            olStopTime.Delegate = new SettingsStopDelegate(this);
            olStopCycle.Delegate = new SettingsStopDelegate(this);
        }
        public override void ViewWillDisappear(bool animated)
        {
            base.ViewWillDisappear(animated);
        }
        partial void rightBarButtonItemClicked(UIButton sender)
        {
            olStopTagCount.ResignFirstResponder();
            olStopTime.ResignFirstResponder();
            olStopCycle.ResignFirstResponder();
            int stopTagCount = 0;
            int.TryParse(olStopTagCount.Text, out stopTagCount);
            int stopTime = 0;
            int.TryParse(olStopTime.Text, out stopTime);
            int stopCycle = 0;
            int.TryParse(olStopCycle.Text, out stopCycle);
            NSUserDefaults.StandardUserDefaults.SetInt(stopTagCount, "RFIDScanTagCount");
            NSUserDefaults.StandardUserDefaults.SetInt(stopTime, "RFIDScanTagTime");
            NSUserDefaults.StandardUserDefaults.SetInt(stopCycle, "RFIDScanTagInventory");
            AsReaderRFIDDevice.SharedInstance().SetTagCount(stopTagCount, stopTime, stopCycle);
        }
        private class SettingsStopDelegate : UITextFieldDelegate
        {
            SettingsStopController currentViewContorller;
            public SettingsStopDelegate(SettingsStopController controller)
            {
                currentViewContorller = controller;
            }
            public override bool ShouldChangeCharacters(UITextField textField, NSRange range, string replacementString)
            
            {
                int i = int.Parse(textField.Text + replacementString);
                if (textField == currentViewContorller.olStopTagCount || textField == currentViewContorller.olStopTime)
                {
                    if (i < 0 || i > 255)
                    {
                        return false;
                    }
                }
                else if (textField == currentViewContorller.olStopCycle)
                {
                    if (i < 0 || i > 65535)
                    {
                        return false;
                    }
                }
                return true; ;
            }
        } 
    }
}
