// This file has been autogenerated from a class added in the UI designer.

using System;
using AsReaderDock4;
using Foundation;
using UIKit;

namespace AsReaderDock_VS
{
    public partial class TagViewController : UITableViewController
	{
        NSMutableArray _accessoryList;
        ModelSettings model;

        TagAccessController tagAccessController;
        
		public TagViewController (IntPtr handle) : base (handle)
		{
		}

        public void updateData()
        {
            TableView.ReloadData();
        }

        public override void ViewDidLoad()
        {
            base.ViewDidLoad();
            model = ModelSettings.sharedInstance();
            TableView.DataSource = this;
            TableView.Delegate = this;
        }

        public override nint NumberOfSections(UITableView tableView)
        {
            return 1;
        }

        public override nint RowsInSection(UITableView tableView, nint section)
        {
            return (nint)model.m_arReadTagData.Count;
        }

        public override UITableViewCell GetCell(UITableView tableView, NSIndexPath indexPath)
        {
            CustomCell cell = (CustomCell)tableView.DequeueReusableCell("Cell",indexPath);
            if (model.m_arReadTagData.Count == 0) return cell;

            NSDictionary dic = model.m_arReadTagData.GetItem<NSDictionary>((nuint) indexPath.Row);

            cell.tagHex.Text = dic.ObjectForKey(GlobalDefine.df_CELL_TAG_INFO).ToString();
            cell.tagHex.TextColor = UIColor.Black;
            cell.tagCount.Text = dic.ObjectForKey(GlobalDefine.df_CELL_TAG_COUNT).ToString();
            cell.Accessory = UITableViewCellAccessory.None;
            cell.SelectionStyle = UITableViewCellSelectionStyle.None;
            cell.tagRSSI.Hidden = true;
            cell.tagEncoding.Hidden = true;
            NSString s = (NSString)dic.ObjectForKey(GlobalDefine.df_CELL_DATA_TYPE).ToString();
            int dataType = int.Parse(dic.ObjectForKey(GlobalDefine.df_CELL_DATA_TYPE).ToString());

            switch (dataType)
            {
                case (int)ReceiveDataType.Rfid:
                    cell.Accessory = UITableViewCellAccessory.DisclosureIndicator;
                    string strRSSI = dic.ObjectForKey(GlobalDefine.df_CELL_TAG_RSSI).ToString();
                    bool isRSSIOn = NSUserDefaults.StandardUserDefaults.BoolForKey("RSSIOn");

                    if (isRSSIOn && strRSSI.Length > 0)
                    {
                        cell.tagRSSI.Hidden = false;
                        cell.tagRSSI.Text = " RSSI : " + strRSSI;
                    }
                    cell.tagEncoding.Hidden = false;
                    cell.tagEncoding.Text = RainTagHelper.getPC((NSData)dic.ObjectForKey(GlobalDefine.df_CELL_TAG_RAW));
                    cell.tagHex.Text = RainTagHelper.getEPC((NSData)dic.ObjectForKey(GlobalDefine.df_CELL_TAG_RAW));
                    cell.imgType.Image = UIImage.FromBundle("icon_rfid");
                    cell.tagHex.TextColor = UIColor.Black;
                    break;
                case (int)ReceiveDataType.Rfidlf:
                    cell.Accessory = UITableViewCellAccessory.DisclosureIndicator;
                    cell.tagEncoding.Hidden = false;
                    NSDictionary getDic = LFTagParser.SharedInstance().ParseDataByProtocolType((NSData)dic.ObjectForKey(GlobalDefine.df_CELL_TAG_RAW), ProtocolTypeLF.ProtocolTypeLF_FDBX);
                    string natinalCode = getDic.ValueForKey(GlobalDefine.Key_FDBX_NationalCode).ToString();
                    string countryCode = getDic.ValueForKey(GlobalDefine.Key_FDBX_CountryCode).ToString();
                    string statusFlag = getDic.ValueForKey(GlobalDefine.Key_FDBX_StatusFlag).ToString();
                    string animalIndicator = getDic.ValueForKey(GlobalDefine.Key_FDBX_AnimalIndicator).ToString();
                    string reserved = getDic.ValueForKey(GlobalDefine.Key_FDBX_Reserved).ToString();
                    cell.tagEncoding.Text = natinalCode + countryCode + statusFlag + animalIndicator + reserved;
                    cell.imgType.Image = UIImage.FromBundle("icon_rfid");
                    cell.tagHex.TextColor = UIColor.Black;
                    break;

                case (int)ReceiveDataType.Nfc:
                    cell.Accessory = UITableViewCellAccessory.DisclosureIndicator;
                    cell.tagEncoding.Text = " Encoding : " + getEncodingString((NSData)dic.ObjectForKey(GlobalDefine.df_CELL_TAG_RAW));
                    cell.imgType.Image = UIImage.FromBundle("icon_nfc");

                    if (cell.tagHex.Text.Length == 24)
                    {
                        string headerStr = cell.tagHex.Text.Substring(0, 6);
                        if ("010104" == headerStr)
                        {
                            cell.tagHex.TextColor = UIColor.Red;
                            break;
                        }
                    }
                    break;
                case (int)ReceiveDataType.Barcode:
                    cell.Accessory = UITableViewCellAccessory.DisclosureIndicator;
                    cell.imgType.Image = UIImage.FromBundle("icon_barcode");
                    break;

            }
            return cell;
        }

        string getEncodingString(NSData pcEpc)
        {
            int encoding_type = (int)NSUserDefaults.StandardUserDefaults.IntForKey("RFIDEncoding");
            return EpcConverter.toString(encoding_type, pcEpc);
        }

        public override void RowSelected(UITableView tableView, NSIndexPath indexPath)
        {
            model.m_nSelectTagNum = indexPath.Row;
            NSDictionary dic = model.m_arReadTagData.GetItem<NSDictionary>((nuint)indexPath.Row);

            if (AsReaderInfo.SharedInstance().DeviceModelNumber.Contains("L70D") == true){
                NSDictionary getDic = LFTagParser.SharedInstance().ParseDataByProtocolType((NSData)dic.ObjectForKey(GlobalDefine.df_CELL_TAG_RAW), ProtocolTypeLF.ProtocolTypeLF_FDBX);
                string natinalCode = getDic.ValueForKey(GlobalDefine.Key_FDBX_NationalCode).ToString();
                string countryCode = getDic.ValueForKey(GlobalDefine.Key_FDBX_CountryCode).ToString();
                string statusFlag = getDic.ValueForKey(GlobalDefine.Key_FDBX_StatusFlag).ToString();
                string animalIndicator = getDic.ValueForKey(GlobalDefine.Key_FDBX_AnimalIndicator).ToString();
                string reserved = getDic.ValueForKey(GlobalDefine.Key_FDBX_Reserved).ToString();
                NSMutableString allData = new NSMutableString();
                allData.Append((NSString)("NationalCode:" + natinalCode + "\n"));
                allData.Append((NSString)("CountryCode:" + countryCode + "\n"));
                allData.Append((NSString)("StatusFlag:" + statusFlag + "\n"));
                allData.Append((NSString)("AnimalIndicator:" + animalIndicator + "\n"));
                allData.Append((NSString)("Reserved:" + reserved + "\n"));
                UIAlertController alert = UIAlertController.Create("TAG Info", allData.ToString(), UIAlertControllerStyle.Alert);
                UIAlertAction action = UIAlertAction.Create("OK", UIAlertActionStyle.Default, null);
                alert.AddAction(action);
                PresentViewController(alert, true, null);
                return;
            }

            int nDeviceType = int.Parse(dic.ObjectForKey(GlobalDefine.df_CELL_DATA_TYPE).ToString());
            switch (nDeviceType)
            {
                case (int)ReaderMode.Rfid:
                    TagAccessController rfid = (TagAccessController)UIStoryboard.FromName("Main", null).InstantiateViewController("ID_TagAcessView");
                    NavigationController.PushViewController(rfid, true);
                    break;
                case (int)ReaderMode.Barcode:
                    BarcodeViewController bar = (BarcodeViewController)UIStoryboard.FromName("Main", null).InstantiateViewController("ID_BarcodeDetailView");
                    NavigationController.PushViewController(bar, true);
                    break;
                case (int)ReaderMode.Nfc:
                    string tagStr = dic.ObjectForKey(GlobalDefine.df_CELL_TAG_INFO).ToString();
                    if (tagStr.Length == 24)
                    {
                        string headerStr = tagStr.Substring(0, 6);
                        if ("010104" == headerStr)
                        {
                            NFCTableViewController nfc = (NFCTableViewController)UIStoryboard.FromName("Main", null).InstantiateViewController("ID_NFCTableView");
                            NavigationController.PushViewController(nfc, true);
                        }
                    }
                    break;
            }
        }
	}

}
