﻿using System;
using Foundation;
using UIKit;
using System.Text.RegularExpressions;

namespace AsReaderDock_VS
{
    public class Utils
    {
        public static void ShowAlert(string title, string message, UIViewController viewController)
        {
            UIAlertController alert = UIAlertController.Create(title, message, UIAlertControllerStyle.Alert);
            UIAlertAction OK = UIAlertAction.Create("OK", UIAlertActionStyle.Default,null);
            alert.AddAction(OK);
            viewController.PresentViewController(alert, true, null);
        }

        public static bool CheckNumberTextLength(string str, int max, int min)
        {
            if (str == null || str.Length == 0)
            {
                return false;
            }
            if (!Regex.IsMatch(str, @"^\d+$")) return false;
            nint number = str.Length;
            if (number >= min && number <= max) return true;
            return false;
        }

        public static NSData ConvertHexStrToData(string str)
        {
            if ((str.Length % 2) != 0)
                str = "0" + str;
            byte[] returnBytes = new byte[str.Length / 2];
            for (int i = 0; i < returnBytes.Length; i++)
                returnBytes[i] = Convert.ToByte(str.Substring(i * 2, 2), 16);
            return NSData.FromArray(returnBytes);
        }
        public static bool IsCorrectWriteData(string str)
        {
            if (str == null || str.Length == 0)
            {
                return false;
            }
            if (!Regex.IsMatch(str, @"[A-Fa-f0-9]+$")) return false;
            return true;
        }
        public static long hexStringToLong(string str)
        {
            if (IsCorrectWriteData(str) == false)
            {
                return 0;
            }
            long num = Convert.ToInt64(str, 16);
            return num;
        }
    }
}
