//
//  AsReaderBarcodeDevice.h
//  AsReaderDockSDK
//
//  Created by Mikiko on 11/7/24.
//  Copyright © 2024 SPS INC. All rights reserved.
//

#import "AsReaderDevice.h"

typedef NS_ENUM(NSInteger, OCRType){
    OCR_TYPENONE,
    OCR_TYPEA,
    OCR_TYPEB,
    OCR_TYPEAB
};

typedef NS_ENUM(NSInteger, OCRSettingSequence){
    OCR_SEQ_NONE,
    OCR_SEQ_1,
    OCR_SEQ_2,
    OCR_SEQ_3
};

typedef NS_ENUM(NSInteger, CODEId){
    CODEID_NONE,
    CODEID_AIM,
    CODEID_SYMBOL
};

/**
 *  @brief      This is responsible for managing communication with a barcode reader device.
 */
@interface AsReaderBarcodeDevice : AsReaderDevice

+ (instancetype)sharedInstance;

// for backward compatibility section

// DO NOT USE THIS. deprecated. 
// please use the startScan:readUntilInSec instead.
- (BOOL)startAutoScan __deprecated_msg("use the startScan:readUntilInSec instead.");

// DO NOT USE THIS. deprecated. 
// please use the startScan:readUntilInSec instead.
- (BOOL)startScan __deprecated_msg("use the startScan:readUntilInSec instead.");
// ////////////////////////////////////////


/**
 *  @brief      Start Barcode Scan
 *  @details    Start a tag (Barcode) read operation,
 *  @return     YES
 */
- (BOOL)startScan:(uint8_t) numberOfTags readUntilInSec:(uint8_t) readUntilInSec;


/**
 *  @brief      Send the "Stop Scan" command to the reader
 *  @details    Stop a read operation
 *  @return     YES
 */
- (BOOL)stopScan;

/**
 *  @brief      Barcode module Factory reset
 *  @details    Reset Barcode module to Factory settings
 *  @return     YES
 */
- (BOOL)doFactoryReset;

- (BOOL)sendBarcodeSettingData:(NSData*)sendData;
/**
 *  @brief      Send the "Barcode Setting" command to the reader
 *  @details    Set illumination
 *  @param      sendData : To turn illumination on, sendData value is converted from String "SCNAIM2." to Byte
 : To turn illumination off, sendData value is converted from String "SCNAIM0." to Byte
 *  @return     YES
 */
- (BOOL)sendBarcodeHoneywellSettingWithData:(NSData*)sendData;

- (BOOL)setCustomPrefix:(NSString *)prefix;
- (BOOL)setDisableCustomPrefix;
- (BOOL)setCustomSuffix:(NSString *)suffix;
- (BOOL)setDisableCustomSuffix;

/**
 *  @brief      Send the "Barcode Setting" command about SymbologyPrefix to the reader
 *  @details    setSymbologyPrefix
 *  @return     YES (Sucess) / NO (Not suport fuction or Not Selected Barcode)
 */
- (BOOL)setSymbologyPrefix;
- (BOOL)setDisableSymbologyPrefix;
- (BOOL)setBarcodeEngineUserCommand:(NSString *)command;

#pragma MARK

//API for M24D
/**
 *  @brief      Start Barcode Scan (Presentation Mode) for M24D
 *  @details    Start a tag (Barcode) read operation,
 *  @return     YES
 */



- (BOOL)setCodeID: (CODEId)type isBeepOn:(BOOL)isBeepOn;



- (BOOL)setOCRType: (OCRType)type isBeepOn:(BOOL)isBeepOn;

- (BOOL)setAndroidHIDEnable: (BOOL)isOn;

- (BOOL)setiOSHIDEnable: (BOOL)isOn;

- (BOOL)setPresentationMode: (BOOL)isOn isBeepOn:(BOOL)isBeepOn;

- (BOOL)getCodeID;



- (BOOL)getOCR;

- (BOOL)getHID;

- (BOOL)getSymbologies;

- (BOOL)setSsiParamWithData:(NSData *)symbolData beepOn:(BOOL)beepOn;

- (BOOL)setSsiParamWithDictionary:(NSDictionary*)symbologies beepOn:(BOOL)beepOn;

- (BOOL)getPresentationMode;



- (BOOL)getSecurity;
//- (void)test;

//025S
/**
 *  @brief      Send the "Get sleep buzzer" command to the reader(ASR-025S)
 *  @return     Returns NO if selected mode of reader is not BARCODE, YES otherwise
 */
- (BOOL)getSleepBuzzer;
/**
 *  @brief      Send the "Set sleep buzzer"" command to the reader(ASR-025S)
 *  @param      sleepBuzzer :   On(1), Off(0)
 *  @return     Returns NO if selected mode of reader is not BARCODE, YES otherwise
 */
- (BOOL)setSleepBuzzer:(BOOL)sleepBuzzer;
/**
 *  @brief      Send the "Get auto off time" command to the reader(025S)
 *  @return     Returns NO if selected mode of reader is not BARCODE, YES otherwise
 */
- (BOOL)getAutoOffTime;
/**
 *  @brief      Send the "Set auto off time" command to the reader(025S)
 *  @param      time :  Auto off time (0~1800s), 0: not sleep
 *  @return     Returns NO if selected mode of reader is not BARCODE, YES otherwise
 */
- (BOOL)setAutoOffTime:(int)time;
/**
 *  @brief      Send the "Get barcode timeout" command to the reader(025S)
 *  @return     Returns NO if selected mode of reader is not BARCODE, YES otherwise
 */
- (BOOL)getBarcodeTimeOut;
/**
 *  @brief      Send the "Set barcode timeout" command to the reader(025S)
 *  @param      timeout :  Barcode timeout (4~300s)
 *  @return     Returns NO if selected mode of reader is not BARCODE, YES otherwise
 */
- (BOOL)setBarcodeTimeOut:(int)timeout;
@end
