//
//  AsReaderInfo.h
//  AsReaderDockSDK
//
//  Created by Mikiko on 11/7/24.
//  Copyright © 2024 SPS INC. All rights reserved.
//

#import <Foundation/Foundation.h>
#import "AsReaderInfoDefine.h"

/**
 *  @brief      The AsReaderInfo.m file is an implementation of the AsReaderInfo class in the AsReaderDockSDK. This class manages and provides various device information, pulling data from the ModelInformations class.
 */
@interface AsReaderInfo : NSObject

+ (instancetype)sharedInstance;

@property(readonly,assign) BOOL isShowPrintNSLog;

/*Reader Infomation*/
@property(nonatomic,readonly) NSString *bundleIdentifier;
@property(nonatomic,readonly) NSString *deviceName;
@property(nonatomic,readonly) NSString *deviceFirmware;
@property(nonatomic,readonly) NSString *deviceHardware;
@property(nonatomic,readonly) NSString *deviceID;
@property(nonatomic,readonly) NSString *deviceManufacturer;
@property(nonatomic,readonly) NSString *deviceModelNumber;
@property(nonatomic,readonly) NSString *deviceSerialNumber;
@property(nonatomic,readonly) NSString *deviceProtocol;

@property(readonly,assign) int  currentSelectDevice;
@property(readonly,assign) BOOL isPowerOn;

@property(readonly,assign) ReaderMode supportMode;
@property(readonly,assign) ReaderMode currentReaderMode;
@property(readonly,assign) ReaderMode receiveDataType;

@property(readonly,assign) BOOL dualSameTime;

/*AsReader  Setting */
@property(readonly,assign) BOOL isBeep;
@property(readonly,assign) BOOL isVibration;
@property(readonly,assign) BOOL isLED;
@property(readonly,assign) BOOL isIllumination;
@property(readonly,assign) BOOL isSymbologyPrefix;

@property(readonly,assign) int   count;
@property(readonly,assign) int   scanTime;
@property(readonly,assign) int   cycle;

/*TriggerButtonProperty*/
@property(readonly,assign) BOOL isTriggerModeDefault;
@property(readonly,assign) BOOL isReadRSSIMode;

// options
@property(nonatomic,assign) BOOL isEnginePowerAlwaysOn;

// Barcode
@property(nonatomic,assign) BarcodeEngineType barcodeEngineType;

// RFID
@property(readonly,assign) int   carrierSenseTime;
@property(readonly,assign) int   targetRFPowerLevel;
@property(readonly,assign) BOOL  isSmartHopping;

@property(readonly,assign) float rfidPower;
@property(readonly,assign) float rfidPowerMax;
@property(readonly,assign) float rfidPowerMin;
@property(readonly,assign) int   rfidOnTime;
@property(readonly,assign) int   rfidOffTime;
@property(readonly,assign) int   rfidChannel;
@property(readonly,assign) int   rfidListenBeforeTalk;
@property(readonly,assign) int   rfidFrequencyHopping;
@property(readonly,assign) int   rfidContinuousWave;
@property(nonatomic,readonly) NSString *rfidModuleVersion;


- (BOOL)isSupportType:(ReaderMode)supportType;
- (NSArray *)getSupportTypeArray;

// backward compatibility section
// DO NOT USE THIS. deprecated. please use rfidChannel instead
@property(readonly,assign) int nRFIDchannel __deprecated_msg("use rfidChannel instead.");
// DO NOT USE THIS. deprecated. please use dualSameTime instead
@property(readonly,assign) BOOL  bDualModeOnAndPreFix __deprecated_msg("use dualSameTime instead."); 
// DO NOT USE THIS. obsoleted
@property(readonly,assign) BOOL canUseRFID;
// DO NOT USE THIS. obsoleted
@property(readonly,assign) BOOL canUseBarcode;
// DO NOT USE THIS. obsoleted
@property(readonly,assign) BOOL canUseNFC;
// DO NOT USE THIS. obsoleted
@property(readonly,assign) BOOL canUseLFRFID;
// DO NOT USE THIS. obsoleted
@property(readonly,assign) BOOL canUseLFRFID2;
@end
