enum BarcodeSettings {
  DECODE_MODE_SINGLE,
  DECODE_MODE_CONTINUOUS,
  NOTIS_EDITING,
  CHARACTER_CODE_ID_SYMBOL,
  CHARACTER_CODE_ID_AIM,
  CHARACTER_NONE,
  CHARACTER_GET,
  PREFIX_STATUS,
  TRIGGER_STANDARD,
  TRIGGER_PRESENTATION,
  PRESENTATION_GET,
}

enum QREncodeMode {
  AUTO,
  SHIFT_JIS,
  EUC_KR,
  UTF_8,
  UTF_16,
  UTF_32,
}

enum MemoryType { MEMORY_TYPE_TEMPORARY, MEMORY_TYPE_PERMANENT }

enum SystemBeepSoundType {
  NONE,
  TYPE1,
  TYPE2,
  TYPE3,
  TYPE4,
  TYPE5,
  TYPE6,
  TYPE7,
  TYPE8,
}

enum BarcodeCommandAction {
  UNSET,
  GET_INFO_STOP_CONDITION,
  GET_INFO_CHARACTER_STATUS,
  GET_INFO_SYMBOLOGIES_ENABLE_STATUS,
  GET_INFO_OCR_ENABLE_STATUS,
  GET_INFO_SECURITY_LEVEL_ENABLE_STATUS,
  GET_INFO_SCAN_DATA_TRANSMISSION_FORMAT,
  GET_INFO_SYSTEM_BEEP,
  GET_INFO_CODE_ID_ENABLE,
  GET_INFO_NOTIS_EDITING,
  GET_INFO_PRESENTATION_MODE,
  SETTINGS_CHARACTER_STATUS,
  SETTINGS_SYMBOLOGIES,
  SETTING_OCR,
  SETTING_SECURITY_LEVEL,
  SETTINGS_SYSTEM_BEEP,
  SETTINGS_NOTIS_EDITING,
  SETTINGS_PRESENTATION_MODE,
  FACTORY_DEFAULT,
  FINISH,
}

enum Status {
  SUCCESS,
  FAILED,
}

enum Result {
  UNKNOWN,
  SYSTEM_BEEP_TYPE1,
  SYSTEM_BEEP_TYPE2,
  SYSTEM_BEEP_TYPE3,
  SYSTEM_BEEP_TYPE4,
  SYSTEM_BEEP_TYPE5,
  SYSTEM_BEEP_TYPE6,
  SYSTEM_BEEP_TYPE7,
  SYSTEM_BEEP_TYPE8,
  SYSTEM_BEEP_SOUND_NONE,
  FACTORY_DEFAULT,
  CHARACTER_NONE,
  CHARACTER_SYMBOL,
  CHARACTER_AIM,
  STOP_CONDITIONS_CONTINUOUS_ON,
  STOP_CONDITIONS_CONTINUOUS_OFF,
  SYMBOLOGY_STATUS_GET,
  SYMBOLOGY_STATUS_SET,
  OCR_STATUS_GET,
  OCR_STATUS_SET,
  SECURITY_LEVEL_STATUS_GET,
  SECURITY_LEVEL_STATUS_SET,
  FORMAT_DATA_ONLY,
  FORMAT_DATA_SUFFIX_TYPE1,
  FORMAT_DATA_SUFFIX_TYPE2,
  FORMAT_DATA_SUFFIX_TYPE3,
  FORMAT_PREFIX_DATA,
  FORMAT_PREFIX_DATA_SUFFIX_TYPE1,
  FORMAT_PREFIX_DATA_SUFFIX_TYPE2,
  FORMAT_PREFIX_DATA_SUFFIX_TYPE3,
  NOTIS_EDITING_GET_ENABLED,
  NOTIS_EDITING_GET_DISABLED,
  PRESENTATION_SET,
  PRESENTATION_GET_ENABLED,
  PRESENTATION_GET_DISABLED,
}

enum TriggerMode {
  MANUAL,
  AUTO,
}

enum DeviceTriggerEvent {
  PUSH_NONE,
  PUSH_RIGHT,
  PUSH_LEFT,
}

enum HIDType {
  ANDROID_HID,
  IOS_HID,
  HID_OFF,
  NOT_APPLICABLE,
}

enum OCR {
  OCR_A,
  OCR_B,
}

enum LogLevel {
  Fatal,
  Error,
  Warning,
  Information,
  Debug,
}

enum ConnectionType {
  BLE,
  USB,
}

enum Symbology {
  UPC_A,
  UPC_E,
  UPC_E1,
  EAN13_JAN13,
  EAN8_JAN8,
  BOOK_LAND_EAN,
  ISSN_EAN,
  INTERLEAVED_2_OF_5,
  DISCRETE_2_OF_5,
  CODA_BAR,
  CODE_128,
  CODE_39,
  CODE_93,
  CODE_11,
  MSI,
  CHINESE_2_OF_5,
  MATRIX_2_OF_5,
  KOREAN_2_OF_5,
  GS1_128,
  GS1_DATA_BAR,
  PDF_417,
  MACRO_PDF,
  DATA_MATRIX,
  GS1_DATA_MATRIX,
  QR_CODE,
  JAPAN_POSTAL,
  MICRO_QR_CODE,
  AZTEC,
  COMPOSITE_CC_C,
  COMPOSITE_CC_AB,
  COMPOSITE_TLC_39,
  MAXICODE,
  US_POSTNET,
  US_PLANET,
  UK_POSTAL,
  AUSTRALIA_POST,
  NETHERLAND_KIX_CODE,
}

enum ErrorCode {
  NOT_SUPPORTED,
  WITHOUT_AUTHORITY,
  MEMORY_OVERRUN,
  MEMORY_LOCKED,
  CRYPTO_SUITE_ERROR,
  COMMAND_NOT_ENCAPSULATED,
  RESPONSE_BUFFER_OVERFLOW,
  SECURITY_TIMEOUT,
  INSUFFICIENT_POWER,
  NON_SPECIFIC_ERROR,
  ALREADY_POWER_ON,
  FAILED_TO_SEND_PACKET,
}