import 'package:flutter/foundation.dart';
import 'package:flutter/services.dart';

import 'asreader_m24d_plugin_platform_interface.dart';
import 'asreader_m24d_plugin_define.dart';
import 'package:asreader_m24d_plugin/SymbologyInfoModel.dart';
import 'package:asreader_m24d_plugin/OCRInfoModel.dart';

/// An implementation of [AsreaderM24dPluginPlatform] that uses method channels.
class MethodChannelAsreaderM24dPlugin extends AsreaderM24dPluginPlatform {
  /// The method channel used to interact with the native platform.
  @visibleForTesting
  final methodChannel = const MethodChannel('asreader_m24d_plugin');

  @override
  Future<String?> getPlatformVersion() async {
    final version = await methodChannel.invokeMethod<String>(
      'getPlatformVersion',
    );
    return version;
  }

  @override
  Future<String?> getSDKVersion() async {
    final version = await methodChannel.invokeMethod<String>('getSDKVersion');
    return version;
  }

  @override
  Future<void> setConnectionType(ConnectionType connectionType) async {
    await methodChannel.invokeMethod('setConnectionType', {
      'connectionType': connectionType.index,
    });
  }

  @override
  Future<void> setLogLevel(LogLevel logLevel) async {
    await methodChannel.invokeMethod('setLogLevel', {'logLevel': logLevel.index});
  }

  @override
  Future<LogLevel?> getLogLevel() async {
    final level = await methodChannel.invokeMethod<int>('getLogLevel');
    return LogLevel.values[level!];
  }

  @override
  Future<void> setLog(bool enable) async {
    await methodChannel.invokeMethod('setLog', {'enable': enable});
  }

  @override
  Future<void> removeSDKLog() async {
    await methodChannel.invokeMethod('removeSDKLog');
  }

  @override
  Future<void> enableAutoLaunchApp(bool enable, String aliasName) async {
    await methodChannel.invokeMethod('enableAutoLaunchApp', {
      'enable': enable,
      'aliasName': aliasName,
    });
  }

  @override
  Future<BarcodeSettings?> getCharacterStatus() async {
    final barcodeSettings = await methodChannel.invokeMethod<int>(
      'getCharacterStatus',
    );
    return BarcodeSettings.values[barcodeSettings!];
  }

  @override
  Future<void> setDecodeMode(BarcodeSettings mode) async {
    await methodChannel.invokeMethod('setDecodeMode', {'mode': mode.index});
  }

  @override
  Future<BarcodeSettings?> getDecodeMode() async {
    final barcodeSettings = await methodChannel.invokeMethod<int>(
      'getDecodeMode',
    );
    return BarcodeSettings.values[barcodeSettings!];
  }

  @override
  Future<void> setEncodeMode(QREncodeMode qrEncodeMode) async {
    await methodChannel.invokeMethod('setEncodeMode', {
      'qrEncodeMode': qrEncodeMode.index,
    });
  }

  @override
  Future<QREncodeMode?> getEncodeMode() async {
    final mode = await methodChannel.invokeMethod<int>('getEncodeMode');
    return QREncodeMode.values[mode!];
  }

  @override
  Future<void> startDecode() async {
    await methodChannel.invokeMethod('startDecode');
  }

  @override
  Future<void> startDecodeWithCountTime(int count, int time) async {
    await methodChannel.invokeMethod('startDecodeWithCountTime', {
      'count': count,
      'time': time,
    });
  }

  @override
  Future<void> stopDecode() async {
    await methodChannel.invokeMethod('stopDecode');
  }

  @override
  Future<void> factoryDefault() async {
    await methodChannel.invokeMethod('factoryDefault');
  }

  @override
  Future<void> getStopCondition() async {
    await methodChannel.invokeMethod('getStopCondition');
  }

  @override
  Future<void> setBarcodeSettings(MemoryType memoryType, BarcodeSettings settingsType) async {
    await methodChannel.invokeMethod('setBarcodeSettings', {
      'memoryType': memoryType.index,
      'settingsType': settingsType.index,
    });
  }

  @override
  Future<void> getBarcodeSettings(BarcodeSettings settingsType) async {
    await methodChannel.invokeMethod('getBarcodeSettings', {
      'settingsType': settingsType.index,
    });
  }

  @override
  Future<void> setSymbologyAllEnable(MemoryType memoryType, bool isEnable) async {
    await methodChannel.invokeMethod('setSymbologyAllEnable', {
      'memoryType': memoryType.index,
      'isEnable': isEnable,
    });
  }

  @override
  Future<void> setSymbologySettings(MemoryType memoryType, Symbology symbology, bool isEnable) async {
    await methodChannel.invokeMethod('setSymbologySettings', {
      'memoryType': memoryType.index,
      'symbology': symbology.index,
      'isEnable': isEnable,
    });
  }

  @override
  Future<void> setSymbologyListSettings(MemoryType memoryType, List<SymbologyInfoModel> symbologyInfoList) async {
    List<Map<String, Object>> array = [];
    for (SymbologyInfoModel model in symbologyInfoList) {
      Map<String, Object> symbologyInfoModelMap = {};
      symbologyInfoModelMap["symbology"] = model.symbology.index;
      symbologyInfoModelMap["isEnableStatus"] = model.isEnableStatus;
      array.add(symbologyInfoModelMap);
    }
    await methodChannel.invokeMethod('setSymbologyListSettings', {
      'memoryType': memoryType.index,
      'symbologyInfoList': array,
    });
  }

  @override
  Future<void> setOCRSettings(MemoryType memoryType, OCR ocr, bool isEnable) async {
    await methodChannel.invokeMethod('setOCRSettings', {
      'memoryType': memoryType.index,
      'ocr': ocr.index,
      'isEnable': isEnable,
    });
  }

  @override
  Future<void> setOCRListSettings(MemoryType memoryType, List<OCRInfoModel> ocrInfoList) async {
    List<Map<String, Object>> array = [];
    for (OCRInfoModel model in ocrInfoList) {
      Map<String, Object> ocrInfoModelMap = {};
      ocrInfoModelMap["ocr"] = model.ocr.index;
      ocrInfoModelMap["isEnable"] = model.isEnable;
      array.add(ocrInfoModelMap);
    }
    await methodChannel.invokeMethod('setOCRListSettings', {
      'memoryType': memoryType.index,
      'ocrInfoList': array,
    });
  }

  @override
  Future<void> getSymbologySettings(Symbology symbology) async {
    await methodChannel.invokeMethod('getSymbologySettings', {
      'symbology': symbology.index,
    });
  }

  @override
  Future<void> getSymbologySettingsList(List<Symbology> symbologyList) async {
    List<int> array = [];
    for (Symbology model in symbologyList) {
      array.add(model.index);
    }
    await methodChannel.invokeMethod('getSymbologySettingsList', {
      'symbologyList': array,
    });
  }

  @override
  Future<void> getOCRSettings(OCR ocr) async {
    await methodChannel.invokeMethod('getOCRSettings', {
      'ocr': ocr.index,
    });
  }

  @override
  Future<void> getOCRSettingsList(List<OCR> ocrList) async {
    List<int> array = [];
    for (OCR model in ocrList) {
      array.add(model.index);
    }
    await methodChannel.invokeMethod('getOCRSettingsList', {
      'ocrList': array,
    });
  }

  @override
  Future<SystemBeepSoundType?> getSystemBeep() async {
    final beep = await methodChannel.invokeMethod<int>('getSystemBeep');
    return SystemBeepSoundType.values[beep!];
  }

  @override
  Future<void> setNotisEditing(MemoryType memoryType, bool isEnabled) async {
    await methodChannel.invokeMethod('setNotisEditing', {
      'memoryType': memoryType.index,
      'isEnabled': isEnabled,
    });
  }

  @override
  Future<void> getNotisEditing() async {
    await methodChannel.invokeMethod('getNotisEditing');
  }

  @override
  Future<void> setPresentationMode(MemoryType memoryType, BarcodeSettings settingsType) async {
    await methodChannel.invokeMethod('setPresentationMode', {
      'memoryType': memoryType.index,
      'settingsType': settingsType.index,
    });
  }

  @override
  Future<void> getPresentationMode() async {
    await methodChannel.invokeMethod('getPresentationMode');
  }

  @override
  Future<bool?> isConnected() async {
    final isConnect = await methodChannel.invokeMethod<bool>('isConnected');
    return isConnect;
  }

  @override
  Future<void> setTriggerMode(TriggerMode mode) async {
    await methodChannel.invokeMethod('setTriggerMode', {
      'mode': mode.index,
    });
  }

  @override
  Future<TriggerMode?> getTriggerMode() async {
    final mode = await methodChannel.invokeMethod<int>('getTriggerMode');
    return TriggerMode.values[mode!];
  }

  @override
  Future<bool?> getBackgroundRead() async {
    final read = await methodChannel.invokeMethod<bool>('getBackgroundRead');
    return read;
  }

  @override
  Future<bool?> isOpen() async {
    final open = await methodChannel.invokeMethod<bool>('isConnected');
    return open;
  }

  @override
  Future<void> open() async {
    await methodChannel.invokeMethod('open');
  }

  @override
  Future<void> close() async {
    await methodChannel.invokeMethod('close');
  }

  @override
  Future<void> setReaderSettings(bool beep, bool vib, bool aimer, bool led, bool powerOnBeep) async {
    await methodChannel.invokeMethod('setReaderSettings', {
      'beep': beep,
      'vib': vib,
      'aimer': aimer,
      'led': led,
      'powerOnBeep': powerOnBeep,
    });
  }

  @override
  Future<void> getReaderSettings() async {
    await methodChannel.invokeMethod('getReaderSettings');
  }

  @override
  Future<void> getReaderInfo() async {
    await methodChannel.invokeMethod('getReaderInfo');
  }

  @override
  Future<void> setSleepTime(int sleepTime) async {
    await methodChannel.invokeMethod('setSleepTime', {
      'sleepTime': sleepTime,
    });
  }

  @override
  Future<void> getSleepTime() async {
    await methodChannel.invokeMethod('getSleepTime');
  }

  @override
  Future<void> setSleepBeep(bool isSleepBeepOn) async {
    await methodChannel.invokeMethod('setSleepBeep', {
      'isSleepBeepOn': isSleepBeepOn,
    });
  }

  @override
  Future<void> getSleepBeep() async {
    await methodChannel.invokeMethod('getSleepBeep');
  }

  @override
  Future<void> setSleepTimeAndBeep(int sleepTime, bool isSleepBeepOn) async {
    await methodChannel.invokeMethod('setSleepTimeAndBeep', {
      'sleepTime': sleepTime,
      'isSleepBeepOn': isSleepBeepOn,
    });
  }

  @override
  Future<void> getSleepTimeAndBeep() async {
    await methodChannel.invokeMethod('getSleepTimeAndBeep');
  }

  @override
  Future<void> setHIDMode(HIDType hidMode) async {
    await methodChannel.invokeMethod('setHIDMode', {
      'hidMode': hidMode.index,
    });
  }

  @override
  Future<void> getHIDMode() async {
    await methodChannel.invokeMethod('getHIDMode');
  }
}
