import 'package:plugin_platform_interface/plugin_platform_interface.dart';

import 'asreader_m24d_plugin_method_channel.dart';
import 'asreader_m24d_plugin_define.dart';
import 'package:asreader_m24d_plugin/SymbologyInfoModel.dart';
import 'package:asreader_m24d_plugin/OCRInfoModel.dart';

abstract class AsreaderM24dPluginPlatform extends PlatformInterface {
  /// Constructs a AsreaderM24dPluginPlatform.
  AsreaderM24dPluginPlatform() : super(token: _token);

  static final Object _token = Object();

  static AsreaderM24dPluginPlatform _instance =
      MethodChannelAsreaderM24dPlugin();

  /// The default instance of [AsreaderM24dPluginPlatform] to use.
  ///
  /// Defaults to [MethodChannelAsreaderM24dPlugin].
  static AsreaderM24dPluginPlatform get instance => _instance;

  /// Platform-specific implementations should set this with their own
  /// platform-specific class that extends [AsreaderM24dPluginPlatform] when
  /// they register themselves.
  static set instance(AsreaderM24dPluginPlatform instance) {
    PlatformInterface.verifyToken(instance, _token);
    _instance = instance;
  }

  Future<String?> getPlatformVersion() {
    throw UnimplementedError('platformVersion() has not been implemented.');
  }

  Future<String?> getSDKVersion() {
    throw UnimplementedError('getSDKVersion() has not been implemented.');
  }

  Future<void> setConnectionType(ConnectionType connectionType) {
    throw UnimplementedError('setConnectionType() has not been implemented.');
  }

  Future<void> setLogLevel(LogLevel logLevel) {
    throw UnimplementedError('setLogLevel() has not been implemented.');
  }

  Future<LogLevel?> getLogLevel() {
    throw UnimplementedError('getLogLevel() has not been implemented.');
  }

  Future<void> setLog(bool enable) {
    throw UnimplementedError('setLog() has not been implemented.');
  }

  Future<void> removeSDKLog() {
    throw UnimplementedError('removeSDKLog() has not been implemented.');
  }

  Future<void> enableAutoLaunchApp(bool enable, String aliasName) {
    throw UnimplementedError('enableAutoLaunchApp() has not been implemented.');
  }

  Future<BarcodeSettings?> getCharacterStatus() {
    throw UnimplementedError('getCharacterStatus() has not been implemented.');
  }

  Future<void> setDecodeMode(BarcodeSettings mode) {
    throw UnimplementedError('setDecodeMode() has not been implemented.');
  }

  Future<BarcodeSettings?> getDecodeMode() {
    throw UnimplementedError('getDecodeMode() has not been implemented.');
  }

  Future<void> setEncodeMode(QREncodeMode qrEncodeMode) {
    throw UnimplementedError('setEncodeMode() has not been implemented.');
  }

  Future<QREncodeMode?> getEncodeMode() {
    throw UnimplementedError('getEncodeMode() has not been implemented.');
  }

  Future<void> startDecode() {
    throw UnimplementedError('startDecode() has not been implemented.');
  }

  Future<void> startDecodeWithCountTime(int count, int time) {
    throw UnimplementedError(
      'startDecodeWithCountTime() has not been implemented.',
    );
  }

  Future<void> stopDecode() {
    throw UnimplementedError('stopDecode() has not been implemented.');
  }

  Future<void> factoryDefault() {
    throw UnimplementedError('factoryDefault() has not been implemented.');
  }

  Future<void> getStopCondition() {
    throw UnimplementedError('getStopCondition() has not been implemented.');
  }

  Future<void> setBarcodeSettings(MemoryType memoryType, BarcodeSettings settingsType) {
    throw UnimplementedError('setBarcodeSettings() has not been implemented.');
  }

  Future<void> getBarcodeSettings(BarcodeSettings settingsType) {
    throw UnimplementedError('getBarcodeSettings() has not been implemented.');
  }

  Future<void> setSymbologyAllEnable(MemoryType memoryType, bool isEnable) {
    throw UnimplementedError('setSymbologyAllEnable() has not been implemented.');
  }

  Future<void> setSymbologySettings(MemoryType memoryType, Symbology symbology, bool isEnable) {
    throw UnimplementedError('setSymbologySettings() has not been implemented.');
  }

  Future<void> setSymbologyListSettings(MemoryType memoryType, List<SymbologyInfoModel> symbologyInfoList) {
    throw UnimplementedError('setSymbologyListSettings() has not been implemented.');
  }

  Future<void> setOCRSettings(MemoryType memoryType, OCR ocr, bool isEnable) {
    throw UnimplementedError('setOCRSettings() has not been implemented.');
  }

  Future<void> setOCRListSettings(MemoryType memoryType, List<OCRInfoModel> ocrInfoList) {
    throw UnimplementedError('setOCRListSettings() has not been implemented.');
  }

  Future<void> getSymbologySettings(Symbology symbology) {
    throw UnimplementedError('getSymbologySettings() has not been implemented.');
  }

  Future<void> getSymbologySettingsList(List<Symbology> symbologyList) {
    throw UnimplementedError('getSymbologySettingsList() has not been implemented.');
  }

  Future<void> getOCRSettings(OCR ocr) {
    throw UnimplementedError('getOCRSettings() has not been implemented.');
  }

  Future<void> getOCRSettingsList(List<OCR> ocrList) {
    throw UnimplementedError('getOCRSettingsList() has not been implemented.');
  }

  Future<SystemBeepSoundType?> getSystemBeep() {
    throw UnimplementedError('getSystemBeep() has not been implemented.');
  }

  Future<void> setNotisEditing(MemoryType memoryType, bool isEnabled) {
    throw UnimplementedError('setNotisEditing() has not been implemented.');
  }

  Future<void> getNotisEditing() {
    throw UnimplementedError('getNotisEditing() has not been implemented.');
  }

  Future<void> setPresentationMode(MemoryType memoryType, BarcodeSettings settingsType) {
    throw UnimplementedError('setPresentationMode() has not been implemented.');
  }

  Future<void> getPresentationMode() {
    throw UnimplementedError('getPresentationMode() has not been implemented.');
  }

  Future<bool?> isConnected() {
    throw UnimplementedError('isConnected() has not been implemented.');
  }

  Future<void> setTriggerMode(TriggerMode mode) {
    throw UnimplementedError('setTriggerMode() has not been implemented.');
  }

  Future<TriggerMode?> getTriggerMode() {
    throw UnimplementedError('getTriggerMode() has not been implemented.');
  }

  Future<bool?> getBackgroundRead() {
    throw UnimplementedError('getBackgroundRead() has not been implemented.');
  }

  Future<bool?> isOpen() {
    throw UnimplementedError('isOpen() has not been implemented.');
  }

  Future<void> open() {
    throw UnimplementedError('open() has not been implemented.');
  }

  Future<void> close() {
    throw UnimplementedError('close() has not been implemented.');
  }

  Future<void> setReaderSettings(bool beep, bool vib, bool aimer, bool led, bool powerOnBeep) {
    throw UnimplementedError('setReaderSettings() has not been implemented.');
  }

  Future<void> getReaderSettings() {
    throw UnimplementedError('getReaderSettings() has not been implemented.');
  }

  Future<void> getReaderInfo() {
    throw UnimplementedError('getReaderSettings() has not been implemented.');
  }

  Future<void> setSleepTime(int sleepTime) {
    throw UnimplementedError('setSleepTime() has not been implemented.');
  }

  Future<void> getSleepTime() {
    throw UnimplementedError('getSleepTime() has not been implemented.');
  }

  Future<void> setSleepBeep(bool isSleepBeepOn) {
    throw UnimplementedError('setSleepBeep() has not been implemented.');
  }

  Future<void> getSleepBeep() {
    throw UnimplementedError('getSleepBeep() has not been implemented.');
  }

  Future<void> setSleepTimeAndBeep(int sleepTime, bool isSleepBeepOn) {
    throw UnimplementedError('setSleepTimeAndBeep() has not been implemented.');
  }

  Future<void> getSleepTimeAndBeep() {
    throw UnimplementedError('getSleepTimeAndBeep() has not been implemented.');
  }

  Future<void> setHIDMode(HIDType hidMode) {
    throw UnimplementedError('setHIDMode() has not been implemented.');
  }

  Future<void> getHIDMode() {
    throw UnimplementedError('getHIDMode() has not been implemented.');
  }
}
