﻿using System.Collections.ObjectModel;
using AsReader251GMAUIiOSDemo.Platforms.iOS;
using Foundation;

namespace AsReader251GMAUIiOSDemo;

public partial class BarcodeScanPage : ContentPage
{
    private AsReader251GManager formManager;
    private AsReader251GDelegate asReader251GDelegate;
    private ObservableCollection<ItemData> BarcodeItems = new ObservableCollection<ItemData>();
    public ObservableCollection<ItemData> ItemData { get { return BarcodeItems; } }
    private Dictionary<string, ItemData> dataDic = new Dictionary<string, ItemData>();
    private NSStringEncoding charset;
    int count;

    public BarcodeScanPage()
    {
        InitializeComponent();
        Title = "Barcode Scan";
        count = 0;
        charset = NSStringEncoding.ASCIIStringEncoding;
        formManager = AsReader251GManager.sharedInstance();
        asReader251GDelegate = AsReader251GDelegate.sharedInstance();
        asReader251GDelegate.ReaderInitialized = (bool connect) =>
        {
            ReaderInitialized(connect);
        };
        asReader251GDelegate.DetectBarcode = (string barcodeType, string codeId, NSData barcodeData) =>
        {
            DetectBarcode(barcodeType, codeId, barcodeData);
        };
        asReader251GDelegate.OnAsReaderTriggerKeyEvent = (bool status) =>
        {
            bool sta = OnAsReaderTriggerKeyEvent(status);
            return sta;
        };
        asReader251GDelegate.OnAlert = (string error) =>
        {
            OnAlert(error);
        };
        asReader251GDelegate.OnAsReaderLeftModeKeyEvent = (bool status) =>
        {
            bool sta = OnAsReaderLeftModeKeyEvent(status);
            return sta;
        };
        asReader251GDelegate.OnAsReaderRightModeKeyEvent = (bool status) =>
        {
            bool sta = OnAsReaderRightModeKeyEvent(status);
            return sta;
        };
    }
    protected override void OnAppearing()
    {
        base.OnAppearing();
        BarcodeListView.ItemsSource = BarcodeItems;
        try
        {
            formManager.SetScanMode(AsReaderGunSDK.ScanMode.BarcodeScanMode);
            formManager.SetBarcodeMode(true, true);
        }
        catch (Exception)
        {
        }
    }
    protected override void OnDisappearing()
    {
        base.OnDisappearing();
        try
        {
            formManager.StopDecode();
            formManager.SetBarcodeMode(false, false);
        }
        catch (Exception)
        {
        }
    }
    void StartScanButton_Clicked(object sender, EventArgs e)
    {
        formManager.StartDecode();
    }
    void StopScanButton_Clicked(object sender, EventArgs e)
    {
        formManager.StopDecode();
    }
    void ClearScanButton_Clicked(object sender, EventArgs e)
    {
        count = 0;
        CountLabel.Text = count.ToString();
        dataDic.Clear();
        BarcodeItems.Clear();
    }
    void ASCIIButton_Clicked(object sender, EventArgs e)
    {
        ASCIIButton.TextColor = Colors.Black;
        UTF8Button.TextColor = Colors.Gray;
        ShiftJISButton.TextColor = Colors.Gray;
        charset = NSStringEncoding.ASCIIStringEncoding;
    }
    void UTF8Button_Clicked(object sender, EventArgs e)
    {
        ASCIIButton.TextColor = Colors.Gray;
        UTF8Button.TextColor = Colors.Black;
        ShiftJISButton.TextColor = Colors.Gray;
        charset = NSStringEncoding.UTF8;
    }
    void ShiftJISButton_Clicked(object sender, EventArgs e)
    {
        ASCIIButton.TextColor = Colors.Gray;
        UTF8Button.TextColor = Colors.Gray;
        ShiftJISButton.TextColor = Colors.Black;
        charset = NSStringEncoding.ShiftJIS;
    }
    private void ReaderInitialized(bool connect)
    {
        if (!connect)
        {
            MainThread.BeginInvokeOnMainThread(() =>
            {
                Navigation.PopAsync();
            });
        }
    }
    private void DetectBarcode(string barcodeType, string codeId, NSData barcodeData)
    {
        NSString barcode = new NSString();
        try
        {
            barcode = new NSString(barcodeData, charset);
        }
        catch
        {
            try
            {
                barcode = new NSString(barcodeData, NSStringEncoding.ASCIIStringEncoding);
            }
            catch
            {
                return;
            }
        }
        if (barcode == null)
        {
            barcode = new NSString(barcodeData, NSStringEncoding.ASCIIStringEncoding);
        }
        ItemData InventoryDataChanged;
        if (dataDic.ContainsKey(barcodeType + barcode))
        {
            InventoryDataChanged = dataDic[barcodeType + barcode];
            InventoryDataChanged.Count++;
            dataDic[barcodeType + barcode] = InventoryDataChanged;
        }
        else
        {
            int nowCount = dataDic.Count;
            InventoryDataChanged = new ItemData(barcodeType, barcode, 1);
            dataDic.Add(barcodeType + barcode, InventoryDataChanged);
            BarcodeItems.Add(InventoryDataChanged);
        }
        count++;
        MainThread.BeginInvokeOnMainThread(() =>
        {
            BarcodeListView.ItemsSource = null;
            BarcodeListView.ItemsSource = BarcodeItems;
            CountLabel.Text = count.ToString();
        });
    }
    private bool OnAsReaderTriggerKeyEvent(bool status)
    {
        if (formManager.GetScanMode() == AsReaderGunSDK.ScanMode.BarcodeScanMode)
        {
            if (status)
            {
                formManager.StartDecode();
            }
            else
            {
                formManager.StopDecode();
            }
            return false;
        }
        else
        {
            return true;
        }
    }
    private void OnAlert(string error)
    {
        MainThread.BeginInvokeOnMainThread(() =>
        {
            DisplayAlert("Alert", error, "OK");
        });
    }
    public bool OnAsReaderLeftModeKeyEvent(bool status)
    {
        if (formManager.GetReaderIsModule())
        {
            return true;
        }
        else
        {
            return false;
        }
    }
    public bool OnAsReaderRightModeKeyEvent(bool status)
    {
        if (formManager.GetReaderIsModule())
        {
            return true;
        }
        else
        {
            return false;
        }
    }
}
