﻿using AsReader251GMAUIiOSDemo.Platforms.iOS;

namespace AsReader251GMAUIiOSDemo;

public partial class MainPage : ContentPage
{
    private AsReader251GManager formManager;
    private AsReader251GDelegate asReader251GDelegate;

    public MainPage()
    {
        InitializeComponent();
        Title = "L251G";
        formManager = AsReader251GManager.sharedInstance();
        asReader251GDelegate = AsReader251GDelegate.sharedInstance();
    }
    protected override void OnAppearing()
    {
        base.OnAppearing();
        asReader251GDelegate.ReaderInitialized = (bool connect) =>
        {
            ReaderInitialized(connect);
        };
        asReader251GDelegate.OnAsReaderTriggerKeyEvent = (bool status) =>
        {
            return false;
        };
        asReader251GDelegate.OnAlert = (string error) =>
        {
            OnAlert(error);
        };
        asReader251GDelegate.OnAsReaderLeftModeKeyEvent = (bool status) =>
        {
            bool sta = OnAsReaderLeftModeKeyEvent(status);
            return sta;
        };
        asReader251GDelegate.OnAsReaderRightModeKeyEvent = (bool status) =>
        {
            bool sta = OnAsReaderRightModeKeyEvent(status);
            return sta;
        };
        try
        {
            formManager.SetScanMode(AsReaderGunSDK.ScanMode.RFIDScanMode);
        }
        catch (Exception)
        {
        }
        if (formManager.isConnect == true)
        {
            reloadUI(true);
        }
        else
        {
            reloadUI(false);
        }
    }
    private void reloadUI(bool status)
    {
        MainThread.BeginInvokeOnMainThread(() =>
        {
            if (status == true)
            {
                APPVersionLabel.Text = formManager.GetAPPVersion();
                DLLVersionLabel.Text = formManager.GetAsReader251GSDKDLL();
                SDKVersionLabel.Text = formManager.GetSDKVersion();
                FirmwareVersionLabel.Text = formManager.GetFirmwareVersion();
                UHFLabel.Text = formManager.GetRFModuleVersion();
                SNLabel.Text = formManager.GetSerialNumber();
                RegionLabel.Text = formManager.GetGlobalBand();
                CheckBattery(formManager.GetBatteryStatus());
                BarocdeScanLabel.TextColor = Colors.Black;
                RFIDInventoryLabel.TextColor = Colors.Black;
                LogoImage.Source = "asreader_log_on.png";
            }
            else
            {
                APPVersionLabel.Text = "";
                DLLVersionLabel.Text = "";
                SDKVersionLabel.Text = "";
                FirmwareVersionLabel.Text = "";
                UHFLabel.Text = "";
                SNLabel.Text = "";
                RegionLabel.Text = "";
                BatteryImage.Source = "battery0.png";
                BarocdeScanLabel.TextColor = Colors.LightGray;
                RFIDInventoryLabel.TextColor = Colors.LightGray;
                LogoImage.Source = "asreader_log_off.png";
            }
        });
    }
    async void BarocdeScanClicked(object sender, EventArgs e)
    {
        if (formManager.isConnect)
        {
            await Navigation.PushAsync(new BarcodeScanPage());
        }
    }
    async void RFIDInventoryClicked(object sender, EventArgs e)
    {
        if (formManager.isConnect)
        {
            await Navigation.PushAsync(new RFIDInventoryPage());
        }
    }
    private void ReaderInitialized(bool connect)
    {
        if (connect)
        {
            reloadUI(true);
        }
        else
        {
            reloadUI(false);
        }
    }
    private void OnAlert(string error)
    {
        MainThread.BeginInvokeOnMainThread(() =>
        {
            DisplayAlert("Alert", error, "OK");
        });
    }
    public bool OnAsReaderLeftModeKeyEvent(bool status)
    {
        if (formManager.GetReaderIsModule())
        {
            return true;
        }
        else
        {
            return false;
        }
    }
    public bool OnAsReaderRightModeKeyEvent(bool status)
    {
        if (formManager.GetReaderIsModule())
        {
            return true;
        }
        else
        {
            return false;
        }
    }
    private void CheckBattery(int battery)
    {
        switch (battery)
        {
            case 0:
                BatteryImage.Source = "battery0.png";
                break;
            case 1:
                BatteryImage.Source = "battery1.png";
                break;
            case 2:
                BatteryImage.Source = "battery2.png";
                break;
            case 3:
                BatteryImage.Source = "battery3.png";
                break;
            case 4:
                BatteryImage.Source = "battery4.png";
                break;
            default:
                return;
        }
    }
}


