﻿using Foundation;
using static AsReader251GMAUIiOSDemo.Platforms.iOS.AsReader251GDefine;

namespace AsReader251GMAUIiOSDemo.Platforms.iOS
{
	public class AsReader251GDelegate
	{
        public delegate void ReaderInitializedDelegate(bool connect);
        public ReaderInitializedDelegate ReaderInitialized;

        public delegate void ReadTagDelegate(string tag, float rssi, float phase, float frequency);
        public ReadTagDelegate ReadTag;

        public delegate void DetectBarcodeDelegate(string barcodeType, string codeId, NSData barcodeData);
        public DetectBarcodeDelegate DetectBarcode;

        public delegate bool OnAsReaderTriggerKeyEventDelegate(bool status);
        public OnAsReaderTriggerKeyEventDelegate OnAsReaderTriggerKeyEvent;

        public delegate bool OnAsReaderLeftModeKeyEventDelegate(bool status);
        public OnAsReaderLeftModeKeyEventDelegate OnAsReaderLeftModeKeyEvent;

        public delegate bool OnAsReaderRightModeKeyEventDelegate(bool status);
        public OnAsReaderRightModeKeyEventDelegate OnAsReaderRightModeKeyEvent;

        public delegate void OnAlertDelegate(string error);
        public OnAlertDelegate OnAlert;

        public delegate void ChangedActionStateDelegate(AsReader251G_CommandType action, nint resultCode);
        public ChangedActionStateDelegate ChangedActionState;

        static AsReader251GDelegate uniqueInstance;

        static readonly object locker = new object();

        public static AsReader251GDelegate sharedInstance()
        {
            if (uniqueInstance == null)
            {
                lock (locker)
                {
                    if (uniqueInstance == null)
                    {
                        uniqueInstance = new AsReader251GDelegate();
                    }
                }
            }
            return uniqueInstance;
        }
        public AsReader251GDelegate()
        {

        }
    }
}

