﻿using Foundation;
using AsRingAccessorySDK;
using AsReaderGunSDK;
using static AsReader251GMAUIiOSDemo.Platforms.iOS.AsReader251GDefine;
using System.Collections;

namespace AsReader251GMAUIiOSDemo.Platforms.iOS
{
    public class AsReader251GManager
    {
        public class MyAsreaderDelegate : AsReaderDelegate
        {
            AsReader251GDelegate asReader251GDelegate = AsReader251GDelegate.sharedInstance();
            public MyAsreaderDelegate()
            {

            }
            public override void ReaderInitialized(AsReader reader)
            {
                sharedInstance().isConnect = true;
                sharedInstance().setAsReaderDelegate();
                if (asReader251GDelegate.ReaderInitialized != null)
                {
                    asReader251GDelegate.ReaderInitialized(true);
                }
            }
            public override void DetectBarcode(BarcodeType barcodeType, string codeId, NSData barcodeData)
            {
                if (asReader251GDelegate.DetectBarcode != null)
                {
                    string p = AsBarcodeType.GetBarcodeString(barcodeType);
                    asReader251GDelegate.DetectBarcode(p, codeId, barcodeData);
                }
            }
            public override void ReadTag(string tag, float rssi, float phase, float frequency)
            {
                if(asReader251GDelegate.ReadTag != null)
                    asReader251GDelegate.ReadTag(tag, rssi, phase, frequency);
            }
            public override void ChangedActionState(CommandType action, nint resultCode)
            {
                if (asReader251GDelegate.ChangedActionState != null)
                {
                    AsReader251G_CommandType actionState = (AsReader251G_CommandType)Convert.ToInt32(action);
                    asReader251GDelegate.ChangedActionState(actionState, resultCode);
                }
            }
            public override bool OnAsReaderTriggerKeyEvent(bool status)
            {
                if (asReader251GDelegate.OnAsReaderTriggerKeyEvent != null)
                {
                    return asReader251GDelegate.OnAsReaderTriggerKeyEvent(status);
                } else
                {
                    return false;
                } 
            }
            public override bool OnAsReaderLeftModeKeyEvent(bool status)
            {
                if (asReader251GDelegate.OnAsReaderLeftModeKeyEvent != null)
                {
                    return asReader251GDelegate.OnAsReaderLeftModeKeyEvent(status);
                }
                else
                {
                    return false;
                }
            }
            public override bool OnAsReaderRightModeKeyEvent(bool status)
            {
                if (asReader251GDelegate.OnAsReaderRightModeKeyEvent != null)
                {
                    return asReader251GDelegate.OnAsReaderRightModeKeyEvent(status);
                }
                else
                {
                    return false;
                }
            }
        }

        public AsReaderGUN mAsReaderGUN;
        static AsReader mReader;
        public bool isConnect;
        private int max;
        private int min;
        static MyAsreaderDelegate mAsreaderDelegate;
        private AsReader251GDelegate asReader251GDelegate;
        static AsReader251GManager uniqueInstance;
        static readonly object locker = new object();
        public static AsReader251GManager sharedInstance()
        {
            if (uniqueInstance == null)
            {
                lock (locker)
                {
                    if (uniqueInstance == null)
                    {
                        uniqueInstance = new AsReader251GManager();
                    }
                }
            }
            return uniqueInstance;
        }
        public void setAsReaderDelegate()
        {
            if (mReader != null)
            {
                mReader.SetDelegate(mAsreaderDelegate);
            }
        }
        public AsReader251GManager()
        {
            isConnect = false;
            asReader251GDelegate = AsReader251GDelegate.sharedInstance();
            mAsReaderGUN = new AsReaderGUN("com.asreader.gun");
            mAsreaderDelegate = new MyAsreaderDelegate();

            NSNotificationCenter center = NSNotificationCenter.DefaultCenter;
            NSString connectedStr = new NSString("AsReaderGUNConnected");
            NSString disconnectedStr = new NSString("AsReaderGUNDisconnected");
            NSString alertStr = new NSString("Alert");
            center.AddObserver(connectedStr, AsReaderGUNConnected);
            center.AddObserver(disconnectedStr, AsReaderGUNDisconnected);
            center.AddObserver(alertStr, AlertAction);
        }
        void AsReaderGUNConnected(NSNotification notification)
        {
            mReader = new AsReader(mAsReaderGUN, mAsreaderDelegate);
        }
        void AsReaderGUNDisconnected(NSNotification notification)
        {
            if (mReader != null)
            {
                mReader = null;
            }
            isConnect = false;
            if (asReader251GDelegate.ReaderInitialized != null)
                asReader251GDelegate.ReaderInitialized(false);
        }
        void AlertAction(NSNotification notification)
        {
            MainThread.BeginInvokeOnMainThread(() =>
            {
                if (asReader251GDelegate.OnAlert != null)
                {
                    NSString data = (NSString)notification.UserInfo["DATA"];
                    asReader251GDelegate.OnAlert(data);
                }
            });
        }
        public bool GetReaderIsModule()
        {
            if (mReader.IsRFIDModule && mReader.IsBarcodeModule)
            {
                return true;
            }
            return false;
        }
        public ArrayList GetPowerGainRange()
        {
            ArrayList mList = new ArrayList();
            if (GetAsReaderStatus() == true)
            {
                min = mReader.PowerGainRange.min;
                max = mReader.PowerGainRange.max;
                for (int i = min; i <= max; i += 10)
                {
                    mList.Add((i / 10).ToString() + ".0dB");
                }
            }
            return mList;
        }
        public int GetPowerRangeMax()
        {
            return max;
        }
        public int GetPowerRangeMin()
        {
            return min;
        }
        public int PowerGain
        {
            get
            {
                if (GetAsReaderStatus() == false)
                {
                    return 5;
                }
                return mReader.PowerGain;
            }
            set
            {
                if (GetAsReaderStatus() == false)
                {
                    return;
                }
                mReader.PowerGain = value;
            }
        }
        public string GetAPPVersion()
        {
            return GetAppVersion() + " (" + GetAPPBuild() + ")";
        }
        private string GetAppVersion()
        {
            return NSBundle.MainBundle.InfoDictionary["CFBundleShortVersionString"].ToString();
        }
        private string GetAPPBuild()
        {
            return NSBundle.MainBundle.InfoDictionary["CFBundleVersion"].ToString();
        }
        public string GetSDKVersion()
        {
            if (GetAsReaderStatus() == false)
            {
                return "";
            }
            else
            {
                return mAsReaderGUN.AsReaderGUNVersion;
            }
        }
        public string GetFirmwareVersion()
        {
            if (GetAsReaderStatus() == false)
            {
                return "";
            }
            else
            {
                return mReader.FirmwareVersion;
            }
        }
        public string GetRFModuleVersion()
        {
            if (GetAsReaderStatus() == false)
            {
                return "";
            }
            else
            {
                return mReader.RFModuleVersion;
            }
        }
        public string GetAsRingSDKVersion()
        {
            if (GetAsReaderStatus() == false)
            {
                return "";
            }
            else
            {
                return AsRingDeviceSDK.SharedAsRingDeviceSDK.AsRingSDKVersion;
            }
        }
        public string GetSerialNumber()
        {
            if (GetAsReaderStatus() == false)
            {
                return "";
            }
            else
            {
                return mReader.SerialNumber;
            }
        }
        public string GetGlobalBand()
        {
            if (GetAsReaderStatus() == false)
            {
                return "";
            }
            else
            {
                return mReader.RegionName;
            }
        }
        public int GetBatteryStatus()
        {
            if (GetAsReaderStatus() == false)
            {
                return 0;
            }
            else
            {
                return mReader.BatteryStatus;
            }
        }
        public void StartDecode()
        {
            if (GetAsReaderStatus() == true)
            {
                ResultCode code = mReader.StartDecode;
            }
        }
        public void StopDecode()
        {
            if (GetAsReaderStatus() == true)
            {
                ResultCode code = mReader.StopSync;
            }
        }
        public void Inventory()
        {
            if (GetAsReaderStatus() == true)
            {
                ResultCode code = mReader.Inventory;
            }
        }
        public void Stop()
        {
            if (GetAsReaderStatus() == true)
            {
                ResultCode code = mReader.Stop;
            }
        }
        public void SetContinuousMode(bool enabled)
        {
            if (GetAsReaderStatus() == true)
            {
                mReader.ContinuousMode = enabled;
            }
        }

        public ScanMode GetScanMode()
        {
            return mReader.ScanMode;
        }
        public void SetScanMode(ScanMode scanMode)
        {
            if (GetAsReaderStatus() == true)
            {
                mReader.SetScanMode(scanMode);
            }
        }
        public void SetBarcodeMode(bool isBarcodeMode, bool isKeyAction)
        {
            if (GetAsReaderStatus() == true)
            {
                mReader.SetBarcodeMode(isBarcodeMode, isKeyAction, false, AsReaderGunSDK.ParamType.Temporary);
            }
        }
        public bool GetAsReaderStatus()
        {
            if (mReader != null && isConnect)
            {
                return true;
            }
            else
            {
                return false;
            }
        }
        public AsReader251G_TagState GetTagState(string pcEPCData)
        {
            if (GetAsReaderStatus() == true)
            {
                AsReader251G_TagState tagState = (AsReader251G_TagState)mReader.GetTagState(pcEPCData);
                return tagState;
            } else
            {
                return AsReader251G_TagState.State_Unknown;
            }
        }
        //public string GetSDKMessage()
        //{
        //    if (mReader != null)
        //    {
        //        return mReader.SDKMessage;
        //    }
        //    else
        //    {
        //        return "";
        //    }
        //}
        public string GetAsReader251GSDKDLL()
        {
            return AsReaderGunSDKDLL.DLLVersion();
        }
    }
}

