﻿
namespace AsReader251GMAUIiOSDemo
{
    public class CustomCell : ViewCell
    {
        Label barcodeLabel, typeLabel, countLabel;

        public static readonly BindableProperty TypeProperty = BindableProperty.Create("Type", typeof(string), typeof(CustomCell), "Type");
        public static readonly BindableProperty BarcodeProperty = BindableProperty.Create("Barcode", typeof(string), typeof(CustomCell), "Barcode");
        public static readonly BindableProperty CountProperty = BindableProperty.Create("Count", typeof(int), typeof(CustomCell), 0);

        public string Type
        {
            get { return (string)GetValue(TypeProperty); }
            set { SetValue(TypeProperty, value); }
        }

        public string Barcode
        {
            get { return (string)GetValue(BarcodeProperty); }
            set { SetValue(BarcodeProperty, value); }
        }
       
        public int Count
        {
            get { return (int)GetValue(CountProperty); }
            set { SetValue(CountProperty, value); }
        }

        public CustomCell()
        {
            typeLabel = new Label { TextColor = Color.FromArgb("#000000"), FontSize = 16, HorizontalOptions = LayoutOptions.Start };
            barcodeLabel = new Label { TextColor = Color.FromArgb("#000000"), FontSize = 16, HorizontalOptions = LayoutOptions.Start };
            countLabel = new Label { TextColor = Color.FromArgb("#000000"), FontSize = 16, HorizontalOptions = LayoutOptions.End};

            StackLayout barcodeLayout = new StackLayout
            {
                Padding = new Thickness(10, 0, 0, 0),
                Orientation = StackOrientation.Horizontal,
                HorizontalOptions = LayoutOptions.StartAndExpand,
                Children = { barcodeLabel }
            };

            StackLayout countLayout = new StackLayout
            {
                Padding = new Thickness(0, 0, 10, 0),
                Orientation = StackOrientation.Horizontal,
                HorizontalOptions = LayoutOptions.EndAndExpand,
                Children = { countLabel }
            };

            var viewLayout1 = new StackLayout()
            {
                Orientation = StackOrientation.Horizontal,
                Children = { barcodeLayout, countLayout }
            };

            StackLayout typeLayout = new StackLayout
            {
                Padding = new Thickness(10, 0, 0, 0),
                Orientation = StackOrientation.Vertical,
                HorizontalOptions = LayoutOptions.StartAndExpand,
                Children = { typeLabel }
            };

            var viewLayout2 = new StackLayout()
            {
                Orientation = StackOrientation.Vertical,
                Children = { viewLayout1, typeLayout }
            };
            View = viewLayout2;

        }

        protected override void OnBindingContextChanged()
        {
            base.OnBindingContextChanged();

            if (BindingContext != null)
            {
                if (Type != "0")
                {
                    typeLabel.Text = Type;
                }
                else
                {
                    typeLabel.Text = "";
                }
                barcodeLabel.Text = Barcode;
                countLabel.Text = Count.ToString();
            }
        }
    }
}
