﻿using System;
using System.ComponentModel;

namespace AsReader251GMAUIiOSDemo
{
	public class BaseViewModel : INotifyPropertyChanged
    {
		public BaseViewModel()
		{
        }
        public event PropertyChangedEventHandler? PropertyChanged;

        protected virtual void OnPropertyChanged(string propertyName)
        {
            if (PropertyChanged != null)
            {
                PropertyChanged(this, new PropertyChangedEventArgs(propertyName));
            }
        }

        private string activityIndicatorText = "";
        private bool showActivityIndicator = false;
        private bool activityIndicatorIsRunning = false;
        private string toastMessage = "";
        private bool showToast = false;

        public string ActivityIndicatorText
        {
            get { return activityIndicatorText; }
            set
            {
                if (activityIndicatorText == value) return;
                activityIndicatorText = value;
                OnPropertyChanged("ActivityIndicatorText");
            }
        }

        public bool ShowActivityIndicator
        {
            get { return showActivityIndicator; }
            set
            {
                if (showActivityIndicator == value) return;
                showActivityIndicator = value;
                PropertyChanged?.Invoke(this, new PropertyChangedEventArgs("ShowActivityIndicator"));
            }
        }

        public bool ActivityIndicatorIsRunning
        {
            get { return activityIndicatorIsRunning; }
            set
            {
                if (activityIndicatorIsRunning == value) return;
                activityIndicatorIsRunning = value;
                PropertyChanged?.Invoke(this, new PropertyChangedEventArgs("ActivityIndicatorIsRunning"));
            }
        }
        bool showMask = false;
        public bool ShowMask
        {
            get { return showMask; }
            set
            {
                if (showMask == value) return;
                showMask = value;
                PropertyChanged?.Invoke(this, new PropertyChangedEventArgs("ShowMask"));
            }
        }

        public bool ShowToast
        {
            get { return showToast; }
            set
            {
                if (showToast == value) return;
                showToast = value;
                PropertyChanged?.Invoke(this, new PropertyChangedEventArgs("ShowToast"));
            }
        }

        public string ToastMessage
        {
            get { return toastMessage; }
            set
            {
                if (toastMessage == value) return;
                toastMessage = value;
                PropertyChanged?.Invoke(this, new PropertyChangedEventArgs("ToastMessage"));
            }
        }
    }
}

