#import <Foundation/Foundation.h>

@interface AsTagItem : NSObject<NSCoding>
@property (strong, nonatomic) NSString *ids;
@property (strong, nonatomic) NSString *tag;
@property (strong, nonatomic) NSString *tid;
@property (nonatomic) int count;
@property (nonatomic) float rssi;
@property (nonatomic) float phase;
@property (nonatomic) float frequency;
@property (strong, nonatomic) NSString *dateTime;

@property (strong, nonatomic) NSString *celsius;
@property (strong, nonatomic) NSString *fahrenheit;
@property (strong, nonatomic) NSString *moisture;

+ (id)itemWith:(NSString *)tag rssi:(float)rssi phase:(float)phase frequency:(float)frequency tid:(NSString*)tid;
- (void)updateRssi:(float)rssi withPhase:(float)phase frequency:(float)frequency;
- (void)updateRssi:(float)rssi withPhase:(float)phase frequency:(float)frequency data:(NSString*)data;

//RFM
+ (id)itemWithRFM:(NSString *)tag temp1:(NSString *)temp1 temp2:(NSString *)temp2 moisture:(NSString *)moisture;
- (void)updateRFMTemp1:(NSString *)temp1 temp2:(NSString *)temp2 moisture:(NSString *)moisture;

@end
