//
//  DatabaseManeger.m
//  AsReaderLR
//
//  Created by mac on 2017/12/21.
//  Copyright © 2017年 asterisk. All rights reserved.
//

#import "DatabaseManeger.h"

#define DATABASE_NAME           @"database5.db"


@implementation DatabaseManeger{
    FMDatabaseQueue * dbQueue;
}

static DatabaseManeger * _databaseManeger;

+ (DatabaseManeger *)sharedDatabaseManeger{
    if (!_databaseManeger) {
        _databaseManeger = [[DatabaseManeger alloc] init];
    }
    return _databaseManeger;
}

- (instancetype)init
{
    self = [super init];
    if (self) {
          [self getDatebaseQueue];
    }
    return self;
}

- (FMDatabaseQueue *)getDatebaseQueue{
    if(dbQueue){
        return dbQueue;
    }
    NSFileManager *fileManager = [NSFileManager defaultManager];
    NSError *error;
    NSArray *paths = NSSearchPathForDirectoriesInDomains(NSDocumentDirectory, NSUserDomainMask, YES);
    NSString *documentDirectory = [paths objectAtIndex:0];
    NSString *writableDbPath = [documentDirectory stringByAppendingPathComponent:DATABASE_NAME];
    NSLog(@"%@",writableDbPath);
    BOOL isHave = [fileManager fileExistsAtPath:writableDbPath];
    if(!isHave){
        NSString *defaultDbPath = [[[NSBundle mainBundle]resourcePath]stringByAppendingPathComponent:DATABASE_NAME];
        isHave = [fileManager copyItemAtPath:defaultDbPath toPath:writableDbPath error:&error];
    }
    if(!isHave){
        return nil;
    }else{
        dbQueue = [FMDatabaseQueue databaseQueueWithPath:writableDbPath];
        return dbQueue;
    }
}

- (BOOL)updataOrAddAsTagItem:(AsTagItem *)asTagItem fmdb:(FMDatabase *)fmdb{
    if (!fmdb) {
        NSLog(@"FMDB ERROR");
    }
   BOOL replace = [fmdb executeUpdate:@"REPLACE INTO AsTagItem \
               (ids\
               ,tag\
               ,count\
               ,rssi\
               ,phase\
               ,frequency\
               ,datetime\
               ,tid\
                   ,temp1\
                   ,temp2\
                   ,moisture)\
               VALUES (?,?,?,?,?,?,?,?,?)",
                   [NSString stringWithFormat:@"%@%@",asTagItem.tid,asTagItem.tag],
                   asTagItem.tag,
                   [NSString stringWithFormat:@"%d",asTagItem.count],
                   [NSString stringWithFormat:@"%f",asTagItem.rssi],
                   [NSString stringWithFormat:@"%f",asTagItem.phase],
                   [NSString stringWithFormat:@"%f",asTagItem.frequency],
                   asTagItem.dateTime,
                   asTagItem.tid,
                   asTagItem.celsius,
                   asTagItem.fahrenheit,
                   asTagItem.moisture];
    if (replace) {
        //NSLog(@"REPLACE SUCCESS");
        return YES;
    }else{
        NSLog(@"REPLACE ERROR");
        return NO;
    }
}

- (BOOL)deleteAllAsTagItemsFmdb:(FMDatabase *)fmdb{
    if (!fmdb) {
        NSLog(@"FMDB ERROR");
    }
    NSString *sql = [NSString stringWithFormat:@"DELETE FROM AsTagItem"];
    BOOL result = [fmdb executeUpdate:sql];
    if (result) {
        NSLog(@"DELETE SUCCESS");
        return YES;
    }else{
        NSLog(@"DELETE ERROR");
        return NO;
    }
}



- (NSArray *)getAllAsTagItemsfmdb:(FMDatabase *)fmdb{
    if (!fmdb) {
        NSLog(@"FMDB ERROR");
    }
    NSMutableArray * array = [[NSMutableArray alloc] init];
    
    NSString *sql = [NSString stringWithFormat:@"SELECT * FROM AsTagItem"];
    FMResultSet *set = [fmdb executeQuery:sql];
    while ([set next]) {
        AsTagItem * item = [[AsTagItem alloc] init];
        item.ids       = [set stringForColumn:@"ids"];
        item.tag       = [set stringForColumn:@"tag"];
        item.dateTime  = [set stringForColumn:@"datetime"];
        item.count     = [set doubleForColumn:@"count"];
        item.rssi      = [set doubleForColumn:@"rssi"];
        item.phase     = [set doubleForColumn:@"phase"];
        item.frequency = [set doubleForColumn:@"frequency"];
        item.tid       = [set stringForColumn:@"tid"];
        item.celsius       = [set stringForColumn:@"temp1"];
        item.fahrenheit       = [set stringForColumn:@"temp2"];
        item.moisture       = [set stringForColumn:@"moisture"];
        NSLog(@" DB : %@ TID : %@",item.ids,item.tid);
        [array addObject:item];
    }
    return array;
}

- (BOOL)updataOrAddSql:(NSString *)sql fmdb:(FMDatabase *)fmdb{
    if (!fmdb) {
        NSLog(@"FMDB ERROR");
    }
    BOOL replace = [fmdb executeUpdate:sql];
    if (replace) {
        //NSLog(@"REPLACE SUCCESS");
        return YES;
    }else{
        NSLog(@"REPLACE ERROR");
        return NO;
    }
}

@end
